/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TrySyncList;
import oracle.ojc.compiler.TypeSymbol;

final class SynchronizedStatement
extends Statement {
    Expression syncExpr;
    StatementList bodyStatements;
    int endPos;
    short localVar;

    SynchronizedStatement(StatementList statementList, int n, int n2, Expression expression, StatementList statementList2) {
        super(statementList, n, (byte)15);
        this.syncExpr = expression;
        this.bodyStatements = statementList2;
        this.endPos = n2;
        statementList2.parent = this;
    }

    void resolveAndCheck(Parser parser) {
        Expression expression = this.syncExpr;
        expression = expression.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        byte by = typeSymbol.typeClass;
        if ((by & 0xFFFFFFC0) == 0) {
            parser.error(Message.errorIncompatibleTypes, expression.pos, typeSymbol.isErroneous(), typeSymbol.errorName(), parser.javaLangObjectSymbol.errorName());
        } else if (expression instanceof NullConstantExpression) {
            parser.error(Message.errorCannotSynchronizedNull, expression.pos, false);
        }
        this.syncExpr = expression;
        this.bodyStatements.resolveAndCheck(parser);
        parser.estimatedLineCount += 2;
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        short s;
        TrySyncList trySyncList;
        Expression expression = this.syncExpr;
        expression.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8((byte)89);
        byteCodeGenerator.incOpStackHeight(1);
        short s2 = byteCodeGenerator.methodSymbol.localVarCount;
        byteCodeGenerator.methodSymbol.localVarCount = (short)(s2 + 1);
        this.localVar = s2;
        byteCodeGenerator.methodSymbol.cmd.localVariables.add(null);
        TypeSymbol typeSymbol = expression.getType();
        byteCodeGenerator.storeLocalVariable(typeSymbol, this.localVar);
        byteCodeGenerator.generate_8((byte)-62);
        byteCodeGenerator.decOpStackHeight(1);
        short s3 = byteCodeGenerator.generateGetPC();
        TrySyncList trySyncList2 = byteCodeGenerator.parser.innerTrySync;
        byteCodeGenerator.parser.innerTrySync = trySyncList = new TrySyncList(trySyncList2, null, this);
        this.bodyStatements.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.parser.innerTrySync = trySyncList2;
        short s4 = s = byteCodeGenerator.generateGetPC();
        Label label = new Label();
        if (this.bodyStatements.canReachNextStatement(false)) {
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.endPos));
            byteCodeGenerator.loadLocalVariable(typeSymbol, this.localVar);
            byteCodeGenerator.generate_8((byte)-61);
            byteCodeGenerator.decOpStackHeight(1);
            s4 = byteCodeGenerator.generateGetPC();
            byteCodeGenerator.generateBranch_goto(label);
        }
        short s5 = byteCodeGenerator.generateGetPC();
        if (s3 != s) {
            byteCodeGenerator.generateExceptionHandler(s3, s, s5, (short)0);
        }
        if (s != s4) {
            byteCodeGenerator.generateExceptionHandler(s, s4, s5, (short)0);
        }
        byteCodeGenerator.setOpStackHeight(1);
        byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.endPos));
        byteCodeGenerator.loadLocalVariable(typeSymbol, this.localVar);
        byteCodeGenerator.generate_8((byte)-61);
        byteCodeGenerator.decOpStackHeight(1);
        s = byteCodeGenerator.generateGetPC();
        byteCodeGenerator.generateExceptionHandler(s5, s, s5, (short)0);
        byteCodeGenerator.generate_8((byte)-65);
        byteCodeGenerator.decOpStackHeight(1);
        byteCodeGenerator.setLabel(label);
    }

    boolean canReachNextStatement(boolean bl) {
        return this.bodyStatements.canReachNextStatement(bl);
    }
}

