/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelStatement;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.SwitchStatement;

final class SwitchLoopList {
    SwitchLoopList outerSwitchLoop;
    SwitchStatement switchStmt;
    LoopStatement loopStmt;
    ArrayList caseStmts;
    LabelSymbol breakSymbol;
    LabelSymbol continueSymbol;
    BitSet defSet;
    BitSet posSet;
    BitSet useSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    SwitchLoopList(SwitchLoopList switchLoopList, SwitchStatement switchStatement, LoopStatement loopStatement, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        this.outerSwitchLoop = switchLoopList;
        this.switchStmt = switchStatement;
        this.loopStmt = loopStatement;
        this.defSet = (BitSet)bitSet.clone();
        this.posSet = (BitSet)bitSet2.clone();
        this.useSet = (BitSet)bitSet3.clone();
        if (switchStatement != null) {
            this.caseStmts = new ArrayList();
        }
    }

    boolean inLoop() {
        SwitchLoopList switchLoopList = this;
        while (switchLoopList != null) {
            if (switchLoopList.loopStmt != null) {
                return true;
            }
            switchLoopList = switchLoopList.outerSwitchLoop;
        }
        return false;
    }

    LoopStatement getLoopStatement() {
        SwitchLoopList switchLoopList = this;
        while (switchLoopList != null) {
            if (switchLoopList.loopStmt != null) {
                return switchLoopList.loopStmt;
            }
            switchLoopList = switchLoopList.outerSwitchLoop;
        }
        return null;
    }

    LabelSymbol getBreakSymbol() {
        LabelSymbol labelSymbol = this.breakSymbol;
        if (labelSymbol == null) {
            labelSymbol = new LabelSymbol(0, null);
            labelSymbol.label = new Label();
            this.breakSymbol = labelSymbol;
        }
        return labelSymbol;
    }

    LabelSymbol getContinueSymbol() {
        if (!$assertionsDisabled && this.loopStmt == null) {
            throw new AssertionError();
        }
        LabelSymbol labelSymbol = this.continueSymbol;
        if (labelSymbol == null) {
            labelSymbol = new LabelSymbol(0, null);
            labelSymbol.label = new Label();
            this.continueSymbol = labelSymbol;
        }
        return labelSymbol;
    }

    void insertLabels() {
        LabelSymbol labelSymbol;
        LabelSymbol labelSymbol2 = this.breakSymbol;
        if (labelSymbol2 != null) {
            if (this.switchStmt != null) {
                this.switchStmt.insertAfter(new LabelStatement(this.switchStmt.parent, 0, 7, labelSymbol2));
            } else {
                this.loopStmt.insertAfter(new LabelStatement(this.loopStmt.parent, 0, 7, labelSymbol2));
            }
        }
        if ((labelSymbol = this.continueSymbol) != null) {
            if (!$assertionsDisabled && this.loopStmt == null) {
                throw new AssertionError();
            }
            this.loopStmt.bodyStatements.last.insertAfter(new LabelStatement(this.loopStmt.bodyStatements, 0, 7, labelSymbol));
        }
    }

    static {
        $assertionsDisabled = !SwitchLoopList.class.desiredAssertionStatus();
    }
}

