/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class ShiftExpression
extends BinaryExpression {
    ShiftExpression(byte by, int n, Expression expression, Expression expression2) {
        super(by, n, expression, expression2);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.leftOperand.resolveAndCheck(parser);
        Expression expression2 = this.rightOperand.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        if ((typeSymbol2.typeClass & 0xC) == 0) {
            if (parser.options.sourceJDKVersion >= 150 && (typeSymbol = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && (typeSymbol.typeClass & 0xC) != 0) {
                expression = expression.promoteType(parser, typeSymbol);
                typeSymbol2 = typeSymbol;
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName());
                return new ErrorExpression(error);
            }
        }
        TypeSymbol typeSymbol3 = TypeSymbol.unaryNumericPromotion(parser, typeSymbol2);
        this.setType(typeSymbol3);
        this.leftOperand = expression.promoteType(parser, typeSymbol3);
        TypeSymbol typeSymbol4 = expression2.getType();
        if ((typeSymbol4.typeClass & 0xC) == 0) {
            if (parser.options.sourceJDKVersion >= 150 && (typeSymbol = BoxingExpression.getPrimitiveType(parser, typeSymbol4)) != null && (typeSymbol.typeClass & 0xC) != 0) {
                expression2 = expression2.promoteType(parser, typeSymbol);
                typeSymbol4 = typeSymbol;
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol4.isErroneous(), this.toString(), typeSymbol4.errorName());
                return new ErrorExpression(error);
            }
        }
        if (typeSymbol4 == TypeSymbol.intSymbol) {
            this.rightOperand = expression2;
        } else {
            CastExpression castExpression = new CastExpression(this.pos, expression2, TypeSymbol.intSymbol);
            if (expression2.kind == 2) {
                this.rightOperand = ((Expression)castExpression).resolveAndCheck(parser);
            } else {
                castExpression.setType(TypeSymbol.intSymbol);
                this.rightOperand = castExpression;
            }
        }
        return this.foldExpression();
    }
}

