/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

abstract class Scope {
    static final byte SC_GLOBAL = 0;
    static final byte SC_PACKAGE = 1;
    static final byte SC_CLASS = 2;
    static final byte SC_METHOD = 3;
    static final byte SC_BLOCK = 4;
    byte kind;
    ArrayList declList;
    Parser parser;
    int symbolCount;
    Object symbolTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    Scope(byte by, int n, Parser parser) {
        this.kind = by;
        this.parser = parser;
        if (n > 0) {
            this.symbolTable = new Symbol[n];
        }
    }

    final ArrayList recordDeclarations(ArrayList arrayList) {
        ArrayList arrayList2 = this.declList;
        this.declList = arrayList;
        return arrayList2;
    }

    final void enterDeclarations(Symbol[] symbolArray) {
        if (symbolArray != null) {
            int n = symbolArray.length;
            for (int i = 0; i < n; ++i) {
                this.enterSymbol(symbolArray[i]);
            }
        }
    }

    final void removeDeclarations(Symbol[] symbolArray) {
        if (symbolArray != null) {
            int n = symbolArray.length;
            for (int i = 0; i < n; ++i) {
                this.removeSymbol(symbolArray[i]);
            }
        }
    }

    void removeSymbol(Symbol symbol) {
        Symbol[] symbolArray = (Symbol[])this.symbolTable;
        int n = symbol.identifier.hashCode() & symbolArray.length - 1;
        Symbol symbol2 = symbolArray[n];
        if (symbol2 == symbol) {
            symbolArray[n] = symbol.nextHashed;
        } else {
            while (true) {
                Symbol symbol3 = symbol2.nextHashed;
                if (!$assertionsDisabled && symbol3 == null) {
                    throw new AssertionError();
                }
                if (symbol3 == symbol) {
                    symbol2.nextHashed = symbol.nextHashed;
                    break;
                }
                symbol2 = symbol3;
            }
        }
        --this.symbolCount;
    }

    private final int rehash() {
        Symbol[] symbolArray = (Symbol[])this.symbolTable;
        int n = symbolArray.length;
        int n2 = this.symbolCount;
        int n3 = n << 1;
        Symbol[] symbolArray2 = new Symbol[n3];
        for (int i = 0; i < n; ++i) {
            Symbol symbol;
            Symbol symbol2 = symbolArray[i];
            if (symbol2 == null) continue;
            do {
                --n2;
                symbol = symbol2.nextHashed;
                int n4 = symbol2.identifier.hashCode() & n3 - 1;
                symbol2.nextHashed = symbolArray2[n4];
                symbolArray2[n4] = symbol2;
            } while ((symbol2 = symbol) != null);
            if (n2 == 0) break;
        }
        this.symbolTable = symbolArray2;
        return n3;
    }

    void enterSymbol(Symbol symbol) {
        if (!$assertionsDisabled && (symbol instanceof UnresolvedSymbol || symbol instanceof UnresolvedClassSymbol)) {
            throw new AssertionError();
        }
        int n = this.symbolCount;
        Symbol[] symbolArray = (Symbol[])this.symbolTable;
        int n2 = symbolArray.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehash();
            symbolArray = (Symbol[])this.symbolTable;
        }
        this.symbolCount = n + 1;
        int n3 = symbol.identifier.hashCode() & n2 - 1;
        symbol.scope = this;
        symbol.nextHashed = symbolArray[n3];
        symbolArray[n3] = symbol;
        if (this.declList != null && (this.kind > 1 || (symbol.kind & 4) != 0) && (symbol.kind & 0xFFFFFF80) == 0) {
            this.declList.add(symbol);
        }
    }

    Symbol lookupSymbolInScope(Identifier identifier, boolean bl) {
        Symbol[] symbolArray = (Symbol[])this.symbolTable;
        int n = identifier.hashCode() & symbolArray.length - 1;
        Symbol symbol = symbolArray[n];
        while (symbol != null) {
            if (!(identifier != symbol.identifier || bl && (symbol.kind & 4) != 0)) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    Symbol lookupSpecificSymbolInScope(Identifier identifier, int n, boolean bl) {
        Symbol[] symbolArray = (Symbol[])this.symbolTable;
        int n2 = identifier.hashCode() & symbolArray.length - 1;
        Symbol symbol = symbolArray[n2];
        while (symbol != null) {
            if (!((symbol.kind & n) == 0 || identifier != symbol.identifier || bl && (symbol.kind & 4) != 0)) {
                return symbol;
            }
            symbol = symbol.nextHashed;
        }
        return null;
    }

    Symbol[] getSymbols() {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
        Symbol[] symbolArray = (Symbol[])this.symbolTable;
        for (int i = 0; i < symbolArray.length; ++i) {
            Symbol symbol = symbolArray[i];
            while (symbol != null) {
                arrayList.add(symbol);
                symbol = symbol.nextHashed;
            }
        }
        return arrayList.toArray(new Symbol[arrayList.size()]);
    }

    abstract Symbol lookupSymbol(Identifier var1, boolean var2);

    abstract Symbol lookupSpecificSymbol(Identifier var1, int var2, boolean var3);

    abstract String errorName();

    abstract boolean isSubScopeOf(Scope var1);

    abstract Scope getOuterScope();

    static {
        $assertionsDisabled = !Scope.class.desiredAssertionStatus();
    }
}

