/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

class ReferenceTypeSymbol
extends TypeSymbol {
    static ReferenceTypeSymbol nullTypeSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    ReferenceTypeSymbol(int n, Identifier identifier, byte by, short s, Annotation annotation) {
        super(n, identifier, by, s, annotation);
    }

    char[] getSignature() {
        if (this == nullTypeSymbol) {
            return Identifier.javaLangObjectSignature.name;
        }
        return super.getSignature();
    }

    boolean isReferenceType() {
        return true;
    }

    static void initializeStatics() {
        nullTypeSymbol = new ReferenceTypeSymbol(0, Identifier.getIdentifier("null"), 10, 1, null);
    }

    static void releaseStatics() {
        nullTypeSymbol = null;
    }

    boolean isAssignmentCompatible(Parser parser, ReferenceTypeSymbol referenceTypeSymbol) {
        if (this.equalTo(referenceTypeSymbol)) {
            return true;
        }
        if (this == nullTypeSymbol || referenceTypeSymbol == nullTypeSymbol) {
            return true;
        }
        if (this.isTypeParameter()) {
            return ((TypeParameterSymbol)this).bound.isAssignmentCompatible(parser, referenceTypeSymbol);
        }
        if (referenceTypeSymbol.isTypeParameter()) {
            return this.isAssignmentCompatible(parser, ((TypeParameterSymbol)referenceTypeSymbol).bound);
        }
        if (this.isClass()) {
            ClassSymbol classSymbol = (ClassSymbol)this;
            if (!classSymbol.isInterface()) {
                if (referenceTypeSymbol.isClass()) {
                    ClassSymbol classSymbol2 = (ClassSymbol)referenceTypeSymbol;
                    if (!classSymbol2.isInterface()) {
                        return classSymbol2.isSuperclass(classSymbol);
                    }
                    return classSymbol.implementsInterface(classSymbol2);
                }
                return false;
            }
            if (referenceTypeSymbol.isClass()) {
                ClassSymbol classSymbol3 = (ClassSymbol)referenceTypeSymbol;
                if (!classSymbol3.isInterface()) {
                    return classSymbol3.equalTo(parser.javaLangObjectSymbol);
                }
                return classSymbol.implementsInterface(classSymbol3);
            }
            return false;
        }
        if (referenceTypeSymbol.isClass()) {
            ClassSymbol classSymbol = (ClassSymbol)referenceTypeSymbol;
            if (!classSymbol.isInterface()) {
                return classSymbol.equalTo(parser.javaLangObjectSymbol);
            }
            return classSymbol.equalTo(parser.javaLangCloneableSymbol) || classSymbol.equalTo(parser.javaIoSerializableSymbol);
        }
        ArraySymbol arraySymbol = (ArraySymbol)this;
        ArraySymbol arraySymbol2 = (ArraySymbol)referenceTypeSymbol;
        TypeSymbol typeSymbol = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
        TypeSymbol typeSymbol2 = ArraySymbol.getArrayType(arraySymbol2.baseType, arraySymbol2.dimension - 1);
        if (typeSymbol.isPrimitiveType() || typeSymbol2.isPrimitiveType()) {
            return typeSymbol == typeSymbol2;
        }
        return ((ReferenceTypeSymbol)typeSymbol).isAssignmentCompatible(parser, (ReferenceTypeSymbol)typeSymbol2);
    }

    boolean isReturnSubstitutable(Parser parser, ReferenceTypeSymbol referenceTypeSymbol) {
        if (referenceTypeSymbol.equalTo(this)) {
            return true;
        }
        if (this.isClass()) {
            ClassSymbol classSymbol = (ClassSymbol)this;
            if (!classSymbol.isInterface()) {
                if (referenceTypeSymbol.isClass()) {
                    ClassSymbol classSymbol2 = (ClassSymbol)referenceTypeSymbol;
                    if (!classSymbol2.isInterface()) {
                        return classSymbol.isSuperclass(classSymbol2);
                    }
                    return classSymbol.equalTo(parser.javaLangObjectSymbol);
                }
                return classSymbol.equalTo(parser.javaLangObjectSymbol);
            }
            if (referenceTypeSymbol.isClass()) {
                ClassSymbol classSymbol3 = (ClassSymbol)referenceTypeSymbol;
                return classSymbol3.implementsInterface(classSymbol);
            }
            return classSymbol.equalTo(parser.javaLangCloneableSymbol) || classSymbol.equalTo(parser.javaIoSerializableSymbol);
        }
        if (referenceTypeSymbol.isClass()) {
            return false;
        }
        ArraySymbol arraySymbol = (ArraySymbol)this;
        ArraySymbol arraySymbol2 = (ArraySymbol)referenceTypeSymbol;
        TypeSymbol typeSymbol = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
        TypeSymbol typeSymbol2 = ArraySymbol.getArrayType(arraySymbol2.baseType, arraySymbol2.dimension - 1);
        if (typeSymbol.isPrimitiveType() || typeSymbol2.isPrimitiveType()) {
            return typeSymbol == typeSymbol2;
        }
        return ((ReferenceTypeSymbol)typeSymbol).isReturnSubstitutable(parser, (ReferenceTypeSymbol)typeSymbol2);
    }

    static boolean compareMethods(MethodSymbol methodSymbol, MethodSymbol methodSymbol2) {
        if (methodSymbol.identifier != methodSymbol2.identifier) {
            return false;
        }
        if (methodSymbol.argCount != methodSymbol2.argCount) {
            return false;
        }
        if (methodSymbol.argumentList == null || methodSymbol2.argumentList == null) {
            return methodSymbol.argumentList == methodSymbol2.argumentList;
        }
        return methodSymbol.argumentList.equals(methodSymbol2.argumentList);
    }

    private static boolean checkInterfaces(Parser parser, ClassSymbol classSymbol, ClassSymbol classSymbol2) {
        if (!($assertionsDisabled || classSymbol.isInterface() && classSymbol2.isInterface())) {
            throw new AssertionError();
        }
        MethodSymbol[] methodSymbolArray = classSymbol.getClassSymbol().getMethodTable(parser);
        MethodSymbol[] methodSymbolArray2 = classSymbol2.getClassSymbol().getMethodTable(parser);
        int n = methodSymbolArray.length;
        block0: while (--n >= 0) {
            MethodSymbol methodSymbol = methodSymbolArray[n];
            if (methodSymbol.definingClass == parser.javaLangObjectSymbol) continue;
            int n2 = methodSymbolArray2.length;
            while (--n2 >= 0) {
                MethodSymbol methodSymbol2 = methodSymbolArray2[n2];
                if (methodSymbol2.definingClass == parser.javaLangObjectSymbol || !ReferenceTypeSymbol.compareMethods(methodSymbol, methodSymbol2)) continue;
                if (methodSymbol.resultType.equalTo(methodSymbol2.resultType)) continue block0;
                return false;
            }
        }
        return true;
    }

    boolean isCastCompatible(Parser parser, ReferenceTypeSymbol referenceTypeSymbol) {
        if (referenceTypeSymbol.equalTo(this)) {
            return true;
        }
        if (this == nullTypeSymbol || referenceTypeSymbol == nullTypeSymbol) {
            return true;
        }
        if (this.isClass()) {
            ClassSymbol classSymbol = (ClassSymbol)this;
            if (classSymbol.isTypeParameter()) {
                return ((TypeParameterSymbol)this).bound.isCastCompatible(parser, referenceTypeSymbol);
            }
            if (!classSymbol.isInterface()) {
                if (referenceTypeSymbol.isClass()) {
                    ClassSymbol classSymbol2 = (ClassSymbol)referenceTypeSymbol;
                    if (classSymbol2.isTypeParameter()) {
                        return this.isCastCompatible(parser, ((TypeParameterSymbol)referenceTypeSymbol).bound);
                    }
                    if (!classSymbol2.isInterface()) {
                        return classSymbol2.isSuperclass(classSymbol) || classSymbol.isSuperclass(classSymbol2);
                    }
                    if ((classSymbol.access & 0x10) == 0) {
                        return true;
                    }
                    return classSymbol.implementsInterface(classSymbol2);
                }
                return classSymbol.equalTo(parser.javaLangObjectSymbol);
            }
            if (referenceTypeSymbol.isClass()) {
                ClassSymbol classSymbol3 = (ClassSymbol)referenceTypeSymbol;
                if (!classSymbol3.isInterface()) {
                    if ((classSymbol3.access & 0x10) == 0) {
                        return true;
                    }
                    return classSymbol3.implementsInterface(classSymbol);
                }
                if (parser.options.sourceJDKVersion >= 150) {
                    return true;
                }
                return ReferenceTypeSymbol.checkInterfaces(parser, classSymbol, classSymbol3);
            }
            return classSymbol.equalTo(parser.javaLangCloneableSymbol) || classSymbol.equalTo(parser.javaIoSerializableSymbol);
        }
        if (referenceTypeSymbol.isClass()) {
            ClassSymbol classSymbol = (ClassSymbol)referenceTypeSymbol;
            if (classSymbol.isTypeParameter()) {
                return this.isCastCompatible(parser, ((TypeParameterSymbol)referenceTypeSymbol).bound);
            }
            if (!classSymbol.isInterface()) {
                return classSymbol.equalTo(parser.javaLangObjectSymbol);
            }
            return classSymbol.equalTo(parser.javaLangCloneableSymbol) || classSymbol.equalTo(parser.javaIoSerializableSymbol);
        }
        ArraySymbol arraySymbol = (ArraySymbol)this;
        ArraySymbol arraySymbol2 = (ArraySymbol)referenceTypeSymbol;
        TypeSymbol typeSymbol = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
        TypeSymbol typeSymbol2 = ArraySymbol.getArrayType(arraySymbol2.baseType, arraySymbol2.dimension - 1);
        if (typeSymbol.isPrimitiveType() || typeSymbol2.isPrimitiveType()) {
            return typeSymbol == typeSymbol2;
        }
        return ((ReferenceTypeSymbol)typeSymbol).isCastCompatible(parser, (ReferenceTypeSymbol)typeSymbol2);
    }

    static {
        $assertionsDisabled = !ReferenceTypeSymbol.class.desiredAssertionStatus();
    }
}

