/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.IdeEnv;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;
import oracle.ojc.storage.JarStorage;

public class Options {
    public static final int JDK_1_1_0 = 110;
    public static final int JDK_1_2_0 = 120;
    public static final int JDK_1_3_0 = 130;
    public static final int JDK_1_4_0 = 140;
    public static final int JDK_1_5_0 = 150;
    public static final int JDK_1_6_0 = 160;
    public Log log;
    public IdeEnv ideEnv;
    public int sourceJDKVersion;
    public int targetJDKVersion;
    boolean sourceTargetJDKDefault;
    int javaLangObjectJDKVersion;
    String fileSeparator;
    String pathSeparator;
    String prependBootClasspathStr;
    public String bootClasspathStr;
    String appendBootClasspathStr;
    String endorseddirsStr;
    String extdirsStr;
    public String classpathStr;
    public Storage[] classpathStorage;
    public String sourcepathStr;
    public Storage[] sourcepathStorage;
    Storage[] bootClasspath;
    Storage[] endorseddirs;
    Storage[] extdirs;
    Storage[] classpath;
    Storage[] sourcepath;
    String[] deployExtensions;
    public ArrayList excludeClasses;
    public Storage makeFile;
    public String destinationDir;
    Storage destinationFile;
    public String encoding;
    char[][] tagNameList;
    int messageLimit;
    int errorLimit;
    int warningLimit;
    boolean noCodeGeneration;
    boolean helpPrinted;
    public boolean verbose;
    boolean verbosepath;
    public boolean noquiet;
    public boolean lineNumbers;
    public boolean sourceFile;
    public boolean localVariables;
    public boolean codecoach;
    public boolean omitAssertions;
    public boolean selfDeprecation;
    boolean strictfpmethods;
    boolean elapsedTime;
    boolean noWarnings;
    boolean warnNonExistingPath;
    boolean warningsAreErrors;
    public boolean rebuild;
    public boolean generateClassesDespiteErrors;
    public boolean lineColumnInfo;
    boolean nameReferences;
    private static Map supportedOptionsTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Options(Log log) {
        this.log = log;
        this.sourceTargetJDKDefault = true;
        this.targetJDKVersion = 150;
        this.sourceJDKVersion = 150;
        this.fileSeparator = System.getProperty("file.separator");
        this.pathSeparator = System.getProperty("path.separator");
        this.encoding = Options.getDefaultEncoding();
        this.lineNumbers = true;
        this.sourceFile = true;
        this.messageLimit = 1000;
        this.warningLimit = Integer.MAX_VALUE;
        this.errorLimit = Integer.MAX_VALUE;
        this.warnNonExistingPath = true;
    }

    private void listFiles(ArrayList arrayList, Storage storage, String string, boolean bl) {
        ArrayList arrayList2 = storage.listStorage();
        if (arrayList2 != null) {
            int n;
            int n2 = n = arrayList2.size();
            while (--n2 >= 0) {
                Storage storage2 = (Storage)arrayList2.get(n2);
                String string2 = storage2.getName();
                if (string != null && !string2.endsWith(string)) continue;
                if (bl) {
                    arrayList.add(storage2);
                    continue;
                }
                string2 = string2.substring(0, string2.indexOf(46));
                arrayList.add(Identifier.getIdentifier(string2));
            }
        }
    }

    private ArrayList findInPackage(Storage[] storageArray, String string) {
        if (storageArray == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(20);
        for (int i = 0; i < storageArray.length; ++i) {
            this.listFiles(arrayList, storageArray[i], string, false);
        }
        return arrayList;
    }

    ArrayList findClassesInPackage(PackageSymbol packageSymbol) {
        return this.findInPackage(packageSymbol.classStorage, ".class");
    }

    ArrayList findSourcesInPackage(PackageSymbol packageSymbol) {
        return this.findInPackage(packageSymbol.sourceStorage, ".java");
    }

    ArrayList findSourcesInPackage(Parser parser, String string) {
        PackageSymbol packageSymbol = PackageSymbol.getPackageSymbol(parser, string);
        Storage[] storageArray = packageSymbol.sourceStorage;
        if (storageArray == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(20);
        for (int i = 0; i < storageArray.length; ++i) {
            this.listFiles(arrayList, storageArray[i], null, true);
        }
        return arrayList.size() == 0 ? null : arrayList;
    }

    Storage findStorageOfClass(String string) {
        return null;
    }

    Storage findStorageOfClass(RawClassSymbol rawClassSymbol) {
        String string = new String(rawClassSymbol.getInternalName());
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? string + ".class" : string.substring(n + 1) + ".class";
        PackageScope packageScope = (PackageScope)rawClassSymbol.getPackageScope();
        PackageSymbol packageSymbol = packageScope.packageSymbol;
        Storage[] storageArray = packageSymbol == null ? this.classpath : packageSymbol.classStorage;
        if (storageArray == null) {
            return null;
        }
        for (int i = 0; i < storageArray.length; ++i) {
            Storage storage = storageArray[i].open(string2);
            if (storage == null) continue;
            return storage;
        }
        return null;
    }

    Storage findStorageOfSource(RawClassSymbol rawClassSymbol) {
        String string = new String(rawClassSymbol.getInternalName());
        int n = string.lastIndexOf(47);
        String string2 = n < 0 ? string + ".java" : string.substring(n + 1) + ".java";
        PackageScope packageScope = (PackageScope)rawClassSymbol.getPackageScope();
        PackageSymbol packageSymbol = packageScope.packageSymbol;
        Storage[] storageArray = packageSymbol == null ? this.sourcepath : packageSymbol.sourceStorage;
        if (storageArray == null) {
            return null;
        }
        for (int i = 0; i < storageArray.length; ++i) {
            Storage storage = storageArray[i].open(string2);
            if (storage == null) continue;
            return storage;
        }
        return null;
    }

    void findSourceStorageForPackage(PackageSymbol packageSymbol) {
        int n;
        ArrayList<Storage> arrayList = new ArrayList<Storage>();
        String string = packageSymbol.identifier.toString();
        PackageSymbol packageSymbol2 = packageSymbol.getOuterPackage();
        Storage[] storageArray = packageSymbol2 == null ? this.sourcepath : packageSymbol2.sourceStorage;
        if (storageArray != null) {
            for (int i = 0; i < storageArray.length; ++i) {
                Storage storage = storageArray[i].open(string);
                if (storage == null) continue;
                arrayList.add(storage);
            }
        }
        if ((n = arrayList.size()) > 0) {
            packageSymbol.sourceStorage = arrayList.toArray(new Storage[n]);
        }
    }

    void findClassStorageForPackage(PackageSymbol packageSymbol) {
        int n;
        ArrayList<Storage> arrayList = new ArrayList<Storage>();
        String string = packageSymbol.identifier.toString() + '/';
        PackageSymbol packageSymbol2 = packageSymbol.getOuterPackage();
        if (packageSymbol2 == null) {
            Storage storage;
            int n2;
            if (this.targetJDKVersion >= 120) {
                if (this.endorseddirs != null) {
                    for (n2 = 0; n2 < this.endorseddirs.length; ++n2) {
                        storage = this.endorseddirs[n2].open(string);
                        if (storage == null) continue;
                        arrayList.add(storage);
                    }
                }
                if (this.bootClasspath != null) {
                    for (n2 = 0; n2 < this.bootClasspath.length; ++n2) {
                        storage = this.bootClasspath[n2].open(string);
                        if (storage == null) continue;
                        arrayList.add(storage);
                    }
                }
            }
            if (this.extdirs != null) {
                for (n2 = 0; n2 < this.extdirs.length; ++n2) {
                    storage = this.extdirs[n2].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
            if (this.classpath != null) {
                for (n2 = 0; n2 < this.classpath.length; ++n2) {
                    storage = this.classpath[n2].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
            if (this.targetJDKVersion == 110 && this.bootClasspath != null) {
                for (n2 = 0; n2 < this.bootClasspath.length; ++n2) {
                    storage = this.bootClasspath[n2].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
        } else {
            Storage[] storageArray = packageSymbol2.classStorage;
            if (storageArray != null) {
                for (int i = 0; i < storageArray.length; ++i) {
                    Storage storage = storageArray[i].open(string);
                    if (storage == null) continue;
                    arrayList.add(storage);
                }
            }
        }
        if ((n = arrayList.size()) > 0) {
            packageSymbol.classStorage = arrayList.toArray(new Storage[n]);
        }
    }

    public static String[] stringToArray(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (true) {
            ++n2;
            if ((n = string.indexOf(string2, n)) < 0) break;
            ++n;
        }
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        n2 = 0;
        while (true) {
            if ((n = string.indexOf(string2, n3)) < 0) break;
            stringArray[n2++] = string.substring(n3, n);
            n3 = n + 1;
        }
        stringArray[n2] = string.substring(n3);
        return stringArray;
    }

    protected Storage[] makeClassPath(String string, String string2, boolean bl, boolean bl2) {
        String[] stringArray = Options.stringToArray(string, this.pathSeparator);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        ArrayList arrayList = new ArrayList(n + 10);
        HashSet hashSet = new HashSet(n + 10);
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i];
            if (string3 == null || string3.length() <= 0) continue;
            File file = new File(string3);
            this.addClassPathItemToList(string2, bl, bl2, arrayList, hashSet, string3, file);
        }
        return arrayList.toArray(new Storage[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addClassPathItemToList(String string, boolean bl, boolean bl2, ArrayList arrayList, HashSet hashSet, String string2, File file) {
        if (string2.indexOf("..") >= 0) {
            try {
                string2 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (hashSet.contains(string2)) {
            return;
        }
        if (this.verbosepath) {
            this.log.println("Dynamically adding entry to classpath: " + string2);
        }
        hashSet.add(string2);
        if (!file.exists()) {
            if (!(bl & this.warnNonExistingPath)) return;
            Warning warning = new Warning(null, Message.warningDirectoryDoesntExist, 0, string2, string);
            this.log.println(Message.warningColonString + warning.message.getMessage());
            return;
        }
        if (string2.endsWith(".zip") || string2.endsWith(".jar")) {
            String string3;
            Attributes attributes;
            Manifest manifest;
            arrayList.add(new JarStorage(file));
            JarFile jarFile = null;
            jarFile = new JarFile(file);
            if (jarFile != null && (manifest = jarFile.getManifest()) != null && (attributes = manifest.getMainAttributes()) != null && (string3 = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                File file2 = file.getParentFile();
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    File file3 = new File(file2, string4);
                    this.addClassPathItemToList(string, bl, bl2, arrayList, hashSet, file3.getAbsolutePath(), file3);
                }
            }
            Object var17_25 = null;
            if (jarFile == null) return;
            try {
                jarFile.close();
                return;
            }
            catch (IOException iOException) {}
            return;
            {
                catch (IOException iOException) {
                    this.log.println(iOException.getLocalizedMessage());
                    Object var17_26 = null;
                    if (jarFile == null) return;
                    try {
                        jarFile.close();
                        return;
                    }
                    catch (IOException iOException2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var17_27 = null;
                if (jarFile == null) throw throwable;
                try {
                    jarFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (bl2) {
            if (!file.isDirectory()) return;
            DirectoryStorage directoryStorage = new DirectoryStorage(file);
            ArrayList arrayList2 = directoryStorage.listStorage();
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                String string5 = ((Storage)arrayList2.get(i)).getPath();
                if (!string5.endsWith(".zip") && !string5.endsWith(".jar")) continue;
                File file4 = new File(string5);
                this.addClassPathItemToList(string, bl, bl2, arrayList, hashSet, string5, file4);
            }
            return;
        } else {
            if (!file.isDirectory()) return;
            arrayList.add(new DirectoryStorage(file));
        }
    }

    public static String getDefaultEncoding() {
        return Options.getEncoding("default");
    }

    public static String getEncoding(String string) {
        if (string == null || string.equals("null")) {
            return null;
        }
        if (string.equalsIgnoreCase("default")) {
            String string2 = System.getProperty("file.encoding", "8859_1");
            if (string2 != null && string2.equals("ISO8859_1")) {
                return null;
            }
            return string2;
        }
        return string;
    }

    static String JDKVersionToString(int n) {
        switch (n) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 110: {
                return "1.1";
            }
            case 120: {
                return "1.2";
            }
            case 130: {
                return "1.3";
            }
            case 140: {
                return "1.4";
            }
            case 150: {
                return "1.5";
            }
            case 160: 
        }
        return "1.6";
    }

    boolean checkSourceTargetVersions() {
        switch (this.sourceJDKVersion) {
            default: {
                return true;
            }
            case 140: 
            case 150: 
            case 160: 
        }
        if (this.targetJDKVersion >= this.sourceJDKVersion) {
            return true;
        }
        Error error = new Error(null, Message.errorIncompatibleSourceTargetVersion, 0, Options.JDKVersionToString(this.targetJDKVersion), Options.JDKVersionToString(this.sourceJDKVersion));
        this.log.println(Message.errorColonString + error.message.getMessage());
        return false;
    }

    public int parseOption(String[] stringArray, int n) {
        String string = stringArray[n];
        if (string.startsWith("-g")) {
            if (string.equals("-g")) {
                this.codecoach = true;
                this.localVariables = true;
            } else if (string.equals("-g:none")) {
                this.sourceFile = false;
                this.lineNumbers = false;
            } else {
                this.lineNumbers = string.indexOf("lines") > 0;
                this.sourceFile = string.indexOf("source") > 0;
                this.localVariables = string.indexOf("vars") > 0;
                this.codecoach = string.indexOf("codecoach") > 0;
            }
            return 1;
        }
        if (string.equals("-nowarn")) {
            this.noWarnings = true;
            this.warnNonExistingPath = false;
            Warning.disableAllWarnings();
            return 1;
        }
        if (string.equals("-verbose")) {
            this.verbose = true;
            this.verbosepath = true;
            return 1;
        }
        if (string.startsWith("-deprecation")) {
            if (string.endsWith(":self")) {
                this.selfDeprecation = true;
            }
            Warning.enableWarning(Message.warningIsDeprecated.getNumber());
            return 1;
        }
        if (string.equals("-classpath") || string.equals("-cp")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.classpathStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-sourcepath")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.sourcepathStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-bootclasspath") || string.equals("-sysclasspath")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.bootClasspathStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-extdirs")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.extdirsStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-endorseddirs")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingPathnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.endorseddirsStr = stringArray[n + 1];
            return 2;
        }
        if (string.equals("-d")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingDirectoryName, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.destinationDir = stringArray[n + 1];
            if (!this.destinationDir.endsWith(this.fileSeparator)) {
                this.destinationDir = this.destinationDir + this.fileSeparator;
            }
            return 2;
        }
        if (string.equals("-encoding")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingEncoding, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.encoding = Options.getEncoding(stringArray[n + 1]);
            return 2;
        }
        if (string.equals("-source")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            string = stringArray[n + 1];
            if (string.startsWith("1.1")) {
                this.sourceJDKVersion = 110;
            } else if (string.startsWith("1.2")) {
                this.sourceJDKVersion = 120;
            } else if (string.startsWith("1.3")) {
                this.sourceJDKVersion = 130;
            } else if (string.startsWith("1.4")) {
                this.targetJDKVersion = 140;
                this.sourceJDKVersion = 140;
            } else if (string.startsWith("1.5") || string.startsWith("5")) {
                this.targetJDKVersion = 150;
                this.sourceJDKVersion = 150;
            } else if (string.startsWith("1.6") || string.startsWith("6")) {
                this.targetJDKVersion = 160;
                this.sourceJDKVersion = 160;
            } else {
                Error error = new Error(null, Message.errorUnsupportedVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.sourceTargetJDKDefault = false;
            return 2;
        }
        if (string.equals("-target")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            string = stringArray[n + 1];
            if (string.startsWith("1.1")) {
                this.targetJDKVersion = 110;
            } else if (string.startsWith("1.2")) {
                this.targetJDKVersion = 120;
            } else if (string.startsWith("1.3")) {
                this.targetJDKVersion = 130;
            } else if (string.startsWith("1.4")) {
                this.targetJDKVersion = 140;
            } else if (string.startsWith("1.5") || string.startsWith("5")) {
                this.targetJDKVersion = 150;
            } else if (string.startsWith("1.6") || string.startsWith("6")) {
                this.targetJDKVersion = 160;
            } else {
                Error error = new Error(null, Message.errorUnsupportedVersionNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.sourceTargetJDKDefault = false;
            return 2;
        }
        if (string.equals("-version")) {
            this.helpPrinted = true;
            this.log.println("ojc 10.1.3 build 4306");
            return 1;
        }
        if (string.equals("-help") || string.equals("--help")) {
            this.helpPrinted = true;
            Compiler.standardUsage(this.log);
            return 1;
        }
        if (string.startsWith("-J-")) {
            return 1;
        }
        if (string.equals("-X")) {
            this.helpPrinted = true;
            Compiler.nonstandardUsage(this.log);
            return 1;
        }
        if (string.startsWith("-et")) {
            this.elapsedTime = true;
            return 1;
        }
        if (string.equals("-exclude")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingClassnameList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            if (this.excludeClasses == null) {
                this.excludeClasses = new ArrayList();
            }
            String[] stringArray2 = Options.stringToArray(stringArray[n + 1], File.pathSeparator);
            for (int i = 0; i < stringArray2.length; ++i) {
                this.excludeClasses.add(stringArray2[i]);
            }
            return 2;
        }
        if (string.equals("-make")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingFilename, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.makeFile = new FileStorage(new File(stringArray[n + 1]));
            return 2;
        }
        if (string.equals("-rebuild")) {
            this.rebuild = true;
            return 1;
        }
        if (string.equals("-obfuscate") || string.startsWith("-updateimports")) {
            Error error = new Error(null, Message.warningObsoleteCompilerOption, 0, string);
            this.log.println(Message.warningColonString + error.message.getMessage());
            return 1;
        }
        if (string.startsWith("-msglimit:")) {
            String string2 = string.substring(string.indexOf(58) + 1);
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < -1) {
                    throw new NumberFormatException();
                }
                if (n2 == -1) {
                    n2 = Integer.MAX_VALUE;
                }
                this.messageLimit = n2;
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, string2);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 1;
        }
        if (string.startsWith("-nowarn:")) {
            String string3 = string.substring(string.indexOf(58) + 1);
            try {
                Warning.disableWarning(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorWarningNumberExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 1;
        }
        if (string.equals("-O")) {
            return 1;
        }
        if (string.equals("-noquiet")) {
            this.noquiet = true;
            return 1;
        }
        if (string.equals("-nowrite")) {
            this.noCodeGeneration = true;
            return 1;
        }
        if (string.equals("-strictfp")) {
            this.strictfpmethods = true;
            return 1;
        }
        if (string.equals("-verbosepath")) {
            this.verbosepath = true;
            return 1;
        }
        if (string.equals("-warn")) {
            this.noWarnings = false;
            this.warnNonExistingPath = true;
            Warning.enableAllWarnings();
            return 1;
        }
        if (string.startsWith("-warn:")) {
            this.noWarnings = false;
            String string4 = string.substring(string.indexOf(58) + 1);
            try {
                Warning.enableWarning(Integer.parseInt(string4));
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorWarningNumberExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 1;
        }
        if (string.equals("-warningtag")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingTagList, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            String[] stringArray3 = Options.stringToArray(stringArray[n + 1], ",");
            this.tagNameList = new char[stringArray3.length][];
            for (int i = 0; i < stringArray3.length; ++i) {
                this.tagNameList[i] = stringArray3[i].toCharArray();
            }
            return 2;
        }
        if (string.equals("-deploy")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorDeployExtensionsExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.deployExtensions = Options.stringToArray(stringArray[n + 1], this.pathSeparator);
            return 2;
        }
        if (string.equals("-Xomitasserts")) {
            this.omitAssertions = true;
            return 1;
        }
        if (string.equals("-Xwarnerror")) {
            this.warningsAreErrors = true;
            return 1;
        }
        if (string.equals("-Xhelp")) {
            this.helpPrinted = true;
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorOptionExpected, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            Compiler.help(this.log, stringArray[n + 1]);
            return 2;
        }
        if (string.startsWith("-Djava.endorsed.dirs=")) {
            this.endorseddirsStr = string.substring(21);
            return 1;
        }
        if (string.startsWith("-Djava.ext.dirs=")) {
            this.extdirsStr = string.substring(16);
            return 1;
        }
        if (string.startsWith("-Xbootclasspath/:")) {
            this.bootClasspathStr = stringArray[n].substring(17);
            return 1;
        }
        if (string.startsWith("-Xbootclasspath/a:")) {
            this.appendBootClasspathStr = stringArray[n].substring(18);
            return 1;
        }
        if (string.startsWith("-Xbootclasspath/p:")) {
            this.prependBootClasspathStr = stringArray[n].substring(18);
            return 1;
        }
        if (string.startsWith("-Xlint")) {
            if (string.equals("-Xlint")) {
                this.warnNonExistingPath = true;
                Warning.enableWarning(Message.warningFallThrough.getNumber());
                Warning.enableWarning(Message.warningUnterminatedFinally.getNumber());
                Warning.enableWarning(Message.warningNoSerialVersionUID.getNumber());
                Warning.enableWarning(Message.warningUncheckedConversion.getNumber());
            } else if (string.equals("-Xlint:none")) {
                this.warnNonExistingPath = false;
                Warning.disableAllWarnings();
            } else if (string.equals("-Xlint:fallthrough")) {
                Warning.enableWarning(Message.warningFallThrough.getNumber());
            } else if (string.equals("-Xlint:-fallthrough")) {
                Warning.disableWarning(Message.warningFallThrough.getNumber());
            } else if (string.equals("-Xlint:finally")) {
                Warning.enableWarning(Message.warningUnterminatedFinally.getNumber());
            } else if (string.equals("-Xlint:-finally")) {
                Warning.disableWarning(Message.warningUnterminatedFinally.getNumber());
            } else if (string.equals("-Xlint:path")) {
                this.warnNonExistingPath = true;
            } else if (string.equals("-Xlint:-path")) {
                this.warnNonExistingPath = false;
            } else if (string.equals("-Xlint:serial")) {
                Warning.enableWarning(Message.warningNoSerialVersionUID.getNumber());
            } else if (string.equals("-Xlint:-serial")) {
                Warning.disableWarning(Message.warningNoSerialVersionUID.getNumber());
            } else if (string.equals("-Xlint:unchecked")) {
                Warning.enableWarning(Message.warningUncheckedConversion.getNumber());
            } else if (string.equals("-Xlint:-unchecked")) {
                Warning.disableWarning(Message.warningUncheckedConversion.getNumber());
            }
            return 1;
        }
        if (string.equals("-Xmaxerrors")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            String string5 = stringArray[n + 1];
            try {
                int n3 = Integer.parseInt(string5);
                if (n3 < -1) {
                    throw new NumberFormatException();
                }
                if (n3 == -1) {
                    n3 = Integer.MAX_VALUE;
                }
                this.errorLimit = n3;
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, string5);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 2;
        }
        if (string.equals("-Xmaxwarns")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingNumber, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            String string6 = stringArray[n + 1];
            try {
                int n4 = Integer.parseInt(string6);
                if (n4 < -1) {
                    throw new NumberFormatException();
                }
                if (n4 == -1) {
                    n4 = Integer.MAX_VALUE;
                }
                this.warningLimit = n4;
            }
            catch (NumberFormatException numberFormatException) {
                Error error = new Error(null, Message.errorInvalidMessageLimit, 0, string6);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            return 2;
        }
        if (string.equals("-Xstdout")) {
            if (n + 1 >= stringArray.length) {
                Error error = new Error(null, Message.errorMissingFilename, 0, string);
                this.log.println(Message.errorColonString + error.message.getMessage());
                return 0;
            }
            this.log.redirect(stringArray[n + 1]);
            return 2;
        }
        if (string.equals("-forcecodegen")) {
            this.generateClassesDespiteErrors = true;
            return 1;
        }
        Error error = new Error(null, Message.errorUnknownCompilerOption, 0, string);
        this.log.println(Message.errorColonString + error.message.getMessage());
        return 0;
    }

    public static int isSupportedOption(String string) {
        Integer n;
        if (string.startsWith("-msglimit:") || string.startsWith("-nowarn:") || string.startsWith("-warn:")) {
            String string2 = string.substring(string.indexOf(58) + 1);
            try {
                int n2 = Integer.parseInt(string2);
                if (string.startsWith("-msglimit:")) {
                    return n2 < -1 ? -1 : 0;
                }
                return n2 < 1 ? -1 : 0;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        if (string.startsWith("-Djava.endorsed.dirs=") || string.startsWith("-Xbootclasspath/:") || string.startsWith("-Xbootclasspath/a:") || string.startsWith("-Xbootclasspath/p:") || string.startsWith("-Djava.ext.dirs=")) {
            return 0;
        }
        if (supportedOptionsTable == null) {
            supportedOptionsTable = new Hashtable();
            supportedOptionsTable.put("-bootclasspath", new Integer(1));
            supportedOptionsTable.put("-classpath", new Integer(1));
            supportedOptionsTable.put("-cp", new Integer(1));
            supportedOptionsTable.put("-d", new Integer(1));
            supportedOptionsTable.put("-deploy", new Integer(1));
            supportedOptionsTable.put("-deprecation", new Integer(0));
            supportedOptionsTable.put("-deprecation:self", new Integer(0));
            supportedOptionsTable.put("-encoding", new Integer(1));
            supportedOptionsTable.put("-endorseddirs", new Integer(1));
            supportedOptionsTable.put("-et", new Integer(0));
            supportedOptionsTable.put("-exclude", new Integer(1));
            supportedOptionsTable.put("-extdirs", new Integer(1));
            supportedOptionsTable.put("-forcecodegen", new Integer(0));
            supportedOptionsTable.put("-g", new Integer(0));
            supportedOptionsTable.put("-g:codecoach", new Integer(0));
            supportedOptionsTable.put("-g:lines", new Integer(0));
            supportedOptionsTable.put("-g:none", new Integer(0));
            supportedOptionsTable.put("-g:source", new Integer(0));
            supportedOptionsTable.put("-g:vars", new Integer(0));
            supportedOptionsTable.put("-help", new Integer(0));
            supportedOptionsTable.put("-make", new Integer(1));
            supportedOptionsTable.put("-namereferences", new Integer(0));
            supportedOptionsTable.put("-noquiet", new Integer(0));
            supportedOptionsTable.put("-nowarn", new Integer(0));
            supportedOptionsTable.put("-nowrite", new Integer(0));
            supportedOptionsTable.put("-O", new Integer(0));
            supportedOptionsTable.put("-rebuild", new Integer(0));
            supportedOptionsTable.put("-source", new Integer(1));
            supportedOptionsTable.put("-sourcepath", new Integer(1));
            supportedOptionsTable.put("-strictfp", new Integer(0));
            supportedOptionsTable.put("-sysclasspath", new Integer(1));
            supportedOptionsTable.put("-target", new Integer(1));
            supportedOptionsTable.put("-verbose", new Integer(0));
            supportedOptionsTable.put("-verbosepath", new Integer(0));
            supportedOptionsTable.put("-version", new Integer(0));
            supportedOptionsTable.put("-warn", new Integer(0));
            supportedOptionsTable.put("-warningtag", new Integer(1));
            supportedOptionsTable.put("-X", new Integer(0));
            supportedOptionsTable.put("-Xhelp", new Integer(1));
            supportedOptionsTable.put("-Xlint", new Integer(0));
            supportedOptionsTable.put("-Xlint:fallthrough", new Integer(0));
            supportedOptionsTable.put("-Xlint:-fallthrough", new Integer(0));
            supportedOptionsTable.put("-Xlint:finally", new Integer(0));
            supportedOptionsTable.put("-Xlint:-finally", new Integer(0));
            supportedOptionsTable.put("-Xlint:none", new Integer(0));
            supportedOptionsTable.put("-Xmaxerrors", new Integer(1));
            supportedOptionsTable.put("-Xmaxwarns", new Integer(1));
            supportedOptionsTable.put("-Xomitasserts", new Integer(0));
            supportedOptionsTable.put("-Xpath", new Integer(0));
            supportedOptionsTable.put("-X-path", new Integer(0));
            supportedOptionsTable.put("-Xserial", new Integer(0));
            supportedOptionsTable.put("-X-serial", new Integer(0));
            supportedOptionsTable.put("-Xstdout", new Integer(1));
            supportedOptionsTable.put("-Xunchecked", new Integer(0));
            supportedOptionsTable.put("-X-unchecked", new Integer(0));
            supportedOptionsTable.put("-Xwarnerror", new Integer(0));
        }
        return (n = (Integer)supportedOptionsTable.get(string)) == null ? -1 : n;
    }

    private static boolean printStoragePath(PrintStream printStream, Storage[] storageArray, String string, boolean bl) {
        int n = storageArray.length;
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                bl = true;
            } else {
                printStream.print(string);
            }
            printStream.print(storageArray[i].getPath());
        }
        return bl;
    }

    void print(PrintStream printStream) {
        printStream.println("\tsource:         " + this.sourceJDKVersion);
        printStream.println("\ttarget:         " + this.targetJDKVersion);
        printStream.println();
        printStream.print("\tclasspath:        ");
        boolean bl = false;
        if (this.endorseddirs != null) {
            bl = Options.printStoragePath(printStream, this.endorseddirs, this.pathSeparator, bl);
        }
        if (this.bootClasspath != null) {
            bl = Options.printStoragePath(printStream, this.bootClasspath, this.pathSeparator, bl);
        }
        if (this.extdirs != null) {
            bl = Options.printStoragePath(printStream, this.extdirs, this.pathSeparator, bl);
        }
        if (this.classpath != null) {
            Options.printStoragePath(printStream, this.classpath, this.pathSeparator, bl);
        }
        printStream.println();
        printStream.println();
        printStream.print("\tsourcepath:       ");
        if (this.sourcepath != null) {
            Options.printStoragePath(printStream, this.sourcepath, "", false);
        }
        printStream.println();
        printStream.println();
        printStream.println("\tencoding:       " + this.encoding);
        printStream.println();
        printStream.print("\texcluded cls:  ");
        if (this.excludeClasses != null) {
            int n = this.excludeClasses.size();
            for (int i = 0; i < n; ++i) {
                printStream.println("\t" + (String)this.excludeClasses.get(i));
            }
        }
        printStream.println();
        printStream.println("\trebuild:        " + this.rebuild);
        printStream.println("\tnoCodeGen:      " + this.noCodeGeneration);
        printStream.println("\tlineNumbers:    " + this.lineNumbers);
        printStream.println("\tsourceFile:     " + this.sourceFile);
        printStream.println("\tlocalVars:      " + this.localVariables);
        printStream.println("\tcodecoach:      " + this.codecoach);
        printStream.println("\tomitAsserts:    " + this.omitAssertions);
    }

    static {
        $assertionsDisabled = !Options.class.desiredAssertionStatus();
    }
}

