/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class NegateExpression
extends UnaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    NegateExpression(int n, Expression expression) {
        super((byte)39, n, expression);
    }

    Expression foldExpression() {
        Expression expression = this.operand;
        if (expression.kind == 2) {
            TypeSymbol typeSymbol = expression.getType();
            switch (typeSymbol.typeClass) {
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                case 4: {
                    return new IntConstantExpression(this.pos, this.getType(), -((ConstantExpression)expression).getIntConstValue());
                }
                case 8: {
                    return new LongConstantExpression(this.pos, -((LongConstantExpression)expression).lval);
                }
                case 16: {
                    return new FloatConstantExpression(this.pos, -((FloatConstantExpression)expression).fval);
                }
                case 32: 
            }
            return new DoubleConstantExpression(this.pos, -((DoubleConstantExpression)expression).dval);
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol typeSymbol;
        Expression expression = this.operand.resolveAndCheck(parser);
        TypeSymbol typeSymbol2 = expression.getType();
        if (!(typeSymbol2.isNumericType() || parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && (typeSymbol = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && typeSymbol.isNumericType())) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol2.isErroneous(), this.toString(), typeSymbol2.errorName());
            return new ErrorExpression(error);
        }
        typeSymbol2 = TypeSymbol.unaryNumericPromotion(parser, typeSymbol2);
        this.setType(typeSymbol2);
        this.operand = expression.promoteType(parser, typeSymbol2);
        return this.foldExpression();
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.operand.generateByteCode(byteCodeGenerator);
        switch (this.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                byteCodeGenerator.generate_8((byte)116);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)117);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)118);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)119);
            }
        }
    }

    public String toString() {
        return "-";
    }

    static {
        $assertionsDisabled = !NegateExpression.class.desiredAssertionStatus();
    }
}

