/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.FieldInitializationStatement;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;

final class MethodSymbol
extends Symbol {
    static final short MSF_NONE = 0;
    static final short MSF_SYNTHETIC = 1;
    static final short MSF_CONSTRUCTOR_CALL_THIS = 2;
    static final short MSF_DEPRECATED = 4;
    static final short MSF_RESOLVED = 8;
    static final short MSF_USED = 16;
    static final short MSF_GENERATED = 32;
    static final short MSF_DEFAULTVALUE = 64;
    static final short MSF_HAS_PARAMETER_ANNOTATIONS = 64;
    static final short MSF_CHECK_OVERRIDE = 128;
    static final short MSF_INVOLVES_GENERICS = 256;
    static final short MSF_DEFAULT_CONSTRUCTOR = 512;
    MethodSymbol nextWithSameName;
    MethodSymbol nextInClass;
    RawClassSymbol definingClass;
    TypeParameterList typeParameterList;
    ArgumentVariableList argumentList;
    TypeSymbol resultType;
    int tpos;
    ThrowsList throwsList;
    Object annotation;
    char[] signature;
    short access;
    short flags;
    short argCount;
    short actualArgCount;
    short localVarCount;
    CompiledMethodData cmd;
    static /* synthetic */ Class class$oracle$ojc$compiler$MethodSymbol;

    MethodSymbol(int n, RawClassSymbol rawClassSymbol, Identifier identifier, TypeSymbol typeSymbol, int n2, short s, Annotation annotation, boolean bl) {
        super((byte)8, n, identifier);
        this.definingClass = rawClassSymbol;
        this.resultType = typeSymbol;
        this.tpos = n2;
        this.access = s;
        this.annotation = annotation;
        rawClassSymbol.cd.methodCount = (short)(rawClassSymbol.cd.methodCount + 1);
        if (bl) {
            this.cmd = new CompiledMethodData();
            this.cmd.localVariables = new ArrayList(10);
        }
    }

    void deprecate() {
        this.flags = (short)(this.flags | 4);
    }

    boolean isDeprecated() {
        return (this.flags & 4) != 0;
    }

    boolean isSynthetic() {
        return (this.flags & 1) != 0;
    }

    boolean isErroneous() {
        return this.definingClass.isErroneous() || this.resultType.isErroneous() || this.argumentList != null && this.argumentList.isErroneous();
    }

    String errorName() {
        StringBuffer stringBuffer;
        if (this.isErroneous()) {
            return "";
        }
        if (this.isConstructor()) {
            stringBuffer = new StringBuffer(Message.constructorString);
            stringBuffer.append(' ');
            stringBuffer.append(this.definingClass.identifier.toString());
        } else {
            if (this.identifier == Identifier.classInitializerIdentifier) {
                return Message.classInitializerString;
            }
            stringBuffer = new StringBuffer(Message.methodString);
            stringBuffer.append(' ');
            stringBuffer.append(this.identifier.toString());
        }
        stringBuffer.append('(');
        ArgumentVariableList argumentVariableList = this.argumentList;
        while (argumentVariableList != null) {
            stringBuffer.append(argumentVariableList.argSymbol.type.toString());
            if (argumentVariableList.next != null) {
                stringBuffer.append(", ");
            }
            argumentVariableList = argumentVariableList.next;
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    String kindName() {
        if (this.isConstructor()) {
            return Message.constructorString;
        }
        return Message.methodString;
    }

    char[] getSignature() {
        if (this.signature == null) {
            char[] cArray;
            InnerClassSymbol innerClassSymbol;
            InnerClassSymbol.HiddenArgumentList hiddenArgumentList;
            int n = this.argCount;
            if (this.isConstructor() && this.definingClass.isInnerClass()) {
                hiddenArgumentList = ((InnerClassSymbol)this.definingClass).hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    ++n;
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            }
            char[][] cArrayArray = new char[n][];
            int n2 = 2;
            int n3 = 0;
            if (this.isConstructor() && this.definingClass.isInnerClass()) {
                innerClassSymbol = (InnerClassSymbol)this.definingClass;
                hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    if (hiddenArgumentList.kind == 0 || hiddenArgumentList.kind == 1) {
                        cArray = hiddenArgumentList.type.getSignature();
                        cArrayArray[n3++] = cArray;
                        n2 += cArray.length;
                    }
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            }
            ArgumentVariableList argumentVariableList = this.argumentList;
            while (argumentVariableList != null) {
                cArray = argumentVariableList.argSymbol.getSignature();
                cArrayArray[n3++] = cArray;
                n2 += cArray.length;
                argumentVariableList = argumentVariableList.next;
            }
            if (this.isConstructor() && this.definingClass.isInnerClass()) {
                innerClassSymbol = (InnerClassSymbol)this.definingClass;
                hiddenArgumentList = innerClassSymbol.hiddenArgumentList;
                while (hiddenArgumentList != null) {
                    if (hiddenArgumentList.kind == 2) {
                        cArray = hiddenArgumentList.type.getSignature();
                        cArrayArray[n3++] = cArray;
                        n2 += cArray.length;
                    }
                    hiddenArgumentList = hiddenArgumentList.next;
                }
            }
            TypeSymbol typeSymbol = this.resultType;
            char[] cArray2 = typeSymbol.getSignature();
            this.signature = new char[n2 += cArray2.length];
            this.signature[0] = 40;
            int n4 = 1;
            for (n3 = 0; n3 < n; ++n3) {
                char[] cArray3 = cArrayArray[n3];
                System.arraycopy(cArray3, 0, this.signature, n4, cArray3.length);
                n4 += cArray3.length;
            }
            this.signature[n4++] = 41;
            System.arraycopy(cArray2, 0, this.signature, n4, cArray2.length);
        }
        return this.signature;
    }

    protected void toString(StringBuffer stringBuffer) {
        this.resultType.toString(stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(this.definingClass.toString());
        stringBuffer.append('.');
        if (this.identifier == Identifier.initializerIdentifier) {
            stringBuffer.append(this.definingClass.getClassName());
        } else {
            stringBuffer.append(this.identifier.name);
        }
        stringBuffer.append('(');
        ArgumentVariableList argumentVariableList = this.argumentList;
        if (argumentVariableList != null) {
            while (true) {
                argumentVariableList.argSymbol.type.toString(stringBuffer);
                argumentVariableList = argumentVariableList.next;
                if (argumentVariableList == null) break;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(')');
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(80);
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    Annotation getAnnotations() {
        if (this.isBridgeMethod()) {
            return null;
        }
        return (Annotation)this.annotation;
    }

    byte getAnnotationTarget() {
        if (this.isConstructor()) {
            return 16;
        }
        return 4;
    }

    boolean isGenerated() {
        return (this.flags & 0x20) != 0;
    }

    boolean isConstructor() {
        return this.identifier == Identifier.initializerIdentifier;
    }

    boolean isClassInitializer() {
        return this.identifier == Identifier.classInitializerIdentifier;
    }

    boolean isDynamicInitializer() {
        return this.identifier == Identifier.dynamicInitializerIdentifier;
    }

    boolean isDefaultConstructor() {
        return (this.flags & 0x200) != 0;
    }

    boolean isBridgeMethod() {
        return (this.access & 0x40) != 0;
    }

    boolean involvesGenerics() {
        return (this.flags & 0x100) != 0;
    }

    ArgumentVariableSymbol addArgument(TypeSymbol typeSymbol) {
        short s = this.localVarCount;
        this.localVarCount = (short)(s + 1);
        ArgumentVariableSymbol argumentVariableSymbol = new ArgumentVariableSymbol(0, this, null, typeSymbol, 0, 0, null, s);
        this.cmd.localVariables.add(argumentVariableSymbol);
        if ((typeSymbol.typeClass & 0x28) != 0) {
            this.actualArgCount = (short)(this.actualArgCount + 1);
            this.localVarCount = (short)(this.localVarCount + 1);
            this.cmd.localVariables.add(null);
        }
        this.actualArgCount = (short)(this.actualArgCount + 1);
        this.argCount = (short)(this.argCount + 1);
        ArgumentVariableList argumentVariableList = new ArgumentVariableList(argumentVariableSymbol);
        if (this.argumentList == null) {
            this.argumentList = argumentVariableList;
        } else {
            ArgumentVariableList argumentVariableList2 = this.argumentList;
            while (true) {
                if (argumentVariableList2.next == null) {
                    argumentVariableList2.next = argumentVariableList;
                    break;
                }
                argumentVariableList2 = argumentVariableList2.next;
            }
        }
        return argumentVariableSymbol;
    }

    boolean isAccessible(ClassSymbol classSymbol, ClassSymbol classSymbol2) {
        if (!classSymbol2.isAccessible(classSymbol)) {
            return false;
        }
        switch (this.access & 7) {
            case 2: {
                return this.definingClass.equalTo(classSymbol) && this.definingClass.equalTo(classSymbol2);
            }
            case 1: {
                return true;
            }
            case 4: {
                if (!this.definingClass.equalTo(classSymbol) && !this.definingClass.isSuperclass(classSymbol)) break;
                if ((this.access & 8) != 0) {
                    return true;
                }
                if (!classSymbol.equalTo(classSymbol2) && !classSymbol.isSuperclass(classSymbol2)) break;
                return true;
            }
        }
        return this.definingClass.inSamePackage(classSymbol);
    }

    boolean checkThrowsList(ClassSymbol classSymbol) {
        ThrowsList throwsList = this.throwsList;
        while (throwsList != null) {
            ClassSymbol classSymbol2 = (ClassSymbol)throwsList.throwsType;
            if (classSymbol.equalTo(classSymbol2) || classSymbol2.isSuperclass(classSymbol)) {
                return true;
            }
            throwsList = throwsList.next;
        }
        return false;
    }

    Statement getFirstStatement() {
        if (this.cmd == null || this.cmd.statementList == null) {
            return null;
        }
        return this.cmd.statementList.first;
    }

    boolean compareMethod(Identifier identifier, ArgumentVariableList argumentVariableList, TypeSymbol typeSymbol) {
        if (this.identifier != identifier) {
            return false;
        }
        if (argumentVariableList == null || this.argumentList == null ? this.argumentList != argumentVariableList : !this.argumentList.equals(argumentVariableList)) {
            return false;
        }
        if (typeSymbol == null) {
            return true;
        }
        return this.resultType.equalTo(typeSymbol);
    }

    private void initLocalVariableChecking(Parser parser) {
        short s = this.definingClass.cd.fieldCount;
        int n = s + this.localVarCount;
        parser.defSet = new BitSet(n);
        parser.posSet = new BitSet(n);
        parser.useSet = new BitSet(n);
        parser.defSet.set((int)s, s + this.actualArgCount);
        parser.posSet.set((int)s, s + this.actualArgCount);
        if (this.isClassInitializer()) {
            FieldSymbol fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) == 0 || (fieldSymbol.flags & Short.MIN_VALUE) != 0) {
                    parser.defSet.set(fieldSymbol.index);
                    parser.posSet.set(fieldSymbol.index);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        } else if (this.isConstructor()) {
            if ((this.flags & 2) != 0) {
                parser.defSet.set(0, s);
                parser.posSet.set(0, s);
            } else {
                FieldSymbol fieldSymbol = this.definingClass.cd.fieldList;
                while (fieldSymbol != null) {
                    if ((fieldSymbol.access & 8) != 0 || (fieldSymbol.flags & Short.MIN_VALUE) != 0) {
                        parser.defSet.set(fieldSymbol.index);
                        parser.posSet.set(fieldSymbol.index);
                    }
                    fieldSymbol = fieldSymbol.nextInClass;
                }
            }
        } else if (this.identifier == Identifier.dynamicInitializerIdentifier) {
            FieldSymbol fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) != 0 || (fieldSymbol.flags & Short.MIN_VALUE) != 0) {
                    parser.defSet.set(fieldSymbol.index);
                    parser.posSet.set(fieldSymbol.index);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        } else {
            parser.defSet.set(0, s);
            parser.posSet.set(0, s);
        }
    }

    private void doneLocalVariableChecking(Parser parser) {
        FieldSymbol fieldSymbol;
        int n = this.definingClass.cd.fieldCount;
        int n2 = n + this.localVarCount;
        if (this.isClassInitializer()) {
            fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) != 0 && parser.defSet.get(fieldSymbol.index)) {
                    fieldSymbol.flags = (short)(fieldSymbol.flags | Short.MIN_VALUE);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        } else if (this.isConstructor()) {
            if ((this.flags & 2) == 0) {
                fieldSymbol = this.definingClass.cd.fieldList;
                while (fieldSymbol != null) {
                    if ((fieldSymbol.access & 8) == 0 && (fieldSymbol.flags & Short.MIN_VALUE) == 0 && !parser.defSet.get(fieldSymbol.index)) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 0x4000);
                    }
                    fieldSymbol = fieldSymbol.nextInClass;
                }
            }
        } else if (this.identifier == Identifier.dynamicInitializerIdentifier) {
            fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) == 0 && (fieldSymbol.flags & Short.MIN_VALUE) == 0) {
                    if (parser.defSet.get(fieldSymbol.index)) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | Short.MIN_VALUE);
                    } else if (parser.posSet.get(fieldSymbol.index)) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 0x4000);
                    }
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        }
        for (int i = n; i < n2; ++i) {
            MethodVariableSymbol methodVariableSymbol;
            if (parser.useSet.get(i) || (methodVariableSymbol = (MethodVariableSymbol)this.cmd.localVariables.get(i - n)) == null || methodVariableSymbol.identifier == null) continue;
            if (parser.defSet.get(i)) {
                if (i < n + this.actualArgCount) {
                    parser.warning(methodVariableSymbol, Message.warningParameterNeverUsed, methodVariableSymbol.pos, methodVariableSymbol.identifier.toString());
                    continue;
                }
                if ((methodVariableSymbol.flags & 4) != 0) {
                    parser.warning(methodVariableSymbol, Message.warningCatchVarNeverUsed, methodVariableSymbol.pos, methodVariableSymbol.identifier.toString());
                    continue;
                }
                parser.warning(methodVariableSymbol, Message.warningVarAssignmentNeverUsed, methodVariableSymbol.pos, methodVariableSymbol.errorName());
                continue;
            }
            if (parser.exitDefSet != null && parser.exitDefSet.get(i) || parser.posSet.get(i)) continue;
            if ((methodVariableSymbol.flags & 4) != 0) {
                if ((methodVariableSymbol.flags & 1) != 0) continue;
                parser.warning(methodVariableSymbol, Message.warningCatchVarNeverUsed, methodVariableSymbol.pos, methodVariableSymbol.identifier.toString());
                continue;
            }
            if ((methodVariableSymbol.flags & 1) != 0) {
                if ((methodVariableSymbol.flags & 2) != 0) continue;
                parser.error(Message.errorNotInitialized, methodVariableSymbol.pos, methodVariableSymbol.isErroneous(), methodVariableSymbol.errorName());
                continue;
            }
            parser.warning(methodVariableSymbol, Message.warningVariableNeverUsed, methodVariableSymbol.pos, methodVariableSymbol.errorName());
        }
        parser.exitDefSet = null;
        parser.useSet = null;
        parser.defSet = null;
    }

    void resolveTypeParameters(Parser parser) {
        if (this.typeParameterList != null) {
            this.typeParameterList.resolve(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveMethod(Parser parser) {
        StatementList statementList;
        Object object;
        ClassSymbol classSymbol;
        if ((this.flags & 8) != 0) {
            return;
        }
        MethodSymbol methodSymbol = this.nextWithSameName;
        while (methodSymbol != null) {
            if (!methodSymbol.isGenerated()) {
                if ((this.access & 0x80) != 0 && Identifier.compare(methodSymbol.getSignature(), this.getSignature())) {
                    parser.error(Error.errorAlreadyDefined, this.pos, false, this.errorName());
                    break;
                }
                if (this.argCount == methodSymbol.argCount && (this.argumentList == null || this.argumentList.identical(methodSymbol.argumentList))) {
                    parser.error(Message.errorDuplicateDefinition, this.pos, this.isErroneous(), this.errorName() + " " + Message.inString + " " + this.definingClass.errorName());
                }
            }
            methodSymbol = methodSymbol.nextWithSameName;
        }
        if (this.isGenerated()) {
            return;
        }
        if (this.isConstructor() && parser.currentClassSymbol.superClass != null && (classSymbol = parser.currentClassSymbol.superClass.getClassSymbol()).isNonStaticInnerClass() && !parser.currentClassSymbol.isAnonymousInnerClass()) {
            RawClassSymbol rawClassSymbol = null;
            if (parser.currentClassSymbol.isInnerClass()) {
                classSymbol = classSymbol.getOuterClass();
                rawClassSymbol = parser.currentClassSymbol.getOuterClass();
                while (!classSymbol.equalTo(rawClassSymbol) && !classSymbol.isSuperclass(rawClassSymbol)) {
                    if (!rawClassSymbol.isInnerClass()) {
                        rawClassSymbol = null;
                        break;
                    }
                    rawClassSymbol = ((ClassSymbol)rawClassSymbol).getOuterClass();
                }
            }
            if (rawClassSymbol == null) {
                Statement statement;
                object = parser.currentStatement;
                parser.currentStatement = statement = this.getFirstStatement();
                try {
                    if (statement == null || !(statement instanceof ExpressionStatement)) {
                        parser.error(Message.errorInstanceNotInScope, this.pos, false, parser.currentClassSymbol.superClass.errorName());
                    } else {
                        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                        if (!(expressionStatement.expr instanceof InvokeExpression)) {
                        } else {
                            InvokeExpression invokeExpression = (InvokeExpression)expressionStatement.expr;
                            if ((invokeExpression.flags & 2) == 0) {
                            } else {
                                Expression expression = invokeExpression.thisArgument;
                                if (expression == null || !(expression instanceof SuperExpression) || ((SuperExpression)expression).outerClassExpr == null) {
                                    parser.error(Message.errorInstanceNotInScope, this.pos, false, parser.currentClassSymbol.superClass.errorName());
                                }
                            }
                        }
                    }
                }
                finally {
                    parser.currentStatement = object;
                }
            }
        }
        this.resolveTypeParameters(parser);
        CompiledThrowsList compiledThrowsList = (CompiledThrowsList)this.throwsList;
        while (compiledThrowsList != null) {
            TypeSymbol typeSymbol = compiledThrowsList.throwsType;
            if (typeSymbol != null) {
                if (typeSymbol.isTypeParameter()) {
                    typeSymbol = ((TypeParameterSymbol)typeSymbol).getClassSymbol();
                }
                if (!(typeSymbol = typeSymbol.resolveType(parser, compiledThrowsList.pos, false, true, false)).isClass() || !typeSymbol.equalTo(parser.javaLangThrowableSymbol) && !parser.javaLangThrowableSymbol.isSuperclass((ClassSymbol)typeSymbol)) {
                    parser.error(Message.errorIncompatibleTypes, compiledThrowsList.pos, typeSymbol.isErroneous(), typeSymbol.errorName(), "java.lang.Throwable");
                }
            }
            compiledThrowsList = (CompiledThrowsList)compiledThrowsList.next;
        }
        if (!((this.access & 8) == 0 || this.isClassInitializer() || this.isSynthetic() || parser.currentClassSymbol.isInterface() || !parser.currentClassSymbol.isNonStaticInnerClass() && !parser.currentClassSymbol.isLocalInnerClass())) {
            parser.error(Message.errorInnerCannotHaveStatics, this.pos, false);
        }
        if ((this.flags & 0x80) != 0 && this.definingClass.superClass != null) {
            classSymbol = this.definingClass.superClass;
            char[] cArray = this.getSignature();
            block6: while (true) {
                methodSymbol = (MethodSymbol)classSymbol.getClassScope().lookupSpecificSymbolInScope(this.identifier, 8, true);
                while (methodSymbol != null) {
                    if (!methodSymbol.isBridgeMethod() && this.definingClass.compareMethods(this, classSymbol, methodSymbol)) {
                        boolean bl;
                        Object object2;
                        Object object3;
                        object = methodSymbol.resultType;
                        TypeSymbol typeSymbol = this.resultType;
                        if (classSymbol.isParameterizedClass()) {
                            ParameterizedClassSymbol parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol;
                            object3 = null;
                            object2 = parameterizedClassSymbol.typeVariableList;
                            if (object2 != null) {
                                object3 = parameterizedClassSymbol.genericClassSymbol.cd.getTypeParameterList();
                            }
                            object = ((TypeSymbol)object).replaceTypeParameters(this.definingClass, (TypeParameterList)object3, (TypeVariableList)object2, null);
                            typeSymbol = typeSymbol.replaceTypeParameters(this.definingClass, (TypeParameterList)object3, (TypeVariableList)object2, null);
                        }
                        if (!(bl = typeSymbol.equalTo((TypeSymbol)object)) && parser.options.sourceJDKVersion >= 150 && ((TypeSymbol)object).isReferenceType() && typeSymbol.isReferenceType()) {
                            object3 = (ReferenceTypeSymbol)object;
                            object2 = (ReferenceTypeSymbol)typeSymbol;
                            bl = ((ReferenceTypeSymbol)object3).isReturnSubstitutable(parser, (ReferenceTypeSymbol)object2);
                        }
                        if (bl) break block6;
                    }
                    methodSymbol = methodSymbol.nextWithSameName;
                }
                ClassSymbol classSymbol2 = classSymbol.getSuperClassSymbol();
                if (classSymbol2 == null) {
                    parser.error(Message.errorDoesNotOverride, this.pos, false, this.errorName());
                    break;
                }
                classSymbol = classSymbol2;
            }
        }
        if ((statementList = this.cmd.statementList) != null) {
            parser.currentMethodSymbol = this;
            this.initLocalVariableChecking(parser);
            parser.thisInitialized = !this.isConstructor();
            parser.estimatedLineCount = 0;
            statementList.resolveAndCheck(parser);
            parser.addReturnStatement(this, statementList);
            this.cmd.estimatedLineCount = parser.estimatedLineCount;
            this.doneLocalVariableChecking(parser);
            this.flags = (short)(this.flags | 8);
            parser.currentStatement = null;
            parser.currentMethodSymbol = null;
        }
        if (parser.options.noCodeGeneration || parser.errorFound && !parser.options.generateClassesDespiteErrors) {
            this.cmd.statementList = null;
        }
    }

    void generateMethod(Parser parser) {
        StatementList statementList = this.cmd.statementList;
        if (statementList != null) {
            parser.currentMethodSymbol = this;
            this.cmd.statementList = null;
            if (!(parser.options.noCodeGeneration || parser.errorFound && !parser.options.generateClassesDespiteErrors)) {
                boolean bl = this.isClassInitializer();
                if (bl) {
                    ++this.cmd.estimatedLineCount;
                }
                ByteCodeGenerator byteCodeGenerator = new ByteCodeGenerator(parser, this);
                do {
                    if (bl) {
                        byteCodeGenerator.generateClassInitalizerPrologue();
                    }
                    if (this.isErroneous()) {
                        ErrorExpression.errorExpression.generateByteCode(byteCodeGenerator);
                        continue;
                    }
                    statementList.generateByteCode(byteCodeGenerator);
                } while (!byteCodeGenerator.finish());
            }
            parser.currentMethodSymbol = null;
        }
    }

    char[] getMethodSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        TypeParameterList typeParameterList = this.typeParameterList;
        if (typeParameterList != null) {
            typeParameterList.getSignature(stringBuffer);
        }
        stringBuffer.append('(');
        ArgumentVariableList argumentVariableList = this.argumentList;
        while (argumentVariableList != null) {
            stringBuffer.append(argumentVariableList.argSymbol.type.getGenericSignature());
            argumentVariableList = argumentVariableList.next;
        }
        stringBuffer.append(')');
        stringBuffer.append(this.resultType.getGenericSignature());
        ThrowsList throwsList = this.throwsList;
        while (throwsList != null) {
            TypeSymbol typeSymbol = throwsList.throwsType;
            if (typeSymbol.isTypeParameter()) {
                stringBuffer.append('^');
                stringBuffer.append(typeSymbol.getGenericSignature());
            }
            throwsList = throwsList.next;
        }
        return stringBuffer.toString().toCharArray();
    }

    void addFieldInitializer(FieldSymbol fieldSymbol, int n) {
        FieldInitializationStatement fieldInitializationStatement = new FieldInitializationStatement(this.cmd.statementList, n, fieldSymbol);
        this.cmd.statementList.add(fieldInitializationStatement);
    }

    static final class CompiledThrowsList
    extends ThrowsList {
        int pos;
        short index;

        CompiledThrowsList(TypeSymbol typeSymbol, int n) {
            super(typeSymbol);
            this.pos = n;
        }

        int getPos() {
            return this.pos;
        }
    }

    static class ThrowsList {
        ThrowsList next;
        TypeSymbol throwsType;
        static final /* synthetic */ boolean $assertionsDisabled;

        ThrowsList(TypeSymbol typeSymbol) {
            this.throwsType = typeSymbol;
        }

        int getPos() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        static CompiledThrowsList copyIntoCompiledThrowsList(ThrowsList throwsList) {
            CompiledThrowsList compiledThrowsList = null;
            CompiledThrowsList compiledThrowsList2 = null;
            while (throwsList != null) {
                CompiledThrowsList compiledThrowsList3 = new CompiledThrowsList(throwsList.throwsType, 0);
                if (compiledThrowsList2 == null) {
                    compiledThrowsList2 = compiledThrowsList = compiledThrowsList3;
                } else {
                    compiledThrowsList.next = compiledThrowsList3;
                    compiledThrowsList = compiledThrowsList3;
                }
                throwsList = throwsList.next;
            }
            return compiledThrowsList2;
        }

        static {
            $assertionsDisabled = !(class$oracle$ojc$compiler$MethodSymbol == null ? (class$oracle$ojc$compiler$MethodSymbol = MethodSymbol.class$("oracle.ojc.compiler.MethodSymbol")) : class$oracle$ojc$compiler$MethodSymbol).desiredAssertionStatus();
        }
    }

    static final class CompiledMethodData {
        StatementList statementList;
        int estimatedLineCount;
        int maxOpStackDepth;
        short lastLine;
        byte[] lineNumberTable;
        short localVarTableLen;
        byte[] localVarTable;
        byte[] ccLocalVarTable;
        short localVarTypeTableLen;
        byte[] localVarTypeTable;
        short exceptionTableLen;
        byte[] exceptionTable;
        byte[] codeBuffer;
        ArrayList localVariables;

        CompiledMethodData() {
        }
    }
}

