/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

abstract class MemberExpression
extends Expression {
    ClassSymbol qualification;
    Expression thisArgument;
    boolean useAccessor;
    static final /* synthetic */ boolean $assertionsDisabled;

    MemberExpression(byte by, int n, Expression expression) {
        super(by, n);
        this.thisArgument = expression;
    }

    static ParameterizedClassSymbol getParameterizedSuperType(ClassSymbol classSymbol, RawClassSymbol rawClassSymbol) {
        ParameterizedClassSymbol parameterizedClassSymbol;
        if (classSymbol.isParameterizedClass()) {
            parameterizedClassSymbol = (ParameterizedClassSymbol)classSymbol;
        } else {
            if (!$assertionsDisabled && !classSymbol.isRawClass()) {
                throw new AssertionError();
            }
            parameterizedClassSymbol = ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)classSymbol, null, null);
        }
        if (rawClassSymbol.isInterface()) {
            if (parameterizedClassSymbol != null && parameterizedClassSymbol.genericClassSymbol != rawClassSymbol) {
                parameterizedClassSymbol = (ParameterizedClassSymbol)parameterizedClassSymbol.getInterface(rawClassSymbol);
            }
        } else {
            while (parameterizedClassSymbol != null && parameterizedClassSymbol.genericClassSymbol != rawClassSymbol) {
                parameterizedClassSymbol = (ParameterizedClassSymbol)parameterizedClassSymbol.getSuperClassSymbol();
            }
        }
        return parameterizedClassSymbol;
    }

    private boolean resolveField(Parser parser, UnresolvedSymbol unresolvedSymbol, RawClassSymbol rawClassSymbol, Expression expression, Symbol symbol, IdentifierList identifierList, int n) {
        Identifier identifier = symbol.identifier;
        if (unresolvedSymbol.qualifierList.next == identifierList) {
            symbol.checkForAmbigousImport(parser, this.pos, parser.currentPackageScope, (short)2);
        }
        while (true) {
            FieldExpression fieldExpression = new FieldExpression(this.pos, new UnresolvedSymbol(n, null, identifier), expression);
            if (rawClassSymbol != null) {
                fieldExpression.qualification = rawClassSymbol;
                rawClassSymbol = null;
            }
            if (identifierList == null) {
                this.thisArgument = fieldExpression;
                return true;
            }
            n = identifierList.pos;
            identifier = identifierList.identifier;
            expression = fieldExpression;
            identifierList = identifierList.next;
        }
    }

    private boolean resolveType(Parser parser, UnresolvedSymbol unresolvedSymbol, Scope scope, Symbol symbol, IdentifierList identifierList, int n) {
        RawClassSymbol rawClassSymbol = ((ClassSymbol)symbol).getClassSymbol();
        if (scope == parser.currentClassSymbol.classScope && rawClassSymbol.isInnerClass()) {
            parser.addAmbiguityCheck(((ClassScope)scope).classSymbol, rawClassSymbol);
        }
        if (unresolvedSymbol.qualifierList.next == identifierList) {
            rawClassSymbol.checkForAmbigousImport(parser, this.pos, parser.currentPackageScope, (short)32);
        }
        while (true) {
            rawClassSymbol.resolveType(parser, this.pos, true, true, false);
            if (identifierList == null) {
                this.qualification = rawClassSymbol;
                return true;
            }
            n = identifierList.pos;
            symbol = rawClassSymbol.lookupSpecificSymbolInClass(parser, identifierList.identifier, 34, false);
            if (symbol == null) {
                parser.error(Message.errorNotFound, n, false, Message.identifierString + " " + identifierList.identifier.toString(), "");
                return false;
            }
            identifierList = identifierList.next;
            if (symbol.kind != 32) {
                if (!$assertionsDisabled && (symbol.kind & 2) == 0) {
                    throw new AssertionError();
                }
                return this.resolveField(parser, unresolvedSymbol, rawClassSymbol, null, symbol, identifierList, n);
            }
            rawClassSymbol = (RawClassSymbol)symbol;
        }
    }

    private boolean resolvePackage(Parser parser, UnresolvedSymbol unresolvedSymbol, Symbol symbol, IdentifierList identifierList, int n) {
        PackageScope packageScope;
        do {
            if (identifierList == null) {
                parser.error(Message.errorNotFound, n, false, Message.identifierString + " " + symbol.identifier.toString(), "");
                return false;
            }
            n = identifierList.pos;
            packageScope = ((PackageSymbol)symbol).packageScope;
            symbol = ((Scope)packageScope).lookupSymbolInScope(identifierList.identifier, true);
            if (symbol == null) {
                parser.findSourceFileForIdentifier(packageScope, identifierList.identifier);
                PackageScope packageScope2 = new PackageScope(parser, packageScope);
                PackageSymbol packageSymbol = new PackageSymbol(this.pos, identifierList.identifier, packageScope2);
                packageScope.enterSymbol(packageSymbol);
                packageScope2.packageSymbol = packageSymbol;
                packageScope2.readPackage();
                symbol = packageSymbol;
            }
            identifierList = identifierList.next;
        } while ((symbol.kind & 0x10) != 0);
        if (!$assertionsDisabled && (symbol.kind & 0x20) == 0) {
            throw new AssertionError();
        }
        return this.resolveType(parser, unresolvedSymbol, packageScope, symbol, identifierList, n);
    }

    boolean resolveQualifiedName(Parser parser, UnresolvedSymbol unresolvedSymbol) {
        TypeSymbol typeSymbol;
        RawClassSymbol rawClassSymbol = parser.currentClassSymbol;
        Scope scope = unresolvedSymbol.scope;
        if (scope == null) {
            scope = rawClassSymbol.classScope;
        }
        IdentifierList identifierList = unresolvedSymbol.qualifierList;
        if (!$assertionsDisabled && identifierList == null) {
            throw new AssertionError();
        }
        Symbol symbol = scope.lookupSpecificSymbol(identifierList.identifier, 2, false);
        if (symbol == null) {
            symbol = scope.lookupSpecificSymbol(identifierList.identifier, 32, false);
            if (symbol != null && ((typeSymbol = ((TypeSymbol)symbol).resolveType(parser, identifierList.pos, false, true, false)).isErroneous() || !((ClassSymbol)typeSymbol).isAccessible(rawClassSymbol))) {
                symbol = null;
            }
            if (symbol == null) {
                symbol = parser.globalScope.lookupSpecificSymbol(identifierList.identifier, 16, false);
            }
        }
        if (symbol == null) {
            MethodVariableSymbol methodVariableSymbol;
            symbol = rawClassSymbol.lookupSpecificSymbolInClass(parser, identifierList.identifier, 34, true);
            if (symbol == null && rawClassSymbol.isInnerClass() && (methodVariableSymbol = (MethodVariableSymbol)rawClassSymbol.classScope.lookupSpecificSymbol(identifierList.identifier, 64, false)) != null && (methodVariableSymbol.access & 0x10) != 0) {
                symbol = parser.getSyntheticFieldForLocalInInnerClass(methodVariableSymbol);
            }
            if (symbol == null) {
                if (parser.sourceOrClassFileForIdentifierAvailable(scope, identifierList.identifier)) {
                    typeSymbol = new UnresolvedClassSymbol(null, identifierList.identifier, null, parser.currentPackageScope);
                    if ((typeSymbol = typeSymbol.resolveType(parser, this.pos, false, true, false)).isErroneous()) {
                        return false;
                    }
                    symbol = typeSymbol;
                } else {
                    PackageScope packageScope = new PackageScope(parser, parser.globalScope);
                    PackageSymbol packageSymbol = new PackageSymbol(this.pos, identifierList.identifier, packageScope);
                    symbol = packageSymbol;
                    parser.globalScope.enterSymbol(packageSymbol);
                    packageScope.packageSymbol = packageSymbol;
                    packageSymbol.packageScope.readPackage();
                }
            }
        } else if ((symbol.kind & 2) != 0) {
            FieldSymbol fieldSymbol = (FieldSymbol)symbol;
            if ((fieldSymbol.definingClass.equalTo(rawClassSymbol) || fieldSymbol.definingClass.isSuperclass(rawClassSymbol) || rawClassSymbol.implementsInterface(fieldSymbol.definingClass)) && !fieldSymbol.isAccessible(rawClassSymbol, rawClassSymbol)) {
                symbol = null;
                if (rawClassSymbol.isInnerClass()) {
                    symbol = rawClassSymbol.classScope.outerScope.lookupSpecificSymbol(identifierList.identifier, 2, false);
                }
                if (symbol == null && (symbol = scope.lookupSpecificSymbol(identifierList.identifier, 32, false)) == null) {
                    symbol = parser.globalScope.lookupSpecificSymbol(identifierList.identifier, 16, false);
                }
                if (symbol == null) {
                    parser.error(Message.errorNotFound, identifierList.pos, false, Message.identifierString + " " + identifierList.identifier.toString(), "");
                    return false;
                }
            }
        }
        identifierList = identifierList.next;
        switch (symbol.kind & 0xFFFFFFFB) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 16: {
                return this.resolvePackage(parser, unresolvedSymbol, symbol, identifierList, this.pos);
            }
            case 32: {
                return this.resolveType(parser, unresolvedSymbol, scope, symbol, identifierList, this.pos);
            }
            case 2: 
        }
        return this.resolveField(parser, unresolvedSymbol, null, null, symbol, identifierList, this.pos);
    }

    static {
        $assertionsDisabled = !MemberExpression.class.desiredAssertionStatus();
    }
}

