/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class LogicalNotExpression
extends UnaryExpression {
    BitSet trueDefSet;
    BitSet falseDefSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    LogicalNotExpression(int n, Expression expression) {
        super((byte)45, n, expression);
    }

    Expression foldExpression() {
        Expression expression = this.operand;
        if (expression.kind == 2) {
            return new BooleanConstantExpression(expression.pos, !((BooleanConstantExpression)expression).bval);
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.operand.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        byte by = typeSymbol.typeKind;
        if (by != 2) {
            if (parser.options.sourceJDKVersion >= 150 && typeSymbol.equalTo(parser.javaLangBooleanSymbol)) {
                expression = expression.promoteType(parser, TypeSymbol.booleanSymbol);
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol.isErroneous(), this.toString(), typeSymbol.errorName());
                return new ErrorExpression(error);
            }
        }
        if (expression.kind == 2) {
            return new BooleanConstantExpression(expression.pos, !((BooleanConstantExpression)expression).bval);
        }
        this.setType(TypeSymbol.booleanSymbol);
        if (expression.isLogicalExpression()) {
            this.trueDefSet = expression.getLogicalExpressionFalseDefSet();
            this.falseDefSet = expression.getLogicalExpressionTrueDefSet();
        } else {
            this.trueDefSet = (BitSet)parser.defSet.clone();
            this.falseDefSet = (BitSet)parser.defSet.clone();
        }
        this.operand = expression;
        return this;
    }

    boolean isConstantBooleanExpression() {
        return this.operand.isConstantBooleanExpression();
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$assertionsDisabled && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        return !this.operand.getConstantBooleanExpressionValue();
    }

    boolean isLogicalExpression() {
        return true;
    }

    BitSet getLogicalExpressionTrueDefSet() {
        return this.trueDefSet;
    }

    BitSet getLogicalExpressionFalseDefSet() {
        return this.falseDefSet;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.operand.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8_8((byte)4, (byte)-126);
        byteCodeGenerator.incOpStackHeight(1);
        byteCodeGenerator.decOpStackHeight(1);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean bl) {
        this.operand.generateByteCodeBranch(byteCodeGenerator, label, !bl);
    }

    public String toString() {
        return "!";
    }

    static {
        $assertionsDisabled = !LogicalNotExpression.class.desiredAssertionStatus();
    }
}

