/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TypeSymbol;

final class IfElseStatement
extends Statement {
    Expression condition;
    StatementList thenStatements;
    StatementList elseStatements;

    IfElseStatement(StatementList statementList, int n, Expression expression, StatementList statementList2, StatementList statementList3) {
        super(statementList, n, (byte)3);
        this.condition = expression;
        this.thenStatements = statementList2;
        this.elseStatements = statementList3;
        statementList2.parent = statementList3.parent = this;
    }

    void resolveAndCheck(Parser parser) {
        Expression expression = this.condition.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        byte by = typeSymbol.typeKind;
        if (by != 2) {
            if (parser.options.sourceJDKVersion >= 150 && typeSymbol.equalTo(parser.javaLangBooleanSymbol)) {
                expression = new AutoUnboxingExpression(expression, TypeSymbol.booleanSymbol);
            } else {
                parser.error(Message.errorIncompatibleTypes, expression.pos, by == 0, typeSymbol.errorName(), "boolean");
            }
        }
        this.condition = expression;
        BitSet bitSet = (BitSet)parser.defSet.clone();
        BitSet bitSet2 = (BitSet)parser.posSet.clone();
        BitSet bitSet3 = (BitSet)parser.useSet.clone();
        if (expression.isLogicalExpression()) {
            parser.defSet = expression.getLogicalExpressionTrueDefSet();
        }
        boolean bl = parser.suspendDataFlowChecking;
        if (expression.isConstantBooleanExpression() && !expression.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        this.thenStatements.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = bl;
        BitSet bitSet4 = parser.defSet;
        BitSet bitSet5 = parser.posSet;
        BitSet bitSet6 = parser.useSet;
        parser.defSet = bitSet;
        parser.posSet = bitSet2;
        parser.useSet = bitSet3;
        if (expression.isLogicalExpression()) {
            parser.defSet = expression.getLogicalExpressionFalseDefSet();
        }
        if (expression.isConstantBooleanExpression() && expression.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        this.elseStatements.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = bl;
        boolean bl2 = this.thenStatements.canReachNextStatement(false);
        boolean bl3 = this.elseStatements.canReachNextStatement(false);
        if (expression.isConstantBooleanExpression()) {
            if (expression.getConstantBooleanExpressionValue() && bl2) {
                parser.defSet = bitSet4;
                parser.useSet = bitSet6;
            }
        } else {
            if (!bl3) {
                parser.defSet = bitSet4;
                parser.posSet = bitSet5;
            } else if (bl2) {
                parser.defSet.and(bitSet4);
            }
            parser.posSet.or(bitSet5);
            parser.useSet.or(bitSet6);
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        if (this.next != null && !(bl2 | bl3) && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression expression = this.condition;
        if (expression.isConstantBooleanExpression()) {
            if (expression.kind != 2) {
                expression.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (expression.getConstantBooleanExpressionValue()) {
                this.thenStatements.generateByteCode(byteCodeGenerator);
            } else {
                this.elseStatements.generateByteCode(byteCodeGenerator);
            }
        } else {
            Label label = new Label();
            expression.generateByteCodeBranch(byteCodeGenerator, label, true);
            this.thenStatements.generateByteCode(byteCodeGenerator);
            Label label2 = new Label();
            if (this.thenStatements.canReachNextStatement(false)) {
                byteCodeGenerator.generateBranch_goto(label2);
            }
            byteCodeGenerator.setLabel(label);
            this.elseStatements.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.setLabel(label2);
        }
    }

    boolean isLoopExitStatement() {
        return this.thenStatements.isLoopExitStatement() & this.elseStatements.isLoopExitStatement();
    }

    boolean canReachNextStatement(boolean bl) {
        return this.thenStatements.canReachNextStatement(bl) | this.elseStatements.canReachNextStatement(bl);
    }
}

