/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TypeSymbol;

final class ExpressionStatement
extends Statement {
    Expression expr;

    ExpressionStatement(StatementList statementList, int n, Expression expression) {
        super(statementList, n, (byte)1);
        this.expr = expression;
    }

    void resolveAndCheck(Parser parser) {
        if (!Expression.isStatementExpression(this.expr.kind)) {
            if (this.expr.kind != 0) {
                Error error = parser.error(Message.errorNotAnExpressionStatement, this.pos, false);
                this.expr = new ErrorExpression(error);
            }
        } else {
            if (this.expr instanceof InvokeExpression && (((InvokeExpression)this.expr).flags & 3) != 0 && (this.prev != null || this.parent.parent != null) && parser.currentMethodSymbol.isConstructor()) {
                String string = "super";
                if ((((InvokeExpression)this.expr).flags & 1) != 0) {
                    string = "this";
                }
                parser.error(Message.errorSelfMethodNotAllowed, this.pos, false, string);
            }
            this.expr = this.expr.resolveAndCheck(parser);
            if (this.expr.kind != 0) {
                this.expr.setType(TypeSymbol.voidSymbol);
            }
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.expr.generateByteCode(byteCodeGenerator);
        if (this.expr.kind == 4) {
            InvokeExpression invokeExpression = (InvokeExpression)this.expr;
            if (invokeExpression.method.identifier == Identifier.initializerIdentifier && invokeExpression.thisArgument.kind == 47) {
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
        }
    }
}

