/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.IdeLog;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

final class ErrorExpression
extends Expression {
    static ErrorExpression errorExpression;
    static ErrorExpression markerExpression;
    private Error error;
    static final /* synthetic */ boolean $assertionsDisabled;

    ErrorExpression(Error error) {
        super((byte)0, 0);
        super.setType(TypeSymbol.errorSymbol);
        this.error = error;
    }

    static void initializeStatics() {
        errorExpression = new ErrorExpression(null);
        markerExpression = new ErrorExpression(null);
    }

    static void releaseStatics() {
        errorExpression = null;
        markerExpression = null;
    }

    void setType(TypeSymbol typeSymbol) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    Expression resolveAndCheck(Parser parser) {
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        String string = "Compilation error";
        if (this.error != null) {
            string = IdeLog.formatMessage(this.error.storage, this.error.pos, this.error.message, false);
        }
        short s = byteCodeGenerator.constantPool.enterConstantPoolClass(Identifier.javaLangErrorInternal.name);
        byteCodeGenerator.generate_8_16_8((byte)-69, s, (byte)89);
        byteCodeGenerator.incOpStackHeight(2);
        byteCodeGenerator.generateStringConst(string.toCharArray());
        byteCodeGenerator.incOpStackHeight(1);
        s = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(Identifier.javaLangErrorInternal.name, Identifier.initializerIdentifier.name, Identifier.voidMethodStringSignature.name);
        byteCodeGenerator.generate_8_16_8((byte)-73, s, (byte)-65);
        byteCodeGenerator.decOpStackHeight(3);
    }

    static {
        $assertionsDisabled = !ErrorExpression.class.desiredAssertionStatus();
    }
}

