/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

abstract class EqualityExpression
extends BinaryExpression {
    EqualityExpression(byte by, int n, Expression expression, Expression expression2) {
        super(by, n, expression, expression2);
    }

    /*
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser parser) {
        block18: {
            Expression expression = this.leftOperand.resolveAndCheck(parser);
            Expression expression2 = this.rightOperand.resolveAndCheck(parser);
            TypeSymbol typeSymbol = expression.getType();
            TypeSymbol typeSymbol2 = expression2.getType();
            if (typeSymbol.isErroneous() || typeSymbol2.isErroneous()) {
                return ErrorExpression.errorExpression;
            }
            if (typeSymbol.isReferenceType()) {
                if (!typeSymbol2.isReferenceType()) {
                    TypeSymbol typeSymbol3;
                    if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isPrimitiveType() && (typeSymbol3 = BoxingExpression.getPrimitiveType(parser, typeSymbol)) != null) {
                        TypeSymbol typeSymbol4;
                        if (typeSymbol3.typeKind == typeSymbol2.typeKind) {
                            typeSymbol4 = typeSymbol2;
                        } else {
                            typeSymbol4 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol3, typeSymbol2);
                            if (typeSymbol4.isErroneous()) {
                                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        this.leftOperand = expression.promoteType(parser, typeSymbol4);
                        this.rightOperand = expression2.promoteType(parser, typeSymbol4);
                        break block18;
                    } else {
                        Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                        return new ErrorExpression(error);
                    }
                }
                ReferenceTypeSymbol referenceTypeSymbol = (ReferenceTypeSymbol)typeSymbol;
                ReferenceTypeSymbol referenceTypeSymbol2 = (ReferenceTypeSymbol)typeSymbol2;
                if (referenceTypeSymbol.isCastCompatible(parser, referenceTypeSymbol2)) {
                    this.leftOperand = expression;
                    this.rightOperand = expression2.promoteType(parser, typeSymbol);
                } else {
                    if (!referenceTypeSymbol2.isCastCompatible(parser, referenceTypeSymbol)) {
                        Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, typeSymbol2.errorName(), typeSymbol.errorName());
                        return new ErrorExpression(error);
                    }
                    this.rightOperand = expression2;
                    this.leftOperand = expression.promoteType(parser, typeSymbol2);
                }
            } else if ((typeSymbol.typeClass & 2) != 0) {
                if ((typeSymbol2.typeClass & 2) == 0) {
                    if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.equalTo(parser.javaLangBooleanSymbol)) {
                        expression2 = expression2.promoteType(parser, typeSymbol);
                    } else {
                        Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                        return new ErrorExpression(error);
                    }
                }
                this.leftOperand = expression;
                this.rightOperand = expression2;
            } else {
                TypeSymbol typeSymbol5 = TypeSymbol.binaryNumericPromotion(parser, typeSymbol, typeSymbol2);
                if (typeSymbol5.isErroneous()) {
                    Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), typeSymbol.errorName() + " " + Message.andString + " " + typeSymbol2.errorName());
                    return new ErrorExpression(error);
                }
                this.leftOperand = expression.promoteType(parser, typeSymbol5);
                this.rightOperand = expression2.promoteType(parser, typeSymbol5);
            }
        }
        this.setType(TypeSymbol.booleanSymbol);
        return this.foldExpression();
    }
}

