/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.AnonymousClassSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;

final class EnumMapClassSymbol
extends AnonymousClassSymbol {
    EnumDescriptor enumList;
    static final /* synthetic */ boolean $assertionsDisabled;

    EnumMapClassSymbol(Parser parser, RawClassSymbol rawClassSymbol) {
        super(0, (short)4104);
        if (!$assertionsDisabled && parser.options.targetJDKVersion < 150) {
            throw new AssertionError();
        }
        this.superClass = parser.javaLangObjectPcs;
        this.flags = (short)(this.flags | 0x120);
        this.cd.ccd.sourceFile = rawClassSymbol.cd.ccd.sourceFile;
        this.scope = rawClassSymbol.classScope;
        this.classScope = new ClassScope(this, rawClassSymbol.classScope, parser);
        this.cd.ccd.constantPool = new ConstantPool(parser);
        parser.classSymbolList.add(this);
        rawClassSymbol.addInnerClass(this);
        this.getClassInitializer();
    }

    boolean isLocalInnerClass() {
        return false;
    }

    static EnumMapClassSymbol getEnumMapClass(Parser parser, RawClassSymbol rawClassSymbol) {
        TypeSymbolList typeSymbolList = rawClassSymbol.cd.innerClassList;
        while (typeSymbolList != null) {
            if (typeSymbolList.typeSymbol instanceof EnumMapClassSymbol) {
                return (EnumMapClassSymbol)typeSymbolList.typeSymbol;
            }
            typeSymbolList = typeSymbolList.next;
        }
        return new EnumMapClassSymbol(parser, rawClassSymbol);
    }

    private Identifier getEnumMapName(RawClassSymbol rawClassSymbol, int n) {
        StringBuffer stringBuffer = new StringBuffer(Identifier.dollarString + "sm$");
        while (--n >= 0) {
            stringBuffer.append('$');
        }
        stringBuffer.append(rawClassSymbol.getInternalName());
        String string = stringBuffer.toString().replace('/', '$');
        return Identifier.getIdentifier(string);
    }

    private FieldSymbol addNewEnumMap(RawClassSymbol rawClassSymbol) {
        int n = 0;
        while (true) {
            Identifier identifier;
            FieldSymbol fieldSymbol;
            if ((fieldSymbol = (FieldSymbol)this.classScope.lookupSpecificSymbolInScope(identifier = this.getEnumMapName(rawClassSymbol, n), 2, true)) == null) {
                fieldSymbol = new FieldSymbol(0, this, identifier, ArraySymbol.getArrayType(TypeSymbol.intSymbol, 1), 0, 4120, null);
                fieldSymbol.flags = (short)(fieldSymbol.flags | 0xFFFFA001);
                this.addField(fieldSymbol);
                return fieldSymbol;
            }
            ++n;
        }
    }

    private EnumDescriptor addEnumDescriptor(RawClassSymbol rawClassSymbol) {
        EnumDescriptor enumDescriptor = new EnumDescriptor();
        enumDescriptor.enumClassSymbol = rawClassSymbol;
        enumDescriptor.enumConstList = new ArrayList();
        enumDescriptor.enumMapField = this.addNewEnumMap(rawClassSymbol);
        enumDescriptor.next = this.enumList;
        this.enumList = enumDescriptor;
        return enumDescriptor;
    }

    int getEnumConst(RawClassSymbol rawClassSymbol, FieldSymbol fieldSymbol) {
        EnumDescriptor enumDescriptor = this.enumList;
        while (enumDescriptor != null) {
            if (enumDescriptor.enumClassSymbol == rawClassSymbol) {
                int n = enumDescriptor.enumConstList.size();
                for (int i = 0; i < n; ++i) {
                    if (fieldSymbol != enumDescriptor.enumConstList.get(i)) continue;
                    return i + 1;
                }
                enumDescriptor.enumConstList.add(fieldSymbol);
                return n + 1;
            }
            enumDescriptor = enumDescriptor.next;
        }
        enumDescriptor = this.addEnumDescriptor(rawClassSymbol);
        enumDescriptor.enumConstList.add(fieldSymbol);
        return 1;
    }

    char[] getMapName(RawClassSymbol rawClassSymbol) {
        EnumDescriptor enumDescriptor = this.enumList;
        while (enumDescriptor != null) {
            if (enumDescriptor.enumClassSymbol == rawClassSymbol) {
                return enumDescriptor.enumMapField.identifier.name;
            }
            enumDescriptor = enumDescriptor.next;
        }
        return this.addEnumDescriptor((RawClassSymbol)rawClassSymbol).enumMapField.identifier.name;
    }

    static {
        $assertionsDisabled = !EnumMapClassSymbol.class.desiredAssertionStatus();
    }

    static final class EnumDescriptor {
        EnumDescriptor next;
        RawClassSymbol enumClassSymbol;
        ArrayList enumConstList;
        FieldSymbol enumMapField;

        EnumDescriptor() {
        }
    }
}

