/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolClass;
import oracle.ojc.compiler.ConstantPoolDouble;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.ConstantPoolFieldRef;
import oracle.ojc.compiler.ConstantPoolFloat;
import oracle.ojc.compiler.ConstantPoolInteger;
import oracle.ojc.compiler.ConstantPoolInterfaceMethodRef;
import oracle.ojc.compiler.ConstantPoolLong;
import oracle.ojc.compiler.ConstantPoolMethodRef;
import oracle.ojc.compiler.ConstantPoolNameAndType;
import oracle.ojc.compiler.ConstantPoolString;
import oracle.ojc.compiler.ConstantPoolUtf8;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.TypeSymbolList;

final class ConstantPool {
    static final byte CONSTANT_Utf8 = 1;
    static final byte CONSTANT_Integer = 3;
    static final byte CONSTANT_Float = 4;
    static final byte CONSTANT_Long = 5;
    static final byte CONSTANT_Double = 6;
    static final byte CONSTANT_Class = 7;
    static final byte CONSTANT_String = 8;
    static final byte CONSTANT_Fieldref = 9;
    static final byte CONSTANT_Methodref = 10;
    static final byte CONSTANT_InterfaceMethodref = 11;
    static final byte CONSTANT_NameAndType = 12;
    private static final int CONSTANTPOOL_INTEGER_HASHTABLESIZE = 128;
    private static final int CONSTANTPOOL_LONG_HASHTABLESIZE = 32;
    private static final int CONSTANTPOOL_FLOAT_HASHTABLESIZE = 32;
    private static final int CONSTANTPOOL_DOUBLE_HASHTABLESIZE = 32;
    private static final int CONSTANTPOOL_STRING_HASHTABLESIZE = 64;
    private static final int CONSTANTPOOL_FIELDREF_HASHTABLESIZE = 256;
    private static final int CONSTANTPOOL_INTERFACEMETHODREF_HASHTABLESIZE = 64;
    private static final int CONSTANTPOOL_METHODREF_HASHTABLESIZE = 256;
    private static final int CONSTANTPOOL_CLASS_HASHTABLESIZE = 128;
    private static final int CONSTANTPOOL_NAMEANDTYPE_HASHTABLESIZE = 256;
    private static final int CONSTANTPOOL_UTF8_HASHTABLESIZE = 256;
    ConstantPoolClass[] constantPoolClassHashTable;
    int constantPoolClassHashTableCount;
    private ConstantPoolFieldRef[] constantPoolFieldRefHashTable;
    private int constantPoolFieldRefHashTableCount;
    private ConstantPoolMethodRef[] constantPoolMethodRefHashTable;
    private int constantPoolMethodRefHashTableCount;
    private ConstantPoolInterfaceMethodRef[] constantPoolInterfaceMethodRefHashTable;
    private int constantPoolInterfaceMethodRefHashTableCount;
    private ConstantPoolNameAndType[] constantPoolNameAndTypeHashTable;
    private int constantPoolNameAndTypeHashTableCount;
    private ConstantPoolString[] constantPoolStringHashTable;
    private int constantPoolStringHashTableCount;
    private ConstantPoolUtf8[] constantPoolUtf8HashTable;
    private int constantPoolUtf8HashTableCount;
    private ConstantPoolInteger[] constantPoolIntegerHashTable;
    private int constantPoolIntegerHashTableCount;
    private ConstantPoolLong[] constantPoolLongHashTable;
    private int constantPoolLongHashTableCount;
    private ConstantPoolFloat[] constantPoolFloatHashTable;
    private int constantPoolFloatHashTableCount;
    private ConstantPoolDouble[] constantPoolDoubleHashTable;
    private int constantPoolDoubleHashTableCount;
    private int constantPoolIndex;
    private ArrayList constantPoolVector;
    Parser parser;
    TypeSymbolList outOfPackageInnerClassList;

    ConstantPool(Parser parser) {
        this.parser = parser;
        this.constantPoolClassHashTable = new ConstantPoolClass[128];
        this.constantPoolFieldRefHashTable = new ConstantPoolFieldRef[256];
        this.constantPoolMethodRefHashTable = new ConstantPoolMethodRef[256];
        this.constantPoolInterfaceMethodRefHashTable = new ConstantPoolInterfaceMethodRef[64];
        this.constantPoolNameAndTypeHashTable = new ConstantPoolNameAndType[256];
        this.constantPoolStringHashTable = new ConstantPoolString[64];
        this.constantPoolUtf8HashTable = new ConstantPoolUtf8[256];
        this.constantPoolIntegerHashTable = new ConstantPoolInteger[128];
        this.constantPoolLongHashTable = new ConstantPoolLong[32];
        this.constantPoolFloatHashTable = new ConstantPoolFloat[32];
        this.constantPoolDoubleHashTable = new ConstantPoolDouble[32];
        this.constantPoolVector = new ArrayList();
        this.constantPoolVector.add(null);
        this.constantPoolIndex = 1;
    }

    private int rehashConstantPoolClass() {
        int n = this.constantPoolClassHashTableCount;
        ConstantPoolClass[] constantPoolClassArray = this.constantPoolClassHashTable;
        int n2 = constantPoolClassArray.length;
        int n3 = n2 << 1;
        ConstantPoolClass[] constantPoolClassArray2 = new ConstantPoolClass[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolClass constantPoolClass;
            ConstantPoolClass constantPoolClass2 = constantPoolClassArray[i];
            if (constantPoolClass2 == null) continue;
            do {
                --n;
                constantPoolClass = constantPoolClass2.nextHashed;
                int n4 = constantPoolClass2.hashCode() & n3 - 1;
                constantPoolClass2.nextHashed = constantPoolClassArray2[n4];
                constantPoolClassArray2[n4] = constantPoolClass2;
            } while ((constantPoolClass2 = constantPoolClass) != null);
            if (n == 0) break;
        }
        this.constantPoolClassHashTable = constantPoolClassArray2;
        return n3;
    }

    short enterConstantPoolClass(char[] cArray) {
        int n = this.constantPoolClassHashTableCount;
        int n2 = this.constantPoolClassHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolClass();
        }
        int n3 = Identifier.hashCode(cArray) & n2 - 1;
        ConstantPoolClass constantPoolClass = this.constantPoolClassHashTable[n3];
        while (constantPoolClass != null) {
            if (Identifier.compare(cArray, constantPoolClass.className)) {
                return constantPoolClass.index;
            }
            constantPoolClass = constantPoolClass.nextHashed;
        }
        constantPoolClass = new ConstantPoolClass(this, cArray);
        constantPoolClass.nextHashed = this.constantPoolClassHashTable[n3];
        this.constantPoolClassHashTable[n3] = constantPoolClass;
        this.constantPoolVector.add(constantPoolClass);
        int n4 = this.constantPoolIndex;
        constantPoolClass.index = (short)n4;
        if (n4 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolClassHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 1;
        return (short)n4;
    }

    private int rehashConstantPoolMethodRef() {
        int n = this.constantPoolMethodRefHashTableCount;
        ConstantPoolMethodRef[] constantPoolMethodRefArray = this.constantPoolMethodRefHashTable;
        int n2 = constantPoolMethodRefArray.length;
        int n3 = n2 << 1;
        ConstantPoolMethodRef[] constantPoolMethodRefArray2 = new ConstantPoolMethodRef[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolMethodRef constantPoolMethodRef;
            ConstantPoolMethodRef constantPoolMethodRef2 = constantPoolMethodRefArray[i];
            if (constantPoolMethodRef2 == null) continue;
            do {
                --n;
                constantPoolMethodRef = constantPoolMethodRef2.nextHashed;
                int n4 = constantPoolMethodRef2.hashCode() & n3 - 1;
                constantPoolMethodRef2.nextHashed = constantPoolMethodRefArray2[n4];
                constantPoolMethodRefArray2[n4] = constantPoolMethodRef2;
            } while ((constantPoolMethodRef2 = constantPoolMethodRef) != null);
            if (n == 0) break;
        }
        this.constantPoolMethodRefHashTable = constantPoolMethodRefArray2;
        return n3;
    }

    short enterConstantPoolMethodRef(char[] cArray, char[] cArray2, char[] cArray3) {
        int n = this.constantPoolMethodRefHashTableCount;
        int n2 = this.constantPoolMethodRefHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolMethodRef();
        }
        int n3 = Identifier.hashCode(cArray) + Identifier.hashCode(cArray2) + Identifier.hashCode(cArray3) & n2 - 1;
        ConstantPoolMethodRef constantPoolMethodRef = this.constantPoolMethodRefHashTable[n3];
        while (constantPoolMethodRef != null) {
            if (Identifier.compare(cArray, constantPoolMethodRef.className) && Identifier.compare(cArray2, constantPoolMethodRef.name) && Identifier.compare(cArray3, constantPoolMethodRef.signature)) {
                return constantPoolMethodRef.index;
            }
            constantPoolMethodRef = constantPoolMethodRef.nextHashed;
        }
        constantPoolMethodRef = new ConstantPoolMethodRef(this, cArray, cArray2, cArray3);
        constantPoolMethodRef.nextHashed = this.constantPoolMethodRefHashTable[n3];
        this.constantPoolMethodRefHashTable[n3] = constantPoolMethodRef;
        this.constantPoolVector.add(constantPoolMethodRef);
        int n4 = this.constantPoolIndex;
        constantPoolMethodRef.index = (short)n4;
        if (n4 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolMethodRefHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 1;
        return (short)n4;
    }

    private int rehashConstantPoolInterfaceMethodRef() {
        int n = this.constantPoolInterfaceMethodRefHashTableCount;
        ConstantPoolInterfaceMethodRef[] constantPoolInterfaceMethodRefArray = this.constantPoolInterfaceMethodRefHashTable;
        int n2 = constantPoolInterfaceMethodRefArray.length;
        int n3 = n2 << 1;
        ConstantPoolInterfaceMethodRef[] constantPoolInterfaceMethodRefArray2 = new ConstantPoolInterfaceMethodRef[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolInterfaceMethodRef constantPoolInterfaceMethodRef;
            ConstantPoolInterfaceMethodRef constantPoolInterfaceMethodRef2 = constantPoolInterfaceMethodRefArray[i];
            if (constantPoolInterfaceMethodRef2 == null) continue;
            do {
                --n;
                constantPoolInterfaceMethodRef = constantPoolInterfaceMethodRef2.nextHashed;
                int n4 = constantPoolInterfaceMethodRef2.hashCode() & n3 - 1;
                constantPoolInterfaceMethodRef2.nextHashed = constantPoolInterfaceMethodRefArray2[n4];
                constantPoolInterfaceMethodRefArray2[n4] = constantPoolInterfaceMethodRef2;
            } while ((constantPoolInterfaceMethodRef2 = constantPoolInterfaceMethodRef) != null);
            if (n == 0) break;
        }
        this.constantPoolInterfaceMethodRefHashTable = constantPoolInterfaceMethodRefArray2;
        return n3;
    }

    short enterConstantPoolInterfaceMethodRef(char[] cArray, char[] cArray2, char[] cArray3) {
        int n = this.constantPoolInterfaceMethodRefHashTableCount;
        int n2 = this.constantPoolInterfaceMethodRefHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolInterfaceMethodRef();
        }
        int n3 = Identifier.hashCode(cArray) + Identifier.hashCode(cArray2) + Identifier.hashCode(cArray3) & n2 - 1;
        ConstantPoolInterfaceMethodRef constantPoolInterfaceMethodRef = this.constantPoolInterfaceMethodRefHashTable[n3];
        while (constantPoolInterfaceMethodRef != null) {
            if (Identifier.compare(cArray, constantPoolInterfaceMethodRef.className) && Identifier.compare(cArray2, constantPoolInterfaceMethodRef.name) && Identifier.compare(cArray3, constantPoolInterfaceMethodRef.signature)) {
                return constantPoolInterfaceMethodRef.index;
            }
            constantPoolInterfaceMethodRef = constantPoolInterfaceMethodRef.nextHashed;
        }
        constantPoolInterfaceMethodRef = new ConstantPoolInterfaceMethodRef(this, cArray, cArray2, cArray3);
        constantPoolInterfaceMethodRef.nextHashed = this.constantPoolInterfaceMethodRefHashTable[n3];
        this.constantPoolInterfaceMethodRefHashTable[n3] = constantPoolInterfaceMethodRef;
        this.constantPoolVector.add(constantPoolInterfaceMethodRef);
        int n4 = this.constantPoolIndex;
        constantPoolInterfaceMethodRef.index = (short)n4;
        if (n4 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolInterfaceMethodRefHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 1;
        return (short)n4;
    }

    private int rehashConstantPoolFieldRef() {
        int n = this.constantPoolFieldRefHashTableCount;
        ConstantPoolFieldRef[] constantPoolFieldRefArray = this.constantPoolFieldRefHashTable;
        int n2 = constantPoolFieldRefArray.length;
        int n3 = n2 << 1;
        ConstantPoolFieldRef[] constantPoolFieldRefArray2 = new ConstantPoolFieldRef[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolFieldRef constantPoolFieldRef;
            ConstantPoolFieldRef constantPoolFieldRef2 = constantPoolFieldRefArray[i];
            if (constantPoolFieldRef2 == null) continue;
            do {
                --n;
                constantPoolFieldRef = constantPoolFieldRef2.nextHashed;
                int n4 = constantPoolFieldRef2.hashCode() & n3 - 1;
                constantPoolFieldRef2.nextHashed = constantPoolFieldRefArray2[n4];
                constantPoolFieldRefArray2[n4] = constantPoolFieldRef2;
            } while ((constantPoolFieldRef2 = constantPoolFieldRef) != null);
            if (n == 0) break;
        }
        this.constantPoolFieldRefHashTable = constantPoolFieldRefArray2;
        return n3;
    }

    short enterConstantPoolFieldRef(char[] cArray, char[] cArray2, char[] cArray3) {
        int n = this.constantPoolFieldRefHashTableCount;
        int n2 = this.constantPoolFieldRefHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolFieldRef();
        }
        int n3 = Identifier.hashCode(cArray) + Identifier.hashCode(cArray2) + Identifier.hashCode(cArray3) & n2 - 1;
        ConstantPoolFieldRef constantPoolFieldRef = this.constantPoolFieldRefHashTable[n3];
        while (constantPoolFieldRef != null) {
            if (Identifier.compare(cArray, constantPoolFieldRef.className) && Identifier.compare(cArray2, constantPoolFieldRef.name) && Identifier.compare(cArray3, constantPoolFieldRef.signature)) {
                return constantPoolFieldRef.index;
            }
            constantPoolFieldRef = constantPoolFieldRef.nextHashed;
        }
        constantPoolFieldRef = new ConstantPoolFieldRef(this, cArray, cArray2, cArray3);
        constantPoolFieldRef.nextHashed = this.constantPoolFieldRefHashTable[n3];
        this.constantPoolFieldRefHashTable[n3] = constantPoolFieldRef;
        this.constantPoolVector.add(constantPoolFieldRef);
        int n4 = this.constantPoolIndex;
        constantPoolFieldRef.index = (short)n4;
        if (n4 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolFieldRefHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 1;
        return (short)n4;
    }

    private int rehashConstantPoolNameAndType() {
        int n = this.constantPoolNameAndTypeHashTableCount;
        ConstantPoolNameAndType[] constantPoolNameAndTypeArray = this.constantPoolNameAndTypeHashTable;
        int n2 = constantPoolNameAndTypeArray.length;
        int n3 = n2 << 1;
        ConstantPoolNameAndType[] constantPoolNameAndTypeArray2 = new ConstantPoolNameAndType[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolNameAndType constantPoolNameAndType;
            ConstantPoolNameAndType constantPoolNameAndType2 = constantPoolNameAndTypeArray[i];
            if (constantPoolNameAndType2 == null) continue;
            do {
                --n;
                constantPoolNameAndType = constantPoolNameAndType2.nextHashed;
                int n4 = constantPoolNameAndType2.hashCode() & n3 - 1;
                constantPoolNameAndType2.nextHashed = constantPoolNameAndTypeArray2[n4];
                constantPoolNameAndTypeArray2[n4] = constantPoolNameAndType2;
            } while ((constantPoolNameAndType2 = constantPoolNameAndType) != null);
            if (n == 0) break;
        }
        this.constantPoolNameAndTypeHashTable = constantPoolNameAndTypeArray2;
        return n3;
    }

    short enterConstantPoolNameAndType(char[] cArray, char[] cArray2) {
        int n = this.constantPoolNameAndTypeHashTableCount;
        int n2 = this.constantPoolNameAndTypeHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolNameAndType();
        }
        int n3 = Identifier.hashCode(cArray) + Identifier.hashCode(cArray2) & n2 - 1;
        ConstantPoolNameAndType constantPoolNameAndType = this.constantPoolNameAndTypeHashTable[n3];
        while (constantPoolNameAndType != null) {
            if (Identifier.compare(cArray, constantPoolNameAndType.name) && Identifier.compare(cArray2, constantPoolNameAndType.type)) {
                return constantPoolNameAndType.index;
            }
            constantPoolNameAndType = constantPoolNameAndType.nextHashed;
        }
        constantPoolNameAndType = new ConstantPoolNameAndType(this, cArray, cArray2);
        constantPoolNameAndType.nextHashed = this.constantPoolNameAndTypeHashTable[n3];
        this.constantPoolNameAndTypeHashTable[n3] = constantPoolNameAndType;
        this.constantPoolVector.add(constantPoolNameAndType);
        int n4 = this.constantPoolIndex;
        constantPoolNameAndType.index = (short)n4;
        if (n4 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolNameAndTypeHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 1;
        return (short)n4;
    }

    private int rehashConstantPoolUtf8() {
        int n = this.constantPoolUtf8HashTableCount;
        ConstantPoolUtf8[] constantPoolUtf8Array = this.constantPoolUtf8HashTable;
        int n2 = constantPoolUtf8Array.length;
        int n3 = n2 << 1;
        ConstantPoolUtf8[] constantPoolUtf8Array2 = new ConstantPoolUtf8[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolUtf8 constantPoolUtf8;
            ConstantPoolUtf8 constantPoolUtf82 = constantPoolUtf8Array[i];
            if (constantPoolUtf82 == null) continue;
            do {
                --n;
                constantPoolUtf8 = constantPoolUtf82.nextHashed;
                int n4 = constantPoolUtf82.hashCode() & n3 - 1;
                constantPoolUtf82.nextHashed = constantPoolUtf8Array2[n4];
                constantPoolUtf8Array2[n4] = constantPoolUtf82;
            } while ((constantPoolUtf82 = constantPoolUtf8) != null);
            if (n == 0) break;
        }
        this.constantPoolUtf8HashTable = constantPoolUtf8Array2;
        return n3;
    }

    short enterConstantPoolUtf8(char[] cArray) {
        int n = this.constantPoolUtf8HashTableCount;
        int n2 = this.constantPoolUtf8HashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolUtf8();
        }
        int n3 = Identifier.hashCode(cArray) & n2 - 1;
        ConstantPoolUtf8 constantPoolUtf8 = this.constantPoolUtf8HashTable[n3];
        while (constantPoolUtf8 != null) {
            if (Identifier.compare(cArray, constantPoolUtf8.string)) {
                return constantPoolUtf8.index;
            }
            constantPoolUtf8 = constantPoolUtf8.nextHashed;
        }
        constantPoolUtf8 = new ConstantPoolUtf8(cArray);
        constantPoolUtf8.nextHashed = this.constantPoolUtf8HashTable[n3];
        this.constantPoolUtf8HashTable[n3] = constantPoolUtf8;
        this.constantPoolVector.add(constantPoolUtf8);
        int n4 = this.constantPoolIndex;
        constantPoolUtf8.index = (short)n4;
        if (n4 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolUtf8HashTableCount = n + 1;
        this.constantPoolIndex = n4 + 1;
        return (short)n4;
    }

    private int rehashConstantPoolString() {
        int n = this.constantPoolStringHashTableCount;
        ConstantPoolString[] constantPoolStringArray = this.constantPoolStringHashTable;
        int n2 = constantPoolStringArray.length;
        int n3 = n2 << 1;
        ConstantPoolString[] constantPoolStringArray2 = new ConstantPoolString[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolString constantPoolString;
            ConstantPoolString constantPoolString2 = constantPoolStringArray[i];
            if (constantPoolString2 == null) continue;
            do {
                --n;
                constantPoolString = constantPoolString2.nextHashed;
                int n4 = constantPoolString2.hashCode() & n3 - 1;
                constantPoolString2.nextHashed = constantPoolStringArray2[n4];
                constantPoolStringArray2[n4] = constantPoolString2;
            } while ((constantPoolString2 = constantPoolString) != null);
            if (n == 0) break;
        }
        this.constantPoolStringHashTable = constantPoolStringArray2;
        return n3;
    }

    short enterConstantPoolString(char[] cArray) {
        int n = this.constantPoolStringHashTableCount;
        int n2 = this.constantPoolStringHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolString();
        }
        int n3 = Identifier.hashCode(cArray) & n2 - 1;
        ConstantPoolString constantPoolString = this.constantPoolStringHashTable[n3];
        while (constantPoolString != null) {
            if (Identifier.compare(cArray, constantPoolString.string)) {
                return constantPoolString.index;
            }
            constantPoolString = constantPoolString.nextHashed;
        }
        constantPoolString = new ConstantPoolString(this, cArray);
        constantPoolString.nextHashed = this.constantPoolStringHashTable[n3];
        this.constantPoolStringHashTable[n3] = constantPoolString;
        this.constantPoolVector.add(constantPoolString);
        int n4 = this.constantPoolIndex;
        constantPoolString.index = (short)n4;
        if (n4 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolStringHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 1;
        return (short)n4;
    }

    private int rehashConstantPoolInteger() {
        int n = this.constantPoolIntegerHashTableCount;
        ConstantPoolInteger[] constantPoolIntegerArray = this.constantPoolIntegerHashTable;
        int n2 = constantPoolIntegerArray.length;
        int n3 = n2 << 1;
        ConstantPoolInteger[] constantPoolIntegerArray2 = new ConstantPoolInteger[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolInteger constantPoolInteger;
            ConstantPoolInteger constantPoolInteger2 = constantPoolIntegerArray[i];
            if (constantPoolInteger2 == null) continue;
            do {
                --n;
                constantPoolInteger = constantPoolInteger2.nextHashed;
                int n4 = constantPoolInteger2.hashCode() & n3 - 1;
                constantPoolInteger2.nextHashed = constantPoolIntegerArray2[n4];
                constantPoolIntegerArray2[n4] = constantPoolInteger2;
            } while ((constantPoolInteger2 = constantPoolInteger) != null);
            if (n == 0) break;
        }
        this.constantPoolIntegerHashTable = constantPoolIntegerArray2;
        return n3;
    }

    short enterConstantPoolInteger(int n) {
        int n2 = this.constantPoolIntegerHashTableCount;
        int n3 = this.constantPoolIntegerHashTable.length;
        if (n2 > n3 - (n3 >> 2)) {
            n3 = this.rehashConstantPoolInteger();
        }
        int n4 = ConstantPoolInteger.hashCode(n) & n3 - 1;
        ConstantPoolInteger constantPoolInteger = this.constantPoolIntegerHashTable[n4];
        while (constantPoolInteger != null) {
            if (constantPoolInteger.ival == n) {
                return constantPoolInteger.index;
            }
            constantPoolInteger = constantPoolInteger.nextHashed;
        }
        constantPoolInteger = new ConstantPoolInteger(n);
        constantPoolInteger.nextHashed = this.constantPoolIntegerHashTable[n4];
        this.constantPoolIntegerHashTable[n4] = constantPoolInteger;
        this.constantPoolVector.add(constantPoolInteger);
        int n5 = this.constantPoolIndex;
        constantPoolInteger.index = (short)n5;
        if (n5 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolIntegerHashTableCount = n2 + 1;
        this.constantPoolIndex = n5 + 1;
        return (short)n5;
    }

    private int rehashConstantPoolLong() {
        int n = this.constantPoolLongHashTableCount;
        ConstantPoolLong[] constantPoolLongArray = this.constantPoolLongHashTable;
        int n2 = constantPoolLongArray.length;
        int n3 = n2 << 1;
        ConstantPoolLong[] constantPoolLongArray2 = new ConstantPoolLong[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolLong constantPoolLong;
            ConstantPoolLong constantPoolLong2 = constantPoolLongArray[i];
            if (constantPoolLong2 == null) continue;
            do {
                --n;
                constantPoolLong = constantPoolLong2.nextHashed;
                int n4 = constantPoolLong2.hashCode() & n3 - 1;
                constantPoolLong2.nextHashed = constantPoolLongArray2[n4];
                constantPoolLongArray2[n4] = constantPoolLong2;
            } while ((constantPoolLong2 = constantPoolLong) != null);
            if (n == 0) break;
        }
        this.constantPoolLongHashTable = constantPoolLongArray2;
        return n3;
    }

    short enterConstantPoolLong(long l) {
        int n = this.constantPoolLongHashTableCount;
        int n2 = this.constantPoolLongHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolLong();
        }
        int n3 = ConstantPoolLong.hashCode(l) & n2 - 1;
        ConstantPoolLong constantPoolLong = this.constantPoolLongHashTable[n3];
        while (constantPoolLong != null) {
            if (constantPoolLong.lval == l) {
                return constantPoolLong.index;
            }
            constantPoolLong = constantPoolLong.nextHashed;
        }
        constantPoolLong = new ConstantPoolLong(l);
        constantPoolLong.nextHashed = this.constantPoolLongHashTable[n3];
        this.constantPoolLongHashTable[n3] = constantPoolLong;
        this.constantPoolVector.add(constantPoolLong);
        this.constantPoolVector.add(null);
        int n4 = this.constantPoolIndex;
        constantPoolLong.index = (short)n4;
        if (n4 >= 65535) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolLongHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 2;
        return (short)n4;
    }

    private int rehashConstantPoolFloat() {
        int n = this.constantPoolFloatHashTableCount;
        ConstantPoolFloat[] constantPoolFloatArray = this.constantPoolFloatHashTable;
        int n2 = constantPoolFloatArray.length;
        int n3 = n2 << 1;
        ConstantPoolFloat[] constantPoolFloatArray2 = new ConstantPoolFloat[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolFloat constantPoolFloat;
            ConstantPoolFloat constantPoolFloat2 = constantPoolFloatArray[i];
            if (constantPoolFloat2 == null) continue;
            do {
                --n;
                constantPoolFloat = constantPoolFloat2.nextHashed;
                int n4 = constantPoolFloat2.hashCode() & n3 - 1;
                constantPoolFloat2.nextHashed = constantPoolFloatArray2[n4];
                constantPoolFloatArray2[n4] = constantPoolFloat2;
            } while ((constantPoolFloat2 = constantPoolFloat) != null);
            if (n == 0) break;
        }
        this.constantPoolFloatHashTable = constantPoolFloatArray2;
        return n3;
    }

    short enterConstantPoolFloat(float f) {
        int n = this.constantPoolFloatHashTableCount;
        int n2 = this.constantPoolFloatHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolFloat();
        }
        int n3 = Float.floatToIntBits(f);
        int n4 = ConstantPoolFloat.hashCode(n3) & n2 - 1;
        ConstantPoolFloat constantPoolFloat = this.constantPoolFloatHashTable[n4];
        while (constantPoolFloat != null) {
            if (constantPoolFloat.bits == n3) {
                return constantPoolFloat.index;
            }
            constantPoolFloat = constantPoolFloat.nextHashed;
        }
        constantPoolFloat = new ConstantPoolFloat(n3);
        constantPoolFloat.nextHashed = this.constantPoolFloatHashTable[n4];
        this.constantPoolFloatHashTable[n4] = constantPoolFloat;
        this.constantPoolVector.add(constantPoolFloat);
        int n5 = this.constantPoolIndex;
        constantPoolFloat.index = (short)n5;
        if (n5 >= 65536) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolFloatHashTableCount = n + 1;
        this.constantPoolIndex = n5 + 1;
        return (short)n5;
    }

    private int rehashConstantPoolDouble() {
        int n = this.constantPoolDoubleHashTableCount;
        ConstantPoolDouble[] constantPoolDoubleArray = this.constantPoolDoubleHashTable;
        int n2 = constantPoolDoubleArray.length;
        int n3 = n2 << 1;
        ConstantPoolDouble[] constantPoolDoubleArray2 = new ConstantPoolDouble[n3];
        for (int i = 0; i < n2; ++i) {
            ConstantPoolDouble constantPoolDouble;
            ConstantPoolDouble constantPoolDouble2 = constantPoolDoubleArray[i];
            if (constantPoolDouble2 == null) continue;
            do {
                --n;
                constantPoolDouble = constantPoolDouble2.nextHashed;
                int n4 = constantPoolDouble2.hashCode() & n3 - 1;
                constantPoolDouble2.nextHashed = constantPoolDoubleArray2[n4];
                constantPoolDoubleArray2[n4] = constantPoolDouble2;
            } while ((constantPoolDouble2 = constantPoolDouble) != null);
            if (n == 0) break;
        }
        this.constantPoolDoubleHashTable = constantPoolDoubleArray2;
        return n3;
    }

    short enterConstantPoolDouble(double d) {
        int n = this.constantPoolDoubleHashTableCount;
        int n2 = this.constantPoolDoubleHashTable.length;
        if (n > n2 - (n2 >> 2)) {
            n2 = this.rehashConstantPoolDouble();
        }
        long l = Double.doubleToLongBits(d);
        int n3 = ConstantPoolDouble.hashCode(l) & n2 - 1;
        ConstantPoolDouble constantPoolDouble = this.constantPoolDoubleHashTable[n3];
        while (constantPoolDouble != null) {
            if (constantPoolDouble.bits == l) {
                return constantPoolDouble.index;
            }
            constantPoolDouble = constantPoolDouble.nextHashed;
        }
        constantPoolDouble = new ConstantPoolDouble(l);
        constantPoolDouble.nextHashed = this.constantPoolDoubleHashTable[n3];
        this.constantPoolDoubleHashTable[n3] = constantPoolDouble;
        this.constantPoolVector.add(constantPoolDouble);
        this.constantPoolVector.add(null);
        int n4 = this.constantPoolIndex;
        constantPoolDouble.index = (short)n4;
        if (n4 >= 65535) {
            this.parser.error(Message.errorConstantPoolTooLarge, this.parser.currentClassSymbol.pos, false, this.parser.currentClassSymbol.errorName());
        }
        this.constantPoolDoubleHashTableCount = n + 1;
        this.constantPoolIndex = n4 + 2;
        return (short)n4;
    }

    void writeConstantPool(ClassFileWriter classFileWriter) throws IOException {
        int n = classFileWriter.ensureWriteBufferCapacity(2);
        byte[] byArray = classFileWriter.writeBuffer;
        int n2 = this.constantPoolIndex;
        byArray[n + 1] = (byte)n2;
        byArray[n] = (byte)(n2 >> 8);
        classFileWriter.writeBufferIndex = n + 2;
        ConstantPoolEntry[] constantPoolEntryArray = this.constantPoolVector.toArray(new ConstantPoolEntry[n2]);
        for (int i = 1; i < n2; ++i) {
            ConstantPoolEntry constantPoolEntry = constantPoolEntryArray[i];
            i += constantPoolEntry.write(classFileWriter);
        }
    }

    void checkForOutOfPackageInnerClass(RawClassSymbol rawClassSymbol, RawClassSymbol rawClassSymbol2) {
        if (rawClassSymbol2.isInnerClass() && rawClassSymbol2.getPackageScope() != rawClassSymbol.getPackageScope()) {
            TypeSymbolList typeSymbolList = this.outOfPackageInnerClassList;
            while (typeSymbolList != null) {
                if (rawClassSymbol2.equalTo(typeSymbolList.typeSymbol)) {
                    return;
                }
                typeSymbolList = typeSymbolList.next;
            }
            typeSymbolList = new TypeSymbolList(rawClassSymbol2);
            typeSymbolList.next = this.outOfPackageInnerClassList;
            this.outOfPackageInnerClassList = typeSymbolList;
        }
    }
}

