/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.Warning;
import oracle.ojc.interfaces.Log;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public final class Compiler {
    static byte[] loadBuffer;
    private Parser parser;
    static final /* synthetic */ boolean $assertionsDisabled;

    Compiler(Options options) {
        this.parser = new Parser(options);
    }

    static void notImplemented() {
        Thread.dumpStack();
        System.exit(-1);
    }

    static int loadFile(Parser parser, Storage storage) {
        int n;
        try {
            storage.open();
            n = storage.size();
            byte[] byArray = loadBuffer;
            if (byArray == null || byArray.length < n) {
                byArray = loadBuffer = new byte[n + 1024];
            }
            storage.read(byArray);
            storage.close();
        }
        catch (Exception exception) {
            Error error = new Error(null, Error.errorCannotReadSource, 0, storage.getPath());
            parser.error(error);
            if (loadBuffer == null) {
                loadBuffer = new byte[0];
            }
            return 0;
        }
        return n;
    }

    private static void copyFile(Storage storage, Storage storage2, Log log) {
        try {
            storage.open();
            byte[] byArray = storage.read();
            storage.close();
            Storage storage3 = storage2.create(storage.getName());
            storage3.write(byArray, 0, byArray.length);
            storage3.close();
            if (System.getProperty("resetClassTimestampToSource") != null && storage3 instanceof FileStorage) {
                ((FileStorage)storage3).setLastModified(storage.modDate());
            }
        }
        catch (Exception exception) {
            Error error = new Error(null, Error.errorCannotCopy, 0, storage.getPath(), storage2.getPath());
            log.println(Message.errorColonString + error.message.getMessage());
        }
    }

    private static String changeForwardSlashesToBackwardSlashes(String string) {
        if (string != null && File.separator.charAt(0) == '\\') {
            string.replace('/', '\\');
        }
        return string;
    }

    private static String[] expandFile(String[] stringArray, int n, Log log) {
        try {
            int n2;
            String string = stringArray[n].substring(1);
            if (!new File(string).exists()) {
                Error error = new Error(null, Error.errorCannotReadSource, 0, string);
                log.println(Message.errorColonString + error.message.getMessage());
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            int n3 = fileInputStream.available();
            byte[] byArray = new byte[n3];
            fileInputStream.read(byArray, 0, n3);
            fileInputStream.close();
            boolean bl = false;
            boolean bl2 = false;
            int n4 = 0;
            block2: for (n2 = 0; n2 < n3; ++n2) {
                if (byArray[n2] == 96) {
                    if (n2 + 1 < n3 && byArray[n2 + 1] == 10) {
                        byArray[n2++] = 1;
                        byArray[n2] = 1;
                        continue;
                    }
                    if (n2 + 2 < n3 && byArray[n2 + 1] == 13 && byArray[n2 + 2] == 10) {
                        byArray[n2++] = 1;
                        byArray[n2++] = 1;
                        byArray[n2] = 1;
                        continue;
                    }
                }
                if (!bl2 && Character.isWhitespace((char)byArray[n2])) {
                    byArray[n2] = 0;
                    bl = false;
                    continue;
                }
                if (!bl) {
                    if (byArray[n2] == 35) {
                        while (n2 < n3) {
                            byte by = byArray[n2];
                            byArray[n2] = 0;
                            if (by == 10) continue block2;
                            ++n2;
                        }
                        continue;
                    }
                    bl = true;
                    ++n4;
                }
                if (byArray[n2] != 34) continue;
                byArray[n2] = 0;
                bl2 = !bl2;
            }
            if (n4 == 0) {
                return stringArray;
            }
            String[] stringArray2 = new String[n4 + stringArray.length - 1];
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
            }
            if (n + 1 < stringArray.length) {
                System.arraycopy(stringArray, n + 1, stringArray2, n + n4, stringArray.length - (n + 1));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if (byArray[n2] == 0) continue;
                int n5 = 0;
                int n6 = n2;
                while (n6 < n3 && byArray[n6] != 0) {
                    if (byArray[n6++] == 1) continue;
                    ++n5;
                }
                byte[] byArray2 = new byte[n5];
                n5 = 0;
                while (n2 < n3 && byArray[n2] != 0) {
                    if (byArray[n2] != 1) {
                        byArray2[n5++] = byArray[n2];
                    }
                    ++n2;
                }
                stringArray2[n++] = Compiler.changeForwardSlashesToBackwardSlashes(new String(byArray2));
            }
            return stringArray2;
        }
        catch (Throwable throwable) {
            return stringArray;
        }
    }

    private static void banner(Log log) {
        log.println("Oracle Java Compiler 10.1.3");
        log.println("Copyright (c) 1997-2006 Oracle Corporation. All Rights Reserved.");
    }

    static void standardUsage(Log log) {
        Compiler.banner(log);
        log.println(Message.usageString + ": ojc <" + Message.optionsString + "> <" + Message.sourceFilesString + "> <@" + Message.argumentFilesString + ">");
        log.println(Message.standardUsageScreen);
    }

    static void nonstandardUsage(Log log) {
        Compiler.banner(log);
        log.println(Message.nonStandardUsageScreen);
    }

    static void help(Log log, String string) {
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        boolean bl = false;
        try {
            int n;
            Locale locale = Locale.getDefault();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ojc.ojchelp", locale);
            bl = true;
            String string2 = resourceBundle.getString(string);
            if (string2.charAt(0) == '-') {
                string2 = resourceBundle.getString(string2.substring(1));
            }
            if ((n = string2.indexOf("%%")) >= 0) {
                string2 = string2.replaceAll("%%", File.pathSeparator);
            }
            Compiler.banner(log);
            log.println(string2);
        }
        catch (Exception exception) {
            if (!bl) {
                log.println("Error: can't load OJC resource file");
            }
            log.println("Error: option not found in OJC resource file");
        }
    }

    private static boolean containsWildcardCharacters(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        return string.indexOf(42) >= 0 || string.indexOf(63) >= 0;
    }

    static boolean matches(String string, int n, String string2, int n2) {
        if (n2 >= string2.length()) {
            return n >= string.length();
        }
        if (string2.charAt(n2) == '*') {
            return Compiler.matches(string, n, string2, n2 + 1) || n < string.length() && Compiler.matches(string, n + 1, string2, n2);
        }
        if (n >= string.length()) {
            return false;
        }
        char c = string.charAt(n);
        char c2 = string2.charAt(n2);
        return (c2 == '?' || Character.toUpperCase(c) == Character.toUpperCase(c2) || c == '/' && c2 == '\\' || c == '\\' && c2 == '/') && Compiler.matches(string, n + 1, string2, n2 + 1);
    }

    private static boolean ignoreDirectory(String[] stringArray, String string) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!Compiler.matches(string, 0, "*" + stringArray[i], 0)) continue;
                return true;
            }
        }
        return false;
    }

    private static void expandSourceFiles(ArrayList arrayList, int n, int n2, String[] stringArray, String string) {
        File file;
        File file2 = new File(string);
        String string2 = file2.getParent();
        String string3 = file2.getName();
        if (string2 == null) {
            String string4 = string2 = string.indexOf(File.separator) == 0 ? "" : ".";
        }
        if ((file = new File(string2 + File.separator)) == null) {
            arrayList.add(new SourcePackageRecord(string, false));
            return;
        }
        String[] stringArray2 = file.list();
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                String string5 = string2 + File.separator + stringArray2[i];
                if (new File(string5).isDirectory() && n < n2) {
                    if (Compiler.ignoreDirectory(stringArray, string5)) continue;
                    Compiler.expandSourceFiles(arrayList, n + 1, n2, stringArray, string5 + File.separator + string3);
                    continue;
                }
                if (!Compiler.matches(stringArray2[i], 0, string3, 0)) continue;
                arrayList.add(new SourcePackageRecord(string5, false));
            }
        }
    }

    public static ArrayList parseCommandLine(Log log, String[] stringArray, Options options) {
        if (stringArray.length == 0) {
            Compiler.standardUsage(log);
            return null;
        }
        Warning.defaultAllWarnings();
        ArrayList<SourcePackageRecord> arrayList = new ArrayList<SourcePackageRecord>();
        String[] stringArray2 = null;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                ++n2;
                continue;
            }
            if (stringArray[n2].startsWith("-")) {
                if (stringArray[n2].equals("-recurse")) {
                    if (n2 + 1 < stringArray.length) {
                        try {
                            n = Integer.parseInt(stringArray[n2 + 1]);
                            if (n < 0) {
                                n = 0;
                            }
                            ++n2;
                        }
                        catch (NumberFormatException numberFormatException) {
                            n = Integer.MAX_VALUE;
                        }
                    }
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-rx")) {
                    if (n2 + 1 >= stringArray.length) continue;
                    stringArray2 = Options.stringToArray(stringArray[++n2], ",");
                    continue;
                }
                if (stringArray[n2].equals("-s")) {
                    ++n2;
                    while (n2 < stringArray.length && !stringArray[n2].startsWith("-")) {
                        arrayList.add(new SourcePackageRecord(stringArray[n2++], false));
                    }
                    continue;
                }
                if (stringArray[n2].equals("-p")) {
                    ++n2;
                    while (n2 < stringArray.length && !stringArray[n2].startsWith("-")) {
                        arrayList.add(new SourcePackageRecord(stringArray[n2++], true));
                    }
                    continue;
                }
                int n3 = options.parseOption(stringArray, n2);
                if (n3 == 0) {
                    return null;
                }
                n2 += n3;
                continue;
            }
            if (stringArray[n2].startsWith("@")) {
                if ((stringArray = Compiler.expandFile(stringArray, n2, log)) != null) continue;
                return null;
            }
            if (Compiler.containsWildcardCharacters(stringArray[n2])) {
                Compiler.expandSourceFiles(arrayList, 0, n, stringArray2, stringArray[n2++]);
                continue;
            }
            arrayList.add(new SourcePackageRecord(stringArray[n2++], false));
        }
        if (options.makeFile == null) {
            options.nameReferences = false;
        }
        if (!options.checkSourceTargetVersions()) {
            return null;
        }
        if (arrayList.isEmpty() && !options.helpPrinted) {
            Compiler.standardUsage(log);
        }
        return arrayList;
    }

    private static boolean printStoragePath(Log log, Storage[] storageArray, String string, boolean bl) {
        int n = storageArray.length;
        for (int i = 0; i < n; ++i) {
            if (!bl) {
                bl = true;
            } else {
                log.print(string);
            }
            log.print(storageArray[i].getPath());
        }
        return bl;
    }

    private int deployFiles(Options options, ArrayList arrayList) {
        long l = System.currentTimeMillis();
        int n = 0;
        if (options.destinationDir != null) {
            File file;
            if (options.destinationFile == null) {
                file = new File(options.destinationDir);
                if (!file.exists() && !file.mkdirs()) {
                    this.parser.error(Message.errorUnableToCreateOutputDir, 0, false, options.destinationDir);
                }
                options.destinationFile = new DirectoryStorage(file);
            }
            Storage storage = options.destinationFile;
            block0: for (int i = 0; i < arrayList.size(); ++i) {
                DeployRecord deployRecord = (DeployRecord)arrayList.get(i);
                for (int j = 0; j < options.deployExtensions.length; ++j) {
                    Storage storage2;
                    if (!deployRecord.file.getName().endsWith(options.deployExtensions[j])) continue;
                    String string = deployRecord.packageName.replace('.', File.separatorChar);
                    string = storage.getPath() + File.separator + string;
                    file = new File(string);
                    if (!file.exists() && !file.mkdirs()) {
                        options.log.println("Error: unable to create output directory " + string);
                    }
                    DirectoryStorage directoryStorage = new DirectoryStorage(file);
                    if (!options.rebuild && (storage2 = directoryStorage.open(deployRecord.file.getName())) != null && deployRecord.file.modDate() <= storage2.modDate()) continue block0;
                    if (options.verbose || options.noquiet) {
                        options.log.println("[" + Message.deployingString + " " + deployRecord.file.getName() + " " + Message.toString + " " + directoryStorage + "]");
                    }
                    Compiler.copyFile(deployRecord.file, directoryStorage, options.log);
                    ++n;
                    continue block0;
                }
            }
            if (n > 0 && (options.verbose || options.elapsedTime)) {
                options.log.println("[" + Message.deploymentTimeString + " " + (System.currentTimeMillis() - l) + "ms]");
            }
        }
        return n;
    }

    private static String internalError(Log log, Throwable throwable, ArrayList arrayList, Options options, Parser parser) {
        Error error = new Error(null, Error.errorInternalError, 0);
        log.println(Message.errorColonString + error.message.getMessage());
        try {
            String string = "ojcInternalError.log";
            String string2 = System.getProperty("java.io.tmpdir");
            File file = new File(string2);
            if (string2 != null) {
                if (!string2.endsWith(options.fileSeparator)) {
                    string2 = string2 + options.fileSeparator;
                }
                string = string2 + string;
            }
            file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.println("OJC internal error log:");
            printStream.print("----------------------------------------------------");
            printStream.println("----------------------------");
            printStream.println("Compiler version: 10.1.3");
            printStream.println("Build number:     4306");
            printStream.println("Source files:");
            if (arrayList == null || arrayList.size() == 0) {
                printStream.println("\t" + (arrayList == null ? "<null>!" : "None!"));
            } else {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Storage storage = (Storage)arrayList.get(i);
                    printStream.println("\t" + storage.getPath());
                }
            }
            printStream.println();
            printStream.println("Options:");
            if (options == null) {
                printStream.println("<null>");
            } else {
                options.print(printStream);
            }
            printStream.println();
            printStream.println("Parser:");
            if (parser == null) {
                printStream.println("<null>");
            } else {
                parser.print(printStream);
            }
            printStream.println();
            byteArrayOutputStream.flush();
            String string3 = byteArrayOutputStream.toString();
            throwable.printStackTrace(printStream);
            printStream.close();
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.flush();
            fileOutputStream.close();
            log.println(Message.substitePercentArgument(Message.internalErrorLogString, file.getPath(), 1));
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Unknown compiler state";
        }
    }

    private static void outOfMemoryError(Log log) {
        Error error = new Error(null, Error.errorOutOfMemoryError, 0);
        log.println(Message.errorColonString + error.message.getMessage());
    }

    public static int main_throws_exceptions(ArrayList arrayList, Options options) throws Exception {
        Message.initializeMessages(options.log);
        options.sourceTargetJDKDefault = false;
        if (arrayList.size() > 0) {
            return Compiler.main_internal(arrayList, options, options.log);
        }
        return 0;
    }

    public static int main(ArrayList arrayList, Options options) {
        try {
            return Compiler.main_throws_exceptions(arrayList, options);
        }
        catch (Exception exception) {
            return 2;
        }
    }

    public static int main(String[] stringArray, Log log) {
        try {
            Message.initializeMessages(log);
            Options options = new Options(log);
            ArrayList arrayList = Compiler.parseCommandLine(log, stringArray, options);
            if (arrayList == null) {
                return 1;
            }
            if (arrayList.size() > 0) {
                return Compiler.main_internal(arrayList, options, log);
            }
        }
        catch (Exception exception) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int main_internal(ArrayList arrayList, Options options, Log log) throws Exception {
        Exception exception = null;
        Parser parser = null;
        ArrayList arrayList2 = null;
        int n = 0;
        try {
            boolean bl;
            Identifier.initializeIdentifiers(options.targetJDKVersion);
            Symbol.initializeSymbols();
            Expression.initializeExpressions();
            boolean bl2 = true;
            if (options.endorseddirsStr == null) {
                options.endorseddirsStr = System.getProperty("java.endorsed.dirs");
                bl2 = false;
            }
            if (options.bootClasspathStr == null) {
                options.bootClasspathStr = System.getProperty("sun.boot.class.path");
                if (options.bootClasspathStr == null) {
                    options.bootClasspathStr = System.getProperty("java.class.path");
                }
                if (options.bootClasspathStr == null && options.warnNonExistingPath) {
                    options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, false, false);
                }
            } else if (options.warnNonExistingPath) {
                options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, true, false);
            }
            if (options.prependBootClasspathStr != null) {
                if (options.warnNonExistingPath) {
                    options.makeClassPath(options.prependBootClasspathStr, Message.bootclasspathString, true, false);
                }
                options.bootClasspathStr = options.bootClasspathStr == null ? options.prependBootClasspathStr : options.prependBootClasspathStr + options.bootClasspathStr;
            }
            if (options.appendBootClasspathStr != null) {
                if (options.warnNonExistingPath) {
                    options.makeClassPath(options.appendBootClasspathStr, Message.bootclasspathString, true, false);
                }
                options.bootClasspathStr = options.bootClasspathStr == null ? options.appendBootClasspathStr : options.bootClasspathStr + options.appendBootClasspathStr;
            }
            boolean bl3 = true;
            if (options.extdirsStr == null) {
                options.extdirsStr = System.getProperty("java.ext.dirs");
                bl3 = false;
            }
            if (options.classpathStr == null && options.classpathStorage == null) {
                options.classpathStr = System.getProperty("env.class.path");
            }
            boolean bl4 = true;
            if (options.sourcepathStr == null && options.sourcepathStorage == null) {
                options.sourcepathStr = System.getProperty("env.source.path");
                if (options.sourcepathStr == null && options.classpathStr != null) {
                    options.sourcepathStr = options.classpathStr;
                    bl4 = false;
                }
            }
            if (options.endorseddirsStr != null) {
                options.endorseddirs = options.makeClassPath(options.endorseddirsStr, Message.endorsedDirectoryListString, bl2, true);
            }
            if (options.bootClasspathStr != null) {
                options.bootClasspath = options.makeClassPath(options.bootClasspathStr, Message.bootclasspathString, false, false);
            }
            if (options.extdirsStr != null) {
                options.extdirs = options.makeClassPath(options.extdirsStr, Message.extensionDirectoryListString, bl3, true);
            }
            if (options.classpathStr != null) {
                options.classpath = options.makeClassPath(options.classpathStr, Message.classpathString, true, false);
            } else if (options.classpathStorage != null) {
                options.classpath = options.classpathStorage;
            }
            if (options.sourcepathStr != null) {
                options.sourcepath = options.makeClassPath(options.sourcepathStr, Message.sourcepathString, bl4, false);
            } else if (options.sourcepathStorage != null) {
                options.sourcepath = options.sourcepathStorage;
            }
            if (options.verbosepath) {
                log.print("[classpath: ");
                boolean bl5 = false;
                if (options.endorseddirs != null) {
                    bl5 = Compiler.printStoragePath(log, options.endorseddirs, options.pathSeparator, bl5);
                }
                if (options.bootClasspath != null) {
                    bl5 = Compiler.printStoragePath(log, options.bootClasspath, options.pathSeparator, bl5);
                }
                if (options.extdirs != null) {
                    bl5 = Compiler.printStoragePath(log, options.extdirs, options.pathSeparator, bl5);
                }
                if (options.classpath != null) {
                    Compiler.printStoragePath(log, options.classpath, options.pathSeparator, bl5);
                }
                log.println(" ]");
                log.print("[sourcepath: ");
                if (options.sourcepath != null) {
                    Compiler.printStoragePath(log, options.sourcepath, "", false);
                }
                log.println(" ]");
            }
            if (options.verbose) {
                log.println("[encoding: " + options.encoding + "]");
            }
            Compiler compiler = new Compiler(options);
            parser = compiler.parser;
            if (parser.errorFound) {
                int n2 = 1;
                return n2;
            }
            ArrayList<DeployRecord> arrayList3 = new ArrayList<DeployRecord>();
            arrayList2 = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string;
                Storage storage;
                Object e = arrayList.get(i);
                if (e instanceof Storage) {
                    arrayList2.add(e);
                    continue;
                }
                SourcePackageRecord sourcePackageRecord = (SourcePackageRecord)e;
                if (sourcePackageRecord.isPackage) {
                    ArrayList arrayList4 = options.findSourcesInPackage(parser, sourcePackageRecord.source);
                    if (arrayList4 == null) continue;
                    for (int j = 0; j < arrayList4.size(); ++j) {
                        storage = (Storage)arrayList4.get(j);
                        if (storage.getName().endsWith(".java")) {
                            arrayList2.add(storage);
                            continue;
                        }
                        arrayList3.add(new DeployRecord(sourcePackageRecord.source, storage));
                    }
                    continue;
                }
                storage = new FileStorage(new File(sourcePackageRecord.source));
                if (sourcePackageRecord.source.endsWith(".java")) {
                    arrayList2.add(storage);
                    continue;
                }
                int n3 = sourcePackageRecord.source.lastIndexOf(File.separatorChar);
                if (n3 < 0) {
                    string = "";
                } else {
                    string = sourcePackageRecord.source.substring(0, n3);
                    string.replace(File.separatorChar, '.');
                }
                arrayList3.add(new DeployRecord(string, storage));
            }
            boolean bl6 = bl = arrayList2.size() == 0;
            if (options.makeFile != null) {
                arrayList2 = DepInfo.analyzeSources(arrayList2, options);
            }
            arrayList2 = Compiler.trimDuplicates(arrayList2);
            long l = System.currentTimeMillis();
            parser.parse(arrayList2);
            long l2 = System.currentTimeMillis();
            int n4 = 0;
            if ((!parser.errorFound || options.generateClassesDespiteErrors) && arrayList3.size() > 0 && options.deployExtensions != null && options.destinationDir != null) {
                n4 = compiler.deployFiles(options, arrayList3);
            }
            int n5 = n = parser.errorFound ? 1 : 0;
            if (parser.sourceFileList.size() == 0 && n4 == 0 && !options.verbose) {
                if (bl) {
                    Compiler.standardUsage(log);
                    int n6 = 1;
                    return n6;
                }
                int n7 = n;
                return n7;
            }
            parser.printMessages(log);
            if (options.verbose || options.elapsedTime) {
                String string = parser.sourceLineCount == 1 ? Message.lineString : Message.linesString;
                String string2 = parser.sourceFileList.size() == 1 ? Message.fileString : Message.filesString;
                String string3 = parser.classFileCount == 1 ? Message.classString : Message.classesString;
                String string4 = n4 == 1 ? Message.fileString : Message.filesString;
                log.print("[" + parser.sourceLineCount + " " + string + " " + Message.compiledString + " " + Message.inString + " " + (l2 - l) + "ms " + Message.fromString + " " + parser.sourceFileList.size() + " " + string2 + ", " + Message.generatingString + " " + parser.classFileCount + " " + string3);
                if (n4 > 0) {
                    log.print(", " + Message.deployingString + " " + n4 + " " + string4);
                }
                log.println("]");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Compiler.outOfMemoryError(options.log);
            int n8 = 4;
            return n8;
        }
        catch (RuntimeException runtimeException) {
            String string = runtimeException.getMessage();
            if (string != null && string.equals("user aborted")) {
                int n9 = 3;
                return n9;
            }
            runtimeException.printStackTrace();
            String string5 = Compiler.internalError(options.log, runtimeException, arrayList2, options, parser);
            exception = new Exception(string5, runtimeException);
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
            String string = Compiler.internalError(options.log, (Throwable)((Object)assertionError), arrayList2, options, parser);
            exception = new Exception(string, (Throwable)((Object)assertionError));
        }
        catch (StackOverflowError stackOverflowError) {
            stackOverflowError.printStackTrace();
            String string = Compiler.internalError(options.log, stackOverflowError, arrayList2, options, parser);
            exception = new Exception(string, stackOverflowError);
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
            String string = Compiler.internalError(options.log, exception2, arrayList2, options, parser);
            exception = new Exception(string, exception2);
        }
        catch (java.lang.Error error) {
            error.printStackTrace();
            String string = Compiler.internalError(options.log, error, arrayList2, options, parser);
            exception = new Exception(string, error);
        }
        finally {
            Identifier.releaseIdentifiers();
            Symbol.releaseSymbols();
            Expression.releaseExpressions();
            DepInfo.clear();
        }
        if (exception != null) {
            throw exception;
        }
        return n;
    }

    private static ArrayList trimDuplicates(ArrayList arrayList) {
        HashSet<String> hashSet = new HashSet<String>(arrayList.size());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Storage storage = (Storage)arrayList.get(i);
            String string = storage.getPath();
            if (hashSet.contains(string)) {
                arrayList.remove(i);
                continue;
            }
            hashSet.add(string);
        }
        return arrayList;
    }

    static {
        $assertionsDisabled = !Compiler.class.desiredAssertionStatus();
    }

    static class DeployRecord {
        String packageName;
        Storage file;

        DeployRecord(String string, Storage storage) {
            this.packageName = string;
            this.file = storage;
        }
    }

    static class SourcePackageRecord {
        boolean isPackage;
        String source;

        SourcePackageRecord(String string, boolean bl) {
            this.source = string;
            this.isPackage = bl;
        }
    }
}

