/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.CodeCoachPragma;
import oracle.ojc.compiler.CompiledImplementationList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.interfaces.Storage;

final class ClassFileWriter {
    Parser parser;
    byte[] writeBuffer;
    int writeBufferIndex;
    RawClassSymbol classSymbol;
    Storage classFile;
    private short constantValueAttrIndex;
    private short codeAttrIndex;
    private short lineNumberAttrIndex;
    private short localVarsAttrIndex;
    private short localVarsTypesAttrIndex;
    private short exceptionsAttrIndex;
    private short syntheticAttrIndex;
    private short deprecatedAttrIndex;
    private short codeCoachAttrIndex;
    private short sourceFileAttrIndex;
    private short innerClassesAttrIndex;
    private short signatureAttrIndex;
    short runtimeVisibleAnnotationAttrIndex;
    short runtimeInvisibleAnnotationAttrIndex;
    short runtimeVisibleParameterAnnotationAttrIndex;
    short runtimeInvisibleParameterAnnotationAttrIndex;
    short annotationDefaultAttrIndex;
    private short enclosingMethodAttrIndex;
    private short enclosingMethodClassIndex;
    private short enclosingMethodMethodIndex;
    private short thisClassIndex;
    private short superClassIndex;
    private int implementationCount;
    private int fieldCount;
    private FieldSymbolList fieldList;
    private int methodCount;
    private MethodSymbolList methodList;
    private short sourceFileIndex;
    private short innerClassesCount;
    private InnerClassesList innerClassesList;
    private short classSignatureIndex;
    private short compilerAttrIndex;
    private short lineColumnInfoAttrIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassFileWriter(Parser parser, RawClassSymbol rawClassSymbol, Storage storage, byte[] byArray) {
        this.parser = parser;
        this.classSymbol = rawClassSymbol;
        this.classFile = storage;
        this.writeBuffer = byArray;
        this.writeBufferIndex = 0;
    }

    private void flush() throws IOException {
        this.classFile.write(this.writeBuffer, 0, this.writeBufferIndex);
        this.writeBufferIndex = 0;
    }

    private void writeByteArray(byte[] byArray, int n) throws IOException {
        int n2 = this.writeBufferIndex;
        byte[] byArray2 = this.writeBuffer;
        if (n > byArray2.length) {
            this.flush();
            this.writeBufferIndex = 0;
            this.classFile.write(byArray, 0, n);
        } else {
            if (n2 + n > byArray2.length) {
                this.flush();
                n2 = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n2, n);
            this.writeBufferIndex = n2 + n;
        }
    }

    int ensureWriteBufferCapacity(int n) throws IOException {
        int n2 = this.writeBufferIndex;
        if (n2 + n >= this.writeBuffer.length) {
            this.flush();
            n2 = 0;
        }
        return n2;
    }

    private void writeHeader() {
        byte[] byArray = this.writeBuffer;
        switch (this.parser.options.targetJDKVersion) {
            default: {
                byArray[7] = 49;
                byArray[6] = 0;
                byArray[5] = 0;
                byArray[4] = 0;
                break;
            }
            case 160: {
                byArray[7] = 50;
                byArray[6] = 0;
                byArray[5] = 0;
                byArray[4] = 0;
                break;
            }
            case 140: {
                byArray[7] = 48;
                byArray[6] = 0;
                byArray[5] = 0;
                byArray[4] = 0;
                break;
            }
            case 130: {
                byArray[7] = 47;
                byArray[6] = 0;
                byArray[5] = 0;
                byArray[4] = 0;
                break;
            }
            case 120: {
                byArray[7] = 46;
                byArray[6] = 0;
                byArray[5] = 0;
                byArray[4] = 0;
                break;
            }
            case 110: {
                byArray[7] = 45;
                byArray[6] = 0;
                byArray[5] = 3;
                byArray[4] = 0;
            }
        }
        byArray[0] = -54;
        byArray[1] = -2;
        byArray[2] = -70;
        byArray[3] = -66;
        this.writeBufferIndex = 8;
    }

    private void writeAccessThisAndSuper() throws IOException {
        short s = (short)(this.classSymbol.access & 0xFFFFFFF0);
        s = (short)(s | (short)(this.classSymbol.getTopLevelClass().access & 7));
        if (this.parser.options.targetJDKVersion >= 120 && (this.classSymbol.access & 0x200) == 0) {
            s = (short)(s | 0x20);
        }
        int n = this.ensureWriteBufferCapacity(6);
        byte[] byArray = this.writeBuffer;
        byArray[n + 5] = (byte)this.superClassIndex;
        byArray[n + 4] = (byte)(this.superClassIndex >> 8);
        byArray[n + 3] = (byte)this.thisClassIndex;
        byArray[n + 2] = (byte)(this.thisClassIndex >> 8);
        byArray[n + 1] = (byte)s;
        byArray[n] = (byte)(s >> 8);
        this.writeBufferIndex = n + 6;
    }

    private void writeImplementedInterfaces() throws IOException {
        int n = this.ensureWriteBufferCapacity(2);
        byte[] byArray = this.writeBuffer;
        byArray[n + 1] = (byte)this.implementationCount;
        byArray[n] = (byte)(this.implementationCount >> 8);
        this.writeBufferIndex = n + 2;
        CompiledImplementationList compiledImplementationList = (CompiledImplementationList)this.classSymbol.getImplementationList();
        while (compiledImplementationList != null) {
            n = this.ensureWriteBufferCapacity(2);
            byArray[n + 1] = (byte)compiledImplementationList.index;
            byArray[n] = (byte)(compiledImplementationList.index >> 8);
            this.writeBufferIndex = n + 2;
            compiledImplementationList = (CompiledImplementationList)compiledImplementationList.next;
        }
    }

    private void writeSyntheticAttribute() throws IOException {
        int n = this.ensureWriteBufferCapacity(6);
        byte[] byArray = this.writeBuffer;
        byArray[n + 5] = 0;
        byArray[n + 4] = 0;
        byArray[n + 3] = 0;
        byArray[n + 2] = 0;
        byArray[n + 1] = (byte)this.syntheticAttrIndex;
        byArray[n] = (byte)(this.syntheticAttrIndex >> 8);
        this.writeBufferIndex = n + 6;
    }

    private void writeDeprecatedAttribute() throws IOException {
        int n = this.ensureWriteBufferCapacity(6);
        byte[] byArray = this.writeBuffer;
        byArray[n + 5] = 0;
        byArray[n + 4] = 0;
        byArray[n + 3] = 0;
        byArray[n + 2] = 0;
        byArray[n + 1] = (byte)this.deprecatedAttrIndex;
        byArray[n] = (byte)(this.deprecatedAttrIndex >> 8);
        this.writeBufferIndex = n + 6;
    }

    private void writeConstantValueAttribute(short s) throws IOException {
        int n = this.ensureWriteBufferCapacity(8);
        byte[] byArray = this.writeBuffer;
        byArray[n + 7] = (byte)s;
        byArray[n + 6] = (byte)(s >> 8);
        byArray[n + 5] = 2;
        byArray[n + 4] = 0;
        byArray[n + 3] = 0;
        byArray[n + 2] = 0;
        byArray[n + 1] = (byte)this.constantValueAttrIndex;
        byArray[n] = (byte)(this.constantValueAttrIndex >> 8);
        this.writeBufferIndex = n + 8;
    }

    private void writeSignatureAttribute(short s) throws IOException {
        int n = this.ensureWriteBufferCapacity(8);
        byte[] byArray = this.writeBuffer;
        byArray[n + 7] = (byte)s;
        byArray[n + 6] = (byte)(s >> 8);
        byArray[n + 5] = 2;
        byArray[n + 4] = 0;
        byArray[n + 3] = 0;
        byArray[n + 2] = 0;
        byArray[n + 1] = (byte)this.signatureAttrIndex;
        byArray[n] = (byte)(this.signatureAttrIndex >> 8);
        this.writeBufferIndex = n + 8;
    }

    private void writeCodeCoachLineAttribute(int n) throws IOException {
        int n2 = this.ensureWriteBufferCapacity(8);
        byte[] byArray = this.writeBuffer;
        byArray[n2 + 7] = (byte)n;
        byArray[n2 + 6] = (byte)(n >> 8);
        byArray[n2 + 5] = 2;
        byArray[n2 + 4] = 0;
        byArray[n2 + 3] = 0;
        byArray[n2 + 2] = 0;
        byArray[n2 + 1] = (byte)this.codeCoachAttrIndex;
        byArray[n2] = (byte)(this.codeCoachAttrIndex >> 8);
        this.writeBufferIndex = n2 + 8;
    }

    private void writeFields() throws IOException {
        int n = this.ensureWriteBufferCapacity(2);
        byte[] byArray = this.writeBuffer;
        byArray[n + 1] = (byte)this.fieldCount;
        byArray[n] = (byte)(this.fieldCount >> 8);
        this.writeBufferIndex = n + 2;
        FieldSymbolList fieldSymbolList = this.fieldList;
        while (fieldSymbolList != null) {
            FieldSymbol fieldSymbol = fieldSymbolList.fieldSymbol;
            short s = fieldSymbol.access;
            int n2 = 0;
            if (fieldSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    n2 = (short)(n2 + 1);
                }
            } else {
                if (this.parser.options.lineColumnInfo) {
                    n2 = (short)(n2 + 1);
                }
                if (this.parser.options.codecoach) {
                    n2 = (short)(n2 + 1);
                }
                if (fieldSymbol.isDeprecated()) {
                    n2 = (short)(n2 + 1);
                }
                if (fieldSymbolList.signatureAttrIndex != 0) {
                    n2 = (short)(n2 + 1);
                }
            }
            if (fieldSymbolList.constantValueIndex != 0) {
                n2 = (short)(n2 + 1);
            }
            if (fieldSymbol.annotation != null) {
                n2 = (short)(n2 + fieldSymbol.annotation.getAttibuteCount());
            }
            n = this.ensureWriteBufferCapacity(8);
            byArray[n + 7] = (byte)n2;
            byArray[n + 6] = (byte)(n2 >> 8);
            byArray[n + 5] = (byte)fieldSymbolList.signatureIndex;
            byArray[n + 4] = (byte)(fieldSymbolList.signatureIndex >> 8);
            byArray[n + 3] = (byte)fieldSymbolList.nameIndex;
            byArray[n + 2] = (byte)(fieldSymbolList.nameIndex >> 8);
            byArray[n + 1] = (byte)s;
            byArray[n] = (byte)(s >> 8);
            this.writeBufferIndex = n + 8;
            if (fieldSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    this.writeSyntheticAttribute();
                }
            } else {
                if (fieldSymbolList.signatureAttrIndex != 0) {
                    this.writeSignatureAttribute(fieldSymbolList.signatureAttrIndex);
                }
                if (this.parser.options.lineColumnInfo) {
                    this.writeLineColumnInfo(fieldSymbol);
                }
                if (this.parser.options.codecoach) {
                    this.writeCodeCoachLineAttribute(Scanner.positionToLine(fieldSymbol.pos));
                }
                if (fieldSymbol.isDeprecated()) {
                    this.writeDeprecatedAttribute();
                }
            }
            if (fieldSymbolList.constantValueIndex > 0) {
                this.writeConstantValueAttribute(fieldSymbolList.constantValueIndex);
            }
            if (fieldSymbol.annotation != null) {
                fieldSymbol.annotation.write(this);
            }
            fieldSymbolList = fieldSymbolList.next;
        }
    }

    private void writeMethods() throws IOException {
        int n = this.ensureWriteBufferCapacity(2);
        byte[] byArray = this.writeBuffer;
        byArray[n + 1] = (byte)this.methodCount;
        byArray[n] = (byte)(this.methodCount >> 8);
        this.writeBufferIndex = n + 2;
        MethodSymbolList methodSymbolList = this.methodList;
        while (methodSymbolList != null) {
            int n2;
            Annotation annotation;
            MethodSymbol methodSymbol = methodSymbolList.methodSymbol;
            short s = methodSymbol.access;
            int n3 = 0;
            if (methodSymbol.cmd.codeBuffer != null) {
                n3 = (short)(n3 + 1);
            }
            if (methodSymbol.throwsList != null) {
                n3 = (short)(n3 + 1);
            }
            if (methodSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    n3 = (short)(n3 + 1);
                }
            } else {
                if (methodSymbolList.signatureAttrIndex != 0) {
                    n3 = (short)(n3 + 1);
                }
                if (methodSymbol.isDeprecated()) {
                    n3 = (short)(n3 + 1);
                }
                if (!(methodSymbol.isGenerated() || methodSymbol.isDefaultConstructor() || methodSymbol.isBridgeMethod() || this.classSymbol.isSynthetic())) {
                    if (this.parser.options.lineColumnInfo) {
                        n3 = (short)(n3 + 1);
                    }
                    if (this.parser.options.codecoach) {
                        n3 = (short)(n3 + 1);
                    }
                }
            }
            if ((annotation = methodSymbol.getAnnotations()) != null) {
                n3 = (short)(n3 + annotation.getAttibuteCount());
            }
            if ((methodSymbol.flags & 0x40) != 0) {
                n3 = (short)(n3 + Annotation.getAttibuteCount(methodSymbol));
            }
            n = this.ensureWriteBufferCapacity(8);
            byArray[n + 7] = (byte)n3;
            byArray[n + 6] = (byte)(n3 >> 8);
            byArray[n + 5] = (byte)methodSymbolList.signatureIndex;
            byArray[n + 4] = (byte)(methodSymbolList.signatureIndex >> 8);
            byArray[n + 3] = (byte)methodSymbolList.nameIndex;
            byArray[n + 2] = (byte)(methodSymbolList.nameIndex >> 8);
            byArray[n + 1] = (byte)s;
            byArray[n] = (byte)(s >> 8);
            this.writeBufferIndex = n + 8;
            if (methodSymbol.cmd.codeBuffer != null) {
                int n4 = methodSymbol.cmd.codeBuffer.length;
                short s2 = methodSymbol.cmd.exceptionTableLen;
                n2 = 8 + n4 + 2 + s2 + 2;
                int n5 = 0;
                int n6 = 0;
                if (this.parser.options.lineNumbers && methodSymbol.cmd.lineNumberTable != null && (n5 = methodSymbol.cmd.lineNumberTable.length / 4) != 0) {
                    n6 = 2 + n5 * 4;
                    n2 += 6 + n6;
                }
                short s3 = 0;
                int n7 = 0;
                short s4 = 0;
                int n8 = 0;
                if (this.parser.options.localVariables && (s3 = methodSymbol.cmd.localVarTableLen) != 0) {
                    n7 = 2 + s3 * 10;
                    n2 += 6 + n7;
                    s4 = methodSymbol.cmd.localVarTypeTableLen;
                    if (s4 != 0) {
                        n8 = 2 + s4 * 10;
                        n2 += 6 + n8;
                    }
                    if (this.parser.options.codecoach && !this.classSymbol.isSynthetic()) {
                        n2 += 8 + s3 * 2;
                    }
                }
                short s5 = methodSymbol.localVarCount;
                short s6 = (short)methodSymbol.cmd.maxOpStackDepth;
                n = this.ensureWriteBufferCapacity(14);
                byArray[n + 13] = (byte)n4;
                byArray[n + 12] = (byte)(n4 >> 8);
                byArray[n + 11] = (byte)(n4 >> 16);
                byArray[n + 10] = (byte)(n4 >> 24);
                byArray[n + 9] = (byte)s5;
                byArray[n + 8] = (byte)(s5 >> 8);
                byArray[n + 7] = (byte)s6;
                byArray[n + 6] = (byte)(s6 >> 8);
                byArray[n + 5] = (byte)n2;
                byArray[n + 4] = (byte)(n2 >> 8);
                byArray[n + 3] = (byte)(n2 >> 16);
                byArray[n + 2] = (byte)(n2 >> 24);
                byArray[n + 1] = (byte)this.codeAttrIndex;
                byArray[n] = (byte)(this.codeAttrIndex >> 8);
                this.writeBufferIndex = n + 14;
                this.writeByteArray(methodSymbol.cmd.codeBuffer, n4);
                n = this.ensureWriteBufferCapacity(2);
                byArray[n + 1] = (byte)(s2 >> 3);
                byArray[n] = (byte)(s2 >> 11);
                this.writeBufferIndex = n + 2;
                if (s2 > 0) {
                    this.writeByteArray(methodSymbol.cmd.exceptionTable, s2);
                }
                n3 = 0;
                if (n6 > 0) {
                    n3 = (short)(n3 + 1);
                }
                if (n7 > 0) {
                    n3 = (short)(n3 + 1);
                    if (n8 > 0) {
                        n3 = (short)(n3 + 1);
                    }
                    if (this.parser.options.codecoach && !this.classSymbol.isSynthetic()) {
                        n3 = (short)(n3 + 1);
                    }
                }
                n = this.ensureWriteBufferCapacity(2);
                byArray[n + 1] = (byte)n3;
                byArray[n] = (byte)(n3 >> 8);
                this.writeBufferIndex = n + 2;
                if (n6 > 0) {
                    n = this.ensureWriteBufferCapacity(8);
                    byArray[n + 7] = (byte)n5;
                    byArray[n + 6] = (byte)(n5 >> 8);
                    byArray[n + 5] = (byte)n6;
                    byArray[n + 4] = (byte)(n6 >> 8);
                    byArray[n + 3] = (byte)(n6 >> 16);
                    byArray[n + 2] = (byte)(n6 >> 24);
                    byArray[n + 1] = (byte)this.lineNumberAttrIndex;
                    byArray[n] = (byte)(this.lineNumberAttrIndex >> 8);
                    this.writeBufferIndex = n + 8;
                    this.writeByteArray(methodSymbol.cmd.lineNumberTable, n6 - 2);
                }
                if (n7 > 0) {
                    n = this.ensureWriteBufferCapacity(8);
                    byArray[n + 7] = (byte)s3;
                    byArray[n + 6] = (byte)(s3 >> 8);
                    byArray[n + 5] = (byte)n7;
                    byArray[n + 4] = (byte)(n7 >> 8);
                    byArray[n + 3] = (byte)(n7 >> 16);
                    byArray[n + 2] = (byte)(n7 >> 24);
                    byArray[n + 1] = (byte)this.localVarsAttrIndex;
                    byArray[n] = (byte)(this.localVarsAttrIndex >> 8);
                    this.writeBufferIndex = n + 8;
                    this.writeByteArray(methodSymbol.cmd.localVarTable, n7 - 2);
                    if (n8 > 0) {
                        n = this.ensureWriteBufferCapacity(8);
                        byArray[n + 7] = (byte)s4;
                        byArray[n + 6] = (byte)(s4 >> 8);
                        byArray[n + 5] = (byte)n8;
                        byArray[n + 4] = (byte)(n8 >> 8);
                        byArray[n + 3] = (byte)(n8 >> 16);
                        byArray[n + 2] = (byte)(n8 >> 24);
                        byArray[n + 1] = (byte)this.localVarsTypesAttrIndex;
                        byArray[n] = (byte)(this.localVarsTypesAttrIndex >> 8);
                        this.writeBufferIndex = n + 8;
                        this.writeByteArray(methodSymbol.cmd.localVarTypeTable, n8 - 2);
                    }
                    if (this.parser.options.codecoach && !this.classSymbol.isSynthetic()) {
                        n = this.ensureWriteBufferCapacity(8);
                        n2 = 2 + s3 * 2;
                        byArray[n + 7] = (byte)s3;
                        byArray[n + 6] = (byte)(s3 >> 8);
                        byArray[n + 5] = (byte)n2;
                        byArray[n + 4] = (byte)(n2 >> 8);
                        byArray[n + 3] = (byte)(n2 >> 16);
                        byArray[n + 2] = (byte)(n2 >> 24);
                        byArray[n + 1] = (byte)this.codeCoachAttrIndex;
                        byArray[n + 0] = (byte)(this.codeCoachAttrIndex >> 8);
                        this.writeBufferIndex = n + 8;
                        this.writeByteArray(methodSymbol.cmd.ccLocalVarTable, n2 - 2);
                    }
                }
            }
            if (methodSymbol.throwsList != null) {
                n = this.ensureWriteBufferCapacity(8);
                n2 = 2 + methodSymbolList.exceptionCount * 2;
                byArray[n + 7] = (byte)methodSymbolList.exceptionCount;
                byArray[n + 6] = (byte)(methodSymbolList.exceptionCount >> 8);
                byArray[n + 5] = (byte)n2;
                byArray[n + 4] = (byte)(n2 >> 8);
                byArray[n + 3] = (byte)(n2 >> 16);
                byArray[n + 2] = (byte)(n2 >> 24);
                byArray[n + 1] = (byte)this.exceptionsAttrIndex;
                byArray[n] = (byte)(this.exceptionsAttrIndex >> 8);
                this.writeBufferIndex = n + 8;
                MethodSymbol.CompiledThrowsList compiledThrowsList = (MethodSymbol.CompiledThrowsList)methodSymbol.throwsList;
                do {
                    n = this.ensureWriteBufferCapacity(2);
                    byArray[n + 1] = (byte)compiledThrowsList.index;
                    byArray[n] = (byte)(compiledThrowsList.index >> 8);
                    this.writeBufferIndex = n + 2;
                } while ((compiledThrowsList = (MethodSymbol.CompiledThrowsList)compiledThrowsList.next) != null);
            }
            if (methodSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    this.writeSyntheticAttribute();
                }
            } else {
                if (methodSymbolList.signatureAttrIndex != 0) {
                    this.writeSignatureAttribute(methodSymbolList.signatureAttrIndex);
                }
                if (!(methodSymbol.isGenerated() || methodSymbol.isDefaultConstructor() || methodSymbol.isBridgeMethod() || this.classSymbol.isSynthetic())) {
                    if (this.parser.options.lineColumnInfo) {
                        this.writeLineColumnInfo(methodSymbol);
                    }
                    if (this.parser.options.codecoach) {
                        this.writeCodeCoachLineAttribute(Scanner.positionToLine(methodSymbol.pos));
                    }
                }
                if (methodSymbol.isDeprecated()) {
                    this.writeDeprecatedAttribute();
                }
            }
            if (annotation != null) {
                annotation.write(this);
            }
            if ((methodSymbol.flags & 0x40) != 0) {
                Annotation.write(methodSymbol, this);
            }
            methodSymbol.cmd = null;
            methodSymbolList = methodSymbolList.next;
        }
    }

    private void writeLineColumnInfo(Symbol symbol) throws IOException {
        boolean bl = this.parser.options.codecoach;
        byte[] byArray = this.writeBuffer;
        int n = this.ensureWriteBufferCapacity(bl ? 8 : 10);
        short s = (short)(Scanner.positionToColumn(symbol.pos) + 1);
        if (bl) {
            byArray[n + 7] = (byte)s;
            byArray[n + 6] = (byte)(s >> 8);
            byArray[n + 5] = 2;
        } else {
            short s2 = (short)Scanner.positionToLine(symbol.pos);
            byArray[n + 9] = (byte)s;
            byArray[n + 8] = (byte)(s >> 8);
            byArray[n + 7] = (byte)s2;
            byArray[n + 6] = (byte)(s2 >> 8);
            byArray[n + 5] = 4;
        }
        byArray[n + 4] = 0;
        byArray[n + 3] = 0;
        byArray[n + 2] = 0;
        byArray[n + 1] = (byte)this.lineColumnInfoAttrIndex;
        byArray[n] = (byte)(this.lineColumnInfoAttrIndex >> 8);
        this.writeBufferIndex = n + (bl ? 8 : 10);
    }

    private void writeClassAttributes() throws IOException {
        int n;
        int n2 = 1;
        if (this.enclosingMethodAttrIndex != 0) {
            n2 = (short)(n2 + 1);
        }
        if (this.sourceFileAttrIndex != 0) {
            n2 = (short)(n2 + 1);
        }
        if (this.innerClassesAttrIndex != 0) {
            n2 = (short)(n2 + 1);
        }
        if (this.classSymbol.isSynthetic()) {
            if (this.syntheticAttrIndex > 0) {
                n2 = (short)(n2 + 1);
            }
        } else {
            if (this.classSymbol.isDeprecated()) {
                n2 = (short)(n2 + 1);
            }
            if (this.parser.options.codecoach) {
                n2 = (short)(n2 + 1);
            }
            if (this.parser.options.lineColumnInfo) {
                n2 = (short)(n2 + 1);
            }
        }
        if (this.classSymbol.annotation != null) {
            n2 = (short)(n2 + this.classSymbol.annotation.getAttibuteCount());
        }
        if (this.classSignatureIndex != 0) {
            n2 = (short)(n2 + 1);
        }
        int n3 = this.ensureWriteBufferCapacity(2);
        byte[] byArray = this.writeBuffer;
        byArray[n3 + 1] = (byte)n2;
        byArray[n3] = (byte)(n2 >> 8);
        this.writeBufferIndex = n3 + 2;
        if (this.classSymbol.isSynthetic()) {
            if (this.syntheticAttrIndex > 0) {
                this.writeSyntheticAttribute();
            }
        } else {
            if (this.classSignatureIndex != 0) {
                this.writeSignatureAttribute(this.classSignatureIndex);
            }
            if (this.classSymbol.isDeprecated()) {
                this.writeDeprecatedAttribute();
            }
            if (this.parser.options.lineColumnInfo) {
                this.writeLineColumnInfo(this.classSymbol);
            }
            if (this.parser.options.codecoach) {
                short s = this.classSymbol.cd.ccd.sourceFile.codeCoachPragmaCount;
                n = 2 + s * 6;
                n3 = this.ensureWriteBufferCapacity(8);
                short s2 = (short)Scanner.positionToLine(this.classSymbol.pos);
                byArray[n3 + 7] = (byte)s2;
                byArray[n3 + 6] = (byte)(s2 >> 8);
                byArray[n3 + 5] = (byte)n;
                byArray[n3 + 4] = (byte)(n >> 8);
                byArray[n3 + 3] = (byte)(n >> 16);
                byArray[n3 + 2] = (byte)(n >> 24);
                byArray[n3 + 1] = (byte)this.codeCoachAttrIndex;
                byArray[n3] = (byte)(this.codeCoachAttrIndex >> 8);
                this.writeBufferIndex = n3 + 8;
                CodeCoachPragma codeCoachPragma = this.classSymbol.cd.ccd.sourceFile.codeCoachPragmaList;
                while (codeCoachPragma != null) {
                    n3 = this.ensureWriteBufferCapacity(6);
                    byArray[n3 + 5] = (byte)codeCoachPragma.nameIndex;
                    byArray[n3 + 4] = (byte)(codeCoachPragma.nameIndex >> 8);
                    byArray[n3 + 3] = codeCoachPragma.kind;
                    byArray[n3 + 2] = 0;
                    byArray[n3 + 1] = (byte)codeCoachPragma.line;
                    byArray[n3] = (byte)(codeCoachPragma.line >> 8);
                    this.writeBufferIndex = n3 + 6;
                    codeCoachPragma = codeCoachPragma.next;
                }
            }
        }
        if (this.classSymbol.annotation != null) {
            this.classSymbol.annotation.write(this);
        }
        if (this.sourceFileAttrIndex != 0) {
            n3 = this.ensureWriteBufferCapacity(8);
            byArray[n3 + 7] = (byte)this.sourceFileIndex;
            byArray[n3 + 6] = (byte)(this.sourceFileIndex >> 8);
            byArray[n3 + 5] = 2;
            byArray[n3 + 4] = 0;
            byArray[n3 + 3] = 0;
            byArray[n3 + 2] = 0;
            byArray[n3 + 1] = (byte)this.sourceFileAttrIndex;
            byArray[n3] = (byte)(this.sourceFileAttrIndex >> 8);
            this.writeBufferIndex = n3 + 8;
        }
        if (this.innerClassesAttrIndex != 0) {
            n3 = this.ensureWriteBufferCapacity(8);
            n = 2 + this.innerClassesCount * 8;
            byArray[n3 + 7] = (byte)this.innerClassesCount;
            byArray[n3 + 6] = (byte)(this.innerClassesCount >> 8);
            byArray[n3 + 5] = (byte)n;
            byArray[n3 + 4] = (byte)(n >> 8);
            byArray[n3 + 3] = (byte)(n >> 16);
            byArray[n3 + 2] = (byte)(n >> 24);
            byArray[n3 + 1] = (byte)this.innerClassesAttrIndex;
            byArray[n3] = (byte)(this.innerClassesAttrIndex >> 8);
            this.writeBufferIndex = n3 + 8;
            InnerClassesList innerClassesList = this.innerClassesList;
            while (innerClassesList != null) {
                n3 = this.ensureWriteBufferCapacity(8);
                byArray[n3 + 7] = (byte)innerClassesList.innerClassAccess;
                byArray[n3 + 6] = (byte)(innerClassesList.innerClassAccess >> 8);
                byArray[n3 + 5] = (byte)innerClassesList.innerNameIndex;
                byArray[n3 + 4] = (byte)(innerClassesList.innerNameIndex >> 8);
                byArray[n3 + 3] = (byte)innerClassesList.outerClassInfoIndex;
                byArray[n3 + 2] = (byte)(innerClassesList.outerClassInfoIndex >> 8);
                byArray[n3 + 1] = (byte)innerClassesList.innerClassInfoIndex;
                byArray[n3] = (byte)(innerClassesList.innerClassInfoIndex >> 8);
                this.writeBufferIndex = n3 + 8;
                innerClassesList = innerClassesList.next;
            }
        }
        if (this.enclosingMethodAttrIndex != 0) {
            n3 = this.ensureWriteBufferCapacity(10);
            byArray[n3 + 9] = (byte)this.enclosingMethodMethodIndex;
            byArray[n3 + 8] = (byte)(this.enclosingMethodMethodIndex >> 8);
            byArray[n3 + 7] = (byte)this.enclosingMethodClassIndex;
            byArray[n3 + 6] = (byte)(this.enclosingMethodClassIndex >> 8);
            byArray[n3 + 5] = 4;
            byArray[n3 + 4] = 0;
            byArray[n3 + 3] = 0;
            byArray[n3 + 2] = 0;
            byArray[n3 + 1] = (byte)this.enclosingMethodAttrIndex;
            byArray[n3] = (byte)(this.enclosingMethodAttrIndex >> 8);
            this.writeBufferIndex = n3 + 10;
        }
        int n4 = 9;
        n3 = this.ensureWriteBufferCapacity(n4);
        byArray[n3 + 8] = 3;
        byArray[n3 + 7] = 1;
        byArray[n3 + 6] = 10;
        byArray[n3 + 5] = (byte)(n4 - 6);
        byArray[n3 + 4] = 0;
        byArray[n3 + 3] = 0;
        byArray[n3 + 2] = 0;
        byArray[n3 + 1] = (byte)this.compilerAttrIndex;
        byArray[n3] = (byte)(this.compilerAttrIndex >> 8);
        this.writeBufferIndex = n3 + n4;
    }

    void createClassFile(String string) throws IOException {
        InnerClassesList innerClassesList;
        InnerClassSymbol innerClassSymbol;
        TypeSymbol typeSymbol;
        short s;
        RawClassSymbol rawClassSymbol;
        Options options = this.parser.options;
        ConstantPool constantPool = this.classSymbol.cd.ccd.constantPool;
        this.classSymbol.cd.ccd.constantPool = null;
        this.thisClassIndex = constantPool.enterConstantPoolClass(this.classSymbol.getInternalName());
        this.superClassIndex = 0;
        ClassSymbol classSymbol = this.classSymbol.superClass;
        if (classSymbol != null) {
            rawClassSymbol = classSymbol.getClassSymbol();
            this.superClassIndex = constantPool.enterConstantPoolClass(rawClassSymbol.getInternalName());
            constantPool.checkForOutOfPackageInnerClass(this.classSymbol, rawClassSymbol);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.classSymbol.isSynthetic()) {
            bl = true;
        } else {
            if (this.classSymbol.isDeprecated()) {
                bl2 = true;
            }
            if (this.classSymbol.involvesGenerics()) {
                bl3 = true;
                this.classSignatureIndex = constantPool.enterConstantPoolUtf8(this.classSymbol.getClassSignature());
            }
            if (options.codecoach && !this.classSymbol.isSynthetic()) {
                this.codeCoachAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.codecoachAttribute.name);
                CodeCoachPragma codeCoachPragma = this.classSymbol.cd.ccd.sourceFile.codeCoachPragmaList;
                while (codeCoachPragma != null) {
                    if (codeCoachPragma.name != null) {
                        codeCoachPragma.nameIndex = constantPool.enterConstantPoolUtf8(codeCoachPragma.name.name);
                    }
                    codeCoachPragma = codeCoachPragma.next;
                }
            }
        }
        CompiledImplementationList compiledImplementationList = (CompiledImplementationList)this.classSymbol.getImplementationList();
        while (compiledImplementationList != null) {
            ++this.implementationCount;
            rawClassSymbol = compiledImplementationList.interfaceSymbol.getClassSymbol();
            compiledImplementationList.index = constantPool.enterConstantPoolClass(rawClassSymbol.getInternalName());
            constantPool.checkForOutOfPackageInnerClass(this.classSymbol, rawClassSymbol);
            compiledImplementationList = (CompiledImplementationList)compiledImplementationList.next;
        }
        Annotation annotation = this.classSymbol.annotation;
        if (annotation != null) {
            annotation.generateConstantPoolEntries(this, constantPool);
        }
        if ((this.classSymbol.flags & 2) != 0) {
            this.constantValueAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.constantValueAttribute.name);
        }
        this.fieldCount = this.classSymbol.cd.fieldCount;
        this.fieldList = null;
        FieldSymbol fieldSymbol = this.classSymbol.cd.fieldList;
        while (fieldSymbol != null) {
            s = 0;
            if (fieldSymbol.isSynthetic()) {
                bl = true;
            } else {
                if (fieldSymbol.isDeprecated()) {
                    bl2 = true;
                }
                if (fieldSymbol.involvesGenerics()) {
                    bl3 = true;
                    s = constantPool.enterConstantPoolUtf8(fieldSymbol.getFieldSignature());
                }
            }
            FieldSymbolList fieldSymbolList = new FieldSymbolList(fieldSymbol, constantPool.enterConstantPoolUtf8(fieldSymbol.identifier.name), constantPool.enterConstantPoolUtf8(fieldSymbol.getSignature()), s);
            annotation = fieldSymbol.annotation;
            if (annotation != null) {
                annotation.generateConstantPoolEntries(this, constantPool);
            }
            if ((fieldSymbol.flags & 2) != 0) {
                int n;
                Expression expression = fieldSymbol.initializer;
                if (!$assertionsDisabled && (fieldSymbol.access & 8) == 0) {
                    throw new AssertionError();
                }
                if (expression.kind == 2) {
                    n = fieldSymbol.type.typeClass;
                } else if (expression.kind == 53) {
                    expression = ((AutoBoxingExpression)expression).operand;
                    n = expression.getType().typeClass;
                } else {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    n = -1;
                }
                switch (n) {
                    case 2: {
                        BooleanConstantExpression booleanConstantExpression = (BooleanConstantExpression)expression;
                        fieldSymbolList.constantValueIndex = constantPool.enterConstantPoolInteger(booleanConstantExpression.bval ? 1 : 0);
                        break;
                    }
                    case 4: {
                        if (expression.getType().typeKind == 4) {
                            CharConstantExpression charConstantExpression = (CharConstantExpression)expression;
                            fieldSymbolList.constantValueIndex = constantPool.enterConstantPoolInteger(charConstantExpression.cval);
                            break;
                        }
                        IntConstantExpression intConstantExpression = (IntConstantExpression)expression;
                        fieldSymbolList.constantValueIndex = constantPool.enterConstantPoolInteger(intConstantExpression.ival);
                        break;
                    }
                    case 8: {
                        LongConstantExpression longConstantExpression = (LongConstantExpression)expression;
                        fieldSymbolList.constantValueIndex = constantPool.enterConstantPoolLong(longConstantExpression.lval);
                        break;
                    }
                    case 16: {
                        FloatConstantExpression floatConstantExpression = (FloatConstantExpression)expression;
                        fieldSymbolList.constantValueIndex = constantPool.enterConstantPoolFloat(floatConstantExpression.fval);
                        break;
                    }
                    case 32: {
                        DoubleConstantExpression doubleConstantExpression = (DoubleConstantExpression)expression;
                        fieldSymbolList.constantValueIndex = constantPool.enterConstantPoolDouble(doubleConstantExpression.dval);
                        break;
                    }
                    case 64: {
                        if (!$assertionsDisabled && !(expression instanceof StringConstantExpression)) {
                            throw new AssertionError();
                        }
                        StringConstantExpression stringConstantExpression = (StringConstantExpression)expression;
                        fieldSymbolList.constantValueIndex = constantPool.enterConstantPoolString(stringConstantExpression.sval);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            fieldSymbolList.next = this.fieldList;
            this.fieldList = fieldSymbolList;
            fieldSymbol = fieldSymbol.nextInClass;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        this.methodCount = 0;
        this.methodList = null;
        MethodSymbol methodSymbol = this.classSymbol.cd.methodList;
        while (methodSymbol != null) {
            ++this.methodCount;
            if (methodSymbol.cmd.codeBuffer != null) {
                bl5 = true;
            }
            if (methodSymbol.cmd.lineNumberTable != null && methodSymbol.cmd.lineNumberTable.length > 0) {
                bl4 = true;
            }
            if (methodSymbol.cmd.localVarTableLen > 0) {
                bl8 = true;
            }
            if (methodSymbol.cmd.localVarTypeTableLen > 0) {
                bl7 = true;
            }
            if ((annotation = methodSymbol.getAnnotations()) != null) {
                annotation.generateConstantPoolEntries(this, constantPool);
            }
            if ((methodSymbol.flags & 0x40) != 0) {
                Annotation.generateConstantPoolEntries(methodSymbol, this, constantPool);
            }
            short s2 = 0;
            if (methodSymbol.throwsList != null) {
                bl6 = true;
                MethodSymbol.CompiledThrowsList compiledThrowsList = (MethodSymbol.CompiledThrowsList)methodSymbol.throwsList;
                do {
                    if ((typeSymbol = compiledThrowsList.throwsType).isTypeParameter()) {
                        typeSymbol = ((TypeParameterSymbol)typeSymbol).getClassSymbol();
                    }
                    compiledThrowsList.index = constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
                    s2 = (short)(s2 + 1);
                } while ((compiledThrowsList = (MethodSymbol.CompiledThrowsList)compiledThrowsList.next) != null);
            }
            s = 0;
            if (methodSymbol.isSynthetic()) {
                bl = true;
            } else {
                if (methodSymbol.isDeprecated()) {
                    bl2 = true;
                }
                if (methodSymbol.involvesGenerics()) {
                    bl3 = true;
                    s = constantPool.enterConstantPoolUtf8(methodSymbol.getMethodSignature());
                }
            }
            MethodSymbolList methodSymbolList = new MethodSymbolList(methodSymbol, constantPool.enterConstantPoolUtf8(methodSymbol.identifier.name), constantPool.enterConstantPoolUtf8(methodSymbol.getSignature()), s2, s);
            methodSymbolList.next = this.methodList;
            this.methodList = methodSymbolList;
            methodSymbol = methodSymbol.nextInClass;
        }
        if (bl5) {
            this.codeAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.codeAttribute.name);
        }
        if (options.lineNumbers && bl4) {
            this.lineNumberAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.lineNumberTableAttribute.name);
        }
        if (options.sourceFile) {
            this.sourceFileAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.sourceFileAttribute.name);
            this.sourceFileIndex = constantPool.enterConstantPoolUtf8(string.toCharArray());
        }
        if (bl8) {
            this.localVarsAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.localVarsTableAttribute.name);
        }
        if (bl7) {
            this.localVarsTypesAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.localVarsTypeTableAttribute.name);
        }
        if (bl && options.targetJDKVersion < 150) {
            this.syntheticAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.syntheticAttribute.name);
        }
        if (bl6) {
            this.exceptionsAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.exceptionsAttribute.name);
        }
        if (bl2) {
            this.deprecatedAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.deprecatedAttribute.name);
        }
        if (bl3) {
            this.signatureAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.signatureAttribute.name);
        }
        this.innerClassesList = null;
        if (this.classSymbol.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)this.classSymbol;
            RawClassSymbol rawClassSymbol2 = innerClassSymbol.getOuterClass();
            if (this.parser.options.targetJDKVersion >= 150 && innerClassSymbol.isLocalInnerClass()) {
                this.enclosingMethodAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.enclosingMethodAttribute.name);
                this.enclosingMethodClassIndex = constantPool.enterConstantPoolClass(rawClassSymbol2.getInternalName());
                methodSymbol = innerClassSymbol.getEnclosingMethod();
                if (methodSymbol != null) {
                    this.enclosingMethodMethodIndex = constantPool.enterConstantPoolNameAndType(methodSymbol.identifier.name, methodSymbol.getSignature());
                }
            }
            while (true) {
                innerClassesList = new InnerClassesList();
                innerClassesList.innerClassInfoIndex = constantPool.enterConstantPoolClass(innerClassSymbol.getInternalName());
                innerClassesList.outerClassInfoIndex = constantPool.enterConstantPoolClass(rawClassSymbol2.getInternalName());
                innerClassesList.innerClassAccess = innerClassSymbol.access;
                if (!innerClassSymbol.isAnonymousInnerClass()) {
                    innerClassesList.innerNameIndex = constantPool.enterConstantPoolUtf8(innerClassSymbol.identifier.name);
                }
                innerClassesList.next = this.innerClassesList;
                this.innerClassesList = innerClassesList;
                this.innerClassesCount = (short)(this.innerClassesCount + 1);
                if (!rawClassSymbol2.isInnerClass()) break;
                innerClassSymbol = (InnerClassSymbol)rawClassSymbol2;
                rawClassSymbol2 = innerClassSymbol.getOuterClass();
            }
        }
        TypeSymbolList typeSymbolList = this.classSymbol.cd.innerClassList;
        while (typeSymbolList != null) {
            typeSymbol = typeSymbolList.typeSymbol;
            innerClassesList = new InnerClassesList();
            innerClassesList.innerClassInfoIndex = constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
            innerClassesList.outerClassInfoIndex = this.thisClassIndex;
            innerClassesList.innerClassAccess = typeSymbol.access;
            if (!typeSymbol.isAnonymousInnerClass()) {
                innerClassesList.innerNameIndex = constantPool.enterConstantPoolUtf8(typeSymbol.identifier.name);
            }
            innerClassesList.next = this.innerClassesList;
            this.innerClassesList = innerClassesList;
            this.innerClassesCount = (short)(this.innerClassesCount + 1);
            typeSymbolList = typeSymbolList.next;
        }
        this.classSymbol.checkForOutOfPackageInnerClasses(constantPool, this.classSymbol);
        typeSymbolList = constantPool.outOfPackageInnerClassList;
        while (typeSymbolList != null) {
            innerClassSymbol = (InnerClassSymbol)typeSymbolList.typeSymbol;
            innerClassesList = new InnerClassesList();
            innerClassesList.innerClassInfoIndex = constantPool.enterConstantPoolClass(innerClassSymbol.getInternalName());
            innerClassesList.outerClassInfoIndex = constantPool.enterConstantPoolClass(innerClassSymbol.getOuterClass().getInternalName());
            innerClassesList.innerNameIndex = constantPool.enterConstantPoolUtf8(innerClassSymbol.identifier.name);
            innerClassesList.innerClassAccess = innerClassSymbol.access;
            innerClassesList.next = this.innerClassesList;
            this.innerClassesList = innerClassesList;
            this.innerClassesCount = (short)(this.innerClassesCount + 1);
            typeSymbolList = typeSymbolList.next;
        }
        if (this.innerClassesCount > 0) {
            this.innerClassesAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.innerClassesAttribute.name);
        }
        this.compilerAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.ojcAttribute.name);
        this.lineColumnInfoAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.getIdentifier((String)"LineColumnInfo").name);
        this.writeHeader();
        constantPool.writeConstantPool(this);
        this.writeAccessThisAndSuper();
        this.writeImplementedInterfaces();
        this.writeFields();
        this.writeMethods();
        this.writeClassAttributes();
        if (this.parser.options.makeFile != null) {
            DepInfo.addClass(this.classSymbol, constantPool, this.parser);
        }
        this.classSymbol.cd.ccd.constantPool = null;
        this.flush();
    }

    static {
        $assertionsDisabled = !ClassFileWriter.class.desiredAssertionStatus();
    }

    private static class MethodSymbolList {
        MethodSymbolList next;
        MethodSymbol methodSymbol;
        short nameIndex;
        short signatureIndex;
        short exceptionCount;
        short signatureAttrIndex;

        MethodSymbolList(MethodSymbol methodSymbol, short s, short s2, short s3, short s4) {
            this.methodSymbol = methodSymbol;
            this.nameIndex = s;
            this.signatureIndex = s2;
            this.exceptionCount = s3;
            this.signatureAttrIndex = s4;
        }
    }

    private static class FieldSymbolList {
        FieldSymbolList next;
        FieldSymbol fieldSymbol;
        short nameIndex;
        short signatureIndex;
        short constantValueIndex;
        short signatureAttrIndex;

        FieldSymbolList(FieldSymbol fieldSymbol, short s, short s2, short s3) {
            this.fieldSymbol = fieldSymbol;
            this.nameIndex = s;
            this.signatureIndex = s2;
            this.signatureAttrIndex = s3;
        }
    }

    private static class InnerClassesList {
        InnerClassesList next;
        short innerClassInfoIndex;
        short outerClassInfoIndex;
        short innerNameIndex;
        short innerClassAccess;

        private InnerClassesList() {
        }
    }
}

