/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.LabeledStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SynchronizedStatement;
import oracle.ojc.compiler.TryStatement;

final class BreakStatement
extends Statement {
    LabelSymbol labelSymbol;
    LabelSymbol breakSymbol;
    static final /* synthetic */ boolean $assertionsDisabled;

    BreakStatement(StatementList statementList, int n, LabelSymbol labelSymbol) {
        super(statementList, n, (byte)9);
        this.labelSymbol = labelSymbol;
    }

    void resolveAndCheck(Parser parser) {
        this.parent.updateDefUseSetsAfterBreak(parser, this.labelSymbol);
        if (this.labelSymbol != null) {
            LabeledStatement labeledStatement = this.labelSymbol.labeledStatement;
            if (labeledStatement != null) {
                this.breakSymbol = labeledStatement.breakLabelSymbol;
                if (this.breakSymbol == null) {
                    this.breakSymbol = new LabelSymbol(0, null);
                    this.breakSymbol.label = new Label();
                    labeledStatement.breakLabelSymbol = this.breakSymbol;
                }
            }
        } else {
            SwitchLoopList switchLoopList = parser.innerSwitchLoop;
            if (switchLoopList == null) {
                parser.error(Message.errorBreakOutside, this.pos, false);
            } else {
                this.breakSymbol = switchLoopList.getBreakSymbol();
            }
        }
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Statement statement;
        if (this.labelSymbol != null) {
            statement = this.labelSymbol.labeledStatement;
        } else {
            SwitchLoopList switchLoopList = byteCodeGenerator.parser.innerSwitchLoop;
            if (!$assertionsDisabled && switchLoopList == null) {
                throw new AssertionError();
            }
            statement = switchLoopList.loopStmt != null ? switchLoopList.loopStmt : switchLoopList.switchStmt;
        }
        if (statement != null) {
            StatementList statementList = this.parent;
            while (true) {
                if (!$assertionsDisabled && statementList.parent == null) {
                    throw new AssertionError();
                }
                if (statementList.parent == statement) break;
                switch (statementList.parent.kind) {
                    case 17: {
                        TryStatement tryStatement = (TryStatement)statementList.parent;
                        if (tryStatement.finallyBody == null || tryStatement.finallyBody == statementList) break;
                        if (byteCodeGenerator.parser.options.targetJDKVersion < 150) {
                            if (tryStatement.finallyLabel == null) {
                                tryStatement.finallyLabel = new Label();
                            }
                            byteCodeGenerator.generateBranch_jsr(tryStatement.finallyLabel);
                            break;
                        }
                        tryStatement.finallyBody.generateByteCode(byteCodeGenerator);
                        break;
                    }
                    case 15: {
                        SynchronizedStatement synchronizedStatement = (SynchronizedStatement)statementList.parent;
                        byteCodeGenerator.loadLocalVariable(byteCodeGenerator.parser.javaLangObjectSymbol, synchronizedStatement.localVar);
                        byteCodeGenerator.generate_8((byte)-61);
                        byteCodeGenerator.decOpStackHeight(1);
                    }
                }
                statementList = statementList.parent.parent;
            }
        }
        byteCodeGenerator.generateBranch_goto(this.breakSymbol.label);
    }

    boolean isLoopExitStatement() {
        return true;
    }

    boolean canReachNextStatement(boolean bl) {
        return false;
    }

    static {
        $assertionsDisabled = !BreakStatement.class.desiredAssertionStatus();
    }
}

