/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

final class ArrayExpression
extends Expression {
    static byte[] aload_opcode = new byte[12];
    static byte[] astore_opcode;
    Expression arrayExpr;
    Expression indexExpr;

    ArrayExpression(Expression expression, Expression expression2) {
        super((byte)3, expression.pos);
        this.arrayExpr = expression;
        this.indexExpr = expression2;
    }

    Expression resolveAndCheck(Parser parser) {
        Expression expression = this.arrayExpr;
        expression = expression.resolveAndCheck(parser);
        Expression expression2 = this.indexExpr;
        expression2 = expression2.resolveAndCheck(parser);
        TypeSymbol typeSymbol = expression.getType();
        if ((typeSymbol.typeClass & 0xFFFFFF80) == 0) {
            int n = expression.pos;
            if (expression instanceof NullConstantExpression) {
                parser.error(Message.errorNullDeref, n, false);
            } else {
                parser.error(Message.errorArrayRequired, n, false, typeSymbol.errorName());
            }
            this.setType(TypeSymbol.errorSymbol);
        } else if (typeSymbol.isErroneous()) {
            this.setType(typeSymbol);
        } else {
            ArraySymbol arraySymbol = (ArraySymbol)typeSymbol;
            this.setType(ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1));
        }
        TypeSymbol typeSymbol2 = expression2.getType();
        if ((typeSymbol2.typeClass & 4) == 0) {
            TypeSymbol typeSymbol3;
            if (parser.options.sourceJDKVersion >= 150 && typeSymbol2.isReferenceType() && (typeSymbol3 = BoxingExpression.getPrimitiveType(parser, typeSymbol2)) != null && (typeSymbol3.typeClass & 4) != 0) {
                expression2 = new AutoUnboxingExpression(expression2, typeSymbol3);
                typeSymbol2 = typeSymbol3;
            } else {
                Error error = parser.error(Message.errorIncompatibleTypes, expression2.pos, false, typeSymbol2.errorName(), "int");
                return new ErrorExpression(error);
            }
        }
        typeSymbol2 = TypeSymbol.unaryNumericPromotion(parser, typeSymbol2);
        this.indexExpr = expression2.promoteType(parser, typeSymbol2);
        this.arrayExpr = expression;
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.arrayExpr.generateByteCode(byteCodeGenerator);
        this.indexExpr.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8(aload_opcode[this.getType().typeKind]);
        TypeSymbol typeSymbol = this.getType();
        if ((typeSymbol.typeClass & 0x28) == 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
        ArraySymbol arraySymbol = (ArraySymbol)this.arrayExpr.getType();
        TypeSymbol typeSymbol2 = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1).eraseType();
        if (!typeSymbol.equalTo(typeSymbol2)) {
            short s = byteCodeGenerator.constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
            byteCodeGenerator.generate_8_16((byte)-64, s);
        }
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean bl) {
        this.arrayExpr.generateByteCode(byteCodeGenerator);
        this.indexExpr.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8_8(bl ? (byte)93 : 92, aload_opcode[this.getType().typeKind]);
        byteCodeGenerator.incOpStackHeight(2);
        if ((this.getType().typeClass & 0x28) == 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.generate_8(astore_opcode[this.getType().typeKind]);
        byteCodeGenerator.decOpStackHeight(3);
        if ((this.getType().typeClass & 0x28) != 0) {
            byteCodeGenerator.decOpStackHeight(1);
        }
    }

    static {
        ArrayExpression.aload_opcode[11] = 50;
        ArrayExpression.aload_opcode[10] = 50;
        ArrayExpression.aload_opcode[2] = 51;
        ArrayExpression.aload_opcode[3] = 51;
        ArrayExpression.aload_opcode[4] = 52;
        ArrayExpression.aload_opcode[5] = 53;
        ArrayExpression.aload_opcode[6] = 46;
        ArrayExpression.aload_opcode[7] = 47;
        ArrayExpression.aload_opcode[8] = 48;
        ArrayExpression.aload_opcode[9] = 49;
        astore_opcode = new byte[12];
        ArrayExpression.astore_opcode[11] = 83;
        ArrayExpression.astore_opcode[10] = 83;
        ArrayExpression.astore_opcode[2] = 84;
        ArrayExpression.astore_opcode[3] = 84;
        ArrayExpression.astore_opcode[4] = 85;
        ArrayExpression.astore_opcode[5] = 86;
        ArrayExpression.astore_opcode[6] = 79;
        ArrayExpression.astore_opcode[7] = 80;
        ArrayExpression.astore_opcode[8] = 81;
        ArrayExpression.astore_opcode[9] = 82;
    }
}

