/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.CompiledImplementationList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.NewExpression;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

class AnonymousClassSymbol
extends InnerClassSymbol {
    MethodSymbol constructorSymbol;
    InvokeExpression superInvokeExpr;
    InvokeExpression invokeExpr;
    NewExpression newExpr;
    static final /* synthetic */ boolean $assertionsDisabled;

    AnonymousClassSymbol(int n, short s) {
        super(n, Identifier.getIdentifier(""), s, null, null, true);
    }

    protected void toString(StringBuffer stringBuffer) {
        this.getOuterClass().toString(stringBuffer);
        stringBuffer.append('.');
        ClassSymbol classSymbol = this.getOverriddenClass();
        stringBuffer.append(classSymbol.identifier);
    }

    String errorName() {
        return Message.anonymousClassString;
    }

    String kindName() {
        return Message.anonymousClassString;
    }

    TypeSymbol resolveType(Parser parser, int n, boolean bl, boolean bl2, boolean bl3) {
        return this;
    }

    boolean isLocalInnerClass() {
        return true;
    }

    boolean isAnonymousInnerClass() {
        return true;
    }

    boolean isNonAnonymousInnerClass() {
        return false;
    }

    void fixConstructors(Parser parser) {
        if (this.isSynthetic() || this.isEnum()) {
            return;
        }
        Object object = parser.saveResolutionState(this);
        parser.suspendDataFlowChecking = true;
        this.constructorSymbol.resolveMethod(parser);
        if (!(this.superInvokeExpr.method instanceof MethodSymbol)) {
            if (!$assertionsDisabled && !parser.errorFound) {
                throw new AssertionError();
            }
        } else {
            MethodSymbol methodSymbol = (MethodSymbol)this.superInvokeExpr.method;
            boolean bl = false;
            boolean bl2 = (methodSymbol.access & 0x80) != 0;
            ArgumentVariableList argumentVariableList = methodSymbol.argumentList;
            ArgumentVariableList argumentVariableList2 = this.constructorSymbol.argumentList;
            ArgumentVariableList argumentVariableList3 = methodSymbol.argumentList;
            while (argumentVariableList2 != null) {
                TypeSymbol typeSymbol;
                if (bl2 && argumentVariableList3.next == null) {
                    ArraySymbol arraySymbol = (ArraySymbol)argumentVariableList3.argSymbol.type;
                    typeSymbol = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                } else {
                    typeSymbol = argumentVariableList3.argSymbol.type;
                }
                if ((typeSymbol.typeClass & 0xFFFFFFC0) != 0) {
                    argumentVariableList2.argSymbol.type = typeSymbol;
                }
                argumentVariableList2 = argumentVariableList2.next;
                argumentVariableList3 = argumentVariableList3.next == null ? argumentVariableList3 : argumentVariableList3.next;
            }
            int n = this.cd.fieldCount + this.constructorSymbol.localVarCount;
            parser.defSet = new BitSet(n);
            parser.posSet = new BitSet(n);
            parser.useSet = new BitSet(n);
            parser.currentClassSymbol = this;
            parser.currentMethodSymbol = this.constructorSymbol;
            super.fixConstructors(parser);
        }
        parser.restoreResolutionState(object);
    }

    void completeAnonymousClass(Parser parser) {
        if (!this.isEnum()) {
            TypeSymbol typeSymbol = this.superClass.resolveType(parser, this.pos, false, true, false);
            this.superClass = typeSymbol.isErroneous() ? parser.javaLangObjectPcs : (typeSymbol.isRawClass() ? ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)typeSymbol, null, null) : (ClassSymbol)typeSymbol);
            if (this.superClass.isInterface()) {
                this.flags = (short)(this.flags | 0x400);
                if (this.superClass.equalTo(parser.javaIoSerializableSymbol)) {
                    this.flags = (short)(this.flags | 0x800);
                }
                this.setImplementationList(new CompiledImplementationList(this.superClass));
                this.superClass = parser.javaLangObjectPcs;
            } else {
                this.flags = (short)(this.flags | this.superClass.getClassSymbol().flags & 0xC00);
            }
            if ((this.flags & 0x40) == 0) {
                if ((this.superClass.access & 0x10) != 0) {
                    parser.error(Message.errorFinalCannotBeInherited, this.pos, this.superClass.isErroneous(), this.superClass.errorName());
                }
                if (this.superClass.isNonStaticInnerClass()) {
                    this.addHiddenSuperOuterThisArgument((InnerClassSymbol)this.superClass.getClassSymbol());
                }
                MethodSymbol methodSymbol = this.constructorSymbol;
                ExpressionList expressionList = null;
                ExpressionList expressionList2 = null;
                InvokeExpression invokeExpression = this.invokeExpr;
                invokeExpression.resolvedArguments = true;
                ExpressionList expressionList3 = invokeExpression.arguments;
                while (expressionList3 != null) {
                    Expression expression = expressionList3.expr;
                    expression = expression.resolveAndCheck(parser);
                    ArgumentVariableSymbol argumentVariableSymbol = methodSymbol.addArgument(expression.getType());
                    ExpressionList expressionList4 = new ExpressionList(new MethodVariableExpression(0, argumentVariableSymbol));
                    if (expressionList2 == null) {
                        expressionList2 = expressionList = expressionList4;
                    } else {
                        expressionList.next = expressionList4;
                        expressionList = expressionList4;
                    }
                    expressionList3.expr = expression;
                    expressionList3 = expressionList3.next;
                }
                StatementList statementList = methodSymbol.cmd.statementList;
                if (statementList == null) {
                    methodSymbol.cmd.statementList = statementList = new StatementList();
                }
                UnresolvedSymbol unresolvedSymbol = new UnresolvedSymbol(0, this.classScope, Identifier.initializerIdentifier);
                this.superInvokeExpr = new InvokeExpression(0, unresolvedSymbol, null, new SuperExpression(0, this, null), expressionList2);
                this.superInvokeExpr.flags = (byte)(this.superInvokeExpr.flags | 2);
                this.superInvokeExpr.typeArguments = invokeExpression.typeArguments;
                invokeExpression.typeArguments = null;
                ExpressionStatement expressionStatement = new ExpressionStatement(statementList, 0, this.superInvokeExpr);
                if (statementList.first != null) {
                    statementList.first.insertBefore(expressionStatement);
                } else {
                    statementList.add(expressionStatement);
                }
                parser.addReturnStatement(methodSymbol, statementList);
                methodSymbol.flags = (short)(methodSymbol.flags | 1);
                if (this.superClass.isInnerClass()) {
                    InnerClassSymbol.HiddenArgumentList hiddenArgumentList = ((InnerClassSymbol)this.superClass.getClassSymbol()).hiddenArgumentList;
                    while (hiddenArgumentList != null) {
                        if (hiddenArgumentList.kind == 2) {
                            this.addHiddenFinalLocalArgument(hiddenArgumentList.localVar, null);
                        }
                        hiddenArgumentList = hiddenArgumentList.next;
                    }
                }
            }
        }
        this.flags = (short)(this.flags | 0x40);
        Object object = parser.saveResolutionState(this);
        this.resolveFields(parser);
        this.resolveMethods(parser);
        this.buildMethodTable(parser);
        this.checkInnerClasses(parser);
        this.resolveFieldInitializers(parser);
        this.findConstantFields(parser);
        this.assignFieldInitializers(parser);
        if ((this.access & 0x400) != 0) {
            if (parser.options.targetJDKVersion == 110) {
                this.addInheritedInterfaceMethods(parser);
            }
        } else if ((this.superClass.access & 0x400) != 0 || this.getImplementationList() != null) {
            this.checkImplementationsOfAbstractMethods(parser);
        }
        parser.restoreResolutionState(object);
    }

    static AnonymousClassSymbol createDummyClass(Parser parser, RawClassSymbol rawClassSymbol) {
        AnonymousClassSymbol anonymousClassSymbol = new AnonymousClassSymbol(0, 17);
        anonymousClassSymbol.superClass = parser.javaLangObjectPcs;
        anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x20);
        anonymousClassSymbol.cd.ccd.sourceFile = rawClassSymbol.cd.ccd.sourceFile;
        anonymousClassSymbol.scope = rawClassSymbol.classScope;
        anonymousClassSymbol.classScope = new ClassScope(anonymousClassSymbol, rawClassSymbol.classScope, parser);
        anonymousClassSymbol.cd.ccd.constantPool = new ConstantPool(parser);
        if (parser.options.targetJDKVersion >= 150) {
            anonymousClassSymbol.access = (short)(anonymousClassSymbol.access | 0x1000);
        } else {
            anonymousClassSymbol.flags = (short)(anonymousClassSymbol.flags | 0x100);
        }
        parser.classSymbolList.add(anonymousClassSymbol);
        rawClassSymbol.addInnerClass(anonymousClassSymbol);
        return anonymousClassSymbol;
    }

    ClassSymbol getOverriddenClass() {
        ImplementationList implementationList = this.getImplementationList();
        if (implementationList != null) {
            return implementationList.interfaceSymbol;
        }
        return this.superClass;
    }

    static {
        $assertionsDisabled = !AnonymousClassSymbol.class.desiredAssertionStatus();
    }
}

