/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.controls;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.jbo.AttributeDef;
import oracle.jbo.Row;
import oracle.jbo.uicli.jui.JUButtonGroupBinding;
import oracle.jbo.uicli.jui.JUButtonGroupControlInterface;

public class JURadioButtonGroupPanel
extends JPanel
implements JUButtonGroupControlInterface {
    private JUButtonGroupBinding mBinding;
    private int mRows;
    private int mCols = 1;
    private int mVGap;
    private int mHGap;
    private String DISPLAY_DELIMITER = ",";

    public AbstractButton[] createButtons(Object[] objectArray) {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JRadioButton) {
                    this.remove(componentArray[n]);
                }
                ++n;
            }
        }
        AbstractButton[] abstractButtonArray = null;
        if (objectArray != null) {
            if (this.mRows == 0 && this.mCols == 0) {
                this.mCols = 1;
            }
            int n = objectArray.length;
            abstractButtonArray = new AbstractButton[n];
            this.setLayout(new GridLayout(this.mRows, this.mCols, this.mHGap, this.mVGap));
            int n2 = 0;
            while (n2 < n) {
                JRadioButton jRadioButton = new JRadioButton();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.getDisplayValue(objectArray[n2]));
                jRadioButton.setText(stringBuffer.toString());
                this.add(jRadioButton);
                abstractButtonArray[n2] = jRadioButton;
                ++n2;
            }
        }
        this.revalidate();
        return abstractButtonArray;
    }

    private Object getDisplayValue(Object object) {
        if (this.mBinding == null || this.mBinding.isSingleAttrList()) {
            return object;
        }
        Row row = (Row)object;
        AttributeDef[] attributeDefArray = this.mBinding.getDisplayAttributeDefs();
        if (attributeDefArray != null) {
            StringBuffer stringBuffer = new StringBuffer("").append(row.getAttribute(attributeDefArray[0].getIndex()));
            int n = 1;
            while (n < attributeDefArray.length) {
                stringBuffer.append(this.DISPLAY_DELIMITER).append(row.getAttribute(attributeDefArray[n].getIndex()));
                ++n;
            }
            return stringBuffer;
        }
        return null;
    }

    public void setRowCount(int n) {
        this.mRows = n < 0 ? 0 : n;
    }

    public int getRowCount() {
        return this.mRows;
    }

    public void setColumnCount(int n) {
        this.mCols = n < 0 ? 0 : n;
    }

    public int getColumnCount() {
        return this.mCols;
    }

    public void setVerticalGap(int n) {
        this.mVGap = n < 0 ? 0 : n;
    }

    public int getVerticalGap() {
        return this.mVGap;
    }

    public void setHorizontalGap(int n) {
        this.mHGap = n < 0 ? 0 : n;
    }

    public int getHorizontalGap() {
        return this.mHGap;
    }

    public void setModel(JUButtonGroupBinding jUButtonGroupBinding) {
        this.mBinding = jUButtonGroupBinding;
    }

    public JUButtonGroupBinding getModel() {
        return this.mBinding;
    }

    public String getDisplayDelimiter() {
        return this.DISPLAY_DELIMITER;
    }

    public void setDisplayDelimiter(String string) {
        this.DISPLAY_DELIMITER = string;
    }
}

