/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.net.URL;

public class ImageArea
extends Canvas {
    private Image image = null;
    private Insets insetsBorder = new Insets(6, 6, 6, 6);

    public ImageArea(Image image) {
        this.image = image;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.image == null ? new Dimension(0, 0) : new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        dimension.width += this.insetsBorder.left + this.insetsBorder.right;
        dimension.height += this.insetsBorder.top + this.insetsBorder.bottom;
        return dimension;
    }

    public static Image loadImage(String string) {
        Image image = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/jmapps/images/")) {
            string = "/jmapps/images/" + string;
        }
        try {
            Class<?> clazz = Class.forName("jmapps.ui.ImageArea");
            URL uRL = clazz.getResource(string);
            if (uRL != null) {
                Object object = uRL.getContent();
                if (object instanceof ImageProducer) {
                    ImageProducer imageProducer = (ImageProducer)object;
                    image = toolkit.createImage(imageProducer);
                } else if (object instanceof BufferedInputStream) {
                    BufferedInputStream bufferedInputStream = (BufferedInputStream)object;
                    byte[] byArray = new byte[bufferedInputStream.available()];
                    bufferedInputStream.read(byArray);
                    image = toolkit.createImage(byArray);
                }
            }
        }
        catch (Exception exception) {}
        return image;
    }

    public static Image loadImage(String string, Component component, boolean bl) {
        Image image;
        block2: {
            image = ImageArea.loadImage(string);
            if (image == null || !bl) break block2;
            MediaTracker mediaTracker = new MediaTracker(component);
            mediaTracker.addImage(image, 1001);
            try {
                mediaTracker.waitForID(1001);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        dimension.width -= this.insetsBorder.left + this.insetsBorder.right;
        dimension.height -= this.insetsBorder.top + this.insetsBorder.bottom;
        graphics.drawImage(this.image, this.insetsBorder.left, this.insetsBorder.top, dimension.width, dimension.height, this);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setInsets(int n2, int n3, int n4, int n5) {
        this.insetsBorder.left = n2;
        this.insetsBorder.top = n3;
        this.insetsBorder.right = n4;
        this.insetsBorder.bottom = n5;
    }
}

