/*
 * Decompiled with CFR 0.152.
 */
package javax.media.pim;

import com.sun.media.util.Registry;
import com.sun.media.util.Resource;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.Manager;
import javax.media.pim.ClassNameInfo;
import javax.media.pim.ListInfo;
import javax.media.pim.PlugInInfo;
import javax.media.pim.PlugInVector;

public class PlugInManager
extends javax.media.PlugInManager {
    private static Hashtable lists = null;
    private static PlugInVector plugins = null;
    private static Registry r = null;
    private static Format[] emptyFormat = new Format[0];
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;

    static {
        PlugInManager.readFromRegistry();
    }

    public PlugInManager() {
        PlugInManager.readFromRegistry();
    }

    public static synchronized boolean addPlugIn(String string, Format[] formatArray, Format[] formatArray2, int n2) {
        ClassNameInfo classNameInfo;
        Object object;
        Vector<ClassNameInfo> vector;
        Integer n3 = new Integer(n2);
        ListInfo listInfo = (ListInfo)lists.get(n3);
        if (listInfo != null) {
            vector = listInfo.classNames;
            object = vector.elements();
            while (object.hasMoreElements()) {
                classNameInfo = (ClassNameInfo)object.nextElement();
                if (!classNameInfo.className.equals(string)) continue;
                return false;
            }
        } else {
            vector = new Vector<ClassNameInfo>(5);
        }
        try {
            object = PlugInManager.getClassForName(string);
        }
        catch (Throwable throwable) {
            return false;
        }
        classNameInfo = new ClassNameInfo(string);
        vector.addElement(classNameInfo);
        lists.put(n3, new ListInfo(n2, vector));
        if (formatArray == null) {
            formatArray = emptyFormat;
        }
        if (formatArray2 == null) {
            formatArray2 = emptyFormat;
        }
        PlugInManager.vectorInsertPlugIn(new PlugInInfo(n2, string, classNameInfo.hashValue, formatArray, formatArray2));
        Resource.purgeDB();
        return true;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = PlugInManager.class$("java.lang.Class"))).getMethod("forName", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PlugInManager.class$("java.lang.String")), Boolean.TYPE, class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = PlugInManager.class$("java.lang.ClassLoader")));
            getSystemClassLoaderM = (class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = PlugInManager.class$("java.lang.ClassLoader"))).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = PlugInManager.class$("java.lang.ClassLoader"))), null);
            getContextClassLoaderM = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = PlugInManager.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static synchronized void commit() throws IOException {
        Registry.removeGroup("PIM");
        Registry.set("PIM.lists", lists.clone());
        Enumeration enumeration = lists.elements();
        while (enumeration.hasMoreElements()) {
            ListInfo listInfo = (ListInfo)enumeration.nextElement();
            if (listInfo == null) {
                System.err.println("li is null????");
                continue;
            }
            int n2 = listInfo.type;
            Vector vector = listInfo.classNames;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                ClassNameInfo classNameInfo = (ClassNameInfo)enumeration2.nextElement();
                PlugInInfo plugInInfo = PlugInManager.vectorFindPlugIn(n2, classNameInfo.className, classNameInfo.hashValue);
                if (plugInInfo == null) {
                    System.err.println("pii is null for " + classNameInfo.className);
                    continue;
                }
                Registry.set("PIM." + n2 + "_" + classNameInfo.className + ".in", plugInInfo.inputFormats);
                Registry.set("PIM." + n2 + "_" + classNameInfo.className + ".out", plugInInfo.outputFormats);
            }
        }
        Registry.commit();
        Resource.destroy();
    }

    static Class getClassForName(String string) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(string);
            }
            catch (Exception exception) {
                if (!PlugInManager.checkIfJDK12()) {
                    throw new ClassNotFoundException(exception.getMessage());
                }
            }
            catch (Error error) {
                if (PlugInManager.checkIfJDK12()) break block9;
                throw error;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = PlugInManager.class$("java.lang.Class"))), string, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader classLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = PlugInManager.class$("java.lang.Class"))), string, new Boolean(true), classLoader);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException(exception.getMessage());
            }
            catch (Error error) {
                throw error;
            }
        }
    }

    public static synchronized Vector getPlugInList(Format format, Format format2, int n2) {
        ListInfo listInfo = (ListInfo)lists.get(new Integer(n2));
        if (listInfo == null) {
            return new Vector(1);
        }
        Vector vector = listInfo.classNames;
        Vector<String> vector2 = new Vector<String>(5);
        boolean bl = false;
        Boolean bl2 = (Boolean)Manager.getHint(3);
        if (bl2 != null && bl2.booleanValue()) {
            bl = true;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ClassNameInfo classNameInfo = (ClassNameInfo)enumeration.nextElement();
            PlugInInfo plugInInfo = PlugInManager.vectorFindPlugIn(n2, classNameInfo.className, classNameInfo.hashValue);
            if (plugInInfo == null || !PlugInManager.match(plugInInfo.inputFormats, format) || !PlugInManager.match(plugInInfo.outputFormats, format2) || bl && classNameInfo.className.indexOf("com.sun.media.renderer.video") == 0 && !classNameInfo.className.equals("com.sun.media.renderer.video.LightWeightRenderer")) continue;
            vector2.addElement(classNameInfo.className);
        }
        return vector2;
    }

    public static synchronized Format[] getSupportedInputFormats(String string, int n2) {
        ClassNameInfo classNameInfo = new ClassNameInfo(string);
        PlugInInfo plugInInfo = PlugInManager.vectorFindPlugIn(n2, string, classNameInfo.hashValue);
        if (plugInInfo == null) {
            return emptyFormat;
        }
        return plugInInfo.inputFormats;
    }

    public static synchronized Format[] getSupportedOutputFormats(String string, int n2) {
        ClassNameInfo classNameInfo = new ClassNameInfo(string);
        PlugInInfo plugInInfo = PlugInManager.vectorFindPlugIn(n2, string, classNameInfo.hashValue);
        if (plugInInfo == null) {
            return emptyFormat;
        }
        return plugInInfo.outputFormats;
    }

    private static synchronized boolean match(Format[] formatArray, Format format) {
        if (format == null || formatArray == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < formatArray.length) {
            if (formatArray[n2].matches(format)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void readFromRegistry() {
        if (lists != null) {
            return;
        }
        plugins = new PlugInVector(40);
        r = new Registry();
        Object object = Registry.get("PIM.lists");
        if (object == null || !(object instanceof Hashtable)) {
            lists = new Hashtable(8);
            System.out.println("No plugins found");
            return;
        }
        lists = (Hashtable)object;
        Enumeration enumeration = lists.elements();
        while (enumeration.hasMoreElements()) {
            ListInfo listInfo = (ListInfo)enumeration.nextElement();
            int n2 = listInfo.type;
            Vector vector = listInfo.classNames;
            Vector<ClassNameInfo> vector2 = new Vector<ClassNameInfo>(5);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                ClassNameInfo classNameInfo = (ClassNameInfo)enumeration2.nextElement();
                String string = String.valueOf(n2) + "_" + classNameInfo.className;
                Object object2 = Registry.get("PIM." + string + ".in");
                Object object3 = Registry.get("PIM." + string + ".out");
                if (object2 == null || !(object2 instanceof Format[]) || object3 == null || !(object3 instanceof Format[])) continue;
                PlugInInfo plugInInfo = new PlugInInfo(n2, classNameInfo.className, classNameInfo.hashValue, (Format[])object2, (Format[])object3);
                PlugInManager.vectorInsertPlugIn(plugInInfo);
                vector2.addElement(classNameInfo);
            }
            lists.put(new Integer(n2), new ListInfo(n2, vector2));
        }
    }

    public static synchronized boolean removePlugIn(String string, int n2) {
        Integer n3 = new Integer(n2);
        ListInfo listInfo = (ListInfo)lists.get(n3);
        ClassNameInfo classNameInfo = null;
        PlugInInfo plugInInfo = null;
        if (listInfo != null) {
            Vector vector = listInfo.classNames;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                classNameInfo = (ClassNameInfo)enumeration.nextElement();
                if (!classNameInfo.className.equals(string)) continue;
                vector.removeElement(classNameInfo);
                break;
            }
        }
        if (classNameInfo != null) {
            plugInInfo = PlugInManager.vectorRemovePlugIn(n2, string, classNameInfo.hashValue);
            Resource.purgeDB();
        }
        return plugInInfo != null;
    }

    public static synchronized void setPlugInList(Vector vector, int n2) {
        if (vector == null || n2 < 1) {
            return;
        }
        Vector<ClassNameInfo> vector2 = new Vector<ClassNameInfo>(5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ClassNameInfo classNameInfo = new ClassNameInfo(string);
            if (PlugInManager.vectorFindPlugIn(n2, classNameInfo.className, classNameInfo.hashValue) == null) continue;
            vector2.addElement(classNameInfo);
        }
        lists.put(new Integer(n2), new ListInfo(n2, vector2));
        Resource.purgeDB();
    }

    private static PlugInInfo vectorFindPlugIn(int n2, String string, long l2) {
        return plugins.lookup(n2, string, l2);
    }

    private static void vectorInsertPlugIn(PlugInInfo plugInInfo) {
        plugins.addElement(plugInInfo);
    }

    private static PlugInInfo vectorRemovePlugIn(int n2, String string, long l2) {
        PlugInInfo plugInInfo = PlugInManager.vectorFindPlugIn(n2, string, l2);
        if (plugInInfo != null) {
            plugins.removeElement(plugInInfo);
            return plugInInfo;
        }
        return null;
    }
}

