/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.OverallStats;
import com.sun.media.rtp.RTCPBYEPacket;
import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPRRPacket;
import com.sun.media.rtp.RTCPRawSender;
import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTCPSDESItem;
import com.sun.media.rtp.RTCPSDESPacket;
import com.sun.media.rtp.RTCPSRPacket;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.SendSSRCInfo;
import com.sun.media.rtp.util.UDPPacketSender;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class RTCPTransmitter {
    RTCPRawSender sender;
    OverallStats stats = null;
    SSRCCache cache;
    int sdescounter = 0;
    SSRCInfo ssrcInfo = null;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public RTCPTransmitter(SSRCCache sSRCCache) {
        this.cache = sSRCCache;
        this.stats = sSRCCache.sm.defaultstats;
    }

    public RTCPTransmitter(SSRCCache sSRCCache, int n2, String string) throws UnknownHostException, IOException {
        this(sSRCCache, new RTCPRawSender(n2, string));
    }

    public RTCPTransmitter(SSRCCache sSRCCache, int n2, String string, UDPPacketSender uDPPacketSender) throws UnknownHostException, IOException {
        this(sSRCCache, new RTCPRawSender(n2, string, uDPPacketSender));
    }

    public RTCPTransmitter(SSRCCache sSRCCache, RTCPRawSender rTCPRawSender) {
        this(sSRCCache);
        this.setSender(rTCPRawSender);
        this.stats = sSRCCache.sm.defaultstats;
    }

    public void bye(int n2, byte[] byArray) {
        double d2;
        if (!this.cache.rtcpsent) {
            return;
        }
        this.cache.byestate = true;
        Vector vector = this.makereports();
        Object[] objectArray = new RTCPPacket[vector.size() + 1];
        vector.copyInto(objectArray);
        int[] nArray = new int[]{n2};
        RTCPBYEPacket rTCPBYEPacket = new RTCPBYEPacket(nArray, byArray);
        objectArray[objectArray.length - 1] = rTCPBYEPacket;
        RTCPCompoundPacket rTCPCompoundPacket = new RTCPCompoundPacket((RTCPPacket[])objectArray);
        if (jmfSecurity != null) {
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                }
            }
            catch (Throwable throwable) {
                jmfSecurity.permissionFailureNotification(128);
            }
        }
        if (this.cache.aliveCount() > 50) {
            this.cache.reset(rTCPBYEPacket.length);
            d2 = this.cache.calcReportInterval(this.ssrcInfo.sender, false);
        } else {
            d2 = 0.0;
        }
        try {
            Thread.sleep((long)d2);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.transmit(rTCPCompoundPacket);
        this.sdescounter = 0;
    }

    public void bye(String string) {
        if (string != null) {
            this.bye(this.ssrcInfo.ssrc, string.getBytes());
        } else {
            this.bye(this.ssrcInfo.ssrc, null);
        }
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    public RTCPRawSender getSender() {
        return this.sender;
    }

    protected RTCPReportBlock[] makerecreports(long l2) {
        Object[] objectArray;
        Vector<RTCPReportBlock> vector = new Vector<RTCPReportBlock>();
        Enumeration enumeration = this.cache.cache.elements();
        while (enumeration.hasMoreElements()) {
            double d2;
            objectArray = (SSRCInfo)enumeration.nextElement();
            if (objectArray.ours || !objectArray.sender) continue;
            RTCPReportBlock rTCPReportBlock = new RTCPReportBlock();
            rTCPReportBlock.ssrc = objectArray.ssrc;
            rTCPReportBlock.lastseq = objectArray.maxseq + objectArray.cycles;
            rTCPReportBlock.jitter = (int)objectArray.jitter;
            rTCPReportBlock.lsr = (int)(objectArray.lastSRntptimestamp >> 32);
            rTCPReportBlock.dlsr = (int)((double)(l2 - objectArray.lastSRreceiptTime) * 65.536);
            rTCPReportBlock.packetslost = (int)(rTCPReportBlock.lastseq - (long)objectArray.baseseq + 1L - (long)objectArray.received);
            if (rTCPReportBlock.packetslost < 0) {
                rTCPReportBlock.packetslost = 0;
            }
            if ((d2 = (double)(rTCPReportBlock.packetslost - objectArray.prevlost) / (double)(rTCPReportBlock.lastseq - (long)objectArray.prevmaxseq)) < 0.0) {
                d2 = 0.0;
            }
            rTCPReportBlock.fractionlost = (int)(d2 * 256.0);
            objectArray.prevmaxseq = (int)rTCPReportBlock.lastseq;
            objectArray.prevlost = rTCPReportBlock.packetslost;
            vector.addElement(rTCPReportBlock);
        }
        objectArray = new RTCPReportBlock[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected Vector makereports() {
        RTCPPacket rTCPPacket;
        RTCPReportBlock[] rTCPReportBlockArray;
        Vector<RTCPPacket> vector = new Vector<RTCPPacket>();
        SSRCInfo sSRCInfo = this.ssrcInfo;
        boolean bl = false;
        if (sSRCInfo.sender) {
            bl = true;
        }
        long l2 = System.currentTimeMillis();
        RTCPReportBlock[] rTCPReportBlockArray2 = rTCPReportBlockArray = this.makerecreports(l2);
        if (rTCPReportBlockArray.length > 31) {
            rTCPReportBlockArray2 = new RTCPReportBlock[31];
            System.arraycopy(rTCPReportBlockArray, 0, rTCPReportBlockArray2, 0, 31);
        }
        if (bl) {
            rTCPPacket = new RTCPSRPacket(sSRCInfo.ssrc, rTCPReportBlockArray2);
            vector.addElement(rTCPPacket);
            long l3 = sSRCInfo.systime != 0L ? sSRCInfo.systime : System.currentTimeMillis();
            long l4 = l3 / 1000L;
            double d2 = (double)(l3 - l4 * 1000L) / 1000.0;
            rTCPPacket.ntptimestamplsw = (int)(d2 * 4.294967296E9);
            rTCPPacket.ntptimestampmsw = l4;
            rTCPPacket.rtptimestamp = (int)sSRCInfo.rtptime;
            rTCPPacket.packetcount = sSRCInfo.maxseq - sSRCInfo.baseseq;
            rTCPPacket.octetcount = sSRCInfo.bytesreceived;
        } else {
            rTCPPacket = new RTCPRRPacket(sSRCInfo.ssrc, rTCPReportBlockArray2);
            vector.addElement(rTCPPacket);
        }
        if (rTCPReportBlockArray2 != rTCPReportBlockArray) {
            int n2 = 31;
            while (n2 < rTCPReportBlockArray.length) {
                if (rTCPReportBlockArray.length - n2 < 31) {
                    rTCPReportBlockArray2 = new RTCPReportBlock[rTCPReportBlockArray.length - n2];
                }
                System.arraycopy(rTCPReportBlockArray, n2, rTCPReportBlockArray2, 0, rTCPReportBlockArray2.length);
                RTCPRRPacket rTCPRRPacket = new RTCPRRPacket(sSRCInfo.ssrc, rTCPReportBlockArray2);
                vector.addElement(rTCPRRPacket);
                n2 += 31;
            }
        }
        RTCPSDESPacket rTCPSDESPacket = new RTCPSDESPacket(new RTCPSDES[1]);
        rTCPSDESPacket.sdes[0] = new RTCPSDES();
        rTCPSDESPacket.sdes[0].ssrc = this.ssrcInfo.ssrc;
        Vector<RTCPSDESItem> vector2 = new Vector<RTCPSDESItem>();
        vector2.addElement(new RTCPSDESItem(1, sSRCInfo.sourceInfo.getCNAME()));
        if (this.sdescounter % 3 == 0) {
            if (sSRCInfo.name != null && sSRCInfo.name.getDescription() != null) {
                vector2.addElement(new RTCPSDESItem(2, sSRCInfo.name.getDescription()));
            }
            if (sSRCInfo.email != null && sSRCInfo.email.getDescription() != null) {
                vector2.addElement(new RTCPSDESItem(3, sSRCInfo.email.getDescription()));
            }
            if (sSRCInfo.phone != null && sSRCInfo.phone.getDescription() != null) {
                vector2.addElement(new RTCPSDESItem(4, sSRCInfo.phone.getDescription()));
            }
            if (sSRCInfo.loc != null && sSRCInfo.loc.getDescription() != null) {
                vector2.addElement(new RTCPSDESItem(5, sSRCInfo.loc.getDescription()));
            }
            if (sSRCInfo.tool != null && sSRCInfo.tool.getDescription() != null) {
                vector2.addElement(new RTCPSDESItem(6, sSRCInfo.tool.getDescription()));
            }
            if (sSRCInfo.note != null && sSRCInfo.note.getDescription() != null) {
                vector2.addElement(new RTCPSDESItem(7, sSRCInfo.note.getDescription()));
            }
        }
        ++this.sdescounter;
        rTCPSDESPacket.sdes[0].items = new RTCPSDESItem[vector2.size()];
        vector2.copyInto(rTCPSDESPacket.sdes[0].items);
        vector.addElement(rTCPSDESPacket);
        return vector;
    }

    public void report() {
        Vector vector = this.makereports();
        Object[] objectArray = new RTCPPacket[vector.size()];
        vector.copyInto(objectArray);
        RTCPCompoundPacket rTCPCompoundPacket = new RTCPCompoundPacket((RTCPPacket[])objectArray);
        this.transmit(rTCPCompoundPacket);
    }

    public void setSSRCInfo(SSRCInfo sSRCInfo) {
        this.ssrcInfo = sSRCInfo;
    }

    public void setSender(RTCPRawSender rTCPRawSender) {
        this.sender = rTCPRawSender;
    }

    protected void transmit(RTCPCompoundPacket rTCPCompoundPacket) {
        try {
            this.sender.sendTo(rTCPCompoundPacket);
            if (this.ssrcInfo instanceof SendSSRCInfo) {
                ++((SendSSRCInfo)this.ssrcInfo).stats.total_rtcp;
                ++this.cache.sm.transstats.rtcp_sent;
            }
            this.cache.updateavgrtcpsize(rTCPCompoundPacket.length);
            if (this.cache.initial) {
                this.cache.initial = false;
            }
            if (!this.cache.rtcpsent) {
                this.cache.rtcpsent = true;
            }
        }
        catch (IOException iOException) {
            this.stats.update(6, 1);
            ++this.cache.sm.transstats.transmit_failed;
        }
    }
}

