/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPSDES;
import java.io.DataOutputStream;
import java.io.IOException;

public class RTCPSDESPacket
extends RTCPPacket {
    public RTCPSDES[] sdes;

    public RTCPSDESPacket(RTCPPacket rTCPPacket) {
        super(rTCPPacket);
        this.type = 202;
    }

    public RTCPSDESPacket(RTCPSDES[] rTCPSDESArray) {
        this.sdes = rTCPSDESArray;
        if (rTCPSDESArray.length > 31) {
            throw new IllegalArgumentException("Too many SDESs");
        }
    }

    void assemble(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(128 + this.sdes.length);
        dataOutputStream.writeByte(202);
        dataOutputStream.writeShort(this.calcLength() - 4 >> 2);
        int n2 = 0;
        while (n2 < this.sdes.length) {
            dataOutputStream.writeInt(this.sdes[n2].ssrc);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.sdes[n2].items.length) {
                dataOutputStream.writeByte(this.sdes[n2].items[n4].type);
                dataOutputStream.writeByte(this.sdes[n2].items[n4].data.length);
                dataOutputStream.write(this.sdes[n2].items[n4].data);
                n3 += 2 + this.sdes[n2].items[n4].data.length;
                ++n4;
            }
            int n5 = (n3 + 4 & 0xFFFFFFFC) - n3;
            while (n5 > 0) {
                dataOutputStream.writeByte(0);
                --n5;
            }
            ++n2;
        }
    }

    public int calcLength() {
        int n2 = 4;
        int n3 = 0;
        while (n3 < this.sdes.length) {
            int n4 = 5;
            int n5 = 0;
            while (n5 < this.sdes[n3].items.length) {
                n4 += 2 + this.sdes[n3].items[n5].data.length;
                ++n5;
            }
            n4 = n4 + 3 & 0xFFFFFFFC;
            n2 += n4;
            ++n3;
        }
        return n2;
    }

    public String toString() {
        return "\tRTCP SDES Packet:\n" + RTCPSDES.toString(this.sdes);
    }
}

