/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTCPAPPPacket;
import com.sun.media.rtp.RTCPBYEPacket;
import com.sun.media.rtp.RTCPCompoundPacket;
import com.sun.media.rtp.RTCPPacket;
import com.sun.media.rtp.RTCPRRPacket;
import com.sun.media.rtp.RTCPRawReceiver;
import com.sun.media.rtp.RTCPReportBlock;
import com.sun.media.rtp.RTCPSDES;
import com.sun.media.rtp.RTCPSDESPacket;
import com.sun.media.rtp.RTCPSRPacket;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.StreamSynch;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketForwarder;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ApplicationEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.RTPEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.StreamMappedEvent;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.SenderReport;

public class RTCPReceiver
implements PacketConsumer {
    private static final int SR = 1;
    private static final int RR = 2;
    private boolean rtcpstarted = false;
    private boolean sentrecvstrmap = false;
    SSRCCache cache;
    private int type = 0;

    public RTCPReceiver(SSRCCache sSRCCache) {
        this.cache = sSRCCache;
        SSRCInfo sSRCInfo = sSRCCache.lookup(sSRCCache.ourssrc.ssrc);
    }

    public RTCPReceiver(SSRCCache sSRCCache, int n2, String string, StreamSynch streamSynch) throws UnknownHostException, IOException {
        this(sSRCCache, new RTCPRawReceiver(n2 | 1, string, sSRCCache.sm.defaultstats, streamSynch));
    }

    public RTCPReceiver(SSRCCache sSRCCache, PacketSource packetSource) {
        this(sSRCCache);
        PacketForwarder packetForwarder = new PacketForwarder(packetSource, this);
        packetForwarder.startPF();
    }

    public RTCPReceiver(SSRCCache sSRCCache, DatagramSocket datagramSocket, StreamSynch streamSynch) {
        this(sSRCCache, new RTCPRawReceiver(datagramSocket, sSRCCache.sm.defaultstats, streamSynch));
    }

    public void closeConsumer() {
    }

    public String consumerString() {
        return "RTCP Packet Receiver/Collector";
    }

    public void sendTo(RTCPPacket rTCPPacket) {
        int n2;
        Object object;
        int n3;
        Object object2;
        SSRCInfo sSRCInfo = null;
        boolean bl = this.cache.sm.isUnicast();
        if (bl) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(((UDPPacket)rTCPPacket.base).remoteAddress);
                this.rtcpstarted = true;
                object2 = this.cache.sm.controladdress.getAddress();
                n3 = object2[3] & 0xFF;
                if ((n3 & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    object = null;
                    n2 = 1;
                    try {
                        object = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException unknownHostException) {
                        n2 = 0;
                    }
                    if (n2 != 0) {
                        this.cache.sm.addUnicastAddr((InetAddress)object);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(((UDPPacket)rTCPPacket.base).remoteAddress)) {
                this.cache.sm.addUnicastAddr(((UDPPacket)rTCPPacket.base).remoteAddress);
            }
        }
        switch (rTCPPacket.type) {
            case -1: {
                object2 = (RTCPCompoundPacket)rTCPPacket;
                this.cache.updateavgrtcpsize(((Packet)object2).length);
                n3 = 0;
                while (n3 < ((RTCPCompoundPacket)object2).packets.length) {
                    this.sendTo(((RTCPCompoundPacket)object2).packets[n3]);
                    ++n3;
                }
                if (this.cache.sm.cleaner == null) break;
                this.cache.sm.cleaner.setClean();
                break;
            }
            case 200: {
                RTCPSRPacket rTCPSRPacket = (RTCPSRPacket)rTCPPacket;
                this.type = 1;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPSRPacket.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 1) : this.cache.get(rTCPSRPacket.ssrc, null, 0, 1);
                if (sSRCInfo == null) break;
                sSRCInfo.setAlive(true);
                sSRCInfo.lastSRntptimestamp = (rTCPSRPacket.ntptimestampmsw << 32) + rTCPSRPacket.ntptimestamplsw;
                sSRCInfo.lastSRrtptimestamp = rTCPSRPacket.rtptimestamp;
                sSRCInfo.lastSRreceiptTime = rTCPSRPacket.receiptTime;
                sSRCInfo.lastRTCPreceiptTime = rTCPSRPacket.receiptTime;
                sSRCInfo.lastHeardFrom = rTCPSRPacket.receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    object = null;
                    object = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent((RTPEvent)object);
                }
                sSRCInfo.lastSRpacketcount = rTCPSRPacket.packetcount;
                sSRCInfo.lastSRoctetcount = rTCPSRPacket.octetcount;
                int n4 = 0;
                while (n4 < rTCPSRPacket.reports.length) {
                    rTCPSRPacket.reports[n4].receiptTime = rTCPSRPacket.receiptTime;
                    n2 = rTCPSRPacket.reports[n4].ssrc;
                    RTCPReportBlock[] rTCPReportBlockArray = (RTCPReportBlock[])sSRCInfo.reports.get(n2);
                    if (rTCPReportBlockArray == null) {
                        rTCPReportBlockArray = new RTCPReportBlock[2];
                        rTCPReportBlockArray[0] = rTCPSRPacket.reports[n4];
                        sSRCInfo.reports.put(n2, rTCPReportBlockArray);
                    } else {
                        rTCPReportBlockArray[1] = rTCPReportBlockArray[0];
                        rTCPReportBlockArray[0] = rTCPSRPacket.reports[n4];
                    }
                    ++n4;
                }
                if (sSRCInfo.probation > 0) break;
                if (!sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    NewParticipantEvent newParticipantEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newParticipantEvent);
                    sSRCInfo.newpartsent = true;
                }
                if (!sSRCInfo.recvstrmap && sSRCInfo.sourceInfo != null) {
                    sSRCInfo.recvstrmap = true;
                    StreamMappedEvent streamMappedEvent = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(streamMappedEvent);
                }
                SenderReportEvent senderReportEvent = new SenderReportEvent(this.cache.sm, (SenderReport)((Object)sSRCInfo));
                this.cache.eventhandler.postEvent(senderReportEvent);
                break;
            }
            case 201: {
                object = (RTCPRRPacket)rTCPPacket;
                this.type = 2;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(((RTCPRRPacket)object).ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 2) : this.cache.get(((RTCPRRPacket)object).ssrc, null, 0, 2);
                if (sSRCInfo == null) break;
                sSRCInfo.setAlive(true);
                sSRCInfo.lastRTCPreceiptTime = ((Packet)object).receiptTime;
                sSRCInfo.lastHeardFrom = ((Packet)object).receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = null;
                    activeReceiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                int n5 = 0;
                while (n5 < ((RTCPRRPacket)object).reports.length) {
                    ((RTCPRRPacket)object).reports[n5].receiptTime = ((Packet)object).receiptTime;
                    int n6 = ((RTCPRRPacket)object).reports[n5].ssrc;
                    RTCPReportBlock[] rTCPReportBlockArray = (RTCPReportBlock[])sSRCInfo.reports.get(n6);
                    if (rTCPReportBlockArray == null) {
                        rTCPReportBlockArray = new RTCPReportBlock[2];
                        rTCPReportBlockArray[0] = ((RTCPRRPacket)object).reports[n5];
                        sSRCInfo.reports.put(n6, rTCPReportBlockArray);
                    } else {
                        rTCPReportBlockArray[1] = rTCPReportBlockArray[0];
                        rTCPReportBlockArray[0] = ((RTCPRRPacket)object).reports[n5];
                    }
                    ++n5;
                }
                if (!sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    NewParticipantEvent newParticipantEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newParticipantEvent);
                    sSRCInfo.newpartsent = true;
                }
                ReceiverReportEvent receiverReportEvent = new ReceiverReportEvent(this.cache.sm, (ReceiverReport)((Object)sSRCInfo));
                this.cache.eventhandler.postEvent(receiverReportEvent);
                break;
            }
            case 202: {
                RTCPSDESPacket rTCPSDESPacket = (RTCPSDESPacket)rTCPPacket;
                int n7 = 0;
                while (n7 < rTCPSDESPacket.sdes.length) {
                    RTCPSDES rTCPSDES = rTCPSDESPacket.sdes[n7];
                    if (this.type == 1) {
                        sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPSDES.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 1) : this.cache.get(rTCPSDES.ssrc, null, 0, 1);
                    }
                    if (this.type == 2) {
                        sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPSDES.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort, 2) : this.cache.get(rTCPSDES.ssrc, null, 0, 2);
                    }
                    if (sSRCInfo == null) break;
                    sSRCInfo.setAlive(true);
                    sSRCInfo.lastHeardFrom = rTCPSDESPacket.receiptTime;
                    sSRCInfo.addSDESInfo(rTCPSDES);
                    ++n7;
                }
                if (sSRCInfo != null && !sSRCInfo.newpartsent && sSRCInfo.sourceInfo != null) {
                    NewParticipantEvent newParticipantEvent = new NewParticipantEvent(this.cache.sm, sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(newParticipantEvent);
                    sSRCInfo.newpartsent = true;
                }
                if (sSRCInfo != null && !sSRCInfo.recvstrmap && sSRCInfo.sourceInfo != null && sSRCInfo instanceof RecvSSRCInfo) {
                    sSRCInfo.recvstrmap = true;
                    StreamMappedEvent streamMappedEvent = new StreamMappedEvent(this.cache.sm, (ReceiveStream)((Object)sSRCInfo), sSRCInfo.sourceInfo);
                    this.cache.eventhandler.postEvent(streamMappedEvent);
                }
                this.type = 0;
                break;
            }
            case 203: {
                RTCPBYEPacket rTCPBYEPacket = (RTCPBYEPacket)rTCPPacket;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPBYEPacket.ssrc[0], ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPBYEPacket.ssrc[0], null, 0);
                int n8 = 0;
                while (n8 < rTCPBYEPacket.ssrc.length) {
                    sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPBYEPacket.ssrc[n8], ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPBYEPacket.ssrc[n8], null, 0);
                    if (sSRCInfo == null) break;
                    if (!this.cache.byestate) {
                        sSRCInfo.setAlive(false);
                        sSRCInfo.byeReceived = true;
                        sSRCInfo.byeTime = rTCPPacket.receiptTime;
                        sSRCInfo.lastHeardFrom = rTCPBYEPacket.receiptTime;
                    }
                    ++n8;
                }
                if (sSRCInfo == null) break;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    ActiveReceiveStreamEvent activeReceiveStreamEvent = null;
                    activeReceiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(activeReceiveStreamEvent);
                }
                sSRCInfo.byereason = new String(rTCPBYEPacket.reason);
                if (sSRCInfo.byeReceived) break;
                boolean bl2 = false;
                RTPSourceInfo rTPSourceInfo = sSRCInfo.sourceInfo;
                if (rTPSourceInfo != null && rTPSourceInfo.getStreamCount() == 0) {
                    bl2 = true;
                }
                ByeEvent byeEvent = null;
                if (sSRCInfo instanceof RecvSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo), new String(rTCPBYEPacket.reason), bl2);
                }
                if (sSRCInfo instanceof PassiveSSRCInfo) {
                    byeEvent = new ByeEvent(this.cache.sm, sSRCInfo.sourceInfo, null, new String(rTCPBYEPacket.reason), bl2);
                }
                this.cache.eventhandler.postEvent(byeEvent);
                break;
            }
            case 204: {
                ReceiveStreamEvent receiveStreamEvent;
                RTCPAPPPacket rTCPAPPPacket = (RTCPAPPPacket)rTCPPacket;
                sSRCInfo = rTCPPacket.base instanceof UDPPacket ? this.cache.get(rTCPAPPPacket.ssrc, ((UDPPacket)rTCPPacket.base).remoteAddress, ((UDPPacket)rTCPPacket.base).remotePort) : this.cache.get(rTCPAPPPacket.ssrc, null, 0);
                if (sSRCInfo == null) break;
                sSRCInfo.lastHeardFrom = rTCPAPPPacket.receiptTime;
                if (sSRCInfo.quiet) {
                    sSRCInfo.quiet = false;
                    receiveStreamEvent = null;
                    receiveStreamEvent = sSRCInfo instanceof ReceiveStream ? new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo)) : new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, sSRCInfo.sourceInfo, null);
                    this.cache.eventhandler.postEvent(receiveStreamEvent);
                }
                receiveStreamEvent = null;
                if (sSRCInfo instanceof RecvSSRCInfo) {
                    receiveStreamEvent = new ApplicationEvent(this.cache.sm, sSRCInfo.sourceInfo, (ReceiveStream)((Object)sSRCInfo), rTCPAPPPacket.subtype, null, rTCPAPPPacket.data);
                }
                if (sSRCInfo instanceof PassiveSSRCInfo) {
                    receiveStreamEvent = new ApplicationEvent(this.cache.sm, sSRCInfo.sourceInfo, null, rTCPAPPPacket.subtype, null, rTCPAPPPacket.data);
                }
                this.cache.eventhandler.postEvent(receiveStreamEvent);
                break;
            }
        }
    }

    public void sendTo(Packet packet) {
        this.sendTo((RTCPPacket)packet);
    }
}

