/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.processor.rtsp;

import com.sun.media.BasicProcessor;
import com.sun.media.JMFSecurity;
import com.sun.media.Log;
import com.sun.media.content.rtsp.RtspUtil;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NotConfiguredError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.rtp.RTPControl;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;

public class Handler
extends BasicProcessor
implements ReceiveStreamListener {
    private final int INITIALIZED = 0;
    private final int REALIZED = 1;
    private final int PLAYING = 2;
    private final int PAUSING = 3;
    private DataSource[] data_sources;
    Processor processor = null;
    Format[] formats = null;
    Vector locators = null;
    Object dataLock = new Object();
    boolean dataReady = false;
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private boolean first_pass = true;
    RtspUtil rtspUtil;
    String sessionError = "cannot create and initialize the RTP Session.";

    public Handler() {
        this.framePositioning = false;
        this.rtspUtil = new RtspUtil(this);
        this.locators = new Vector();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    private void closeSessions() {
        RTPManager[] rTPManagerArray = this.rtspUtil.getRTPManagers();
        int n2 = 0;
        while (n2 < rTPManagerArray.length) {
            if (rTPManagerArray[n2] != null) {
                rTPManagerArray[n2].removeTargets("Closing session from the RTP Handler");
                rTPManagerArray[n2].dispose();
            }
            rTPManagerArray[n2] = null;
            ++n2;
        }
    }

    protected void completeConfigure() {
        this.state = 180;
        super.completeConfigure();
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doClose() {
        this.closed = true;
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notify();
        }
        this.stop();
        this.processor.close();
        this.closeSessions();
        super.doClose();
    }

    protected synchronized boolean doConfigure() {
        boolean bl = super.doConfigure();
        if (bl) {
            bl = this.initRtspSession();
        }
        return bl;
    }

    protected void doDeallocate() {
        this.processor.deallocate();
        Object object = this.dataLock;
        synchronized (object) {
            this.dataLock.notifyAll();
        }
    }

    protected void doFailedConfigure() {
        this.closeSessions();
        super.doFailedConfigure();
    }

    protected void doFailedRealize() {
        this.closeSessions();
        super.doFailedRealize();
    }

    protected boolean doRealize() {
        return this.waitForRealize(this.processor);
    }

    protected void doStart() {
        super.doStart();
        this.waitForStart(this.processor);
    }

    protected void doStop() {
        super.doStop();
        this.waitForStop(this.processor);
    }

    public ContentDescriptor getContentDescriptor() throws NotConfiguredError {
        super.getContentDescriptor();
        return this.processor.getContentDescriptor();
    }

    public Control[] getControls() {
        return this.processor.getControls();
    }

    public DataSource getDataOutput() throws NotRealizedError {
        super.getDataOutput();
        return this.processor.getDataOutput();
    }

    protected TimeBase getMasterTimeBase() {
        return new SystemTimeBase();
    }

    public ContentDescriptor[] getSupportedContentDescriptors() throws NotConfiguredError {
        super.getSupportedContentDescriptors();
        return this.processor.getSupportedContentDescriptors();
    }

    public TrackControl[] getTrackControls() throws NotConfiguredError {
        super.getTrackControls();
        return this.processor.getTrackControls();
    }

    public Component getVisualComponent() {
        super.getVisualComponent();
        return this.processor.getVisualComponent();
    }

    private boolean initRtspSession() {
        boolean bl = false;
        MediaLocator mediaLocator = (MediaLocator)this.locators.elementAt(0);
        this.rtspUtil.setUrl(mediaLocator.toString());
        String string = this.rtspUtil.getServerIpAddress();
        if (string == null) {
            System.out.println("Invalid server address.");
            bl = false;
        } else {
            this.rtspUtil.setUrl(mediaLocator.toString());
            bl = this.rtspUtil.createConnection();
            if (bl) {
                bl = this.rtspUtil.rtspSetup();
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    int[] nArray = this.rtspUtil.getServerPorts();
                    int n2 = 0;
                    while (n2 < this.rtspUtil.getNumberOfTracks()) {
                        SessionAddress sessionAddress = new SessionAddress(inetAddress, nArray[n2]);
                        this.rtspUtil.getRTPManager(n2).addTarget(sessionAddress);
                        BufferControl bufferControl = (BufferControl)this.rtspUtil.getRTPManager(n2).getControl("javax.media.control.BufferControl");
                        String string2 = this.rtspUtil.getMediaType(n2);
                        if (string2.equals("audio")) {
                            bufferControl.setBufferLength(250L);
                            bufferControl.setMinimumThreshold(125L);
                        } else if (string2.equals("video")) {
                            bufferControl.setBufferLength(1500L);
                            bufferControl.setMinimumThreshold(250L);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    Log.error(exception.getMessage());
                    return bl;
                }
            }
        }
        if (bl) {
            this.state = 1;
            int n3 = this.rtspUtil.getNumberOfTracks();
            this.data_sources = new DataSource[n3];
            this.formats = new Format[n3];
            if (!this.rtspUtil.rtspStart()) {
                if (this.first_pass && this.rtspUtil.getStatusCode() == 454) {
                    this.first_pass = false;
                    return this.initRtspSession();
                }
                return false;
            }
            this.waitForData();
        }
        return bl;
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    private void sendMyEvent(ControllerEvent controllerEvent) {
        super.sendEvent(controllerEvent);
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor contentDescriptor) throws NotConfiguredError {
        super.setContentDescriptor(contentDescriptor);
        return this.processor.setContentDescriptor(contentDescriptor);
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        super.setSource(dataSource);
        if (!(dataSource instanceof com.sun.media.protocol.rtsp.DataSource)) {
            throw new IncompatibleSourceException();
        }
        MediaLocator mediaLocator = dataSource.getLocator();
        this.locators.addElement(mediaLocator);
    }

    public void setTimeBase(TimeBase timeBase) throws IncompatibleTimeBaseException {
    }

    public void update(ReceiveStreamEvent receiveStreamEvent) {
        RTPManager rTPManager = (RTPManager)receiveStreamEvent.getSource();
        if (this.data_sources == null) {
            return;
        }
        RTPManager[] rTPManagerArray = this.rtspUtil.getRTPManagers();
        int n2 = 0;
        while (n2 < rTPManagerArray.length) {
            if (rTPManagerArray[n2] == rTPManager) break;
            ++n2;
        }
        if (n2 >= rTPManagerArray.length) {
            System.err.println("Unknown manager: " + rTPManager);
            return;
        }
        if (receiveStreamEvent instanceof RemotePayloadChangeEvent) {
            Log.comment("Received an RTP PayloadChangeEvent");
            Log.error("The RTP processor cannot handle mid-stream payload change.\n");
            this.sendEvent(new ControllerErrorEvent(this, "Cannot handle mid-stream payload change."));
            this.close();
        }
        if (receiveStreamEvent instanceof NewReceiveStreamEvent) {
            if (this.data_sources[n2] != null) {
                return;
            }
            ReceiveStream receiveStream = null;
            try {
                DataSource dataSource;
                receiveStream = ((NewReceiveStreamEvent)receiveStreamEvent).getReceiveStream();
                this.data_sources[n2] = receiveStream.getDataSource();
                RTPControl rTPControl = (RTPControl)this.data_sources[n2].getControl("javax.media.rtp.RTPControl");
                if (rTPControl != null) {
                    this.formats[n2] = rTPControl.getFormat();
                    if (this.formats[n2] instanceof AudioFormat) {
                        this.audioEnabled = true;
                    }
                    if (this.formats[n2] instanceof VideoFormat) {
                        this.videoEnabled = true;
                    }
                }
                int n3 = 0;
                while (n3 < this.data_sources.length) {
                    if (this.data_sources[n3] == null) {
                        return;
                    }
                    ++n3;
                }
                try {
                    dataSource = Manager.createMergingDataSource(this.data_sources);
                }
                catch (Exception exception) {
                    System.err.println("Cannot merge data sources.");
                    return;
                }
                try {
                    this.processor = Manager.createProcessor(dataSource);
                }
                catch (Exception exception) {
                    System.err.println("Cannot create the mix processor.");
                    return;
                }
                if (!this.waitForConfigure(this.processor)) {
                    return;
                }
                Object object = this.dataLock;
                synchronized (object) {
                    this.dataReady = true;
                    this.dataLock.notifyAll();
                }
            }
            catch (Exception exception) {
                System.err.println("NewReceiveStreamEvent exception " + exception.getMessage());
                return;
            }
        }
    }

    public void updateStats() {
        if (this.processor != null) {
            ((BasicProcessor)this.processor).updateStats();
        }
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void waitForClose(Player player) {
        new StateWaiter().waitForClose(player);
    }

    private boolean waitForConfigure(Processor processor) {
        return new StateWaiter().waitForConfigure(processor);
    }

    private synchronized boolean waitForData() {
        try {
            Object object = this.dataLock;
            synchronized (object) {
                while (!this.dataReady) {
                    this.dataLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return this.dataReady;
    }

    private boolean waitForRealize(Processor processor) {
        return new StateWaiter().waitForRealize(processor);
    }

    private void waitForStart(Player player) {
        new StateWaiter().waitForStart(player, true);
    }

    private void waitForStop(Player player) {
        new StateWaiter().waitForStart(player, false);
    }

    class StateWaiter
    implements ControllerListener {
        boolean closeDown = false;
        Object stateLock = new Object();

        StateWaiter() {
        }

        public void controllerUpdate(ControllerEvent controllerEvent) {
            if (controllerEvent instanceof ControllerClosedEvent || controllerEvent instanceof ControllerErrorEvent) {
                this.closeDown = true;
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.stateLock.notify();
            }
        }

        public void waitForClose(Player player) {
            player.addControllerListener(this);
            player.close();
            Object object = this.stateLock;
            synchronized (object) {
                while (!this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            player.removeControllerListener(this);
        }

        public boolean waitForConfigure(Processor processor) {
            processor.addControllerListener(this);
            processor.configure();
            Object object = this.stateLock;
            synchronized (object) {
                while (processor.getState() != 180 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            processor.removeControllerListener(this);
            return this.closeDown ^ true;
        }

        public boolean waitForRealize(Processor processor) {
            processor.addControllerListener(this);
            processor.realize();
            Object object = this.stateLock;
            synchronized (object) {
                while (processor.getState() != 300 && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            processor.removeControllerListener(this);
            return this.closeDown ^ true;
        }

        public void waitForStart(Player player, boolean bl) {
            player.addControllerListener(this);
            if (bl) {
                player.start();
            } else {
                player.stop();
            }
            Object object = this.stateLock;
            synchronized (object) {
                while ((bl && player.getState() != 600 || !bl && player.getState() == 600) && !this.closeDown) {
                    try {
                        this.stateLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
            player.removeControllerListener(this);
        }
    }
}

