/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class GSMMux
extends BasicMux {
    public GSMMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat("gsm");
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("audio.x_gsm");
    }

    public String getName() {
        return "GSM Multiplexer";
    }

    public Format setInputFormat(Format format, int n2) {
        if (!(format instanceof AudioFormat)) {
            return null;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        double d2 = audioFormat.getSampleRate();
        String string = null;
        double d3 = 0.25;
        if (!audioFormat.getEncoding().equalsIgnoreCase("gsm")) {
            string = "Encoding has to be GSM";
        } else if (Math.abs(d2 - 8000.0) > d3) {
            string = "Sample rate should be 8000. Cannot handle sample rate " + d2;
        } else if (audioFormat.getFrameSizeInBits() != 264) {
            string = "framesize should be 33 bytes";
        } else if (audioFormat.getChannels() != 1) {
            string = "Number of channels should be 1";
        }
        if (string != null) {
            return null;
        }
        this.inputs[0] = audioFormat;
        return audioFormat;
    }
}

