/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;

public class ProfileGroup {
    Hashtable m_profileKeys = new Hashtable();
    Vector m_profiles = new Vector();
    WeakHashMap m_connGroups = new WeakHashMap();
    private static final String DUMMY = "";

    public synchronized Object getProfileKey(Loader loader, String string) throws SQLException {
        Key key = (Key)this.m_profileKeys.get(string);
        if (key == null) {
            Profile profile = null;
            try {
                profile = Profile.instantiate(loader, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                RuntimeRefErrors.raise_PROFILE_NOT_FOUND(string, classNotFoundException);
            }
            catch (IOException iOException) {
                RuntimeRefErrors.raise_PROFILE_NOT_FOUND(string, iOException);
            }
            key = new Key(this.m_profiles.size());
            this.m_profileKeys.put(string, key);
            this.m_profiles.addElement(profile);
            Iterator iterator = this.m_connGroups.keySet().iterator();
            while (iterator.hasNext()) {
                ConnectedGroup connectedGroup = (ConnectedGroup)iterator.next();
                if (connectedGroup == null) continue;
                connectedGroup.addProfile();
            }
        }
        return key;
    }

    public Profile getProfile(Object object) {
        if (object == null || !(object instanceof Key)) {
            throw new IllegalArgumentException(object + DUMMY);
        }
        return (Profile)this.m_profiles.elementAt(((Key)object).index);
    }

    public synchronized ConnectedGroup addConnection(ConnectionContext connectionContext) {
        ConnectedGroup connectedGroup = new ConnectedGroup(connectionContext);
        this.m_connGroups.put(connectedGroup, DUMMY);
        return connectedGroup;
    }

    private synchronized void removeConnection(ConnectedGroup connectedGroup) {
        this.m_connGroups.remove(connectedGroup);
    }

    class ConnectedGroup {
        private ConnectionContext m_conn;
        private Vector m_connProfiles = new Vector();

        ConnectedGroup(ConnectionContext connectionContext) {
            this.m_conn = connectionContext;
            for (int i = ProfileGroup.this.m_profiles.size(); i > 0; --i) {
                this.addProfile();
            }
        }

        public void addProfile() {
            this.m_connProfiles.addElement(null);
        }

        public ConnectedProfile getProfile(Object object) throws SQLException {
            if (object == null || !(object instanceof Key)) {
                throw new IllegalArgumentException(object + ProfileGroup.DUMMY);
            }
            int n = ((Key)object).index;
            ConnectedProfile connectedProfile = (ConnectedProfile)this.m_connProfiles.elementAt(n);
            if (connectedProfile == null) {
                Profile profile = (Profile)ProfileGroup.this.m_profiles.elementAt(n);
                connectedProfile = profile.getConnectedProfile(this.m_conn);
                this.m_connProfiles.setElementAt(connectedProfile, n);
            }
            return connectedProfile;
        }

        public void close() throws SQLException {
            ProfileGroup.this.removeConnection(this);
            Enumeration enumeration = this.m_connProfiles.elements();
            while (enumeration.hasMoreElements()) {
                ConnectedProfile connectedProfile = (ConnectedProfile)enumeration.nextElement();
                if (connectedProfile == null) continue;
                connectedProfile.close();
            }
            this.m_conn = null;
        }
    }

    class Key {
        int index;

        Key(int n) {
            this.index = n;
        }
    }
}

