/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.util;

import java.io.IOException;
import java.io.PrintStream;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.server.util.OutputMonitor;
import oracle.jbo.server.util.TimedMonitor;

public class SafeExec {
    public static final String PROP_TIMEOUT = "jbo.safeexec.timeout";
    public static final String PROP_DIAGNOSTICS = "jbo.safeexec.diagnostics";
    public static final String HLINE = "------------------------------------------------------------";
    public static final int ERROR_TIMED_OUT = 9;
    public static final int ERROR_COULD_NOT_EXEC = 8;
    public static final int DEFAULT_TIMEOUT = 10800;
    private static long s_ProcessTimeout = 10800000L;
    private static boolean s_Diagnostics = false;

    static {
        try {
            if ("true".equals(System.getProperty(PROP_DIAGNOSTICS))) {
                s_Diagnostics = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s_ProcessTimeout = 1000 * Integer.parseInt(System.getProperty(PROP_TIMEOUT));
            Diagnostic.println("SafeExec timeout set to: " + s_ProcessTimeout + "ms, " + s_ProcessTimeout / 1000L + "secs, " + s_ProcessTimeout / 60000L + "mins");
        }
        catch (NumberFormatException numberFormatException) {
            SafeExec.traceln("Default timeout used: " + s_ProcessTimeout + "ms, " + s_ProcessTimeout / 1000L + "secs, " + s_ProcessTimeout / 60000L + "mins");
        }
    }

    public static long getTimeoutMillis() {
        return s_ProcessTimeout;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            SafeExec.Usage();
        } else {
            int n = SafeExec.runProc(stringArray, System.out);
            SafeExec.traceln("exit status was: '" + n + "'");
            System.exit(n);
        }
    }

    public static int runProc(String[] stringArray, PrintStream printStream, long l) {
        Process process = null;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append((n == 0 ? "" : " ") + stringArray[n]);
            ++n;
        }
        SafeExec.traceln("Running ... '" + stringBuffer + "'");
        try {
            process = Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            SafeExec.traceln(iOException.getMessage());
            int n2 = 8;
            return n2;
        }
        return SafeExec.monitorProc(process, printStream, l);
    }

    public static int runProc(String string, PrintStream printStream, long l) {
        Process process = null;
        SafeExec.traceln("Running ... '" + string + "'");
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            SafeExec.traceln(iOException.getMessage());
            int n = 8;
            return n;
        }
        return SafeExec.monitorProc(process, printStream, l);
    }

    public static int monitorProc(Process process, PrintStream printStream, long l) {
        int n = -1;
        try {
            OutputMonitor outputMonitor = new OutputMonitor(process.getInputStream(), printStream, s_Diagnostics ? "out: " : "");
            OutputMonitor outputMonitor2 = new OutputMonitor(process.getErrorStream(), printStream, s_Diagnostics ? "err: " : "");
            Thread thread = new Thread(outputMonitor);
            Thread thread2 = new Thread(outputMonitor2);
            thread.start();
            thread2.start();
            TimedMonitor timedMonitor = new TimedMonitor(process);
            Thread thread3 = new Thread(timedMonitor);
            thread3.start();
            int n2 = 0;
            while (!timedMonitor.isRunning()) {
                Thread.yield();
                if (n2 < 1000000 && ++n2 % 1000 != 0) continue;
            }
            if (l == 0L) {
                thread3.join();
            } else {
                thread3.join(l);
            }
            try {
                n = process.exitValue();
                SafeExec.traceln("Process completed normally");
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                printStream.println("");
                printStream.println(HLINE);
                printStream.println("ERROR: Process took too long (" + l + "ms)and was terminated.");
                printStream.println(HLINE);
                process.destroy();
                n = 9;
            }
            outputMonitor.m_oktorun = false;
            outputMonitor2.m_oktorun = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static int runProc(String[] stringArray, PrintStream printStream) {
        return SafeExec.runProc(stringArray, printStream, s_ProcessTimeout);
    }

    public static int runProc(String string, PrintStream printStream) {
        return SafeExec.runProc(string, printStream, s_ProcessTimeout);
    }

    public static void traceln(String string) {
        if (s_Diagnostics) {
            Diagnostic.println(string);
        }
    }

    public static void Usage() {
        System.out.println(HLINE);
        System.out.println("Usage:");
        System.out.println("        blah - params");
        System.out.println(HLINE);
    }
}

