/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.security.jazn;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.UserAznUtil;
import oracle.jbo.server.security.JboJAASContext;
import oracle.jbo.server.security.JboJAASPolicyManager;
import oracle.jbo.server.security.JboJAASUserManager;
import oracle.jbo.server.security.JboPolicyManager;
import oracle.jbo.server.security.jazn.JboJAZNPolicyManager;
import oracle.jbo.server.security.jazn.JboJAZNUserManager;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.policy.PermissionClassManager;
import oracle.security.jazn.realm.RealmManager;

public class JboJAZNContext
implements JboJAASContext {
    private static JboJAASContext mJAASInterface = null;
    private static JboJAZNContext _singleton;
    private static final Object __LOCK__;
    private static JAZNConfig _config;
    private static RealmManager _realmMgr;
    private static PermissionClassManager _permClsMgr;
    private static JboJAZNPolicyManager _policyMgr;
    private static JboPolicyManager _jboPolicyMgr;
    private static JboJAZNUserManager _userMgr;
    private static String _configStr;
    private static JAZNConfig _embeddedConfig;
    private static String _embeddedConfigPath;
    static final String EMBEDDED_CONFIG_FILENAME = "/system-application.xml";
    static final String OC4JCONFIG_CLASS = "oracle.jdeveloper.xml.oc4j.Oc4jConfigAdmin";

    public static JboJAASContext getInterface() {
        if (mJAASInterface == null) {
            mJAASInterface = JboJAZNContext.getInstance();
        }
        return mJAASInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JboJAZNContext getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (_singleton == null) {
                JboJAZNContext jboJAZNContext;
                _singleton = jboJAZNContext = new JboJAZNContext();
                JboJAZNContext jboJAZNContext2 = jboJAZNContext;
                return jboJAZNContext2;
            }
        }
        return _singleton;
    }

    public void initialize(Hashtable hashtable) {
        this.refresh(hashtable);
    }

    public JboPolicyManager getPolicyManager() {
        if (_jboPolicyMgr == null) {
            _jboPolicyMgr = new JboPolicyManager(this.getJAASPolicyManager());
        }
        return _jboPolicyMgr;
    }

    public JboJAASPolicyManager getJAASPolicyManager() {
        if (_policyMgr == null) {
            _policyMgr = new JboJAZNPolicyManager(this);
        }
        return _policyMgr;
    }

    public JboJAASUserManager getJAASUserManager() {
        if (_userMgr == null) {
            _userMgr = new JboJAZNUserManager(this);
        }
        return _userMgr;
    }

    static void setLoginConfig(String string) {
        _configStr = string;
    }

    public void refresh(Hashtable hashtable) {
        if (hashtable != null) {
            String string = (String)hashtable.get("jbo.security.config");
            _configStr = string != null && string.length() > 0 ? string : UserAznUtil.findApplicationConfig(hashtable);
            if (Diagnostic.isOn()) {
                if (_configStr != null && _configStr.length() > 0) {
                    Diagnostic.println("JAZN Config property: " + _configStr);
                } else {
                    Diagnostic.println("JAZN Config property not specified");
                }
            }
        }
        UserAznUtil.setLoginConfigSystemProperty("oracle.security.jazn.realm.RealmLoginModule", _configStr);
        if (_configStr != null && (_config = new JAZNConfig(_configStr)).getLocationPath() == null) {
            _configStr = null;
        }
        if (_configStr == null) {
            _config = JAZNConfig.getOC4JInstanceConfig();
        }
        try {
            _realmMgr = _config.getRealmManager();
            if (_realmMgr == null && Diagnostic.isOn()) {
                Diagnostic.println("RealmManager not found!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        _embeddedConfigPath = this.getEmbeddedConfigPath();
        if (_embeddedConfigPath != null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Embedded OC4J config dir: " + _embeddedConfigPath);
            }
            this.getEmbeddedConfig();
        }
    }

    public JAZNConfig getJAZNConfig() {
        return _config;
    }

    public JAZNConfig getEmbeddedJAZNConfig() {
        return this.getEmbeddedConfig();
    }

    public String getDefaultRealm() {
        return _config.getDefaultRealm();
    }

    public static PermissionClassManager getPermissionClassManager() {
        if (_permClsMgr == null) {
            _permClsMgr = _config.getPermissionClassManager();
        }
        return _permClsMgr;
    }

    public static RealmManager getRealmManager() {
        return _config.getRealmManager();
    }

    private String getEmbeddedConfigPath() {
        try {
            Method method;
            Class<?> clazz = Class.forName(OC4JCONFIG_CLASS);
            if (clazz != null && (method = clazz.getMethod("getEmbeddedOc4jConfigDir", new Class[0])) != null) {
                _embeddedConfigPath = ((File)method.invoke(null, new Object[0])).getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return _embeddedConfigPath;
    }

    private JAZNConfig getEmbeddedConfig() {
        if (_embeddedConfig != null) {
            return _embeddedConfig;
        }
        if (_embeddedConfigPath != null) {
            StringBuffer stringBuffer = new StringBuffer(_embeddedConfigPath);
            stringBuffer.append(EMBEDDED_CONFIG_FILENAME);
            String string = stringBuffer.toString();
            if (Diagnostic.isOn()) {
                Diagnostic.println("Setting Embedded JAZN Config property ..." + string);
            }
            try {
                _embeddedConfig = new JAZNConfig(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_embeddedConfig != null && Diagnostic.isOn()) {
            Diagnostic.println("Embedded JAZN Config property set.");
        }
        return _embeddedConfig;
    }

    static {
        __LOCK__ = new Object();
        _policyMgr = null;
        _jboPolicyMgr = null;
        _userMgr = null;
        _configStr = null;
        _embeddedConfig = null;
        _embeddedConfigPath = null;
    }
}

