/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.remote;

import com.sun.java.util.collections.HashMap;
import java.io.Serializable;
import oracle.jbo.DeadViewRowAccessException;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.RowSetManagementListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.ViewObject;
import oracle.jbo.common.AccTravDef;
import oracle.jbo.common.DataCollector;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.Marshallable;
import oracle.jbo.common.MasterRowHandles;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.SvcMsgDataRow;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.SvcMsgResponseEvent;
import oracle.jbo.common.SvcMsgResponseException;
import oracle.jbo.common.SvcMsgResponseNavig;
import oracle.jbo.common.SvcMsgResponseRowEvent;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.RowFilter;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;
import oracle.jbo.server.ViewRowSetIteratorImpl;
import oracle.jbo.server.remote.ObjectMarshallerImpl;
import oracle.jbo.server.remote.PiggybackManager;
import oracle.svcmsg.Request;
import oracle.svcmsg.RequestParams;
import oracle.svcmsg.Response;
import oracle.svcmsg.ResponseRef;
import oracle.svcmsg.ResponseValues;

public class RuntimeViewRowSetIteratorInfo
implements DataCollector,
Marshallable,
RowSetManagementListener,
RowSetListener {
    private PiggybackManager mMgr;
    private ObjectMarshallerImpl mMarshaller;
    private ViewRowSetIteratorImpl rv;
    private DBTransaction mTrans;
    private int mRSIId;
    private boolean mRefreshCache;
    private int mSuppressPiggyback;
    private int mRefreshCounter;
    private int mPBSeqId;
    private boolean mIsForOneRow;
    private boolean mIsBatchModeOper;
    private ViewRowSetImpl mSurrogateVRS;
    private Object mRowFilterValues;
    private int mChangeOper;
    private Row mChangedRow;
    private Object mChangedRowOldHandle;
    private static /* synthetic */ Class class$oracle$jbo$server$remote$RuntimeViewRowSetIteratorInfo;

    private /* synthetic */ void $init$() {
        this.mMgr = null;
        this.mMarshaller = null;
        this.mRSIId = -1;
        this.mRefreshCache = true;
        this.mSuppressPiggyback = 0;
        this.mRefreshCounter = 0;
        this.mPBSeqId = 0;
        this.mIsForOneRow = false;
        this.mIsBatchModeOper = false;
        this.mSurrogateVRS = null;
        this.mRowFilterValues = null;
        this.mChangeOper = -1;
        this.mChangedRow = null;
        this.mChangedRowOldHandle = null;
    }

    RuntimeViewRowSetIteratorInfo() {
        this.$init$();
    }

    public RuntimeViewRowSetIteratorInfo(PiggybackManager piggybackManager, RowSetIterator rowSetIterator) {
        this.$init$();
        this.initRowSetIterator(piggybackManager, rowSetIterator);
    }

    RuntimeViewRowSetIteratorInfo(PiggybackManager piggybackManager, RowSetIterator rowSetIterator, int[] nArray) {
        this.$init$();
        this.initRowSetIterator(piggybackManager, rowSetIterator);
    }

    private void initRowSetIterator(PiggybackManager piggybackManager, RowSetIterator rowSetIterator) {
        this.mMgr = piggybackManager;
        this.mMarshaller = piggybackManager.getMarshaller();
        this.rv = ViewObjectImpl.getImplObject(rowSetIterator);
        this.mTrans = ((ViewObjectImpl)this.rv.getViewObject()).getDBTransaction();
        this.rv.addListener(this);
        this.rv.addManagementListener(this);
    }

    public boolean isRefreshCache() {
        return this.mRefreshCache;
    }

    public void setRefreshCache(boolean bl) {
        if (bl) {
            this.mRefreshCache = bl;
        }
    }

    public void setSuppressPiggyback(boolean bl) {
        if (bl) {
            ++this.mSuppressPiggyback;
        } else if (this.mSuppressPiggyback > 0) {
            --this.mSuppressPiggyback;
        }
    }

    public boolean isSuppressPiggyback() {
        return this.mSuppressPiggyback > 0;
    }

    public void setIteratorId(int n) {
        this.mRSIId = n;
    }

    public void addEntry(Serializable serializable) {
        this.mMgr.addEntry(serializable);
    }

    private void cleanAfterBatchModeOper() {
        if (this.mSurrogateVRS != null) {
            this.mSurrogateVRS.removeListener(this);
            this.mSurrogateVRS.closeRowSet();
        }
        this.mIsBatchModeOper = false;
        this.mSurrogateVRS = null;
        this.mRowFilterValues = null;
        this.mChangedRow = null;
        this.mChangedRowOldHandle = null;
        this.mChangeOper = -1;
    }

    static int checkViewDefForRow(ObjectMarshaller objectMarshaller, ViewRowImpl viewRowImpl) {
        int n = -1;
        if (viewRowImpl != null && viewRowImpl.hasExtendedViewDef()) {
            ViewDefImpl viewDefImpl = viewRowImpl.getViewDef();
            ObjectMarshallerImpl objectMarshallerImpl = (ObjectMarshallerImpl)objectMarshaller;
            ResponseValues responseValues = objectMarshallerImpl.marshalViewDef(viewDefImpl);
            n = ((ResponseRef)responseValues).getRefId();
            objectMarshallerImpl.getSvcMsgManager().addEntry(responseValues);
        }
        return n;
    }

    static SvcMsgDataRow sMakeSvcMsgRowForAcc(ObjectMarshaller objectMarshaller, int n, int n2, int n3, ViewRowImpl viewRowImpl, Object object, byte by, int[] nArray, AccTravDef accTravDef, int n4) {
        int n5 = RuntimeViewRowSetIteratorInfo.checkViewDefForRow(objectMarshaller, viewRowImpl);
        SvcMsgDataRow svcMsgDataRow = new SvcMsgDataRow(objectMarshaller, n, n2, n3, viewRowImpl, object, by, nArray, accTravDef, n4);
        if (n5 >= 0) {
            svcMsgDataRow.setViewDefId(n5);
        }
        return svcMsgDataRow;
    }

    static SvcMsgDataRow sMakeSvcMsgRow(ObjectMarshaller objectMarshaller, int n, int n2, int n3, ViewRowImpl viewRowImpl, Object object, byte by, int[] nArray) {
        int n4 = RuntimeViewRowSetIteratorInfo.checkViewDefForRow(objectMarshaller, viewRowImpl);
        SvcMsgDataRow svcMsgDataRow = new SvcMsgDataRow(objectMarshaller, n, n2, n3, viewRowImpl, object, by, nArray);
        if (n4 >= 0) {
            svcMsgDataRow.setViewDefId(n4);
        }
        return svcMsgDataRow;
    }

    SvcMsgDataRow makeSvcMsgRow(int n, int n2, ViewRowImpl viewRowImpl, int[] nArray) {
        return RuntimeViewRowSetIteratorInfo.sMakeSvcMsgRow(this.mMarshaller, n, this.mRSIId, n2, viewRowImpl, viewRowImpl.getHandle(), viewRowImpl.getNewRowState(), nArray);
    }

    public boolean processChanges(RequestParams requestParams) {
        boolean bl = true;
        Object[] objectArray = requestParams.getObjectParams();
        if (objectArray == null) {
            return bl;
        }
        int n = 0;
        while (n < objectArray.length) {
            SvcMsgDataRow svcMsgDataRow = (SvcMsgDataRow)objectArray[n];
            int n2 = svcMsgDataRow.getOperation();
            Row row = null;
            try {
                switch (n2) {
                    case 1: 
                    case 7: {
                        if (!this.insertRow(svcMsgDataRow, n2 == 1)) {
                            bl = false;
                        }
                        break;
                    }
                    default: {
                        Object var13_12;
                        try {
                            boolean bl2 = n2 == 0;
                            this.mChangeOper = n2;
                            row = this.getRowForSvcMsg(svcMsgDataRow, bl2);
                            if (row != null) {
                                if (this.mIsBatchModeOper) {
                                    ViewRowSetIteratorImpl viewRowSetIteratorImpl = this.mSurrogateVRS != null ? this.mSurrogateVRS.getDefaultRowSetIterator() : this.rv;
                                    viewRowSetIteratorImpl.prepareRangeForBatchMode(true, svcMsgDataRow.getRowIndex(), svcMsgDataRow.getRangeStart(), this.rv.getRangeSize(), true);
                                }
                                if (n2 == 10) {
                                    row.remove();
                                } else if (n2 == 11) {
                                    row.removeFromCollection();
                                } else if (n2 == 12) {
                                    row.removeAndRetain();
                                } else if (n2 == 0) {
                                    try {
                                        if (!this.updateRow(row, svcMsgDataRow)) {
                                            bl = false;
                                        }
                                    }
                                    catch (DeadViewRowAccessException deadViewRowAccessException) {
                                        Diagnostic.println("Ignoring DeadRowException. Row was deleted during this remote call.");
                                    }
                                }
                            }
                            var13_12 = null;
                            this.cleanAfterBatchModeOper();
                            break;
                        }
                        catch (Throwable throwable) {
                            var13_12 = null;
                            this.cleanAfterBatchModeOper();
                            throw throwable;
                        }
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
                if (svcMsgDataRow.getOperation() == 10 && !(exception instanceof RowNotFoundException)) {
                    if (row == null) {
                        throw new RowNotFoundException((RowSetIterator)this.rv.getRowSet(), svcMsgDataRow.getRowIndex());
                    }
                    this.addEntry(this.makeSvcMsgRow(20, svcMsgDataRow.getRowIndex(), (ViewRowImpl)row, null));
                }
                this.addException(exception);
            }
            ++n;
        }
        return bl;
    }

    Row getRowForSvcMsg(SvcMsgDataRow svcMsgDataRow, boolean bl) {
        Row row;
        Object[] objectArray = svcMsgDataRow.getHandle();
        Key key = svcMsgDataRow.getServerRowKey();
        if (key != null) {
            Object[] objectArray2 = (Object[])svcMsgDataRow.getRowFilterValues();
            if (objectArray2 != null) {
                ViewRowSetImpl viewRowSetImpl = this.rv.getRowSetImpl();
                viewRowSetImpl.setCollectionForRowFilter(objectArray2, viewRowSetImpl.getViewLinkMode());
                ViewRowSetImpl viewRowSetImpl2 = viewRowSetImpl;
                objectArray = new Object[]{objectArray2, objectArray};
                this.mRowFilterValues = objectArray2;
            }
            row = this.getRowFromKey((Object[])svcMsgDataRow.getRowFilterValues(), key, svcMsgDataRow.getHandle());
            this.mIsBatchModeOper = true;
            this.mChangedRow = row;
            this.mChangedRowOldHandle = objectArray;
        } else if (svcMsgDataRow.getServerObject() != null) {
            row = svcMsgDataRow.getServerObject();
        } else {
            int n = svcMsgDataRow.getRowIndex();
            if (n >= 0) {
                row = this.rv.getRowAtRangeIndexInternal(n);
                if (bl && row == null) {
                    throw new RowNotFoundException((RowSetIterator)this.rv.getRowSet(), svcMsgDataRow.getRowIndex());
                }
            } else {
                row = this.getRowFromHandle(svcMsgDataRow.getHandle());
            }
        }
        return row;
    }

    public Row getRowFromKey(Object[] objectArray, Key key, Object object) {
        Row row = ((ViewObjectImpl)this.rv.getViewObject()).findRowInQCs(objectArray, key, object);
        if (row == null) {
            throw new RowNotFoundException(false, this.rv.getViewObject().getName(), key);
        }
        return row;
    }

    public Row getRowAtRangeIndex(int n) {
        Row row = this.rv.getRowAtRangeIndexInternal(n);
        if (row == null) {
            throw new RowNotFoundException((RowSetIterator)this.rv.getRowSet(), n);
        }
        return row;
    }

    public Row getRowFromHandle(Object object) {
        Row row = this.rv.getRowFromHandle(object);
        if (row == null) {
            throw new RowNotFoundException(this.rv.getRowSet(), object);
        }
        return row;
    }

    private Row getRowFromReq(Request request, HashMap hashMap) {
        Object object = null;
        if (hashMap != null) {
            object = hashMap.get((Object)request);
        }
        if (object == null) {
            RequestParams requestParams = (RequestParams)request;
            return this.getRowFromHandle(new Integer(requestParams.getIntParams()[0]));
        }
        if (object instanceof JboException) {
            throw (JboException)object;
        }
        return (Row)object;
    }

    public boolean syncIterator(RequestParams requestParams, HashMap hashMap) {
        ViewRowSetImpl viewRowSetImpl;
        ViewRowSetIteratorImpl viewRowSetIteratorImpl = this.rv;
        ViewRowSetImpl viewRowSetImpl2 = viewRowSetImpl = viewRowSetIteratorImpl.getRowSetImpl();
        int n = requestParams.getOperation();
        RequestParams requestParams2 = requestParams;
        boolean[] blArray = requestParams2.getBooleanParams();
        Object[] objectArray = requestParams2.getObjectParams();
        Object object = requestParams.getSourceId();
        int n2 = object instanceof Integer ? (Integer)object : -1;
        int n3 = -1;
        boolean bl = false;
        SvcMsgIteratorState svcMsgIteratorState = null;
        if (blArray != null && blArray.length > 0) {
            bl = requestParams2.getBooleanParams()[0];
        }
        try {
            if (objectArray != null && objectArray.length >= 2) {
                Object[] objectArray2 = (Object[])objectArray[0];
                svcMsgIteratorState = (SvcMsgIteratorState)objectArray[1];
                if (objectArray2 != null) {
                    viewRowSetImpl.setCollectionForRowFilter(objectArray2, viewRowSetImpl.getViewLinkMode());
                    this.mRowFilterValues = objectArray2;
                }
                this.mIsBatchModeOper = true;
            }
            int n4 = -1;
            this.setRefreshCache(bl);
            if (this.mIsBatchModeOper && (n == 17 || n == 18)) {
                viewRowSetIteratorImpl.prepareForBatchMode(svcMsgIteratorState, false);
            }
            switch (n) {
                case 9: {
                    if (viewRowSetIteratorImpl.first() != null) {
                        n3 = viewRowSetIteratorImpl.getCurrentRowIndex();
                    }
                    n4 = 4105;
                    break;
                }
                case 10: {
                    if (viewRowSetIteratorImpl.previous() != null) {
                        n3 = viewRowSetIteratorImpl.getCurrentRowIndex();
                    }
                    n4 = 4106;
                    break;
                }
                case 11: {
                    if (viewRowSetIteratorImpl.next() != null) {
                        n3 = viewRowSetIteratorImpl.getCurrentRowIndex();
                    }
                    n4 = 4107;
                    break;
                }
                case 12: {
                    if (viewRowSetIteratorImpl.last() != null) {
                        n3 = viewRowSetIteratorImpl.getCurrentRowIndex();
                    }
                    n4 = 4108;
                    break;
                }
                case 13: {
                    int n5 = requestParams2.getIntParams()[0];
                    if (viewRowSetIteratorImpl.setCurrentRowAtRangeIndex(n5)) {
                        n3 = this.processCurrentRow(true, false);
                    }
                    n4 = 4109;
                    break;
                }
                case 14: {
                    Row row = this.getRowFromReq(requestParams, hashMap);
                    if (viewRowSetIteratorImpl.setCurrentRow(row)) {
                        n3 = this.processCurrentRow(false, false);
                    }
                    n4 = 4110;
                    break;
                }
                case 15: {
                    this.processCurrentRow(false, true);
                    n4 = 4111;
                    break;
                }
                case 16: {
                    Row row = this.getRowFromReq(requestParams, hashMap);
                    this.addEntry(this.makeSvcMsgRow(2, 0, (ViewRowImpl)row, null));
                    n4 = 4112;
                    break;
                }
                case 19: {
                    viewRowSetIteratorImpl.reset();
                    n4 = 4115;
                    break;
                }
                case 20: {
                    this.refreshCache();
                    if (!this.mMarshaller.isInWorkingSet()) {
                        this.processCurrentRow(false, true);
                    }
                    n4 = 4116;
                    break;
                }
                case 21: {
                    int n6 = requestParams2.getIntParams()[0];
                    try {
                        ++this.mSuppressPiggyback;
                        viewRowSetIteratorImpl.setRangeStart(n6);
                        Object var27_21 = null;
                        --this.mSuppressPiggyback;
                    }
                    catch (Throwable throwable) {
                        Object var27_22 = null;
                        --this.mSuppressPiggyback;
                        throw throwable;
                    }
                    n4 = 4119;
                    break;
                }
                case 17: {
                    Row[] rowArray;
                    int n7;
                    int n8 = 0;
                    if (this.mIsBatchModeOper) {
                        n8 = svcMsgIteratorState.getRowsRemoved();
                    }
                    if ((n7 = requestParams2.getIntParams()[0]) >= 0 && n7 != 2 && viewRowSetIteratorImpl.getCurrentRowSlot() == 2) {
                        viewRowSetIteratorImpl.setCurrentRowAtRangeIndex(0);
                    }
                    if (n8 == viewRowSetIteratorImpl.getRangeSize()) {
                        this.refreshCache();
                        rowArray = viewRowSetIteratorImpl.getAllRowsInRange();
                        viewRowSetIteratorImpl.setCurrentRowAtRangeIndex(0);
                    } else {
                        rowArray = viewRowSetIteratorImpl.getNextRangeSetWithAdjustment(-n8);
                    }
                    n3 = rowArray.length;
                    n4 = 4113;
                    if (!this.mIsBatchModeOper) break;
                    this.mMarshaller.getAMWrapper().finishSyncWorkingSet(null, false);
                    break;
                }
                case 18: {
                    int n9 = requestParams2.getIntParams()[0];
                    if (n9 != 3 && viewRowSetIteratorImpl.getCurrentRowSlot() == 3) {
                        viewRowSetIteratorImpl.setCurrentRowAtRangeIndex(0);
                    }
                    Row[] rowArray = viewRowSetIteratorImpl.getPreviousRangeSet();
                    n3 = rowArray.length;
                    n4 = 4114;
                    if (!this.mIsBatchModeOper) break;
                    this.mMarshaller.getAMWrapper().finishSyncWorkingSet(null, false);
                    break;
                }
                default: {
                    Diagnostic.ASSERT(false, "Unrecognized sync iterator request: " + Integer.toHexString(n));
                    boolean bl2 = false;
                    Object var30_30 = null;
                    this.cleanAfterBatchModeOper();
                    return bl2;
                }
            }
            ResponseValues responseValues = new SvcMsgResponseValues(n4, this.mMgr.getRequestName()).setIntValues(new int[]{n3});
            this.addEntry(responseValues);
        }
        catch (Throwable throwable) {
            Object var30_32 = null;
            this.cleanAfterBatchModeOper();
            throw throwable;
        }
        Object var30_31 = null;
        this.cleanAfterBatchModeOper();
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertRow(SvcMsgDataRow var1_1, boolean var2_2) {
        block34: {
            block35: {
                var3_3 = true;
                var5_4 = this.rv;
                var7_5 = var1_1.getRowRSIId();
                if (var7_5 >= 0) {
                    v0 = new Integer(var7_5);
                    v1 = RuntimeViewRowSetIteratorInfo.class$oracle$jbo$server$remote$RuntimeViewRowSetIteratorInfo;
                    if (v1 == null) {
                        v1 = RuntimeViewRowSetIteratorInfo.class$oracle$jbo$server$remote$RuntimeViewRowSetIteratorInfo = RuntimeViewRowSetIteratorInfo.class$("oracle.jbo.server.remote.RuntimeViewRowSetIteratorInfo");
                    }
                    var6_6 = (RuntimeViewRowSetIteratorInfo)this.mMarshaller.getObject(v0, v1);
                } else {
                    var6_6 = this;
                }
                var9_8 = var8_7 = var5_4.getRowSetImpl();
                var12_10 = var11_9 = var1_1.getHandle();
                var13_11 = var11_9 != null ? (Integer)var11_9 : 0;
                var14_12 = var1_1.getRowFilterValues();
                var15_13 = var1_1.isRowCurrent();
                try {
                    block37: {
                        block38: {
                            this.mChangeOper = 1;
                            if (var13_11 > 0 && !this.mMarshaller.isInWorkingSet()) break block37;
                            if (var14_12 == null || !(var14_12 instanceof MasterRowHandles)) break block38;
                            var16_14 = ((MasterRowHandles)var14_12).getMasterRowHandleValues();
                            var17_15 = var9_8.getMasterRowSetIterators();
                            var18_16 = 0;
                            if (true) ** GOTO lbl143
                        }
                        if (var14_12 != null) {
                            var8_7.setCollectionForRowFilter((Object[])var14_12, var8_7.getViewLinkMode());
                            var9_8.setOwnedByQC(true);
                            var11_9 = new Object[]{var14_12, var11_9};
                            this.mRowFilterValues = var14_12;
                        }
                        break block34;
                    }
                    var10_21 = var6_6.getRowFromHandle(var11_9);
lbl34:
                    // 2 sources

                    while (true) {
                        this.mChangedRow = var10_21;
                        this.mChangedRowOldHandle = var11_9;
                        var21_22 = null;
                        var22_23 = false;
                        var23_24 = var9_8.getViewLinkMode();
                        try {
                            var9_8.setViewLinkMode((byte)0);
                            if (this.mIsBatchModeOper) {
                                var24_25 = var9_8.getQueryCollection();
                                var25_26 = var24_25 == null ? null : var24_25.getRowFilter();
                                var21_22 = var24_25.getFilterParamValues((ViewRowImpl)var10_21, var1_1.getAttributes(), var1_1.getAttributeIndices());
                                if (var25_26 != null && !var25_26.whereClauseParamQualifies(var21_22)) {
                                    var9_8.setCollectionForRowFilter(var21_22, var23_24);
                                    if (var24_25 != var9_8.getQueryCollection()) {
                                        var22_23 = true;
                                    }
                                }
                            }
                            var3_3 = this.updateRow(var10_21, var1_1);
                            var26_27 = var1_1.getNewRowState();
                            if (var26_27 != 127 && ((ViewRowImpl)var10_21).getNewRowState() != var26_27) {
                                var10_21.setNewRowState(var26_27);
                            }
                            var33_28 = null;
                            if (var22_23) {
                                var9_8.setCollectionForRowFilter((Object[])var14_12, (byte)0);
                            }
                            var9_8.setViewLinkMode(var23_24);
                        }
                        catch (Throwable var32_30) {
                            var33_29 = null;
                            if (var22_23) {
                                var9_8.setCollectionForRowFilter((Object[])var14_12, (byte)0);
                            }
                            var9_8.setViewLinkMode(var23_24);
                            throw var32_30;
                        }
                        if (!var3_3 && !this.mIsBatchModeOper) break block35;
                        if (!var2_2) {
                            this.processNewRow(7, -1, (ViewRowImpl)var10_21, var5_4);
                            var34_31 = var3_3;
                            var37_32 = null;
                            this.cleanAfterBatchModeOper();
                            var9_8.setOwnedByQC(false);
                            return var34_31;
                        }
                        var27_36 = var1_1.getRowIndex();
                        if (var27_36 >= 0) {
                            if (this.mIsBatchModeOper) {
                                if (var22_23) {
                                    this.processDeleteRow(10, var27_36, (ViewRowImpl)var10_21, null, var5_4);
                                    var35_37 = var3_3;
                                    break;
                                }
                                var28_38 = var5_4.getRangeSize();
                                var29_39 = var5_4.getRangeStart();
                                if (var29_39 < 0) {
                                    var29_39 = 0;
                                }
                                if (var28_38 > 0 && (var27_36 < var29_39 || var27_36 >= var29_39 + var28_38)) {
                                    var5_4.setRangeStart(var27_36);
                                    var27_36 = 0;
                                } else {
                                    var27_36 -= var29_39;
                                }
                            }
                            var5_4.insertRowAtRangeIndex(var27_36, var10_21);
                            if (var15_13) {
                                var5_4.setCurrentRowAtRangeIndex(var27_36);
                                break block35;
                            }
                            if (this.mIsBatchModeOper) {
                                var5_4.refreshDetailRowSet(var10_21);
                            }
                            break block35;
                        }
                        if (var14_12 != null) {
                            var5_4.doInsertRow(var10_21, var15_13);
                            break block35;
                        }
                        if (this.mIsBatchModeOper) {
                            var5_4.doInsertRow(var10_21, var15_13);
                            break block35;
                        } else {
                            var5_4.insertRow(var10_21);
                        }
                        break block35;
                        break;
                    }
                }
                catch (Throwable var36_40) {
                    var37_35 = null;
                    this.cleanAfterBatchModeOper();
                    var9_8.setOwnedByQC(false);
                    throw var36_40;
                }
                var37_33 = null;
                this.cleanAfterBatchModeOper();
                var9_8.setOwnedByQC(false);
                return var35_37;
            }
            var37_34 = null;
            this.cleanAfterBatchModeOper();
            var9_8.setOwnedByQC(false);
            return var3_3;
            do {
                if ((var20_18 = (var19_17 = ViewObjectImpl.getImplObject(var17_15[var18_16])).getRowFromHandle(new Integer(var16_14[var18_16]))) != null && !var20_18.equals(var19_17.getCurrentRow())) {
                    try {
                        ++this.mSuppressPiggyback;
                        var19_17.setCurrentRow(var20_18);
                        var31_19 = null;
                        --this.mSuppressPiggyback;
                    }
                    catch (Throwable var30_20) {
                        var31_19 = null;
                        --this.mSuppressPiggyback;
                        throw var30_20;
                    }
                }
                ++var18_16;
lbl143:
                // 2 sources

            } while (var18_16 < var16_14.length);
            var11_9 = new Object[]{var14_12, var11_9};
        }
        if (var13_11 <= 0) {
            var10_21 = var5_4.createRow();
        } else {
            var10_21 = this.rv.getRowFromHandle(var12_10);
            if (var10_21 == null) {
                var10_21 = var5_4.createRow();
            }
        }
        this.mIsBatchModeOper = true;
        ** while (true)
    }

    private void revertUpdate(int n, int[] nArray, Row row) {
        this.addEntry(this.makeSvcMsgRow(21, n, (ViewRowImpl)row, nArray));
    }

    private boolean updateRow(Row row, SvcMsgDataRow svcMsgDataRow) {
        byte by;
        boolean bl = true;
        int[] nArray = svcMsgDataRow.getAttributeIndices();
        if (nArray != null) {
            Object[] objectArray = svcMsgDataRow.getAttributes();
            boolean bl2 = false;
            int n = 0;
            while (n < nArray.length) {
                try {
                    LobInterface lobInterface;
                    Object object = objectArray[n];
                    if (object instanceof Response) {
                        object = SvcMsgDataRow.unMarshalValue(object, this.mMarshaller);
                    }
                    if (object instanceof LobInterface && (lobInterface = (LobInterface)row.getAttribute(nArray[n])) != null) {
                        ((LobInterface)object).syncServerLob(lobInterface);
                    }
                    row.setAttribute(nArray[n], object);
                }
                catch (Exception exception) {
                    bl = false;
                    if (!bl2) {
                        this.revertUpdate(svcMsgDataRow.getRowIndex(), nArray, row);
                        bl2 = true;
                    }
                    this.addException(exception);
                }
                ++n;
            }
            if (!bl2 && nArray.length > 0 && this.mTrans.isBundledExceptionMode() && ((ViewRowImpl)row).hasDeferredExceptions()) {
                this.revertUpdate(svcMsgDataRow.getRowIndex(), nArray, row);
                bl2 = true;
            }
        }
        if ((by = svcMsgDataRow.getNewRowState()) != 127 && ((ViewRowImpl)row).getNewRowState() != by) {
            row.setNewRowState(by);
        }
        return bl;
    }

    public RowSetIterator getRowSetIterator() {
        return this.rv;
    }

    public void addException(Exception exception) {
        exception.printStackTrace();
        if (exception instanceof JboException) {
            ViewObject viewObject = this.rv.getViewObject();
            ((JboException)exception).doEntityToVOMapping(viewObject.getApplicationModule(), new ViewObject[]{viewObject});
        }
        SvcMsgResponseException svcMsgResponseException = new SvcMsgResponseException(this.mMgr.getRequestName(), exception, this.mRSIId);
        this.addEntry(svcMsgResponseException);
    }

    public void refreshCache() {
        int n = this.mRefreshCounter;
        int n2 = this.rv.getRangeStart();
        int n3 = this.rv.getRowCountInRange();
        Row[] rowArray = this.rv.getAllRowsInRange();
        if (this.mRefreshCounter == n) {
            this.processRangeRefresh(this.rv, n2, n3, rowArray, null, false, false, this.rv.isRangeAtBottom(), this.rv.isRangeAtTop());
        }
    }

    void processMaxFetchSizeReached() {
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (this.rv.getRowSet().isMaxFetchSizeExceeded()) {
            this.addEntry(new SvcMsgResponseEvent(4176, this.mMgr.getRequestName(), this.mRSIId, ++this.mPBSeqId));
        }
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (this.mSurrogateVRS != null) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(rangeRefreshEvent.toString());
        }
        boolean bl = rangeRefreshEvent.isReset();
        boolean bl2 = rangeRefreshEvent.isPosReset();
        this.processRangeRefresh(rangeRefreshEvent.getSource(), rangeRefreshEvent.getRangeStart(), rangeRefreshEvent.getRowCountInRange(), rangeRefreshEvent.getAllRowsInRange(), rangeRefreshEvent.getMasterRows(), bl, bl2, this.rv.isRangeAtBottom(), this.rv.isRangeAtTop());
    }

    int processCurrentRow(boolean bl, boolean bl2) {
        int n;
        int n2 = -1;
        Row row = this.rv.getCurrentRow();
        int n3 = n = bl ? 3 : 4;
        if (row != null) {
            int n4;
            n2 = n4 = this.rv.getCurrentRowIndex();
            if (bl) {
                n4 -= this.rv.getRangeStart();
            }
            if (bl2) {
                this.addEntry(this.makeSvcMsgRow(n, n4, (ViewRowImpl)row, null));
            }
        }
        return n2;
    }

    void processRangeRefresh(Object object, int n, int n2, Row[] rowArray, Row[] rowArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        SvcMsgResponseRowEvent svcMsgResponseRowEvent = this.doRefreshCache(object, n, n2, rowArray, rowArray2, bl, bl2, bl3, bl4, null, -1);
        this.addEntry(svcMsgResponseRowEvent);
        this.mRefreshCache = false;
        ++this.mRefreshCounter;
    }

    static Object[] getRowFilterValues(ViewRowSetImpl viewRowSetImpl) {
        RowFilter rowFilter;
        QueryCollection queryCollection = viewRowSetImpl.getQueryCollection();
        if (queryCollection != null && (rowFilter = queryCollection.getRowFilter()) != null) {
            return rowFilter.getWhereClauseParams();
        }
        return null;
    }

    private Object[] getRowFilterValues() {
        return RuntimeViewRowSetIteratorInfo.getRowFilterValues(this.rv.getRowSetImpl());
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(scrollEvent.toString());
        }
        ViewRowSetIteratorImpl viewRowSetIteratorImpl = ViewObjectImpl.getImplObject(scrollEvent.getSource());
        int n = this.mRSIId;
        int n2 = scrollEvent.getRowCountInRange();
        int n3 = scrollEvent.getRangeStart();
        int n4 = scrollEvent.getRangeStartBefore();
        int n5 = scrollEvent.getNewRowCountInRange();
        int n6 = scrollEvent.getFirstNewRowRangeIndex();
        SvcMsgResponseRowEvent svcMsgResponseRowEvent = new SvcMsgResponseRowEvent(4098, this.mMgr.getRequestName(), n, n2, n4, n3, ++this.mPBSeqId, false, false, viewRowSetIteratorImpl.isRangeAtBottom(), viewRowSetIteratorImpl.isRangeAtTop());
        if (viewRowSetIteratorImpl.getRowSetImpl().isRangePaging()) {
            viewRowSetIteratorImpl.getAllRowsInRange();
        }
        int n7 = 0;
        while (n7 < n5) {
            ViewRowImpl viewRowImpl = (ViewRowImpl)viewRowSetIteratorImpl.getRowAtRangeIndexInternal(n6);
            if (viewRowImpl != null) {
                svcMsgResponseRowEvent.addRow(RuntimeViewRowSetIteratorInfo.sMakeSvcMsgRow(this.mMarshaller, 6, n, n6, viewRowImpl, viewRowImpl.getHandle(), viewRowImpl.getNewRowState(), null));
            }
            ++n7;
            ++n6;
        }
        svcMsgResponseRowEvent.setRowFilterValues(this.getRowFilterValues());
        this.addEntry(svcMsgResponseRowEvent);
    }

    public void rowUpdated(UpdateEvent updateEvent) {
        Object[] objectArray;
        byte by;
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(updateEvent.toString());
        }
        ViewRowImpl viewRowImpl = (ViewRowImpl)updateEvent.getRow();
        Object[] objectArray2 = viewRowImpl.getHandle();
        byte by2 = by = viewRowImpl != null ? (byte)viewRowImpl.getNewRowState() : (byte)127;
        if (viewRowImpl != null && this.mMarshaller.isInWorkingSet() && (objectArray = viewRowImpl.getQueryCollection(null).getRowFilter().getWhereClauseParams()) != null && objectArray.length > 0) {
            objectArray2 = new Object[]{objectArray, objectArray2};
        }
        this.addEntry(RuntimeViewRowSetIteratorInfo.sMakeSvcMsgRow(this.mMarshaller, 0, this.mRSIId, updateEvent.getRowIndex(), viewRowImpl, objectArray2, by, updateEvent.getChangedAttrIndices()));
    }

    public void navigated(NavigationEvent navigationEvent) {
        Object[] objectArray;
        int n;
        int n2;
        RowSetIterator rowSetIterator;
        int n3;
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(navigationEvent.toString());
        }
        if (this.mRefreshCache && this.rv.isRefreshed()) {
            this.refreshCache();
        }
        if ((n3 = (rowSetIterator = (RowSetIterator)navigationEvent.getSource()).getCurrentRowSlot()) == 2 || n3 == 3) {
            n2 = -1;
            n = -1;
        } else {
            int n4 = rowSetIterator.getRangeSize();
            int n5 = rowSetIterator.getRangeStart();
            n2 = rowSetIterator.getCurrentRowIndex();
            n = n4 < 0 ? n2 : (n5 >= 0 && n2 >= n5 && n2 < n5 + n4 ? n2 - n5 : -1);
        }
        if (n < 0 && n2 >= 0) {
            this.processCurrentRow(false, true);
        }
        if ((objectArray = this.mRowFilterValues) == null) {
            objectArray = this.getRowFilterValues();
        }
        this.addEntry(new SvcMsgResponseNavig(this.mMgr.getRequestName(), this.mRSIId, n2, n, n3, objectArray));
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("Delete " + deleteEvent.toString());
        }
        int n = deleteEvent.getRowCountInRange();
        ViewRowSetIteratorImpl viewRowSetIteratorImpl = ViewObjectImpl.getImplObject(deleteEvent.getSource());
        ViewRowImpl viewRowImpl = (ViewRowImpl)deleteEvent.getRow();
        ViewRowImpl viewRowImpl2 = null;
        ViewRowSetImpl viewRowSetImpl = this.mSurrogateVRS != null ? this.mSurrogateVRS : viewRowSetIteratorImpl.getRowSetImpl();
        viewRowImpl2 = (ViewRowImpl)viewRowSetImpl.getRow(viewRowSetIteratorImpl.getRangeStart() + n);
        int n2 = 10;
        if (this.mChangeOper == 10 && deleteEvent.getRow() == this.mChangedRow) {
            n2 = this.mMarshaller.hasSyncROTOccurred() && this.mMarshaller.isMarshalledInThisMsg(this.mRSIId) ? 14 : 13;
        }
        this.processDeleteRow(n2, deleteEvent.getRowIndex(), viewRowImpl, viewRowImpl2, viewRowSetIteratorImpl);
    }

    private void processDeleteRow(int n, int n2, ViewRowImpl viewRowImpl, ViewRowImpl viewRowImpl2, ViewRowSetIteratorImpl viewRowSetIteratorImpl) {
        Object[] objectArray;
        Object[] objectArray2 = null;
        byte by = 127;
        boolean bl = this.mMarshaller.isInWorkingSet();
        if (viewRowImpl2 != null) {
            Object[] objectArray3;
            objectArray2 = viewRowImpl2.getHandle();
            by = viewRowImpl2.getNewRowState();
            if (bl && (objectArray3 = viewRowImpl2.getQueryCollection(null).getRowFilter().getWhereClauseParams()) != null && objectArray3.length > 0) {
                objectArray2 = new Object[]{objectArray3, objectArray2};
            }
        } else if (bl && (objectArray = viewRowImpl.getQueryCollection(null).getRowFilter().getWhereClauseParams()) != null && objectArray.length > 0) {
            objectArray2 = new Object[]{objectArray, null};
        }
        SvcMsgDataRow svcMsgDataRow = RuntimeViewRowSetIteratorInfo.sMakeSvcMsgRow(this.mMarshaller, n, this.mRSIId, n2, viewRowImpl2, objectArray2, by, null);
        boolean bl2 = viewRowSetIteratorImpl.getRowSetImpl().isExecuted();
        svcMsgDataRow.setRowSetExecuted(bl2);
        if (bl2) {
            svcMsgDataRow.setRangeAtBottom(viewRowSetIteratorImpl.isRangeAtBottom());
            svcMsgDataRow.setRangeAtTop(viewRowSetIteratorImpl.isRangeAtTop());
        }
        svcMsgDataRow.setOldHandle(this.mChangedRowOldHandle);
        this.addEntry(svcMsgDataRow);
    }

    public void rowInserted(InsertEvent insertEvent) {
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("Insert " + insertEvent.toString());
        }
        ViewRowImpl viewRowImpl = (ViewRowImpl)insertEvent.getRow();
        this.processNewRow(1, insertEvent.getRowIndex(), viewRowImpl, ViewObjectImpl.getImplObject(insertEvent.getSource()));
    }

    private void processNewRow(int n, int n2, ViewRowImpl viewRowImpl, ViewRowSetIteratorImpl viewRowSetIteratorImpl) {
        Object[] objectArray = viewRowImpl.getHandle();
        if (this.mMarshaller.isInWorkingSet()) {
            if (this.mSurrogateVRS != null && viewRowImpl == this.mChangedRow && this.mChangeOper == 1 && this.rv == viewRowSetIteratorImpl) {
                return;
            }
            Object[] objectArray2 = null;
            RowFilter rowFilter = viewRowImpl.getQueryCollection(null).getRowFilter();
            if (rowFilter != null && (objectArray2 = rowFilter.getWhereClauseParams()) != null && objectArray2.length > 0) {
                objectArray = new Object[]{objectArray2, objectArray};
            }
        }
        SvcMsgDataRow svcMsgDataRow = RuntimeViewRowSetIteratorInfo.sMakeSvcMsgRow(this.mMarshaller, n, this.mRSIId, n2, viewRowImpl, objectArray, viewRowImpl.getNewRowState(), null);
        if (viewRowImpl == this.mChangedRow) {
            svcMsgDataRow.setOldHandle(this.mChangedRowOldHandle);
        }
        this.addEntry(svcMsgDataRow);
    }

    public void iteratorReset(RowSetManagementEvent rowSetManagementEvent) {
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(rowSetManagementEvent.toString());
        }
        int n = this.mRSIId;
        SvcMsgResponseEvent svcMsgResponseEvent = new SvcMsgResponseEvent(4100, this.mMgr.getRequestName(), n, ++this.mPBSeqId);
        svcMsgResponseEvent.setObjectValues(this.getRowFilterValues());
        this.addEntry(svcMsgResponseEvent);
    }

    public void iteratorClosed(RowSetManagementEvent rowSetManagementEvent) {
        if (this.mSuppressPiggyback > 0) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println(rowSetManagementEvent.toString());
        }
        int n = this.mRSIId;
        SvcMsgResponseEvent svcMsgResponseEvent = new SvcMsgResponseEvent(4101, this.mMgr.getRequestName(), n, ++this.mPBSeqId);
        svcMsgResponseEvent.setObjectValues(this.getRowFilterValues());
        this.addEntry(svcMsgResponseEvent);
        this.mMarshaller.removeObject(this);
    }

    void close() {
        this.rv.removeListener(this);
        this.rv.removeManagementListener(this);
    }

    public void unMarshalled() {
        if (this.rv.getRowSetImpl() != null) {
            this.rv.activateIteratorState(null, true);
        }
    }

    public void marshalled() {
    }

    public Object collectDataRows(AccTravDef accTravDef, int n, boolean bl) {
        try {
            SvcMsgResponseRowEvent svcMsgResponseRowEvent;
            ++this.mSuppressPiggyback;
            int n2 = this.rv.getRangeStart();
            int n3 = this.rv.getRowCountInRange();
            Row[] rowArray = this.rv.getAllRowsInRange();
            SvcMsgResponseRowEvent svcMsgResponseRowEvent2 = svcMsgResponseRowEvent = this.doRefreshCache(this.rv, n2, n3, rowArray, null, bl, bl, this.rv.isRangeAtBottom(), this.rv.isRangeAtTop(), accTravDef, n);
            Object var10_9 = null;
            --this.mSuppressPiggyback;
            return svcMsgResponseRowEvent2;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            --this.mSuppressPiggyback;
            throw throwable;
        }
    }

    private SvcMsgResponseRowEvent doRefreshCache(Object object, int n, int n2, Row[] rowArray, Row[] rowArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4, AccTravDef accTravDef, int n3) {
        SvcMsgResponseRowEvent svcMsgResponseRowEvent = new SvcMsgResponseRowEvent(4097, this.mMgr.getRequestName(), this.mRSIId, n2, this.rv.getRowSetImpl().isExecuted() ? 0 : -1, n, ++this.mPBSeqId, bl, bl2, bl3, bl4);
        if (n2 != 0) {
            int n4 = 0;
            while (n4 < rowArray.length) {
                ViewRowImpl viewRowImpl = (ViewRowImpl)rowArray[n4];
                if (viewRowImpl != null) {
                    svcMsgResponseRowEvent.addRow(RuntimeViewRowSetIteratorInfo.sMakeSvcMsgRowForAcc(this.mMarshaller, 5, this.mRSIId, n4, viewRowImpl, viewRowImpl.getHandle(), viewRowImpl.getNewRowState(), null, accTravDef, n3));
                    if (this.mIsForOneRow) break;
                }
                ++n4;
            }
        }
        svcMsgResponseRowEvent.setRowFilterValues(this.getRowFilterValues());
        svcMsgResponseRowEvent.setRangeSize(this.rv.getRangeSize());
        if (rowArray2 != null) {
            int[] nArray = new int[rowArray2.length];
            int n5 = 0;
            while (n5 < rowArray2.length) {
                ViewRowImpl viewRowImpl = (ViewRowImpl)rowArray2[n5];
                if (viewRowImpl != null) {
                    nArray[n5] = (Integer)viewRowImpl.getHandle();
                }
                ++n5;
            }
            svcMsgResponseRowEvent.setMasterRowHandles(nArray);
        }
        return svcMsgResponseRowEvent;
    }

    void refreshIfExecuted() {
        if (this.rv.getRowSetImpl().isExecuted()) {
            this.refreshCache();
        }
    }

    public boolean isForOneRow() {
        return this.mIsForOneRow;
    }

    public void setForOneRow(boolean bl) {
        this.mIsForOneRow = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

