/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.jbo.AlreadyLockedException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeLoadException;
import oracle.jbo.DMLConstraintException;
import oracle.jbo.DMLException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboException;
import oracle.jbo.RowAlreadyDeletedException;
import oracle.jbo.RowInconsistentException;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.SQLStmtException;
import oracle.jbo.TooManyObjectsException;
import oracle.jbo.Transaction;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.EventGroup;
import oracle.jbo.common.InstrumentedEvent;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboTypeMap;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.domain.DatumFactory;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.NullValue;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.mom.LongRunningStatementHandle;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.BaseSQLBuilderImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.JDBCInteract;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.SparseArray;
import oracle.jbo.server.TransactionEvent;
import oracle.jbo.server.util.JboDTUtils;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleStatement;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class OracleSQLBuilderImpl
extends BaseSQLBuilderImpl {
    protected static final String ORACLE_ROWID_COLUMN = "ROWID";
    private static SQLBuilder mSQLBuilderInterface = null;
    private static String SQL_COL_SEPARATOR = ", ";
    private static final byte DEFINE_COLUMN_LENGTH_AS_BYTES = 0;
    private static final byte DEFINE_COLUMN_LENGTH_AS_CHARS = 1;
    private static final byte DEFINE_COLUMN_LENGTH_NEVER = 2;
    private static final byte DEFINE_COLUMN_LENGTH_JDBC_DEFAULT = 3;
    private static final byte DEFINE_COLUMN_SKIP_DEFINES = 4;
    private static byte mUseCharLength = (byte)4;
    private static final String DEFAULT_LOCK_TRAILER = "FOR UPDATE NOWAIT";
    private static boolean mCoverForJdbcBytesConversion = true;
    private static byte mPingDatabaseMethodExists = (byte)-1;
    static final int[] streamTypeIds = new int[]{-1, -2, -3, -4, 2005, 2004, -13};
    static Class dateClass;
    static Class sqlTimestampClass;
    static Class timestampClass;
    static String TO_DATE_FRAG;
    static String TO_TIMESTAMP_FRAG;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$sql$STRUCT;
    private static /* synthetic */ Class class$oracle$jbo$pcoll$OraclePersistManager;

    protected OracleSQLBuilderImpl() {
        String string = PropertyMetadata.USE_DEFINE_COLUMN_LENGTH.getProperty();
        if (string != null) {
            if (string.equals("as_chars")) {
                mUseCharLength = 1;
            } else if (string.equals("as_bytes")) {
                mUseCharLength = 0;
            } else if (string.equals("jdbc_default")) {
                mUseCharLength = (byte)3;
            } else if (string.equals("skipDefines")) {
                Diagnostic.println("* * * Use jdbc with no defineColumnType calls * * *");
                mUseCharLength = (byte)4;
            } else if (!string.equals("true")) {
                mUseCharLength = (byte)2;
            }
        }
        if ("jbo".equals(string = PropertyMetadata.JDBC_DATA_BYTES_CONVERSION.getProperty())) {
            mCoverForJdbcBytesConversion = true;
        } else if ("jdbc".equals(string)) {
            mCoverForJdbcBytesConversion = false;
        }
    }

    public static synchronized SQLBuilder getInterface() {
        if (mSQLBuilderInterface == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("OracleSQLBuilder reached getInterface");
            }
            mSQLBuilderInterface = new OracleSQLBuilderImpl();
            if (Diagnostic.isOn()) {
                Diagnostic.println(mSQLBuilderInterface.getVersion());
            }
        }
        return mSQLBuilderInterface;
    }

    public String getVersion() {
        return "Oracle SQL Builder Version 3.2.0.0.0";
    }

    public String getDbType() {
        return "Oracle";
    }

    public String getTypeMapName() {
        return "Oracle";
    }

    public ArrayList getNestedTables(Connection connection) throws SQLException {
        ArrayList arrayList = new ArrayList();
        ResultSet resultSet = connection.createStatement().executeQuery("select table_name from user_nested_tables");
        while (resultSet.next()) {
            arrayList.add((Object)resultSet.getString(1));
        }
        return arrayList;
    }

    public String getPersistManagerClassName() {
        Class clazz = class$oracle$jbo$pcoll$OraclePersistManager;
        if (clazz == null) {
            clazz = class$oracle$jbo$pcoll$OraclePersistManager = OracleSQLBuilderImpl.class$("oracle.jbo.pcoll.OraclePersistManager");
        }
        return clazz.getName();
    }

    public int getDefaultBindingStyle() {
        return 2;
    }

    public void executeBatch(PreparedStatement preparedStatement) throws SQLException {
        ((OraclePreparedStatement)preparedStatement).executeBatch();
        if (JDBCInteract.mDoTrace) {
            JDBCInteract.executeBatch(preparedStatement);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doEntityDML(EntityImpl var1_1, int var2_2, TransactionEvent var3_3) {
        block66: {
            block60: {
                block65: {
                    block59: {
                        block57: {
                            block58: {
                                var4_4 = 0;
                                if (InstrumentedEvent.isActive) {
                                    var4_4 = InstrumentedEvent.startEvent(EventGroup.SQLB_DOENTITYDML, "Executing operation : " + DMLException.getOperationString(var2_2) + " for " + var1_1);
                                }
                                var5_5 = var1_1.getDBTransactionImpl();
                                var5_5.mBindVarNum = 1;
                                var6_6 = var1_1.getEntityDef();
                                var7_7 = var6_6.getBindingStyle();
                                var8_8 = null;
                                var9_9 = null;
                                var10_10 = new HashMap();
                                var5_5.mUseCallableStmt = false;
                                var12_11 = null;
                                var13_12 = null;
                                var14_13 = var1_1.getEntityCache();
                                var15_14 = true;
                                var16_15 = var14_13.isBatchable(var2_2);
                                var17_16 = var5_5.getLockingMode() == 3;
                                var18_17 = null;
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("OracleSQLBuilder " + (var16_15 != false ? "Batching, Lock " : "Executing, Lock ") + var5_5.getLockingMode() + " DML on: " + var6_6.mSource + " (" + DMLException.getOperationString(var2_2) + ")");
                                }
                                try {
                                    try {
                                        block62: {
                                            block64: {
                                                block63: {
                                                    if (var16_15) {
                                                        var8_8 = var14_13.getBatchStatement(var2_2);
                                                        var11_18 = var14_13.getBatchAttributes(var2_2);
                                                    } else {
                                                        var11_18 = var6_6.getPersistableAttributeDefImpls();
                                                    }
                                                    if (var8_8 != null) break block62;
                                                    switch (var2_2) {
                                                        case 1: {
                                                            if (var16_15) break;
                                                            var12_11 = var6_6.getRetrievedOnInsertAttributes();
                                                            var13_12 = var6_6.getRetrievedOnInsertPrimaryKeys();
                                                            break;
                                                        }
                                                        case 2: {
                                                            if (var16_15) break;
                                                            var12_11 = var6_6.getRetrievedOnUpdateAttributes();
                                                            var13_12 = var6_6.getRetrievedOnUpdatePrimaryKeys();
                                                            break;
                                                        }
                                                        case 3: {
                                                            break;
                                                        }
                                                        default: {
                                                            throw new IllegalArgumentException("");
                                                        }
                                                    }
                                                    var9_9 = var1_1.buildDMLStatement(var2_2, var11_18, var12_11, var13_12, var16_15);
                                                    if (var9_9 == null) break block63;
                                                    if (var9_9.length() != 0) break block64;
                                                }
                                                var42_19 = null;
                                                if (var18_17 != null) {
                                                    if (var18_17.getState() != 2) {
                                                        var18_17.setState(0);
                                                    }
                                                    var5_5.removeLongRunningDMLOperationHandle(var18_17);
                                                }
                                                if (var8_8 == null || !var15_14) break block57;
                                                break block58;
                                            }
                                            if (var5_5.mUseCallableStmt) {
                                                var9_9.insert(0, "BEGIN ");
                                                var9_9.append(" END;");
                                                var19_27 = var9_9.toString();
                                                var8_8 = var5_5.createCallableStatement(var19_27, 1);
                                                this.doStatementSetBindingStyle(var8_8, var7_7);
                                            } else {
                                                var19_27 = var9_9.toString();
                                                var8_8 = var5_5.createPreparedStatement(var19_27, 1);
                                                this.doStatementSetBindingStyle(var8_8, var7_7);
                                            }
                                            if (Diagnostic.isOn()) {
                                                Diagnostic.println(var19_27);
                                            }
                                            if (var16_15) {
                                                var14_13.cacheBatchStatement(var8_8, var2_2);
                                            }
                                        }
                                        var1_1.bindDMLStatement(var2_2, var8_8, var11_18, var12_11, var13_12, var10_10, var16_15);
                                        if (var16_15) {
                                            ((OraclePreparedStatement)var8_8).addBatch();
                                            if (JDBCInteract.mDoTrace) {
                                                JDBCInteract.addBatch(var8_8);
                                            }
                                            var15_14 = false;
                                            break block59;
                                        }
                                        var18_17 = this.createHandleForCancellableStatements(var5_5, var8_8);
                                        var20_28 = var8_8.executeUpdate();
                                        if (!var16_15 && var17_16 && var20_28 == 0) {
                                            v0 = OracleSQLBuilderImpl.class$oracle$jbo$CSMessageBundle;
                                            if (v0 != null) throw new RowNotFoundException(v0, "25057", new Object[]{var6_6.getName(), var1_1.getPrimaryKey()});
                                            v0 = OracleSQLBuilderImpl.class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                                            throw new RowNotFoundException(v0, "25057", new Object[]{var6_6.getName(), var1_1.getPrimaryKey()});
                                        }
                                        var1_1.setPostedToDB(true);
                                        if (JDBCInteract.mDoTrace) {
                                            JDBCInteract.execute(var8_8);
                                        }
                                        var23_29 = var10_10.size();
                                        var24_30 = 0;
                                        var25_31 = new int[var23_29];
                                        var26_32 = new Object[var23_29];
                                        var28_33 = null;
                                        v1 = var29_34 = var2_2 == 1 && var1_1.isPrimaryKeyRetrievedOnInsert() != false || var2_2 == 2 && var1_1.isPrimaryKeyRetrievedOnUpdate() != false;
                                        if (var29_34) {
                                            var28_33 = var1_1.getPrimaryKey();
                                        }
                                        var31_35 = var10_10.keySet().iterator();
                                        while (true) {
                                            if (!var31_35.hasNext()) {
                                                if (var29_34 && (var28_33 == null || !var28_33.equals(var1_1.getPrimaryKey()))) {
                                                    var1_1.getEntityCache().replace(var1_1, var28_33);
                                                    if (var2_2 == 1) {
                                                        var1_1.refreshFKInNewContainees();
                                                    }
                                                }
                                                if (var24_30 != var23_29) break;
                                                var1_1.notifyAttributesChanged(var25_31, var26_32, false);
                                                break block60;
                                            }
                                            var21_36 = (Integer)var31_35.next();
                                            var22_37 = (AttributeDefImpl)var10_10.get((Object)var21_36);
                                            var30_39 = var22_37.mIndex;
                                            var27_38 = var1_1.mData.get(var30_39);
                                            if (!(var1_1.mOrigData.isPopulated(var30_39) || var2_2 == 1 && var22_37.mRetrievedOnInsert || var2_2 == 2 && var22_37.mRetrievedOnUpdate)) {
                                                var1_1.mOrigData.set(var30_39, var27_38);
                                            }
                                            var1_1.populateAttribute(var30_39, var22_37.loadFromStatement(var8_8, var21_36, var5_5));
                                            if (!var1_1.isAttributePopulated(var30_39)) continue;
                                            var25_31[var24_30] = var30_39;
                                            var26_32[var24_30++] = var27_38;
                                        }
                                        var32_40 = new int[var24_30];
                                        var33_41 = new Object[var24_30];
                                        System.arraycopy(var25_31, 0, var32_40, 0, var24_30);
                                        System.arraycopy(var26_32, 0, var33_41, 0, var24_30);
                                        var1_1.notifyAttributesChanged(var32_40, var33_41, false);
                                        break block60;
                                    }
                                    catch (SQLException var34_42) {
                                        var16_15 = false;
                                        if (Diagnostic.isOn()) {
                                            Diagnostic.println("OracleSQLBuilderImpl.doEntityDML failed...");
                                            Diagnostic.println("X/Open SQL State is: " + var34_42.getSQLState());
                                            Diagnostic.printStackTrace(var34_42);
                                        }
                                        if (var34_42.getNextException() != null && Diagnostic.isOn()) {
                                            Diagnostic.println("more sqlerrors on stack");
                                        }
                                        var35_43 = var34_42.getErrorCode();
                                        switch (var35_43) {
                                            case 1: 
                                            case 2290: 
                                            case 2291: 
                                            case 2292: {
                                                var36_44 = var34_42.getMessage();
                                                var37_45 = var36_44.indexOf(".");
                                                var38_46 = var36_44.indexOf(")", var37_45);
                                                var39_47 = new DMLConstraintException(new Object[]{DMLException.getOperationString(var2_2), var9_9 == null ? "" : var9_9.toString(), var36_44.substring(var37_45 + 1, var38_46)}, var34_42);
                                                var39_47.setEntityRowHandle(var1_1.getTransPostHandle());
                                                var39_47.setEntityRow(var1_1);
                                                throw var39_47;
                                            }
                                        }
                                        v2 = var1_1.getTransPostHandle();
                                        if (var9_9 == null) {
                                            v3 = "";
                                            throw new DMLException(var2_2, var1_1, v2, v3, var34_42);
                                        }
                                        v3 = var9_9.toString();
                                        throw new DMLException(var2_2, var1_1, v2, v3, var34_42);
                                    }
                                }
                                catch (Throwable var41_48) {
                                    var42_22 = null;
                                    if (var18_17 != null) {
                                        if (var18_17.getState() != 2) {
                                            var18_17.setState(0);
                                        }
                                        var5_5.removeLongRunningDMLOperationHandle(var18_17);
                                    }
                                    if (var8_8 != null && var15_14) {
                                        try {
                                            var8_8.close();
                                            if (JDBCInteract.mDoTrace) {
                                                JDBCInteract.closeStmt(var8_8);
                                            }
                                        }
                                        catch (SQLException var40_26) {
                                            // empty catch block
                                        }
                                    }
                                    if (InstrumentedEvent.isActive == false) throw var41_48;
                                    InstrumentedEvent.endEvent(var4_4);
                                    throw var41_48;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [2 : 1265->1286)] { 
lbl173:
                            // 1 sources

                            var8_8.close();
                            if (JDBCInteract.mDoTrace) {
                                JDBCInteract.closeStmt(var8_8);
                            }
                            break block57;
lbl177:
                            // 1 sources

                            catch (SQLException var40_23) {
                                // empty catch block
                            }
                        }
                        if (InstrumentedEvent.isActive == false) return;
                        InstrumentedEvent.endEvent(var4_4);
                        return;
                    }
                    var42_20 = null;
                    if (var18_17 != null) {
                        if (var18_17.getState() != 2) {
                            var18_17.setState(0);
                        }
                        var5_5.removeLongRunningDMLOperationHandle(var18_17);
                    }
                    if (var8_8 != null && var15_14) {
                        ** try [egrp 2[TRYBLOCK] [2 : 1265->1286)] { 
lbl191:
                        // 1 sources

                        var8_8.close();
                        if (JDBCInteract.mDoTrace) {
                            JDBCInteract.closeStmt(var8_8);
                        }
                        break block65;
lbl195:
                        // 1 sources

                        catch (SQLException var40_24) {
                            // empty catch block
                        }
                    }
                }
                if (InstrumentedEvent.isActive == false) return;
                InstrumentedEvent.endEvent(var4_4);
                return;
            }
            var42_21 = null;
            if (var18_17 != null) {
                if (var18_17.getState() != 2) {
                    var18_17.setState(0);
                }
                var5_5.removeLongRunningDMLOperationHandle(var18_17);
            }
            if (var8_8 != null && var15_14) {
                ** try [egrp 2[TRYBLOCK] [2 : 1265->1286)] { 
lbl209:
                // 1 sources

                var8_8.close();
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.closeStmt(var8_8);
                }
                break block66;
lbl213:
                // 1 sources

                catch (SQLException var40_25) {
                    // empty catch block
                }
            }
        }
        if (InstrumentedEvent.isActive == false) return;
        InstrumentedEvent.endEvent(var4_4);
    }

    /*
     * Loose catch block
     */
    public void doEntitySelect(EntityImpl entityImpl, boolean bl) {
        block65: {
            ResultSet resultSet;
            LongRunningStatementHandle longRunningStatementHandle;
            EntityCache entityCache;
            PreparedStatement preparedStatement;
            DBTransactionImpl dBTransactionImpl;
            EntityDefImpl entityDefImpl;
            int n;
            block63: {
                block62: {
                    block61: {
                        String string;
                        n = 0;
                        if (InstrumentedEvent.isActive) {
                            n = InstrumentedEvent.startEvent(EventGroup.SQLB_DOENTITYSELECT, "OracleSQLBuilder Executing doSelect ... (" + bl + ")");
                        }
                        if ((string = (entityDefImpl = entityImpl.getEntityDef()).getSource()) == null || string.length() == 0) {
                            return;
                        }
                        dBTransactionImpl = entityImpl.getDBTransactionImpl();
                        dBTransactionImpl.mBindVarNum = 1;
                        preparedStatement = null;
                        String string2 = entityDefImpl.getAliasName();
                        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.getAttributeDefImpls();
                        AttributeDefImpl[] attributeDefImplArray2 = entityDefImpl.getPrimaryKeys();
                        entityCache = entityImpl.getEntityCache();
                        boolean bl2 = false;
                        int n2 = entityDefImpl.getBindingStyle();
                        longRunningStatementHandle = null;
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("OracleSQLBuilder Executing Select on: " + string + " (" + bl + ")");
                        }
                        if ((preparedStatement = entityCache.getPreparedSelectStatement(bl)) == null) {
                            String string3;
                            StringBuffer stringBuffer = new StringBuffer(100);
                            this.buildSelectString(dBTransactionImpl, stringBuffer, string, string2, attributeDefImplArray, false, n2);
                            entityImpl.buildWhereClause(stringBuffer, attributeDefImplArray2, null);
                            if (bl) {
                                String string4 = this.getSqlVariantLockTrailer(entityImpl);
                                if (string4 == null) {
                                    string4 = DEFAULT_LOCK_TRAILER;
                                }
                                string3 = stringBuffer.append(" ").append(string4).toString();
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("Executing LOCK..." + string3);
                                }
                            } else {
                                string3 = stringBuffer.toString();
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("Executing FAULT-IN..." + string3);
                                }
                            }
                            preparedStatement = entityCache.createPreparedStatement(string3, bl, 2);
                        } else {
                            bl2 = true;
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("Reusing prepared " + (bl ? "LOCK" : "FAULT-IN") + " statement");
                            }
                        }
                        resultSet = null;
                        preparedStatement.clearParameters();
                        this.bindWhereClause(entityImpl, preparedStatement, null, 1);
                        if (!bl2) {
                            this.doPreparedStatementDefines(preparedStatement, attributeDefImplArray);
                        }
                        if (bl) {
                            longRunningStatementHandle = this.createHandleForCancellableStatements(dBTransactionImpl, preparedStatement);
                        }
                        resultSet = preparedStatement.executeQuery();
                        if (JDBCInteract.mDoTrace) {
                            JDBCInteract.executeQuery(preparedStatement);
                        }
                        if (!resultSet.next()) {
                            throw new RowAlreadyDeletedException(true, entityDefImpl.getName(), entityImpl.getPrimaryKey());
                        }
                        AttributeDefImpl[] attributeDefImplArray3 = entityDefImpl.getAttributeDefImpls();
                        int n3 = entityImpl.getAttributeCount();
                        SparseArray sparseArray = new SparseArray(n3);
                        int n4 = 1;
                        int n5 = 0;
                        while (n5 < n3) {
                            byte by = attributeDefImplArray3[n5].getAttributeKind();
                            if ((by == 0 || by == 1) && attributeDefImplArray3[n5].isSelected()) {
                                if (attributeDefImplArray3[n5].getAttrLoad() == 1) {
                                    Object[] objectArray = this.doLoadBulkFromResultSet(attributeDefImplArray3, n5, resultSet, n4++, dBTransactionImpl);
                                    int n6 = 0;
                                    while (n5 < n3) {
                                        attributeDefImplArray3[n5].setValueInSparseArray(objectArray[n6], sparseArray, entityImpl, dBTransactionImpl);
                                        if (n5 + 1 >= n3 || attributeDefImplArray3[n5 + 1].getAttrLoad() == 2) {
                                            ++n5;
                                            ++n6;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    attributeDefImplArray3[n5].setValueInSparseArray(attributeDefImplArray3[n5].loadFromResultSet(resultSet, n4++, dBTransactionImpl), sparseArray, entityImpl, dBTransactionImpl);
                                }
                            }
                            ++n5;
                        }
                        if (resultSet.next()) {
                            throw new TooManyObjectsException(entityDefImpl.getFullName(), entityImpl.getPrimaryKey());
                        }
                        boolean bl3 = true;
                        if (bl || entityImpl.getPostState() != 1) {
                            bl3 = entityImpl.checkConsistency(sparseArray, bl);
                        }
                        int n7 = 0;
                        int[] nArray = new int[n3];
                        Object[] objectArray = new Object[n3];
                        boolean[] blArray = null;
                        boolean bl4 = false;
                        if (bl && (bl4 = entityDefImpl.hasLOBAttrs())) {
                            blArray = new boolean[n3];
                            ArrayList arrayList = entityDefImpl.getLOBAttrs();
                            int n8 = arrayList.size();
                            int n9 = 0;
                            while (n9 < n3) {
                                blArray[n9] = false;
                                ++n9;
                            }
                            int n10 = 0;
                            while (n10 < n8) {
                                blArray[((AttributeDef)arrayList.get((int)n10)).getIndex()] = true;
                                ++n10;
                            }
                        }
                        int n11 = 0;
                        while (n11 < n3) {
                            Object object;
                            Object object2 = sparseArray.get(n11);
                            if (bl4 && blArray[n11] && (object = entityImpl.mData.get(n11)) != null) {
                                ((LobInterface)object).syncServerLob((LobInterface)object2);
                                object2 = object;
                            }
                            if (attributeDefImplArray3[n11].mKind == 0 || attributeDefImplArray3[n11].mKind == 1) {
                                if (!entityImpl.isAttributeChanged(n11)) {
                                    Object object3 = entityImpl.mData.get(n11);
                                    if (!(!entityImpl.isAttributePopulated(n11) || bl3 && EntityImpl.compareAttrVals(object3, object2))) {
                                        nArray[n7] = n11;
                                        objectArray[n7++] = object3;
                                    }
                                    entityImpl.populateAttribute(n11, object2);
                                } else {
                                    entityImpl.mOrigData.set(n11, object2);
                                }
                            }
                            ++n11;
                        }
                        if (n7 > 0) {
                            if (n7 == n3) {
                                entityImpl.notifyAttributesChanged(nArray, objectArray, false);
                            } else {
                                int[] nArray2 = new int[n7];
                                Object[] objectArray2 = new Object[n7];
                                System.arraycopy(nArray, 0, nArray2, 0, n7);
                                System.arraycopy(objectArray, 0, objectArray2, 0, n7);
                                entityImpl.notifyAttributesChanged(nArray2, objectArray2, false);
                            }
                        }
                        if (!bl3) {
                            throw new RowInconsistentException(entityImpl.getPrimaryKey());
                        }
                        if (!bl) break block61;
                        entityImpl.setLocked(true);
                    }
                    Object var47_43 = null;
                    if (longRunningStatementHandle == null) break block62;
                    if (longRunningStatementHandle.getState() != 2) {
                        longRunningStatementHandle.setState(0);
                    }
                    dBTransactionImpl.removeLongRunningDMLOperationHandle(longRunningStatementHandle);
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.clearParameters();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    entityCache.freeStatement(preparedStatement);
                }
                catch (SQLException sQLException) {
                    if (!Diagnostic.isOn()) break block63;
                    Diagnostic.println("doEntitySelect cleanup failed");
                    Diagnostic.printStackTrace(sQLException);
                }
            }
            if (InstrumentedEvent.isActive) {
                InstrumentedEvent.endEvent(n);
            }
            break block65;
            {
                catch (SQLException sQLException) {
                    Class clazz;
                    if (bl && sQLException.getErrorCode() == 54) {
                        throw new AlreadyLockedException(sQLException);
                    }
                    if (sQLException.getErrorCode() == 1410) {
                        throw new RowNotFoundException(true, entityDefImpl.getName(), entityImpl.getPrimaryKey());
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("OracleSQLBuilderImpl.doEntitySelect failed...");
                        Diagnostic.printStackTrace(sQLException);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, sQLException);
                }
                catch (Exception exception) {
                    Class clazz;
                    if (exception instanceof JboException) {
                        throw (JboException)exception;
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("OracleSQLBuilderImpl.doEntitySelect failed...");
                        Diagnostic.printStackTrace(exception);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, exception);
                }
            }
            catch (Throwable throwable) {
                block64: {
                    Object var47_44 = null;
                    if (longRunningStatementHandle != null) {
                        if (longRunningStatementHandle.getState() != 2) {
                            longRunningStatementHandle.setState(0);
                        }
                        dBTransactionImpl.removeLongRunningDMLOperationHandle(longRunningStatementHandle);
                    }
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.clearParameters();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        entityCache.freeStatement(preparedStatement);
                    }
                    catch (SQLException sQLException) {
                        if (!Diagnostic.isOn()) break block64;
                        Diagnostic.println("doEntitySelect cleanup failed");
                        Diagnostic.printStackTrace(sQLException);
                    }
                }
                if (InstrumentedEvent.isActive) {
                    InstrumentedEvent.endEvent(n);
                }
                throw throwable;
            }
        }
    }

    public void doStatementSetRowPrefetch(Statement statement, int n) throws SQLException {
        if (n != -1) {
            ((OracleStatement)statement).setFetchSize(n);
        }
    }

    public void doStatementSetBindingStyle(Statement statement, int n) {
        if (n == 1) {
            try {
                ((OracleStatement)statement).setEscapeProcessing(false);
            }
            catch (SQLException sQLException) {
                throw new JboException(sQLException);
            }
        }
    }

    public void doStatementSetBindingStyleDefault(Statement statement) {
        this.doStatementSetBindingStyle(statement, 1);
    }

    public void doPreparedStatementDefineColumnType(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        ((OraclePreparedStatement)preparedStatement).defineColumnType(n, n2);
    }

    public void doPreparedStatementDefines(PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray) {
        if (mUseCharLength == 4) {
            return;
        }
        try {
            int n = 0;
            int n2 = 1;
            while (n < attributeDefImplArray.length) {
                AttributeDefImpl attributeDefImpl = attributeDefImplArray[n];
                if (attributeDefImpl.mAttrLoad != 2 && (attributeDefImpl.mKind == 0 || attributeDefImpl.mKind == 1)) {
                    block2 : switch (attributeDefImplArray[n].mType) {
                        case 1: 
                        case 12: {
                            if (attributeDefImpl.mPrecision > 0) {
                                switch (mUseCharLength) {
                                    case 1: {
                                        ((OracleStatement)preparedStatement).defineColumnTypeChars(n2++, attributeDefImpl.mType, attributeDefImpl.mPrecision);
                                        break block2;
                                    }
                                    case 3: {
                                        ((OracleStatement)preparedStatement).defineColumnType(n2++, attributeDefImpl.mType, attributeDefImpl.mPrecision);
                                        break block2;
                                    }
                                    case 0: {
                                        ((OracleStatement)preparedStatement).defineColumnTypeBytes(n2++, attributeDefImpl.mType, attributeDefImpl.mPrecision);
                                        break block2;
                                    }
                                }
                            }
                        }
                        default: {
                            ((OraclePreparedStatement)preparedStatement).defineColumnType(n2++, attributeDefImpl.mType);
                        }
                    }
                }
                ++n;
            }
        }
        catch (SQLException sQLException) {
            try {
                ((OraclePreparedStatement)preparedStatement).clearDefines();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
        }
    }

    public Object doLoadFromResultSet(Object object, Object object2, Class clazz, byte by, ResultSet resultSet, int n, DBTransactionImpl dBTransactionImpl) {
        try {
            if (object instanceof DatumFactory) {
                Datum datum = ((DatumFactory)object).createDatum(resultSet, n);
                return datum;
            }
            Object object3 = object == null ? TypeFactory.getInstance(clazz, resultSet.getObject(n)) : ((OracleResultSet)resultSet).getCustomDatum(n, (CustomDatumFactory)object);
            return object3;
        }
        catch (JboException jboException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadFromResultSet failed (" + n + ")");
            }
            throw jboException;
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadFromResultSet failed (" + n + ")");
            }
            throw new AttributeLoadException(n, clazz, object != null, exception);
        }
    }

    public Object[] doLoadBulkFromResultSet(AttributeDefImpl[] attributeDefImplArray, int n, ResultSet resultSet, int n2, DBTransactionImpl dBTransactionImpl) {
        Class clazz = null;
        CustomDatumFactory customDatumFactory = null;
        Object[] objectArray = null;
        try {
            Class clazz2 = class$oracle$sql$STRUCT;
            if (clazz2 == null) {
                clazz2 = class$oracle$sql$STRUCT = OracleSQLBuilderImpl.class$("oracle.sql.STRUCT");
            }
            STRUCT sTRUCT = (STRUCT)TypeFactory.getInstance(clazz2, resultSet.getObject(n2));
            Object[] objectArray2 = sTRUCT.getAttributes();
            Datum[] datumArray = sTRUCT.getOracleAttributes();
            ArrayList arrayList = new ArrayList();
            int n3 = 0;
            while (n < attributeDefImplArray.length) {
                AttributeDefImpl attributeDefImpl = attributeDefImplArray[n];
                if (n3 > 0 && attributeDefImpl.getAttrLoad() != 2) break;
                clazz = attributeDefImpl.getJavaType();
                customDatumFactory = (CustomDatumFactory)attributeDefImpl.getTypeFactory();
                Object object = customDatumFactory != null ? customDatumFactory.create(datumArray[n3], attributeDefImpl.getSQLType()) : TypeFactory.getInstance(clazz, objectArray2[n3]);
                arrayList.add(object);
                ++n;
                ++n3;
            }
            objectArray = arrayList.toArray();
        }
        catch (JboException jboException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadBulkFromResultSet failed (" + n2 + ")");
            }
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz3;
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadBulkFromResultSet failed (" + n2 + ")");
            }
            if ((clazz3 = class$oracle$sql$STRUCT) == null) {
                clazz3 = class$oracle$sql$STRUCT = OracleSQLBuilderImpl.class$("oracle.sql.STRUCT");
            }
            throw new AttributeLoadException(n2, clazz3, false, exception);
        }
        return objectArray;
    }

    public Object doLoadFromStatement(Object object, Object object2, Class clazz, PreparedStatement preparedStatement, int n, Transaction transaction) {
        try {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)preparedStatement;
            if (object instanceof DatumFactory) {
                Datum datum = ((DatumFactory)object).createDatum((CallableStatement)oracleCallableStatement, n);
                return datum;
            }
            Object object3 = object == null ? TypeFactory.getInstance(clazz, oracleCallableStatement.getObject(n)) : oracleCallableStatement.getCustomDatum(n, (CustomDatumFactory)object);
            return object3;
        }
        catch (JboException jboException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadFromStatement failed (" + n + ")");
            }
            throw jboException;
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadFromStatement failed (" + n + ")");
            }
            throw new AttributeLoadException(n, clazz, object != null, exception);
        }
    }

    public void setSavepoint(Connection connection, String string) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.prepareStatement("SAVEPOINT " + string);
            if (Diagnostic.isOn()) {
                Diagnostic.println("OracleSQLBuilder: SAVEPOINT '" + string + "'");
            }
            this.doStatementSetBindingStyleDefault(statement);
            statement.execute();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
    }

    public void rollbackToSavepoint(Connection connection, String string) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.prepareStatement("ROLLBACK WORK TO SAVEPOINT " + string);
            this.doStatementSetBindingStyleDefault(statement);
            if (Diagnostic.isOn()) {
                Diagnostic.println("OracleSQLBuilder: ROLLBACK WORK TO SAVEPOINT '" + string + "'");
            }
            statement.execute();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
    }

    public void releaseSavepoint(Connection connection, String string) throws SQLException {
        if (Diagnostic.isOn()) {
            Diagnostic.println("OracleSQLBuilder: releaseSavepoint '" + string + "' ignored");
        }
    }

    public boolean supportsReturningClause() {
        return true;
    }

    public boolean supportsRowNumQuery() {
        return true;
    }

    public StringBuffer buildUpdateStatement(EntityImpl entityImpl, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, boolean bl) {
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        String string = entityDefImpl.mSource;
        if (attributeDefImplArray.length == 0 || string == null) {
            return null;
        }
        String string2 = entityDefImpl.getAliasName();
        AttributeDefImpl[] attributeDefImplArray4 = entityDefImpl.mPrimaryKeys;
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        boolean bl2 = dBTransactionImpl.getLockingMode() == 3;
        boolean bl3 = bl2 || entityDefImpl.isUpdateChangedColumns();
        int n = bl || !bl3 ? attributeDefImplArray.length : entityImpl.getAttributeChangedCount();
        int n2 = 60 + 45 * n;
        int n3 = 0;
        int n4 = 0;
        if (!bl) {
            n3 = attributeDefImplArray3 != null ? attributeDefImplArray3.length : 0;
            n4 = attributeDefImplArray2 != null ? attributeDefImplArray2.length : 0;
            n2 += 60 + 45 * (n3 + n4);
        }
        StringBuffer stringBuffer = new StringBuffer(n2 += attributeDefImplArray4.length * 45);
        boolean bl4 = true;
        int n5 = entityDefImpl.getBindingStyle();
        stringBuffer.append("UPDATE ").append(string).append(" ").append(string2).append(" SET ");
        int n6 = 0;
        while (n6 < attributeDefImplArray.length) {
            if (bl || (bl3 ? entityImpl.isAttributeChanged(attributeDefImplArray[n6].getIndex()) : entityImpl.isAttributePopulated(attributeDefImplArray[n6].getIndex()))) {
                if (bl4) {
                    bl4 = false;
                } else {
                    stringBuffer.append(",");
                }
                if (n5 == 1) {
                    stringBuffer.append(attributeDefImplArray[n6].mColumnName).append("=:").append(dBTransactionImpl.getNextBindVarNum());
                } else {
                    stringBuffer.append(attributeDefImplArray[n6].mColumnName).append("=?");
                }
            }
            ++n6;
        }
        if (bl4) {
            return null;
        }
        entityImpl.buildWhereClause(stringBuffer, attributeDefImplArray4, null);
        if (bl2) {
            this.buildOptUpdateWhereClause(entityImpl, stringBuffer, attributeDefImplArray);
        }
        if (!(bl || n3 <= 0 && n4 <= 0)) {
            if (entityDefImpl.isUseReturningClause()) {
                this.buildReturningClause(stringBuffer, dBTransactionImpl, attributeDefImplArray2, attributeDefImplArray3, false, n5 == 1);
            } else {
                stringBuffer.append(";");
                dBTransactionImpl.mUseCallableStmt = true;
                attributeDefImplArray3 = entityImpl.buildRefreshSQL(stringBuffer, 2, attributeDefImplArray2, attributeDefImplArray3, true);
            }
        }
        if (dBTransactionImpl.mUseCallableStmt) {
            stringBuffer.append(";");
        }
        if (Diagnostic.isOn()) {
            int n7 = stringBuffer.length();
            Diagnostic.println("UPDATE buf " + entityDefImpl.getName() + ">#u SQLStmtBufLen: " + n2 + ", actual=" + n7 + (n7 > n2 ? " ACT > COMP (UPD)!!!" : ""));
        }
        return stringBuffer;
    }

    protected void buildReturningClause(StringBuffer stringBuffer, DBTransactionImpl dBTransactionImpl, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, boolean bl, boolean bl2) {
        if (bl) {
            return;
        }
        int n = 0;
        boolean bl3 = false;
        int n2 = attributeDefImplArray2 != null ? attributeDefImplArray2.length : 0;
        int n3 = attributeDefImplArray != null ? attributeDefImplArray.length : 0;
        StringBuffer stringBuffer2 = null;
        if (n2 > 0 || n3 > 0) {
            stringBuffer2 = new StringBuffer(100);
            dBTransactionImpl.mUseCallableStmt = true;
            stringBuffer.append(" RETURNING ");
        }
        n = 0;
        while (n < n2) {
            if (bl3) {
                stringBuffer.append(SQL_COL_SEPARATOR);
                if (bl2) {
                    stringBuffer2.append(", :").append(dBTransactionImpl.getNextBindVarNum());
                } else {
                    stringBuffer2.append(", ?");
                }
            } else {
                bl3 = true;
                if (bl2) {
                    stringBuffer2.append(" INTO :").append(dBTransactionImpl.getNextBindVarNum());
                } else {
                    stringBuffer2.append(" INTO ?");
                }
            }
            stringBuffer.append(attributeDefImplArray2[n].mColumnName);
            ++n;
        }
        n = 0;
        while (n < n3) {
            if (bl3) {
                stringBuffer.append(SQL_COL_SEPARATOR);
                if (bl2) {
                    stringBuffer2.append(", :").append(dBTransactionImpl.getNextBindVarNum());
                } else {
                    stringBuffer2.append(", ?");
                }
            } else {
                bl3 = true;
                if (bl2) {
                    stringBuffer2.append(" INTO :").append(dBTransactionImpl.getNextBindVarNum());
                } else {
                    stringBuffer2.append(" INTO ?");
                }
            }
            stringBuffer.append(attributeDefImplArray[n].mColumnName);
            ++n;
        }
        if (bl3) {
            stringBuffer.append(stringBuffer2.toString());
        }
    }

    public int bindInsertStatement(EntityImpl entityImpl, PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, HashMap hashMap, boolean bl) throws SQLException {
        int n = 1;
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        boolean bl2 = entityDefImpl.isUpdateChangedColumns();
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n2];
            if (bl || !bl2 || entityImpl.isAttributeChanged(attributeDefImpl.mIndex)) {
                Object object = entityImpl.getAttributeInternal(attributeDefImpl.mIndex);
                Object object2 = object = object != null ? attributeDefImpl.convertToStorage(object, dBTransactionImpl) : null;
                if (object != null) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Insert binding param " + n + ": " + object);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setObject(preparedStatement, n, object, attributeDefImpl);
                    }
                    preparedStatement.setObject(n++, object);
                } else {
                    int n3 = attributeDefImpl.mType;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Insert binding null of type " + n3 + " for " + n);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setNull(preparedStatement, n, n3, attributeDefImpl);
                    }
                    if (n3 == 2006 || n3 == 2002) {
                        ((OraclePreparedStatement)preparedStatement).setNull(n++, n3, attributeDefImpl.mObjectType);
                    } else {
                        preparedStatement.setNull(n++, n3);
                    }
                }
            }
            ++n2;
        }
        boolean bl3 = false;
        if (attributeDefImplArray3 != null && attributeDefImplArray3.length != 0) {
            bl3 = true;
            int n4 = 0;
            while (n4 < attributeDefImplArray3.length) {
                hashMap.put((Object)new Integer(n), (Object)attributeDefImplArray3[n4]);
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.registerOutParameter(preparedStatement, n, attributeDefImplArray3[n4].mType);
                }
                ((CallableStatement)preparedStatement).registerOutParameter(n++, attributeDefImplArray3[n4].mType);
                ++n4;
            }
        }
        if (attributeDefImplArray2 != null && attributeDefImplArray2.length != 0) {
            bl3 = true;
            int n5 = 0;
            while (n5 < attributeDefImplArray2.length) {
                hashMap.put((Object)new Integer(n), (Object)attributeDefImplArray2[n5]);
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.registerOutParameter(preparedStatement, n, attributeDefImplArray2[n5].mType);
                }
                ((CallableStatement)preparedStatement).registerOutParameter(n++, attributeDefImplArray2[n5].mType);
                ++n5;
            }
        }
        if (bl3 && !entityDefImpl.isUseReturningClause()) {
            n = this.bindWhereClause(entityImpl, preparedStatement, entityImpl.getRefreshSQLKeyAttrs(1), null, n);
        }
        return n;
    }

    public int bindUpdateStatement(EntityImpl entityImpl, PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, HashMap hashMap, boolean bl) throws SQLException {
        int n;
        int n2 = 1;
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        boolean bl2 = dBTransactionImpl.getLockingMode() == 3;
        boolean bl3 = bl2 || entityDefImpl.isUpdateChangedColumns();
        int n3 = 0;
        while (n3 < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n3];
            int n4 = attributeDefImpl.mIndex;
            if (bl || (bl3 ? entityImpl.isAttributeChanged(n4) : entityImpl.isAttributePopulated(n4))) {
                Object object;
                if (Diagnostic.isOn() && bl && !entityImpl.isAttributePopulated(n4)) {
                    Diagnostic.println("OracleSQLBuilder: warning - batch mode & attribute missing");
                    Diagnostic.println("  entity: " + entityDefImpl.getName() + ", attr: " + attributeDefImpl.getName() + ", pk: " + entityImpl.getPrimaryKey());
                }
                Object object2 = object = (object = entityImpl.getAttributeInternal(n4)) != null ? attributeDefImpl.convertToStorage(object, dBTransactionImpl) : null;
                if (object == null) {
                    n = attributeDefImpl.mType;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Update binding null of type " + n + " for " + n2);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setNull(preparedStatement, n2, n, attributeDefImpl);
                    }
                    if (n == 2006 || n == 2002) {
                        ((OraclePreparedStatement)preparedStatement).setNull(n2++, n, attributeDefImpl.mObjectType);
                    } else {
                        preparedStatement.setNull(n2++, n);
                    }
                } else {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Update binding param " + n2 + ": " + object);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setObject(preparedStatement, n2, object, attributeDefImpl);
                    }
                    preparedStatement.setObject(n2++, object);
                }
            }
            ++n3;
        }
        n2 = this.bindWhereClause(entityImpl, preparedStatement, null, n2);
        if (bl2) {
            n2 = this.bindOptUpdateWhereClause(entityImpl, preparedStatement, n2);
        }
        boolean bl4 = false;
        if (attributeDefImplArray3 != null && attributeDefImplArray3.length != 0) {
            bl4 = true;
            int n5 = 0;
            while (n5 < attributeDefImplArray3.length) {
                hashMap.put((Object)new Integer(n2), (Object)attributeDefImplArray3[n5]);
                n = attributeDefImplArray3[n5].getSQLType();
                ((CallableStatement)preparedStatement).registerOutParameter(n2++, n);
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.registerOutParameter(preparedStatement, n2 - 1, n);
                }
                ++n5;
            }
        }
        if (attributeDefImplArray2 != null && attributeDefImplArray2.length != 0) {
            bl4 = true;
            int n6 = 0;
            while (n6 < attributeDefImplArray2.length) {
                hashMap.put((Object)new Integer(n2), (Object)attributeDefImplArray2[n6]);
                n = attributeDefImplArray2[n6].getSQLType();
                ((CallableStatement)preparedStatement).registerOutParameter(n2++, n);
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.registerOutParameter(preparedStatement, n2 - 1, n);
                }
                ++n6;
            }
        }
        if (bl4 && !entityDefImpl.isUseReturningClause()) {
            n2 = this.bindWhereClause(entityImpl, preparedStatement, entityImpl.getRefreshSQLKeyAttrs(2), null, n2);
        }
        return n2;
    }

    protected int bindWhereAttrValue(EntityImpl entityImpl, DBTransactionImpl dBTransactionImpl, PreparedStatement preparedStatement, AttributeDefImpl attributeDefImpl, int n, boolean bl) throws SQLException {
        int n2 = attributeDefImpl.getIndex();
        Object object = entityImpl.mOrigData.isPopulated(n2) ? entityImpl.mOrigData.get(n2) : entityImpl.mData.get(n2);
        int n3 = attributeDefImpl.mType;
        if (object == null || object instanceof NullValue) {
            if (!bl) {
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.setNull(preparedStatement, n, n3, attributeDefImpl);
                }
                if (n3 == 2006 || n3 == 2002) {
                    ((OraclePreparedStatement)preparedStatement).setNull(n++, n3, attributeDefImpl.mObjectType);
                } else {
                    preparedStatement.setNull(n++, n3);
                }
            }
        } else if ((object = attributeDefImpl.convertToStorage(object, dBTransactionImpl)) != null) {
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.setObject(preparedStatement, n, object, attributeDefImpl);
            }
            preparedStatement.setObject(n++, object);
        } else if (!bl) {
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.setNull(preparedStatement, n, n3, attributeDefImpl);
            }
            preparedStatement.setNull(n++, n3);
        }
        return n;
    }

    protected Object getROWID(EntityImpl entityImpl) {
        return entityImpl.getAttributeValue(entityImpl.getEntityDef().getAttributeDefImplByColumnName(ORACLE_ROWID_COLUMN));
    }

    public void buildWhereClause(EntityImpl entityImpl, StringBuffer stringBuffer, AttributeDefImpl[] attributeDefImplArray, Object object) {
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        int n = entityDefImpl.getBindingStyle();
        boolean bl = false;
        stringBuffer.append(" WHERE ");
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            int n3;
            if (bl) {
                stringBuffer.append(" AND ");
            }
            if (!entityImpl.isAttributePopulated(n3 = attributeDefImplArray[n2].getIndex())) {
                throw new JboException("Key attribute \"" + entityDefImpl.getName() + "." + attributeDefImplArray[n2].getName() + "\" not populated");
            }
            String string = attributeDefImplArray[n2].isObjectTableRef() ? "REF(" + entityDefImpl.getAliasName() + ")" : attributeDefImplArray[n2].getColumnName();
            stringBuffer.append(string);
            if (n == 1) {
                stringBuffer.append("=:").append(dBTransactionImpl.getNextBindVarNum());
            } else {
                stringBuffer.append("=?");
            }
            bl = true;
            ++n2;
        }
    }

    public void buildOptUpdateWhereClause(EntityImpl entityImpl, StringBuffer stringBuffer, AttributeDefImpl[] attributeDefImplArray) {
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        int n = entityDefImpl.getBindingStyle();
        AttributeDefImpl attributeDefImpl = entityDefImpl.getChangeIndicatorColumn();
        if (attributeDefImpl != null) {
            if (!entityImpl.isAttributePopulated(attributeDefImpl.getIndex())) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "26047", new Object[]{entityDefImpl.getName(), entityImpl.getPrimaryKey()});
            }
            stringBuffer.append(" AND ").append(attributeDefImpl.getColumnName());
            if (n == 1) {
                stringBuffer.append("=:").append(dBTransactionImpl.getNextBindVarNum());
            } else {
                stringBuffer.append("=?");
            }
        } else {
            int n2 = 0;
            while (n2 < attributeDefImplArray.length) {
                AttributeDefImpl attributeDefImpl2 = attributeDefImplArray[n2];
                int n3 = attributeDefImpl2.getIndex();
                if (!attributeDefImpl2.isPrimaryKey() && entityImpl.isAttributePopulated(n3)) {
                    Object object = entityImpl.mOrigData.isPopulated(n3) ? entityImpl.mOrigData.get(n3) : entityImpl.mData.get(n3);
                    stringBuffer.append(" AND ").append(attributeDefImpl2.getColumnName());
                    if (object == null || object instanceof NullValue) {
                        stringBuffer.append(" IS NULL");
                    } else if (n == 1) {
                        stringBuffer.append("=:").append(dBTransactionImpl.getNextBindVarNum());
                    } else {
                        stringBuffer.append("=?");
                    }
                }
                ++n2;
            }
        }
    }

    public StringBuffer buildInsertStatement(EntityImpl entityImpl, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, boolean bl) {
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        String string = entityDefImpl.mSource;
        if (attributeDefImplArray.length == 0 || string == null) {
            return null;
        }
        boolean bl2 = entityDefImpl.isUpdateChangedColumns();
        int n = bl || !bl2 ? attributeDefImplArray.length : entityImpl.getAttributeChangedCount();
        int n2 = 60 + 45 * n;
        int n3 = 0;
        int n4 = 0;
        if (!bl) {
            n3 = attributeDefImplArray3 != null ? attributeDefImplArray3.length : 0;
            n4 = attributeDefImplArray2 != null ? attributeDefImplArray2.length : 0;
            n2 += 60 + 45 * (n3 + n4);
        }
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n5 = entityDefImpl.getBindingStyle();
        boolean bl4 = n5 == 1;
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        stringBuffer.append("INSERT INTO ").append(string).append("(");
        StringBuffer stringBuffer2 = new StringBuffer(100);
        int n6 = 0;
        while (n6 < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n6];
            if (bl || !bl2 || entityImpl.isAttributeChanged(attributeDefImpl.mIndex)) {
                if (bl3) {
                    stringBuffer.append(",");
                    if (bl4) {
                        stringBuffer2.append(",:").append(dBTransactionImpl.getNextBindVarNum());
                    } else {
                        stringBuffer2.append(",?");
                    }
                } else if (bl4) {
                    stringBuffer2.append(":").append(dBTransactionImpl.getNextBindVarNum());
                } else {
                    stringBuffer2.append("?");
                }
                stringBuffer.append(attributeDefImpl.mColumnName);
                bl3 = true;
            }
            ++n6;
        }
        if (!bl3) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "26018", new Object[]{entityDefImpl.getName()});
        }
        stringBuffer.append(") VALUES (").append(stringBuffer2.toString()).append(')');
        if (!(bl || n3 <= 0 && n4 <= 0)) {
            if (entityDefImpl.isUseReturningClause()) {
                this.buildReturningClause(stringBuffer, dBTransactionImpl, attributeDefImplArray2, attributeDefImplArray3, bl, bl4);
            } else {
                stringBuffer.append(";");
                dBTransactionImpl.mUseCallableStmt = true;
                attributeDefImplArray3 = entityImpl.buildRefreshSQL(stringBuffer, 1, attributeDefImplArray2, attributeDefImplArray3, true);
            }
        }
        if (dBTransactionImpl.mUseCallableStmt) {
            stringBuffer.append(";");
        }
        if (Diagnostic.isOn()) {
            int n7 = stringBuffer.length();
            Diagnostic.println("INSERT buf " + entityDefImpl.getName() + ">#i SQLStmtBufLen: " + n2 + ", actual=" + n7 + (n7 > n2 ? " ACT > COMP (INS)!!!" : ""));
        }
        return stringBuffer;
    }

    public StringBuffer buildDeleteStatement(EntityImpl entityImpl) {
        int n;
        boolean bl;
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        String string = entityDefImpl.mSource;
        if (string == null) {
            return null;
        }
        String string2 = entityDefImpl.getAliasName();
        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.mPrimaryKeys;
        AttributeDefImpl[] attributeDefImplArray2 = null;
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        boolean bl2 = bl = dBTransactionImpl.getLockingMode() == 3;
        if (bl) {
            attributeDefImplArray2 = entityDefImpl.getPersistableAttributeDefImpls();
            n = 60 + 45 * attributeDefImplArray2.length;
        } else {
            n = 60 + 45 * attributeDefImplArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("DELETE FROM ").append(string).append(" ").append(string2);
        entityImpl.buildWhereClause(stringBuffer, attributeDefImplArray, null);
        if (bl) {
            this.buildOptUpdateWhereClause(entityImpl, stringBuffer, attributeDefImplArray2);
        }
        if (dBTransactionImpl.mUseCallableStmt) {
            stringBuffer.append(";");
        }
        if (Diagnostic.isOn()) {
            int n2 = stringBuffer.length();
            Diagnostic.println("DELETE buf " + entityDefImpl.getName() + ">#u SQLStmtBufLen: " + n + ", actual=" + n2 + (n2 > n ? " ACT > COMP (DEL)!!!" : ""));
        }
        return stringBuffer;
    }

    public void buildSelectList(StringBuffer stringBuffer, AttributeDefImpl[] attributeDefImplArray, String string) {
        int n = 0;
        while (n < attributeDefImplArray.length) {
            byte by = attributeDefImplArray[n].getAttributeKind();
            if (by == 0 || by == 1) {
                String string2;
                if (n > 0) {
                    stringBuffer.append(SQL_COL_SEPARATOR);
                }
                if (attributeDefImplArray[n].isObjectTableRef()) {
                    string2 = "REF(" + string + ")";
                } else if (attributeDefImplArray[n].getAttrLoad() == 1) {
                    string2 = "VALUE(" + string + ")";
                    ++n;
                    while (n < attributeDefImplArray.length) {
                        if (attributeDefImplArray[n].getAttrLoad() != 2) {
                            --n;
                            break;
                        }
                        ++n;
                    }
                } else {
                    string2 = attributeDefImplArray[n].getColumnName();
                }
                stringBuffer.append(string2);
            }
            ++n;
        }
    }

    public void buildSelectString(DBTransactionImpl dBTransactionImpl, StringBuffer stringBuffer, String string, String string2, AttributeDefImpl[] attributeDefImplArray, boolean bl, int n) {
        stringBuffer.append("SELECT ");
        this.buildSelectList(stringBuffer, attributeDefImplArray, string2);
        if (bl) {
            stringBuffer.append(" INTO ");
            int n2 = 0;
            while (n2 < attributeDefImplArray.length) {
                if (attributeDefImplArray[n2].getAttributeKind() == 0) {
                    if (n2 > 0) {
                        stringBuffer.append(SQL_COL_SEPARATOR);
                    }
                    if (n == 1) {
                        stringBuffer.append(":").append(dBTransactionImpl.getNextBindVarNum());
                    } else {
                        stringBuffer.append("?");
                    }
                }
                ++n2;
            }
        }
        stringBuffer.append(" FROM ").append(string).append(" ").append(string2);
        if (Diagnostic.isOn()) {
            Diagnostic.println("Built select: '" + stringBuffer.toString() + "'");
        }
    }

    /*
     * Loose catch block
     */
    public Object generatePKBasedRef(EntityImpl entityImpl) {
        Object object;
        block17: {
            DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
            EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
            int n = entityDefImpl.getBindingStyle();
            String string = entityDefImpl.getSource();
            AttributeDefImpl[] attributeDefImplArray = entityDefImpl.getPrimaryKeys();
            StringBuffer stringBuffer = new StringBuffer(100);
            dBTransactionImpl.mBindVarNum = 1;
            stringBuffer.append("select make_ref(").append(string);
            int n2 = 0;
            while (n2 < attributeDefImplArray.length) {
                stringBuffer.append(SQL_COL_SEPARATOR);
                if (n == 1) {
                    stringBuffer.append(":").append(dBTransactionImpl.getNextBindVarNum());
                } else {
                    stringBuffer.append("?");
                }
                ++n2;
            }
            stringBuffer.append(") from dual");
            PreparedStatement preparedStatement = dBTransactionImpl.createPreparedStatement(stringBuffer.toString(), 1);
            this.doStatementSetBindingStyle(preparedStatement, n);
            if (Diagnostic.isOn()) {
                Diagnostic.println("Prepared SQL statement in generatePKBasedRef...");
                Diagnostic.println(stringBuffer.toString());
            }
            ResultSet resultSet = null;
            object = null;
            this.bindWhereClause(entityImpl, preparedStatement, null, 1);
            resultSet = preparedStatement.executeQuery();
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.executeQuery(preparedStatement);
            }
            resultSet.next();
            object = TypeFactory.getInstance("oracle.jbo.domain.Ref", "oracle.sql.Datum", resultSet.getObject(1));
            Object var15_12 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
                break block17;
            }
            catch (SQLException sQLException) {}
            break block17;
            {
                catch (SQLException sQLException) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26045", new Object[]{entityDefImpl.getName()}, sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var15_13 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                        preparedStatement = null;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] generateRefAndOID(EntityImpl entityImpl) {
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        Statement statement = dBTransactionImpl.createStatement(1);
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        this.doStatementSetBindingStyle(statement, entityDefImpl.getBindingStyle());
        String string = entityDefImpl.getSource();
        String string2 = "select a.oid, make_ref(" + string + ", a.oid) from (select /*+ NO_MERGE +*/ sys_op_guid() as oid from dual) a";
        if (Diagnostic.isOn()) {
            Diagnostic.println("Executing SQL in generateRefAndOID...");
            Diagnostic.println(string2);
        }
        ResultSet resultSet = null;
        Object[] objectArray = null;
        try {
            try {
                resultSet = statement.executeQuery(string2);
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.executeQuery(statement);
                }
                resultSet.next();
                objectArray = new Object[]{TypeFactory.getInstance("oracle.jbo.domain.Ref", "oracle.sql.Datum", (Object)((Datum)resultSet.getObject(2))), resultSet.getString(1)};
            }
            catch (SQLException sQLException) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz != null) throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26042", new Object[]{entityDefImpl.getName()}, sQLException);
                clazz = class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26042", new Object[]{entityDefImpl.getName()}, sQLException);
            }
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement == null) throw throwable;
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }
        if (statement == null) return objectArray;
        statement.close();
        statement = null;
        return objectArray;
    }

    public boolean isStreamType(int n) {
        int n2 = 0;
        while (n2 < streamTypeIds.length) {
            if (n == streamTypeIds[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public Vector getSchemaList(Connection connection) throws Exception {
        Vector<String> vector;
        block18: {
            Statement statement = null;
            ResultSet resultSet = null;
            vector = new Vector<String>();
            if (connection != null) {
                statement = connection.createStatement();
                String string = "SELECT username FROM all_users ORDER BY 1";
                if (Diagnostic.isOn()) {
                    Diagnostic.println("ORACLE: using '" + string + "'");
                }
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    vector.addElement(resultSet.getString(1));
                }
                Object var9_6 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    break block18;
                }
                catch (SQLException sQLException) {}
                break block18;
                {
                    catch (Exception exception) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("Error: " + exception.getMessage());
                        }
                        Object var9_7 = null;
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                                resultSet = null;
                            }
                            if (statement != null) {
                                statement.close();
                                statement = null;
                            }
                            break block18;
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                            resultSet = null;
                        }
                        if (statement != null) {
                            statement.close();
                            statement = null;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return vector;
    }

    public ArrayList getTables(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        return this.getTables(connection, string, string2, bl, bl2, bl3, bl4, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getTables(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        ResultSet resultSet = null;
        Statement statement = null;
        ArrayList arrayList = new ArrayList();
        try {
            try {
                String string3 = OracleSQLBuilderImpl.getTableListSqlStatement(string, string2, bl, bl2, bl3, bl4, false, bl5);
                if (string3 != null) {
                    statement = connection.createStatement();
                    ((OracleStatement)statement).setFetchSize(100);
                    resultSet = statement.executeQuery(string3);
                    String string4 = string;
                    String string5 = "Table";
                    while (resultSet.next()) {
                        String string6 = resultSet.getString(1);
                        boolean bl6 = string2.equalsIgnoreCase(string);
                        if (!bl6) {
                            string4 = resultSet.getString(2);
                        }
                        if (bl6 || string4.equalsIgnoreCase(string) || string4.equalsIgnoreCase("PUBLIC")) {
                            arrayList.add((Object)string6);
                            continue;
                        }
                        arrayList.add((Object)(string4 + "." + string6));
                    }
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var21_17 = null;
        }
        catch (Throwable throwable) {
            Object var21_18 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement == null) throw throwable;
                statement.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement == null) return arrayList;
        statement.close();
        return arrayList;
    }

    protected boolean needsQuotedTableName(String string) {
        return string != null && string.length() > 0 && string.charAt(0) != this.getQuotationMarkLeft().charAt(0) && (!string.toUpperCase().equals(string) || string.indexOf(" ") != -1 || Character.isDigit(string.charAt(0)));
    }

    protected static String getTableListSqlStatement(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return OracleSQLBuilderImpl.getTableListSqlStatement(string, string2, bl, bl2, bl3, bl4, bl5, true);
    }

    protected static String getTableListSqlStatement(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (bl || bl2 || bl3 || bl4) {
            String string3;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = string3 = bl6 ? "" : " MINUS SELECT table_name, table_type_owner FROM user_nested_tables ";
            if (bl) {
                string4 = OracleSQLBuilderImpl.addSqlTypeText(string4, "TABLE");
                string6 = " MINUS SELECT container_name, owner from all_mviews ";
            }
            if (bl3) {
                string4 = OracleSQLBuilderImpl.addSqlTypeText(string4, "VIEW");
            }
            if (bl2) {
                string4 = OracleSQLBuilderImpl.addSqlTypeText(string4, "SYNONYM");
                string5 = " UNION SELECT syn.synonym_name, syn.owner from all_synonyms syn where owner='PUBLIC' and exists (select objs.object_name from all_objects objs where objs.object_name=syn.table_name and objs.owner=syn.table_owner and (object_type='TABLE' or object_type='VIEW')) ";
            }
            if (bl4) {
                string7 = " UNION SELECT mview_name, owner from all_mviews ";
                string8 = " UNION SELECT mview_name, owner from user_mviews ";
                if (string4.length() == 0) {
                    string4 = "1=2";
                }
            }
            if (string4.length() != 0) {
                String string10;
                boolean bl7 = false;
                String string11 = null;
                String string12 = "all_objects";
                String string13 = "1";
                String string14 = "(" + string4 + ") " + (string5.length() > 0 ? string5 : "") + (string6.length() > 0 ? string6 : "") + (string7.length() > 0 ? string7 : "");
                if (string2 == null || string2.length() == 0) {
                    string10 = "object_name, owner";
                    string14 = "(" + string4 + ") " + (string5.length() > 0 ? string5 : "") + (string6.length() > 0 ? string6 : "") + (string7.length() > 0 ? string7 : "");
                    string13 = "2, 1";
                } else if (string2.equalsIgnoreCase(string)) {
                    bl7 = true;
                    string10 = "object_name, '" + JboDTUtils.getCorrectCaseTableName(string) + "'";
                    string12 = "user_objects ";
                    string14 = "(" + string4 + ") " + (string5.length() > 0 ? string5 : "") + (string6.length() > 0 ? string6 : "") + (string8.length() > 0 ? string8 : "");
                } else {
                    string10 = "object_name, owner ";
                    string14 = "(" + string4 + ") AND (owner = '" + string2 + "') " + (string5.length() > 0 ? string5 : "") + (string6.length() > 0 ? string6 + "where (owner = '" + string2 + "') " : "") + (string7.length() > 0 ? string7 + "where (owner = '" + string2 + "') " : "");
                }
                string14 = string14 + string3;
                string11 = "SELECT " + string10 + " from " + string12 + " where " + string14 + (bl5 ? "" : " ORDER BY " + string13);
                if (bl5) {
                    string11 = "SELECT COUNT(*) FROM (" + string11 + ")";
                }
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Tables: '" + string11 + "'");
                }
                return string11;
            }
        }
        return null;
    }

    protected static String addSqlTypeText(String string, String string2) {
        if (string.length() != 0) {
            string = string.concat(" OR ");
        }
        return string.concat("(object_type = '" + string2 + "')");
    }

    public ArrayList getConstraintsList(Connection connection, String string, String string2, String string3) throws SQLException {
        Statement statement;
        ArrayList arrayList;
        block21: {
            String string4;
            if (Diagnostic.isOn()) {
                Diagnostic.println("OracleSQLBuilder: searching for constraints on table: '" + string3 + "'");
            }
            arrayList = new ArrayList();
            OracleResultSet oracleResultSet = null;
            statement = null;
            int n = 1;
            if (string != null) {
                Diagnostic.println("OracleSQLBuilder: warning - catalog being ignored");
            }
            if ((string4 = JboDTUtils.getSchema(string3 = this.getBaseTable(connection, string2 = string2.toUpperCase(), string3))) != null) {
                string2 = string4;
                string3 = JboDTUtils.getTable(string3);
            }
            string2 = JboDTUtils.stripQuotesAndUpper(string2);
            int n2 = (string3 = JboDTUtils.stripQuotesAndUpper(string3)) != null ? n++ : 0;
            int n3 = string2 != null ? n : 0;
            try {
                String string5 = connection.getMetaData().getDatabaseProductVersion();
                if (string5.startsWith("Oracle7")) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Using Oracle7 compatibility query for constraints");
                    }
                    statement = connection.prepareStatement("SELECT p.owner,p.constraint_name,p.constraint_type, p.table_name, p.search_condition,decode(p.delete_rule, 'CASCADE', 1, 0) as delete_rule,decode(p.status, 'ENABLED', 1, 0) as status,2 as deferrable,0 as deferred,1 as validated,pc.column_name,pc.position,p.r_constraint_name,p.r_owner FROM all_cons_columns pc,all_constraints p WHERE pc.owner = p.owner AND pc.constraint_name = p.constraint_name AND pc.table_name = p.table_name" + (n2 != 0 ? " AND p.table_name = ?" : "") + (n3 != 0 ? " AND p.owner = ?" : "") + " ORDER BY p.owner, p.constraint_name, pc.position");
                } else {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Using Oracle8 query for constraints");
                    }
                    statement = connection.prepareStatement("SELECT p.owner, p.constraint_name,p.constraint_type, p.table_name, p.search_condition,decode(p.delete_rule, 'CASCADE', 1, 0) as delete_rule,decode(p.status,'ENABLED', 1, 0) as status,decode(p.deferrable, 'NOT DEFERRABLE', 2, 0) as deferrable,decode(p.deferred, 'IMMEDIATE', 0, 1) as deferred,decode(p.validated, 'VALIDATED', 1, 0) as validated,pc.column_name,pc.position,p.r_constraint_name,p.r_owner FROM all_cons_columns pc,all_constraints p WHERE pc.owner = p.owner AND pc.constraint_name = p.constraint_name AND pc.table_name = p.table_name" + (n2 != 0 ? " AND p.table_name = ?" : "") + (n3 != 0 ? " AND p.owner = ?" : "") + " ORDER BY p.owner, p.constraint_name, pc.position");
                }
                if (n2 != 0) {
                    statement.setString(n2, string3);
                }
                if (n3 != 0) {
                    statement.setString(n3, string2);
                }
                oracleResultSet = (OracleResultSet)statement.executeQuery();
                while (oracleResultSet.next()) {
                    Object[] objectArray = new Object[14];
                    int n4 = 0;
                    while (n4 < 14) {
                        switch (n4) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 10: 
                            case 12: 
                            case 13: {
                                objectArray[n4] = oracleResultSet.getString(n4 + 1);
                                break;
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 11: {
                                objectArray[n4] = new Integer(oracleResultSet.getInt(n4 + 1));
                                break;
                            }
                        }
                        ++n4;
                    }
                    arrayList.add((Object)objectArray);
                    BaseSQLBuilderImpl.dumpConstraint(objectArray);
                }
                Object var16_15 = null;
                if (oracleResultSet == null) break block21;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (oracleResultSet != null) {
                    oracleResultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            oracleResultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("OracleSQLBuilder: found " + arrayList.size() + " constraints for table: '" + string3 + "'");
        }
        return arrayList;
    }

    public String getBaseTable(Connection connection, String string, String string2) throws SQLException {
        String string3 = string2;
        String string4 = string;
        try {
            String string5 = JboDTUtils.getSchema(string2);
            if (string5 != null) {
                string = string5;
                string2 = JboDTUtils.getTable(string2);
            }
            if (!this.resolveTableName(connection, string = JboDTUtils.stripQuotesAndUpper(string), string3 = JboDTUtils.stripQuotesAndUpper(string2))) {
                ArrayList arrayList = this.resolveSynonymToTable(connection, string, string3);
                if (arrayList != null) {
                    string = (String)arrayList.get(0);
                    string3 = (String)arrayList.get(1);
                } else {
                    ArrayList arrayList2 = this.resolveSynonymToTable(connection, "PUBLIC", string3);
                    if (arrayList2 != null) {
                        string = (String)arrayList2.get(0);
                        string3 = (String)arrayList2.get(1);
                    }
                }
            }
            if (!string3.toUpperCase().equals(string3) || string3.indexOf(" ") != -1) {
                string3 = "\"" + string3 + "\"";
            }
            if (string4 != null && string != null && !string4.equalsIgnoreCase(string)) {
                string3 = string + "." + string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    /*
     * Loose catch block
     */
    private boolean resolveTableName(Connection connection, String string, String string2) {
        boolean bl;
        block16: {
            ResultSet resultSet;
            Statement statement;
            block15: {
                statement = null;
                resultSet = null;
                String string3 = string != null ? "all_tables" : "user_tables";
                String string4 = string != null ? "all_views" : "user_views";
                bl = false;
                if (string2 == null) {
                    return false;
                }
                statement = connection.prepareStatement("SELECT t.table_name FROM " + string3 + " t WHERE " + "t.table_name = '" + string2 + "' " + (string != null ? "AND OWNER = '" + string + "' " : "") + "UNION ALL SELECT v.view_name FROM " + string4 + " v WHERE " + "v.view_name = '" + string2 + "' " + (string != null ? "AND OWNER = '" + string + "' " : ""));
                resultSet = statement.executeQuery();
                if (!resultSet.next()) break block15;
                bl = true;
            }
            Object var12_9 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                break block16;
            }
            catch (Exception exception) {}
            break block16;
            {
                catch (Exception exception) {
                    Object var12_10 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                            resultSet = null;
                        }
                        if (statement != null) {
                            statement.close();
                            statement = null;
                        }
                        break block16;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private ArrayList resolveSynonymToTable(Connection connection, String string, String string2) {
        boolean bl;
        block18: {
            Statement statement = null;
            ResultSet resultSet = null;
            String string3 = string != null ? "all_synonyms" : "user_synonyms";
            boolean bl2 = string != null;
            bl = false;
            if (string2 == null) {
                return null;
            }
            statement = connection.prepareStatement("SELECT syn.table_owner, syn.table_name  FROM " + string3 + " syn " + " WHERE " + " syn.synonym_name = ?" + (bl2 ? " AND syn.owner = ?" : ""));
            while (true) {
                statement.setString(1, string2);
                if (bl2) {
                    statement.setString(2, string);
                }
                if (!(resultSet = statement.executeQuery()).next()) break;
                string = resultSet.getString(1);
                string2 = resultSet.getString(2);
                bl = true;
            }
            Object var13_9 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
                break block18;
            }
            catch (Exception exception) {}
            break block18;
            {
                catch (Exception exception) {
                    Object var13_10 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                            resultSet = null;
                        }
                        if (statement != null) {
                            statement.close();
                            statement = null;
                        }
                        break block18;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (bl) {
            ArrayList arrayList = new ArrayList(2);
            arrayList.add((Object)string);
            arrayList.add((Object)string2);
            return arrayList;
        }
        return null;
    }

    protected String getJDBCDriverClassName(String string) {
        return "oracle.jdbc.driver.OracleDriver";
    }

    protected String getFormattedRHSCompareFragment(ViewObject viewObject, ViewCriteria viewCriteria, AttributeDef attributeDef, int n, String string) {
        if (JboTypeMap.isDateType(n)) {
            if (dateClass == null) {
                try {
                    dateClass = Class.forName("oracle.jbo.domain.Date");
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            if (string != null && attributeDef.getJavaType().equals(dateClass) && (attributeDef.getProperty("FMT_FORMAT") == null || viewCriteria != null && viewCriteria.isUseAttributeFormatHint())) {
                return "TO_DATE('" + string + "', 'yyyy-mm-dd')";
            }
        }
        return super.getFormattedRHSCompareFragment(viewObject, viewCriteria, attributeDef, n, string);
    }

    protected String getFormattedLHSCompareFragment(ViewObject viewObject, ViewCriteria viewCriteria, AttributeDef attributeDef, int n, String string, Object object) {
        if (JboTypeMap.isDateType(n)) {
            if (dateClass == null) {
                try {
                    dateClass = Class.forName("oracle.jbo.domain.Date");
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            if (sqlTimestampClass == null) {
                try {
                    sqlTimestampClass = Class.forName("java.sql.Timestamp");
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            if (timestampClass == null) {
                try {
                    timestampClass = Class.forName("oracle.jbo.domain.Timestamp");
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            Class clazz = attributeDef.getJavaType();
            if (object != null && (dateClass.equals(clazz) || timestampClass.equals(clazz) || sqlTimestampClass.equals(clazz) || clazz == null) && (attributeDef.getProperty("FMT_FORMAT") == null || viewCriteria != null && viewCriteria.isUseAttributeFormatHint())) {
                if (dateClass.equals(clazz)) {
                    if (object.toString().indexOf(TO_DATE_FRAG) < 0) {
                        return "TO_CHAR( " + string + ", 'yyyy-mm-dd')";
                    }
                } else if (object.toString().indexOf(TO_TIMESTAMP_FRAG) < 0) {
                    return "TO_CHAR( TO_TIMESTAMP(" + string + "), 'yyyy-mm-dd hh24:mi:ss.ff1')";
                }
            }
        }
        return super.getFormattedLHSCompareFragment(viewObject, viewCriteria, attributeDef, n, string, object);
    }

    protected String getSqlVariantLockTrailer(EntityImpl entityImpl) {
        return this.getSqlVariantLockTrailer();
    }

    protected String getSqlVariantLockTrailer() {
        return DEFAULT_LOCK_TRAILER;
    }

    public String getDbTimeQuery() {
        return "select sysdate from dual";
    }

    public String getDropTableSQL(String string) {
        if (string == null) {
            return null;
        }
        return "DROP TABLE " + string + " CASCADE CONSTRAINTS";
    }

    public boolean isDisplayBindValueUI() {
        return false;
    }

    public String getCreateSequenceInsertTriggerSQL(String string, String string2, String string3, String string4) {
        return "create trigger " + string + " before insert on " + string2 + " for each row begin select " + string3 + ".nextval into :new." + string4 + " from dual; end;";
    }

    public String getCreateSequenceSQL(String string, int n) {
        return "create sequence " + string + " start with " + String.valueOf(n);
    }

    public String getDropSequenceSQL(String string) {
        return "drop sequence " + string;
    }

    public boolean isConnectionAlive(Connection connection) {
        if (connection == null) {
            return false;
        }
        boolean bl = false;
        if (mPingDatabaseMethodExists < 0) {
            mPingDatabaseMethodExists = 0;
            try {
                Method method = connection.getClass().getMethod("pingDatabase", Integer.TYPE);
                if (method != null) {
                    mPingDatabaseMethodExists = 1;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (mPingDatabaseMethodExists == 0) {
            bl = super.isConnectionAlive(connection);
        } else {
            try {
                int n = ((OracleConnection)connection).pingDatabase(1000);
                if (n == 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public Object convertValueToStorageType(Object object) {
        return object instanceof Datum ? object : super.convertValueToStorageType(object);
    }

    public void jdbcClientSideSecurity(Properties properties, Hashtable hashtable) {
        String[] stringArray = new String[]{"oracle.net.encryption_client", "oracle.net.crypto_checksum_client", "oracle.net.encryption_types_client", "oracle.net.crypto_checksum_types_client", "oracle.net.crypto_seed"};
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = (String)hashtable.get(string);
            if (string2 != null) {
                properties.put(string, string2);
            }
            ++n;
        }
    }

    public boolean compareFetchedValue(EntityImpl entityImpl, AttributeDefImpl attributeDefImpl, Object object, Object object2) {
        if (EntityImpl.compareAttrVals(object, object2)) {
            return true;
        }
        return object2 == null && object != null && JboTypeMap.isCharType(attributeDefImpl.getSQLType()) && object.toString().length() == 0;
    }

    protected int bindParamValue(int n, Object object, DBTransactionImpl dBTransactionImpl, PreparedStatement preparedStatement, AttributeDefImpl attributeDefImpl, int n2, boolean bl) throws SQLException {
        if (n != 2) {
            return super.bindParamValue(n, object, dBTransactionImpl, preparedStatement, attributeDefImpl, n2, bl);
        }
        String string = (String)((Object[])object)[0];
        if ((object = ((Object[])object)[1]) != null && !(object instanceof NullValue)) {
            if (attributeDefImpl != null) {
                object = attributeDefImpl.convertToStorage(object, dBTransactionImpl);
            }
            if (object != null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Binding param \"" + string + "\": " + object);
                }
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.setObjectAtName(preparedStatement, string, object, attributeDefImpl);
                }
                ((OraclePreparedStatement)preparedStatement).setObjectAtName(string, object);
                return n2;
            }
        }
        if (!bl) {
            int n3 = 0;
            if (attributeDefImpl != null) {
                n3 = attributeDefImpl.getSQLType();
            }
            if (n3 == 0) {
                int n4 = n3 = object instanceof NullValue ? ((NullValue)object).getSQLTypeId() : 12;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("Binding null of type " + n3 + " for \"" + string + "\"");
            }
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.setNullAtName(preparedStatement, string, n3, attributeDefImpl);
            }
            ((OraclePreparedStatement)preparedStatement).setNullAtName(string, n3);
        }
        return n2;
    }

    public void processException(String string, Exception exception, Object[] objectArray) {
        int n;
        if (string.equals("27122") && exception instanceof SQLException && (n = ((SQLException)exception).getErrorCode()) == 1013) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = OracleSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27126", (String)objectArray[0], exception);
        }
        super.processException(string, exception, objectArray);
    }

    public boolean invalidDatumFactoryUsage(String string, int n, Class clazz) {
        if (mCoverForJdbcBytesConversion) {
            String string2 = null;
            switch (n) {
                case -1: 
                case 1: 
                case 12: {
                    string2 = "oracle.jbo.domain.Char";
                    break;
                }
                case -6: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string2 = "oracle.jbo.domain.Number";
                    break;
                }
                case 91: {
                    string2 = "oracle.jbo.domain.Date";
                    break;
                }
                case -102: 
                case -101: 
                case -100: 
                case 93: {
                    string2 = "oracle.jbo.domain.Timestamp";
                    break;
                }
                case -2: {
                    string2 = "oracle.jbo.domain.Raw";
                }
            }
            if (string2 != null) {
                int n2;
                if (JBOClass.findDataClass(string2).isAssignableFrom(clazz) && ((n2 = JboTypeMap.columnTypeToSQLTypeId(string, n)) == n || JboTypeMap.getTypeGroup(n) == JboTypeMap.getTypeGroup(n2))) {
                    return false;
                }
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Warning! TypeFactory in class:" + clazz.getName() + " ignored.");
                    Diagnostic.println("Data bytes for Column Type(" + string + ") cannot be converted to jdbc Type id:" + n);
                    Diagnostic.println("Using Object conversion instead.");
                }
                return true;
            }
        }
        return false;
    }

    public void setSessionTimeZone(Connection connection, String string) {
        try {
            ((OracleConnection)connection).setSessionTimeZone(string);
        }
        catch (SQLException sQLException) {
            Diagnostic.println("OracleSQLBuilderImpl.setSessionTimeZone failed...");
            Diagnostic.println("X/Open SQL State is: " + sQLException.getSQLState());
            Diagnostic.printStackTrace(sQLException);
        }
    }

    static {
        TO_DATE_FRAG = "TO_D";
        TO_TIMESTAMP_FRAG = "TO_T";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

