/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Vector;
import oracle.jbo.AttrSetValException;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.BatchDMLException;
import oracle.jbo.DMLException;
import oracle.jbo.DeadEntityAccessException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidOwnerException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.ReadOnlyAttrException;
import oracle.jbo.RemoveWithDetailsException;
import oracle.jbo.Row;
import oracle.jbo.RowAlreadyDeletedException;
import oracle.jbo.RowCreateException;
import oracle.jbo.RowInconsistentException;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSet;
import oracle.jbo.RowValException;
import oracle.jbo.StructureDef;
import oracle.jbo.TooManyObjectsException;
import oracle.jbo.UpdateAttrPrivilegeException;
import oracle.jbo.ValidationException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.domain.BlobDomainInterface;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.DomainAttributeDef;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AssociationEnd;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.Entity;
import oracle.jbo.server.EntityAssociation;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityRowSetImpl;
import oracle.jbo.server.JboMessageObject;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.RowImpl;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.Serializer;
import oracle.jbo.server.SessionImpl;
import oracle.jbo.server.SparseArray;
import oracle.jbo.server.SparseArrayInterface;
import oracle.jbo.server.TransactionEvent;
import oracle.jbo.server.TransactionListener;
import oracle.jbo.server.TransactionManager;
import oracle.jbo.server.TransactionPostListener;
import oracle.jbo.server.ValidationBeanLoader;
import oracle.jbo.server.ValidationListener;
import oracle.jbo.server.ValidationManager;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowSetImpl;
import oracle.jbo.server.util.PropertyChangeEvent;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntityImpl
extends RowImpl
implements DomainOwnerInterface,
Entity {
    protected static final int DML_INSERT = 1;
    protected static final int DML_UPDATE = 2;
    protected static final int DML_DELETE = 3;
    protected static final String ORACLE_ROWID_COLUMN = "ROWID".intern();
    protected static final int MAXATTRCONST = 0;
    static final byte IS_VALID = 0;
    static final byte BEING_VALIDATED = 1;
    static final byte IS_INVALID = 2;
    static final byte IN_POST_LISTENER_LIST = 1;
    static final byte IN_TRANS_LISTENER_LIST = 2;
    static final int MAX_ROWID_GEN_TRIES = 100;
    private final int IN_CACHE_ROW_LIST;
    private final int IN_CACHE_MODIFIED_LIST;
    private Object mContainer;
    private ArrayList mValidationListeners;
    private ArrayList mTransactionListeners;
    private int mTransPostHdl;
    private boolean mPostedToDB;
    SparseArrayInterface mData;
    SparseArray mTransOrigData;
    SparseArray mOrigData;
    SparseArray mTempOrigData;
    private BitSet mChanged;
    private int mChangedCount;
    private Object[] mDynAttrData;
    private BitSet mErrChanged;
    private byte mErrState;
    private byte mState;
    private byte mEffectiveState;
    private byte mValidated;
    private byte mInListenerList;
    private byte mPKChanged;
    private byte mInCache;
    private boolean mLocked;
    private final byte DEFAULT;
    private final byte IN_CREATE;
    private final byte CREATED;
    private final byte CASCADE_UPDATE_PK;
    private byte mInitState;
    private DBTransaction mDBTransaction;
    private EntityCache mEntityCache;
    EntityDefImpl mEbi;
    static final String XML_POSTSTATE_TAG = "PS";
    static final String XML_EXCEPTION_TAG = "ex";
    static final String XML_MORIGDATA_TAG = "ORIG_DATA";
    static final String XML_MDATA_TAG = "DATA";
    static final byte CURRENT_VERSION = 0;
    static final byte ORIGINAL_VERSION = 1;
    public static String XML_CI_CHANGED = "CI";
    public static String XML_PK_CHANGED = "PK";
    public static String XML_PK_CHANGED_YES = "Y";
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.IN_CACHE_ROW_LIST = 1;
        this.IN_CACHE_MODIFIED_LIST = 2;
        this.mContainer = null;
        this.mValidationListeners = null;
        this.mTransactionListeners = null;
        this.mTransPostHdl = -1;
        this.mTempOrigData = null;
        this.mChangedCount = 0;
        this.mDynAttrData = null;
        this.mErrState = 1;
        this.mState = 1;
        this.mEffectiveState = 1;
        this.mValidated = 0;
        this.mInListenerList = 0;
        this.mPKChanged = 0;
        this.mInCache = 0;
        this.mLocked = false;
        this.DEFAULT = 0;
        this.IN_CREATE = 1;
        this.CREATED = (byte)2;
        this.CASCADE_UPDATE_PK = (byte)3;
        this.mInitState = 0;
        this.mEntityCache = null;
    }

    public EntityImpl() {
        this.$init$();
    }

    void init(DBTransaction dBTransaction, EntityDefImpl entityDefImpl) {
        this.mDBTransaction = dBTransaction;
        this.mEbi = entityDefImpl;
        int n = this.mEbi.mAttrAccessors.size();
        this.mData = this.initData(n);
        this.mTransOrigData = null;
        this.mOrigData = new SparseArray(n);
        this.mTempOrigData = null;
        this.mChanged = new BitSet(n);
        this.mChangedCount = 0;
        this.initDynamicAttrArray();
    }

    protected SparseArrayInterface initData(int n) {
        return new SparseArray(n);
    }

    void initDynamicAttrArray() {
        int n = this.getDynamicAttributeCount();
        if (n > 0) {
            this.mDynAttrData = new Object[n];
        }
    }

    protected void create(AttributeList attributeList) {
        this.internalCreate(attributeList);
        if (this.mState == -1) {
            this.addInitializedEntityToCache();
        }
        this.mInitState = (byte)2;
    }

    void callCreate(AttributeList attributeList) {
        if (this.mInitState != 2) {
            this.mInitState = 1;
            try {
                this.create(attributeList);
                this.mInitState = (byte)2;
                Key key = this.getKey();
                if (key != null && !key.isNull() && !this.isInCache() && this.mPKChanged != 0) {
                    this.getEntityCache().add(this);
                    AttributeDefImpl[] attributeDefImplArray = this.mEbi.getPrimaryKeys();
                    int[] nArray = new int[attributeDefImplArray.length];
                    Object[] objectArray = new Object[attributeDefImplArray.length];
                    int n = 0;
                    while (n < attributeDefImplArray.length) {
                        nArray[n] = attributeDefImplArray[n].getIndex();
                        objectArray[n] = this.getAttributeValue(attributeDefImplArray[n]);
                        ++n;
                    }
                    this.notifyAttributesChanged(nArray, objectArray);
                }
                Object var8_7 = null;
                if (this.mInitState < 2) {
                    this.mInitState = 0;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (this.mInitState < 2) {
                    this.mInitState = 0;
                }
                throw throwable;
            }
        }
    }

    private void internalCreate(AttributeList attributeList) {
        if (this.mInitState == 2) {
            return;
        }
        EntityDefImpl entityDefImpl = this.getEntityDef();
        AssociationDefImpl[] associationDefImplArray = entityDefImpl.getAssociationDefImpls();
        if (associationDefImplArray != null) {
            int n = 0;
            while (n < associationDefImplArray.length) {
                if (associationDefImplArray[n].hasContainer()) {
                    EntityImpl entityImpl;
                    if (attributeList != null) {
                        AttributeDefImpl[] attributeDefImplArray = associationDefImplArray[n].getAttributeDefImpls();
                        AttributeDefImpl[] attributeDefImplArray2 = associationDefImplArray[n].getOtherAttributeDefImpls();
                        int n2 = 0;
                        while (n2 < attributeDefImplArray.length) {
                            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n2];
                            if (attributeList.getAttributeIndexOf(attributeDefImpl.mName) > -1) {
                                this.populateAttributeAsChanged(attributeDefImpl.mIndex, attributeDefImpl.convertToJava(attributeList.getAttribute(attributeDefImpl.mName)));
                            } else if (attributeList.getAttributeIndexOf(attributeDefImplArray2[n2].mName) > -1) {
                                this.populateAttributeAsChanged(attributeDefImpl.mIndex, attributeDefImpl.convertToJava(attributeList.getAttribute(attributeDefImplArray2[n2].mName)));
                            }
                            ++n2;
                        }
                    }
                    if ((entityImpl = (EntityImpl)associationDefImplArray[n].getContainer(this)) == null) {
                        String string;
                        Object object;
                        if (attributeList instanceof EntityImpl) {
                            EntityImpl entityImpl2 = (EntityImpl)attributeList;
                            if (entityImpl2.getEntityDef() == associationDefImplArray[n].getOtherAssociationEnd().getOwner()) {
                                entityImpl = entityImpl2;
                            }
                        } else if (attributeList != null && (object = attributeList.getAttribute(string = associationDefImplArray[n].getAssociation().getName() + "." + associationDefImplArray[n].getOtherEndName())) instanceof EntityImpl && ((EntityImpl)object).getEntityDef() == associationDefImplArray[n].getOtherAssociationEnd().getOwner()) {
                            entityImpl = (EntityImpl)object;
                        }
                        if (entityImpl == null) {
                            Class clazz = class$oracle$jbo$CSMessageBundle;
                            if (clazz == null) {
                                clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                            }
                            throw new InvalidOwnerException(clazz, "25030", this.getEntityDef().getName(), this.getPrimaryKey());
                        }
                    }
                    if (this.mContainer != null) {
                        this.adjustContainership((TransactionManager)this.mContainer, entityImpl, true);
                    } else {
                        this.mContainer = entityImpl;
                        this.lockTopLevelEntity();
                    }
                    if (entityImpl.getPostState() == 1) {
                        entityImpl.setInvalid();
                    }
                    if (this.getPostState() != -1) {
                        entityImpl.addToTransactionManager();
                        entityImpl.addToValidationListeners(this);
                        this.addToTransactionManager();
                    }
                }
                ++n;
            }
        }
        if (!MetaObjectManager.getSingleton().is903Compatible() && this.getPostState() != -1) {
            this.setInvalid();
        }
    }

    void initActivatedEntity(AttributeList attributeList) {
        try {
            this.internalCreate(attributeList);
            this.addInitializedEntityToCache();
        }
        catch (Exception exception) {
            this.removeFromValidationManager();
            this.removeFromTransactionPostManager();
            this.removeFromTransactionManager();
            if (exception instanceof JboException) {
                throw (JboException)exception;
            }
            throw new RowCreateException(true, this.getEntityDef().getName(), exception);
        }
    }

    void addInitializedEntityToCache() {
        if (!this.mDBTransaction.isTrackNewAndModifiedRowsOnly() && this.getPostState() == -1) {
            this.setState((byte)0);
        } else if (!this.isInCache()) {
            AttributeDefImpl[] attributeDefImplArray = this.mEbi.getPrimaryKeys();
            Object var2_2 = null;
            int n = 0;
            int n2 = 0;
            while (n2 < attributeDefImplArray.length) {
                if (this.mChanged.get(attributeDefImplArray[n2].mIndex) && this.mData.get(attributeDefImplArray[n2].mIndex) != null) {
                    ++n;
                } else if (this.mEbi.isRowIDPrimaryKey() && attributeDefImplArray[n2].mColumnName == ORACLE_ROWID_COLUMN) {
                    ++n;
                } else if (this.mEbi.mOIDAttribute != null && attributeDefImplArray[n2] == this.mEbi.mOIDAttribute) {
                    ++n;
                }
                ++n2;
            }
            if (n > 0) {
                this.getEntityCache().add(this);
            }
        }
        this.mInitState = (byte)2;
    }

    protected void initDefaults() {
        this.setState(this.mDBTransaction.isTrackNewAndModifiedRowsOnly() ? (byte)-1 : 0);
        ArrayList arrayList = this.mEbi.mAttrAccessors;
        int n = 0;
        while (n < arrayList.size()) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)arrayList.get(n);
            this.populateAttribute(n, attributeDefImpl.getDefaultValue());
            if (attributeDefImpl.mDefaultValue != null) {
                this.setAttributeChanged(n, true);
            }
            ++n;
        }
        if (this.mEbi.isOIDInPrimaryKey()) {
            this.initialRefAndOID();
        } else if (this.mEbi.isRowIDPrimaryKey()) {
            this.initialRowID();
        }
        this.initHistoryColumns();
    }

    void initHistoryColumns() {
        if (!this.mEbi.hasHistory()) {
            return;
        }
        AttributeDefImpl[] attributeDefImplArray = this.mEbi.getHistoryAttributeDefImpls();
        int n = 0;
        while (n < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n];
            if (attributeDefImpl.getUpdateableFlag() == 1 && !attributeDefImpl.isRetrievedOnInsert()) {
                Object object = this.getHistoryContextForAttribute(attributeDefImpl);
                this.populateAttribute(attributeDefImpl.getIndex(), object);
                this.setAttributeChanged(attributeDefImpl.getIndex(), true);
            }
            ++n;
        }
    }

    public Object getAttribute(String string) {
        return this.getAttribute(this.findAttrAndGetIndex(string));
    }

    public Object getAttribute(int n) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
        try {
            Object object = this.getAttrInvokeAccessor(n, attributeDefImpl);
            return object;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof JboException) {
                throw (JboException)throwable;
            }
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
            }
            AttrValException attrValException = new AttrValException(121, clazz, "27019", this.getEntityDef().getFullName(), attributeDefImpl.getName());
            attrValException.setRowKey(121, this.getKey());
            attrValException.addToDetails(throwable);
            throw attrValException;
        }
    }

    protected Object getAttrInvokeAccessor(int n, AttributeDefImpl attributeDefImpl) throws Exception {
        return attributeDefImpl.resolveGet(this);
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(this.findAttrAndGetIndex(string), object);
    }

    private void processAttributeException(AttributeDef attributeDef, Object object, JboException jboException) {
        if (!(jboException instanceof ValidationException)) {
            throw jboException;
        }
        this.registerAttributeException(attributeDef, object, jboException);
    }

    protected void registerAttributeException(AttributeDef attributeDef, Object object, JboException jboException) {
        AttrValException attrValException = null;
        String string = attributeDef.getName();
        if (this.mDeferredExceptions == null) {
            this.mDeferredExceptions = new HashMap(this.getAttributeCount());
        } else {
            attrValException = (AttrValException)this.mDeferredExceptions.get((Object)string);
        }
        if (attrValException == null) {
            if (jboException instanceof AttrValException) {
                attrValException = (AttrValException)jboException;
            } else {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                }
                attrValException = new AttrSetValException(121, clazz, "27025", this.getEntityDef().getFullName(), string, object, new Exception[]{jboException}, true);
            }
        } else if (attrValException.hasPeerExceptions()) {
            attrValException.addToExceptions(jboException);
        } else {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
            }
            attrValException = new AttrSetValException(121, clazz, "27025", this.getEntityDef().getFullName(), string, object, new Exception[]{attrValException, jboException}, true);
        }
        if (attrValException.getEntityKey() == null) {
            attrValException.setRowKey(121, this.getKey());
        }
        this.mDeferredExceptions.put((Object)string, (Object)attrValException);
        this.setInvalid();
    }

    public void setAttribute(int n, Object object) {
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
        try {
            if (!this.hasUpdatePrivilege(n)) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new UpdateAttrPrivilegeException(121, clazz, "24003", this.getEntityDef().getFullName(), attributeDefImpl.getName());
            }
            if (!this.isAttributeUpdateable(n)) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new ReadOnlyAttrException(121, clazz, "27004", this.getEntityDef().getFullName(), attributeDefImpl.getName());
            }
            if (object != null && attributeDefImpl.mJavaType != null && !attributeDefImpl.mJavaType.isInstance(object)) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                }
                AttrSetValException attrSetValException = new AttrSetValException(121, clazz, "27018", this.getEntityDef().getFullName(), attributeDefImpl.getName(), object);
                attrSetValException.setRowKey(121, this.getKey());
                throw attrSetValException;
            }
            if (this.mDeferredExceptions != null) {
                this.clearAttributeException(attributeDefImpl.getName());
            }
            this.setAttrInvokeAccessor(n, object, attributeDefImpl);
        }
        catch (JboException jboException) {
            if (!this.getDBTransactionImpl().isBundledExceptionMode()) {
                throw jboException;
            }
            this.processAttributeException(attributeDefImpl, object, jboException);
        }
        catch (Exception exception) {
            Class clazz;
            Throwable throwable = exception;
            if (Diagnostic.isOn()) {
                Diagnostic.println("EntityImpl.setAttribute failed...");
                Diagnostic.printStackTrace(exception);
            }
            if (exception instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)exception).getTargetException();
                if (Diagnostic.isOn()) {
                    Diagnostic.println("*** InvocationTargetException inner exception");
                    Diagnostic.printStackTrace(exception);
                }
                if (throwable instanceof JboException) {
                    if (!this.getDBTransactionImpl().isBundledExceptionMode()) {
                        throw (JboException)throwable;
                    }
                    this.processAttributeException(attributeDefImpl, object, (JboException)throwable);
                    return;
                }
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
            }
            AttrSetValException attrSetValException = new AttrSetValException(121, clazz, "27020", this.getEntityDef().getFullName(), attributeDefImpl.getName(), object);
            attrSetValException.setRowKey(121, this.getKey());
            attrSetValException.addToDetails(throwable);
            if (!this.getDBTransactionImpl().isBundledExceptionMode()) {
                throw attrSetValException;
            }
            this.processAttributeException(attributeDefImpl, object, attrSetValException);
        }
    }

    protected void setAttrInvokeAccessor(int n, Object object, AttributeDefImpl attributeDefImpl) throws Exception {
        attributeDefImpl.resolveSet(this, object);
    }

    protected void setAttributeInternal(int n, Object object) {
        this.getAttributeDefImpl(n).set(this, object);
    }

    void OnMessage(String string, JboMessageObject jboMessageObject) {
    }

    public StructureDef getStructureDef() {
        return this.getEntityDef();
    }

    protected EntityDefImpl getEntityDef() {
        return this.mEbi;
    }

    protected SQLBuilder getSQLBuilder() {
        return this.getDBTransactionImpl().getSQLBuilder();
    }

    protected ArrayList getTransactionListenersList() {
        Object object;
        ArrayList arrayList = new ArrayList();
        if (this.mTransactionListeners != null) {
            int n = 0;
            while (n < this.mTransactionListeners.size()) {
                object = this.mTransactionListeners.get(n);
                if (object instanceof Entity) {
                    arrayList.add(object);
                }
                ++n;
            }
        }
        if (!this.isValid() && this.mValidationListeners != null) {
            int n = 0;
            while (n < this.mValidationListeners.size()) {
                object = this.mValidationListeners.get(n);
                if (object instanceof Entity && (((EntityImpl)object).mInListenerList & 1) == 0) {
                    arrayList.add(object);
                }
                ++n;
            }
        }
        return arrayList;
    }

    protected Vector getTransactionListeners() {
        return JboEnvUtil.convertArrayListToVector(this.getTransactionListenersList());
    }

    protected ArrayList getValidationListenersList() {
        ArrayList arrayList = new ArrayList();
        if (this.mValidationListeners != null) {
            int n = 0;
            while (n < this.mValidationListeners.size()) {
                arrayList.add(this.mValidationListeners.get(n));
                ++n;
            }
        }
        return arrayList;
    }

    protected Vector getValidationListeners() {
        return JboEnvUtil.convertArrayListToVector(this.getValidationListenersList());
    }

    void validateChildren() throws JboException {
        if (this.mValidationListeners != null) {
            int n = this.mValidationListeners.size();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                ValidationListener validationListener = (ValidationListener)this.mValidationListeners.get(n2);
                validationListener.validate();
                if (validationListener.isValid()) {
                    this.mValidationListeners.remove(n2);
                } else {
                    ++n2;
                }
                ++n3;
            }
        }
    }

    protected void clearAttributeException(int n) {
        if (this.mDeferredExceptions != null) {
            this.mDeferredExceptions.remove((Object)this.getAttributeDefImpls()[n].getName());
        }
    }

    protected boolean hasAttributeException(int n) {
        if (this.mDeferredExceptions != null) {
            return this.mDeferredExceptions.containsKey((Object)this.getAttributeDefImpl(n).getName());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void validateEntity() {
        block22: {
            block21: {
                if (!this.getDBTransactionImpl().isBundledExceptionMode()) {
                    if (this.mValidationListeners != null) {
                        if (this.mValidationListeners.size() > 0) {
                            this.validateChildren();
                        }
                        if (this.mValidationListeners.size() > 0) {
                            v0 = EntityImpl.class$oracle$jbo$CSMessageBundle;
                            if (v0 == null) {
                                v0 = EntityImpl.class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                            }
                            ValidationException.raise(v0, "27015", new Object[]{new Integer(this.mValidationListeners.size())}, new ArrayList());
                        }
                    }
                    this.getEntityDef().validate(this);
                    return;
                }
                var1_1 = null;
                try {
                    if (this.mValidationListeners == null) break block21;
                    var2_2 = this.getDBTransactionImpl().applyValidationThreshold() != false ? this.getDBTransaction().getValidationThreshold() : 1;
                    var3_3 = 0;
                    while (var3_3 < var2_2 && this.mValidationListeners.size() > 0) {
                        try {
                            this.validateChildren();
                        }
                        catch (JboException var4_4) {
                            if (var1_1 == null) {
                                var1_1 = new ArrayList(4);
                            }
                            var1_1.add((Object)var4_4);
                        }
                        ++var3_3;
                    }
                    if (this.mValidationListeners.size() > 0 && var2_2 > 1) {
                        v1 = EntityImpl.class$oracle$jbo$CSMessageBundle;
                        if (v1 == null) {
                            v1 = EntityImpl.class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                        }
                        ValidationException.raise(v1, "27015", new Object[]{new Integer(this.mValidationListeners.size())}, new ArrayList());
                    }
                }
                catch (JboException var5_5) {
                    if (var1_1 == null) {
                        var1_1 = new ArrayList(4);
                    }
                    var1_1.add((Object)var5_5);
                }
            }
            try {
                this.getEntityDef().validate(this);
            }
            catch (RowValException var6_6) {
                if (var1_1 == null) break block22;
                var7_7 = var6_6.getExceptions();
                var8_8 = 0;
                ** while (var8_8 < var7_7.length)
            }
lbl-1000:
            // 1 sources

            {
                var1_1.add((Object)var7_7[var8_8]);
                ++var8_8;
                continue;
            }
lbl52:
            // 1 sources

            var6_6.setExceptions((Throwable[])var1_1.toArray((Object[])new Throwable[var1_1.size()]));
        }
        throw var6_6;
        catch (JboException var9_9) {
            if (var1_1 == null) {
                var1_1 = new ArrayList(4);
            }
            var1_1.add((Object)var9_9);
        }
        if (var1_1 != null) {
            v2 = EntityImpl.class$oracle$jbo$CSMessageBundle;
            if (v2 == null) {
                v2 = EntityImpl.class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new RowValException(v2, "27024", this.getEntityDef().getFullName(), this.getKey(), var1_1, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void validate() throws JboException {
        if (this.isInvalid()) {
            block21: {
                this.mValidated = 1;
                var1_1 = null;
                var2_2 = this.getDBTransactionImpl().isBundledExceptionMode();
                if (var2_2) {
                    var3_3 = this.mEbi.mAttrAccessors;
                    var5_4 = var3_3.size();
                    var8_5 = this.mDeferredExceptions;
                    var9_6 = 0;
                    while (var9_6 < var5_4) {
                        var6_8 = (AttributeDefImpl)var3_3.get(var9_6);
                        var4_7 = null;
                        v0 = var7_9 = var8_5 != null ? (AttrValException)var8_5.get((Object)var6_8.getName()) : null;
                        if (var7_9 != null) {
                            if (!var7_9.getErrorCode().equals("27025") && !var7_9.getErrorCode().equals("25009") && (var7_9 = var6_8.validate(this, new PropertyChangeEvent(this, var6_8.mName, this.mOrigData.get(var9_6), this.mData.get(var9_6)), false)) != null) {
                                var4_7 = var7_9.getAttrValue();
                                var10_10 = var7_9.getExceptions();
                                var11_11 = 0;
                                while (var11_11 < var10_10.length) {
                                    this.registerAttributeException(var6_8, var4_7, (JboException)var10_10[var11_11]);
                                    ++var11_11;
                                }
                            }
                        } else if (this.isAttributeChanged(var9_6)) {
                            var4_7 = this.mData.get(var9_6);
                            var7_9 = var6_8.validate(this, new PropertyChangeEvent(this, var6_8.mName, this.mOrigData.get(var9_6), var4_7), false);
                            if (var7_9 != null) {
                                var12_12 = var7_9.getExceptions();
                                var13_13 = 0;
                                while (var13_13 < var12_12.length) {
                                    this.registerAttributeException(var6_8, var4_7, (JboException)var12_12[var13_13]);
                                    ++var13_13;
                                }
                            }
                        }
                        ++var9_6;
                    }
                }
                try {
                    this.validateEntity();
                    var1_1 = this.getAllExceptions();
                }
                catch (RowValException var14_14) {
                    var1_1 = this.getAllExceptions();
                    this.mValidated = (byte)2;
                    if (var1_1 == null) break block21;
                    var15_15 = var14_14.getExceptions();
                    var16_16 = 0;
                    ** while (var16_16 < var15_15.length)
                }
lbl-1000:
                // 1 sources

                {
                    var1_1.add((Object)var15_15[var16_16]);
                    ++var16_16;
                    continue;
                }
lbl52:
                // 1 sources

                var14_14.setExceptions((Throwable[])var1_1.toArray((Object[])new Throwable[var1_1.size()]));
            }
            throw var14_14;
            catch (Exception var17_17) {
                var1_1 = this.getAllExceptions();
                this.mValidated = (byte)2;
                if (var2_2) {
                    if (var1_1 == null) {
                        var1_1 = new ArrayList(4);
                    }
                    var1_1.add((Object)var17_17);
                }
                if (var1_1 != null && var1_1.size() > 0) {
                    var1_1.add((Object)var17_17);
                }
                if (var17_17 instanceof JboException) {
                    throw (JboException)var17_17;
                }
                v1 = EntityImpl.class$oracle$jbo$CSMessageBundle;
                if (v1 == null) {
                    v1 = EntityImpl.class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                }
                ValidationBeanLoader.raiseException(v1, "27012", this, null, this, "validate()", var17_17);
            }
            if (var1_1 != null) {
                this.mValidated = (byte)2;
                v2 = EntityImpl.class$oracle$jbo$CSMessageBundle;
                if (v2 == null) {
                    v2 = EntityImpl.class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new RowValException(v2, "27024", this.getEntityDef().getFullName(), this.getKey(), var1_1, true);
            }
            this.mDeferredExceptions = null;
            this.setValidated(this.mValidated == 1);
        }
    }

    AttributeDefImpl getAttributeDefImpl(String string) {
        return this.mEbi.getAttributeDefImpl(string);
    }

    AttributeDefImpl getAttributeDefImpl(int n) {
        return (AttributeDefImpl)this.mEbi.mAttrAccessors.get(n);
    }

    public void addToValidationListeners(ValidationListener validationListener) {
        if (this.mValidationListeners == null) {
            this.mValidationListeners = new ArrayList();
        }
        if (!this.mValidationListeners.contains((Object)validationListener)) {
            this.mValidationListeners.add((Object)validationListener);
            if (validationListener instanceof EntityImpl) {
                EntityImpl entityImpl = (EntityImpl)validationListener;
                entityImpl.setPostedToDB(false);
            }
            this.setInvalid();
        }
    }

    void removeFromValidationListeners(ValidationListener validationListener) {
        if (this.mValidationListeners != null && this.mValidationListeners.contains((Object)validationListener) && validationListener.isValid()) {
            this.mValidationListeners.remove((Object)validationListener);
        }
    }

    protected void setInvalid() {
        this.setValidated(false);
    }

    protected EntityImpl getContainerEntity() {
        if (this.getContainer() instanceof EntityImpl) {
            return (EntityImpl)this.mContainer;
        }
        return null;
    }

    Object getContainer() {
        if (this.mContainer == null) {
            AssociationDefImpl[] associationDefImplArray = this.getEntityDef().getAssociationDefImpls();
            if (associationDefImplArray != null) {
                int n = 0;
                while (n < associationDefImplArray.length) {
                    Object object = associationDefImplArray[n].getContainer(this);
                    if (object instanceof Entity) {
                        this.mContainer = object;
                        break;
                    }
                    ++n;
                }
            }
            if (this.mContainer == null) {
                this.mContainer = this.getDBTransaction();
            }
        }
        return this.mContainer;
    }

    boolean isContainerToBeLocked() {
        Object var1_1 = null;
        AssociationDefImpl[] associationDefImplArray = this.getEntityDef().getAssociationDefImpls();
        if (associationDefImplArray != null) {
            int n = 0;
            while (n < associationDefImplArray.length) {
                EntityAssociation entityAssociation;
                if (associationDefImplArray[n].hasContainer() && (entityAssociation = associationDefImplArray[n].getEntityAssociation()) != null && entityAssociation.getSourceEnd().isLockTopContainer()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    void setValidated(boolean bl) {
        if (this.mValidated != 2) {
            if (!bl) {
                ((ValidationManager)this.getContainer()).addToValidationListeners(this);
                this.validateHistoryColumns();
            } else if (this.mValidated == 1) {
                this.addToTransactionManager();
            }
        }
        this.mValidated = (byte)(bl ? 0 : 2);
    }

    public boolean isValid() {
        return this.mValidated == 0;
    }

    public boolean isInvalid() {
        return this.mValidated == 2;
    }

    protected int getDynamicAttributeCount() {
        return this.getEntityCache().getDynamicAttributeCount();
    }

    protected Object getDynamicAttributeValue(int n) {
        if (this.mDynAttrData == null || n >= this.mDynAttrData.length) {
            return null;
        }
        return this.mDynAttrData[n];
    }

    protected void setDynamicAttributeValue(int n, Object object) {
        if (this.mDynAttrData != null || n < this.mDynAttrData.length) {
            this.mDynAttrData[n] = object;
        }
    }

    protected final Object getAttributeValue(AttributeDefImpl attributeDefImpl) {
        int n;
        if (attributeDefImpl == null) {
            return null;
        }
        int n2 = attributeDefImpl.getIndex();
        if (n2 >= (n = this.getEntityDef().getAttributeCount())) {
            return this.getDynamicAttributeValue(n2 - n);
        }
        if (this.isAttributePopulated(n2)) {
            return this.mData.get(n2);
        }
        return null;
    }

    final Object getROWID() {
        return this.getAttributeValue(this.getEntityDef().getAttributeDefImplByColumnName(ORACLE_ROWID_COLUMN));
    }

    protected final Object getChangeIndicator() {
        return this.getAttributeValue(this.getEntityDef().getChangeIndicatorColumn());
    }

    Key retrievePrimaryKey(boolean bl, boolean bl2) {
        AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getPrimaryKeys();
        Object[] objectArray = new Object[attributeDefImplArray.length];
        boolean bl3 = true;
        int n = 0;
        while (n < objectArray.length) {
            Object object = null;
            int n2 = attributeDefImplArray[n].getIndex();
            if (bl) {
                object = this.mOrigData.get(n2);
            }
            if (object == null) {
                object = this.mData.get(n2);
            }
            objectArray[n] = object;
            if (objectArray[n] != null) {
                bl3 = false;
            }
            ++n;
        }
        if (bl3 && bl2) {
            return null;
        }
        return new Key(objectArray);
    }

    Key getOrigPrimaryKey() {
        return this.retrievePrimaryKey(true, false);
    }

    public Key getPrimaryKey() {
        return this.retrievePrimaryKey(false, true);
    }

    public final int getAttributeCount() {
        return this.getEntityCache().getAttributeCount();
    }

    protected Object getPKBasedRef(AttributeDefImpl attributeDefImpl) {
        Object object = this.mData.get(attributeDefImpl.mIndex);
        if (object == null) {
            object = this.getSQLBuilder().generatePKBasedRef(this);
            this.populateAttribute(attributeDefImpl.mIndex, object);
        }
        return object;
    }

    protected void resetPKBasedRef() {
        int n = this.getEntityDef().getRefAttrIndex();
        if (n >= 0) {
            this.populateAttribute(n, null);
            this.mData.clear(n);
        }
    }

    protected Object getAttributeInternal(int n) {
        EntityDefImpl entityDefImpl = this.getEntityDef();
        int n2 = entityDefImpl.getAttributeCount();
        if (n >= n2) {
            return this.getDynamicAttributeValue(n - n2);
        }
        AttributeDefImpl attributeDefImpl = (AttributeDefImpl)entityDefImpl.getAttributeDef(n);
        byte by = attributeDefImpl.getAttributeKind();
        if (by == 2 || by == 6) {
            String string;
            AttributeDef attributeDef;
            Object object;
            EntityCache entityCache = this.getEntityCache();
            boolean bl = entityCache.isAssociationAccessorRetained();
            int n3 = -1;
            if (bl && (object = this.getDynamicAttributeValue((n3 = (attributeDef = entityCache.findAttributeDef(string = EntityCache.assocAccResultAttrName(attributeDefImpl))).getIndex()) - n2)) != null) {
                return object;
            }
            object = attributeDefImpl.get(this);
            if (bl) {
                this.setDynamicAttributeValue(n3 - n2, object);
            }
            return object;
        }
        if (!this.isAttributePopulated(n)) {
            if (attributeDefImpl.mObjectTableRef && this.mEbi.isRefPKBased()) {
                return this.getPKBasedRef(attributeDefImpl);
            }
            if (by == 0 || by == 1) {
                this.populate();
            }
        }
        return this.mData.get(n);
    }

    void setAttributeValue(int n, Object object) {
        Object object2 = this.mData.get(n);
        this.setAttributeValueInternal(n, object);
        try {
            this.notifyAttributesChanged(new int[]{n}, new Object[]{object2});
        }
        catch (RuntimeException runtimeException) {
            this.populateAttribute(n, object2);
            AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
            if (attributeDefImpl.isPrimaryKey() && this.getPrimaryKey() == null) {
                this.removeFromValidationManager();
            }
            throw runtimeException;
        }
    }

    void setAttributeValueInternal(int n, Object object) {
        boolean bl;
        byte by = this.getPostState();
        if (by == 4 || by == 3) {
            throw new DeadEntityAccessException(this.getEntityDef().getName(), this.getPrimaryKey());
        }
        int n2 = this.getEntityDef().getAttributeCount();
        if (n >= n2) {
            this.setDynamicAttributeValue(n - n2, object);
            return;
        }
        AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mEbi.mAttrAccessors.get(n);
        Key key = attributeDefImpl.mPrimaryKey ? this.getPrimaryKey() : null;
        boolean bl2 = this.getDBTransaction().getLockingMode() == 1;
        boolean bl3 = bl = by == -1;
        if (bl) {
            this.setState((byte)0);
            by = 0;
        }
        if (by != 0 && attributeDefImpl.mKind == 0 && !this.isLocked()) {
            if (key != null || !attributeDefImpl.mPrimaryKey) {
                if (bl2) {
                    this.lock();
                } else if (!this.isAttributePopulated(n)) {
                    this.populate();
                }
            } else {
                this.setState((byte)0);
                by = 0;
            }
        } else if (by == 1 && this.isLocked()) {
            this.addToTransactionManager();
        }
        HashMap hashMap = null;
        if (attributeDefImpl.isCascadeUpdateParticipant()) {
            if (attributeDefImpl.isPrimaryKey() && by == 1) {
                this.mInitState = (byte)3;
            }
            hashMap = new HashMap(10);
            this.mEbi.collectCascadeUpdateMap(this, n, (Map)hashMap);
        }
        if (this.mValidated != 2) {
            this.setInvalid();
        }
        Object object2 = this.mData.get(n);
        if (!(by != 1 && by != 2 || this.mOrigData.isPopulated(n))) {
            this.mOrigData.set(n, object2);
        }
        if (attributeDefImpl.isPersistent()) {
            this.setAttributeChanged(n, true);
            this.populateAttribute(n, object);
        } else {
            this.populateAttributeAsChanged(n, object);
        }
        try {
            if (this.mContainer instanceof EntityImpl || this.mContainer == null) {
                AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getForeignKeyAttrs();
                int n3 = 0;
                while (n3 < attributeDefImplArray.length) {
                    if (attributeDefImplArray[n3].equals(attributeDefImpl)) {
                        TransactionManager transactionManager = (TransactionManager)this.getContainer();
                        this.mContainer = null;
                        TransactionManager transactionManager2 = (TransactionManager)this.getContainer();
                        if (transactionManager2 instanceof EntityImpl) {
                            this.adjustContainership(transactionManager, transactionManager2, false);
                            break;
                        }
                        this.mContainer = transactionManager;
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new InvalidOwnerException(clazz, "25030", this.getEntityDef().getName(), this.getPrimaryKey());
                    }
                    ++n3;
                }
            }
            if (by == 1) {
                by = 2;
                this.setState(by);
                if (!bl2) {
                    this.addToTransactionManager();
                }
            }
            if (attributeDefImpl.mPrimaryKey) {
                Key key2 = this.getPrimaryKey();
                if (this.mEbi.isRefPKBased()) {
                    this.resetPKBasedRef();
                }
                if (key2 == null) {
                    if (key != null) {
                        this.notifyBeforePKChange(new int[]{n}, new Object[]{object}, 1, key2);
                        this.getEntityCache().removeRow(this);
                    }
                } else if (key == null || !key2.equals(key)) {
                    if (key != null) {
                        this.notifyBeforePKChange(new int[]{n}, new Object[]{object}, 1, key2);
                    }
                    if (key == null) {
                        this.getEntityCache().add(this);
                    } else {
                        this.mPKChanged = 1;
                        this.getEntityCache().replace(this, key);
                    }
                }
            }
            if (hashMap != null) {
                this.mEbi.doCascadeUpdate(this, hashMap);
            }
        }
        catch (RuntimeException runtimeException) {
            this.populateAttribute(n, object2);
            this.mInitState = 0;
            if (attributeDefImpl.isPrimaryKey()) {
                if (key == null) {
                    this.removeFromValidationManager();
                } else {
                    this.getEntityCache().add(this);
                }
            }
            if (bl) {
                this.removeFromTransactionManager();
            }
            throw runtimeException;
        }
    }

    /*
     * Unable to fully structure code
     */
    void setAttributeValues(int[] var1_1, Object[] var2_2, boolean var3_3) {
        block51: {
            var4_4 = this.getPostState();
            if (var4_4 == 4 || var4_4 == 3) {
                throw new DeadEntityAccessException(this.getEntityDef().getName(), this.getPrimaryKey());
            }
            var5_5 = var1_1.length;
            var6_6 = new Object[var5_5];
            var7_7 = this.mEbi.mAttrAccessors;
            var8_8 = false;
            var9_9 = true;
            var11_10 = new AttributeDefImpl[var5_5];
            var12_11 = 0;
            while (var12_11 < var5_5) {
                var10_12 = var1_1[var12_11];
                var6_6[var12_11] = this.mData.get(var10_12);
                var11_10[var12_11] = (AttributeDefImpl)var7_7.get(var10_12);
                if (!var8_8 && var11_10[var12_11].isPrimaryKey()) {
                    var8_8 = true;
                }
                if (var9_9 && !this.isAttributePopulated(var10_12)) {
                    this.populate();
                    var9_9 = false;
                }
                ++var12_11;
            }
            var13_13 = this.getEntityDef().getAttributeCount();
            var14_14 = var8_8 != false ? this.getPrimaryKey() : null;
            var15_15 = this.getDBTransaction().getLockingMode() == 1;
            v0 = var16_16 = var4_4 == -1;
            if (var16_16) {
                this.setState((byte)0);
                var4_4 = 0;
            }
            if (var4_4 != 0 && !this.isLocked()) {
                if (var15_15) {
                    this.lock();
                } else if (var8_8 && var14_14 == null) {
                    this.setState((byte)0);
                    var4_4 = 0;
                }
            } else if (var4_4 == 1 && this.isLocked()) {
                this.addToTransactionManager();
            }
            var17_17 = null;
            var18_18 = 0;
            while (var18_18 < var5_5) {
                if (var11_10[var18_18].isCascadeUpdateParticipant()) {
                    if (var8_8 && var4_4 == 1) {
                        this.mInitState = (byte)3;
                    }
                    if (var17_17 == null) {
                        var17_17 = new HashMap(10);
                    }
                    this.mEbi.collectCascadeUpdateMap(this, var11_10[var18_18].getIndex(), (Map)var17_17);
                }
                ++var18_18;
            }
            if (this.mValidated != 2) {
                this.setInvalid();
            }
            var19_19 = 0;
            while (var19_19 < var5_5) {
                var10_12 = var1_1[var19_19];
                if (var3_3 && !this.isAttributeUpdateable(var10_12)) {
                    v1 = EntityImpl.class$oracle$jbo$CSMessageBundle;
                    if (v1 == null) {
                        v1 = EntityImpl.class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new ReadOnlyAttrException(121, v1, "27004", this.getEntityDef().getFullName(), var11_10[var19_19].getName());
                }
                if (var10_12 >= var13_13) {
                    this.setDynamicAttributeValue(var10_12 - var13_13, var2_2[var19_19]);
                } else {
                    if (!(var4_4 != 1 && var4_4 != 2 || this.mOrigData.isPopulated(var10_12))) {
                        this.mOrigData.set(var10_12, var6_6[var19_19]);
                    }
                    if (var11_10[var19_19].isPersistent()) {
                        this.setAttributeChanged(var10_12, true);
                        this.populateAttribute(var10_12, var2_2[var19_19]);
                    } else {
                        this.populateAttributeAsChanged(var10_12, var2_2[var19_19]);
                    }
                }
                ++var19_19;
            }
            try {
                if (this.mContainer instanceof EntityImpl || this.mContainer == null) {
                    var20_20 = this.getEntityDef().getForeignKeyAttrs();
                    var21_21 = false;
                    var22_22 = 0;
                    while (var22_22 < var20_20.length) {
                        var23_23 = 0;
                        while (var23_23 < var5_5) {
                            if (var20_20[var22_22] == var11_10[var23_23]) {
                                var21_21 = true;
                                break;
                            }
                            ++var23_23;
                        }
                        ++var22_22;
                    }
                    if (var21_21) {
                        var24_24 = (TransactionManager)this.getContainer();
                        this.mContainer = null;
                        var25_25 = (TransactionManager)this.getContainer();
                        if (var25_25 instanceof EntityImpl) {
                            this.adjustContainership(var24_24, var25_25, false);
                        } else {
                            this.mContainer = var24_24;
                            v2 = EntityImpl.class$oracle$jbo$CSMessageBundle;
                            if (v2 == null) {
                                v2 = EntityImpl.class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                            }
                            throw new InvalidOwnerException(v2, "25030", this.getEntityDef().getName(), this.getPrimaryKey());
                        }
                    }
                }
                if (var4_4 == 1) {
                    var4_4 = 2;
                    this.setState(var4_4);
                    if (!var15_15) {
                        this.addToTransactionManager();
                    }
                }
                if (var8_8) {
                    var26_26 = this.getPrimaryKey();
                    if (this.mEbi.isRefPKBased()) {
                        this.resetPKBasedRef();
                    }
                    if (var26_26 == null) {
                        if (var14_14 != null) {
                            this.notifyBeforePKChange(var1_1, var2_2, 1, var26_26);
                            this.getEntityCache().removeRow(this);
                        }
                    } else if (var14_14 == null || !var26_26.equals(var14_14)) {
                        if (var14_14 != null) {
                            this.notifyBeforePKChange(var1_1, var2_2, 1, var26_26);
                        }
                        if (var14_14 == null) {
                            this.getEntityCache().add(this);
                        } else {
                            this.mPKChanged = 1;
                            this.getEntityCache().replace(this, var14_14);
                        }
                    }
                }
                if (var17_17 != null) {
                    this.mEbi.doCascadeUpdate(this, var17_17);
                }
                this.notifyAttributesChanged(var1_1, var6_6);
                break block51;
            }
            catch (RuntimeException var27_27) {
                this.mInitState = 0;
                var28_28 = 0;
                ** while (var28_28 < var5_5)
            }
lbl-1000:
            // 1 sources

            {
                this.populateAttribute(var1_1[var28_28], var6_6[var28_28]);
                ++var28_28;
                continue;
            }
lbl134:
            // 1 sources

            if (var8_8) {
                if (var14_14 == null) {
                    this.removeFromValidationManager();
                } else {
                    this.getEntityCache().add(this);
                }
            }
            if (var16_16) {
                this.removeFromTransactionManager();
            }
            throw var27_27;
        }
    }

    public final DBTransaction getDBTransaction() {
        return this.mDBTransaction;
    }

    final DBTransactionImpl getDBTransactionImpl() {
        return (DBTransactionImpl)this.mDBTransaction;
    }

    public EntityCache getEntityCache() {
        if (this.mEntityCache == null) {
            this.mEntityCache = this.getDBTransactionImpl().findEntityCache(this.getEntityDef());
        }
        return this.mEntityCache;
    }

    protected boolean isAttributeChanged(int n) {
        return this.mChanged.get(n);
    }

    protected void setAttributeChanged(int n, boolean bl) {
        if (bl) {
            if (!this.mChanged.get(n)) {
                this.mChanged.set(n);
                ++this.mChangedCount;
            }
            if (this.getAttributeDefImpl(n).isPrimaryKey()) {
                this.mPKChanged = 1;
            }
        } else if (this.mChanged.get(n)) {
            this.mChanged.clear(n);
            if (this.mChangedCount == 0) {
                throw new JboException("Internal error: Attempt to set attr changed count negative");
            }
            --this.mChangedCount;
        }
    }

    protected int getAttributeChangedCount() {
        return this.mChangedCount;
    }

    protected final boolean isAttributeChangedInTransaction(int n) {
        return this.isAttributeChanged(n) || this.mTransOrigData != null && this.mData.get(n) != this.mTransOrigData.get(n);
    }

    protected Object getPostedAttribute(int n) {
        if (this.isAttributeChanged(n) && this.mOrigData.isPopulated(n)) {
            return this.mOrigData.get(n);
        }
        return this.getAttributeInternal(n);
    }

    protected boolean isAttributePopulated(int n) {
        return this.mData.isPopulated(n);
    }

    protected void setLocked(boolean bl) {
        this.mLocked = bl;
        if (bl && !(this.getContainer() instanceof EntityImpl)) {
            this.addToTransactionManager();
        }
    }

    public boolean isLocked() {
        return this.mLocked;
    }

    void setInRowList(boolean bl) {
        this.mInCache = bl ? (byte)(this.mInCache | 1) : (byte)(0xFFFFFFFE & this.mInCache);
    }

    boolean isInRowList() {
        return (this.mInCache & 1) != 0;
    }

    void setInModifiedList(boolean bl) {
        this.mInCache = bl ? (byte)(this.mInCache | 2) : (byte)(0xFFFFFFFD & this.mInCache);
    }

    boolean isInModifiedList() {
        return (this.mInCache & 2) != 0;
    }

    public boolean isInCache() {
        return this.mInCache != 0;
    }

    boolean isPKChanged() {
        if (this.mPKChanged == 0) {
            return false;
        }
        Key key = this.getPrimaryKey();
        Key key2 = this.getOrigPrimaryKey();
        if (key == null) {
            return key2 == null;
        }
        return key.equals(key2) ^ true;
    }

    public byte getEntityState() {
        return this.mEffectiveState;
    }

    public byte getPostState() {
        return this.mState;
    }

    public static String getStateAsString(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "CLEAN";
                break;
            }
            case 4: {
                string = "DEAD";
                break;
            }
            case 3: {
                string = "DELETED";
                break;
            }
            case 2: {
                string = "DIRTY";
                break;
            }
            case 0: {
                string = "NEW";
                break;
            }
            case -1: {
                string = "INITIALIZED";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    private void setState(byte by) {
        EntityCache entityCache = this.mEntityCache == null ? this.getEntityCache() : this.mEntityCache;
        byte by2 = this.mState;
        if (by2 == by) {
            return;
        }
        if (by == 1) {
            this.mPKChanged = 0;
            entityCache.removeRowByOldPK(this);
        }
        switch (by) {
            case 1: {
                entityCache.removeModifiedRow(this);
                break;
            }
            case 2: {
                entityCache.addModifiedRow(this);
                if (this.mEffectiveState != 1) break;
                this.mEffectiveState = by;
                break;
            }
            case 4: {
                entityCache.removeModifiedRow(this);
                if (this.mPKChanged != 0 && by2 != 0 && by2 != -1) {
                    entityCache.removeRowByOldPK(this);
                }
                if (by2 == 3) {
                    entityCache.removeRowByDeletedPK(this);
                }
                entityCache.removeRow(this);
                break;
            }
            case -1: {
                if (this.mEffectiveState != 4) {
                    this.mEffectiveState = 0;
                }
                if (this.mInitState != 2 && (this.mInitState != 0 || this.mState != 0)) break;
                entityCache.removeModifiedRow(this);
                this.removeFromValidationManager();
                this.removeFromTransactionManager();
                break;
            }
            case 0: {
                if (this.mEffectiveState != 4) {
                    this.mEffectiveState = 0;
                }
                if (this.mInitState != 2) break;
                this.setStateToNew();
                break;
            }
            case 3: {
                entityCache.addModifiedRow(this);
                if (this.mEffectiveState == 4 || this.mEffectiveState == 0) break;
                this.mEffectiveState = by;
                break;
            }
            default: {
                throw new InvalidParamException("EntityImpl.setState", "state", new Byte(by).toString(), "unknown state value");
            }
        }
        this.mState = by;
        entityCache.notifyStateChange(this, by2);
    }

    void setStateToNew() {
        if (!this.isInCache()) {
            this.mState = 0;
            this.getEntityCache().add(this);
        } else {
            this.addToTransactionManager();
        }
        if (this.mContainer != null) {
            if (this.mContainer instanceof EntityImpl) {
                EntityImpl entityImpl = (EntityImpl)this.mContainer;
                if (entityImpl.getPostState() == -1) {
                    entityImpl.setState((byte)0);
                    entityImpl.setInvalid();
                }
                ((ValidationManager)this.getContainer()).addToValidationListeners(this);
            }
            ((ValidationManager)this.mContainer).addToValidationListeners(this);
            this.setInvalid();
        }
    }

    void markEntityNewForXMLRead() {
        this.mState = 0;
    }

    protected void donePostingAll(TransactionEvent transactionEvent) {
        ArrayList arrayList = this.getTransactionListenersList();
        int n = 0;
        while (n < arrayList.size()) {
            Object object = arrayList.get(n);
            if (object instanceof EntityImpl) {
                ((EntityImpl)object).donePostingAll(transactionEvent);
            }
            ++n;
        }
        this.mTempOrigData = null;
    }

    protected void handlePostChangesError() {
        if (!this.getDBTransactionImpl().hasRollbackSavePoint()) {
            this.mOrigData = new SparseArray(this.getAttributeCount());
        } else if (this.mTempOrigData != null) {
            this.mOrigData = this.mTempOrigData;
        }
        this.mTempOrigData = null;
        EntityCache entityCache = this.getEntityCache();
        if (this.mErrState != 1) {
            byte by = this.mState;
            this.mState = this.mErrState;
            if (by == 1 && this.mState != 2) {
                this.getEntityCache().addModifiedRow(this);
            }
            int n = 0;
            while (n < this.mErrChanged.size()) {
                if (this.mErrChanged.get(n)) {
                    this.setAttributeChanged(n, true);
                }
                ++n;
            }
            entityCache.notifyStateChange(this, by);
            switch (by) {
                case 4: {
                    entityCache.add(this);
                    this.mEffectiveState = this.mState;
                }
            }
            this.mErrState = 1;
            this.mErrChanged = null;
        }
        ArrayList arrayList = this.getTransactionListenersList();
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get(n) instanceof EntityImpl) {
                ((EntityImpl)arrayList.get(n)).handlePostChangesError();
            }
            ++n;
        }
    }

    public int getAttributeIndexOf(String string) {
        ArrayList arrayList = this.mEbi.mAttrAccessors;
        string = string.intern();
        int n = 0;
        while (n < arrayList.size()) {
            if (((AttributeDefImpl)arrayList.get(n)).getName() == string) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String[] getAttributeNames() {
        String[] stringArray = new String[this.getAttributeCount()];
        ArrayList arrayList = this.mEbi.mAttrAccessors;
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((AttributeDefImpl)arrayList.get(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public Object[] getAttributeValues() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getAttribute(n);
            ++n;
        }
        return objectArray;
    }

    public void revert() {
        this.refresh(0);
    }

    private void restoreAttrValues(SparseArray sparseArray) {
        int n = this.getAttributeCount();
        ArrayList arrayList = new ArrayList(n);
        ArrayList arrayList2 = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            if (sparseArray.isPopulated(n2)) {
                arrayList2.add((Object)new Integer(n2));
                arrayList.add(sparseArray.get(n2));
            }
            ++n2;
        }
        int n3 = arrayList.size();
        if (n3 > 0) {
            int[] nArray = new int[n3];
            Object[] objectArray = new Object[n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = (Integer)arrayList2.get(n4);
                objectArray[n4] = arrayList.get(n4);
                ++n4;
            }
            this.setAttributeValues(nArray, objectArray, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void refresh(int var1_1) {
        block21: {
            block19: {
                block22: {
                    block20: {
                        var2_2 = this.getPostState();
                        var3_3 = this.getEntityState();
                        var4_4 = (var1_1 & 32768) != 0;
                        var5_5 = (var1_1 & 16384) != 0;
                        var6_6 = (var1_1 & 8192) != 0;
                        var7_7 = var1_1;
                        var1_1 = var1_1 & -32769 & -16385 & -8193;
                        if (var4_4 && (var8_8 = this.getTransactionListenersList()) != null) {
                            var9_9 = var8_8.size();
                            --var9_9;
                            while (var9_9 > -1) {
                                ((EntityImpl)var8_8.get(var9_9)).refresh(var7_7);
                                --var9_9;
                            }
                        }
                        if (!(var1_1 != 1 || var2_2 == 1 && (var6_6 || var5_5 || var2_2 != 0 && var2_2 != -1))) {
                            return;
                        }
                        if (var2_2 != 0 && var2_2 != -1 && (var1_1 != 10 || var3_3 != 0 && var3_3 != -1)) break block20;
                        if (var6_6) {
                            this.setValidated(true);
                            this.removeFromValidationManager();
                            this.removeFromTransactionManager();
                            this.setState((byte)4);
                        } else if (var5_5) {
                            this.remove();
                        } else {
                            this.mInitState = 0;
                            this.init(this.getDBTransaction(), this.getEntityDef());
                            this.initDefaults();
                            this.initActivatedEntity(null);
                        }
                        break block21;
                    }
                    var10_10 = this.getAttributeCount();
                    if (var3_3 == 1 || this.mTransOrigData == null || var1_1 != 10) break block22;
                    this.restoreAttrValues(this.mTransOrigData);
                    break block21;
                }
                var11_11 = this.getEntityDef();
                var12_12 = this.getPrimaryKey();
                if (var12_12 == null || var12_12.isNull()) break block19;
                try {
                    this.doSelect(false);
                    break block19;
                }
                catch (RowInconsistentException var13_13) {
                    break block19;
                }
                catch (RowAlreadyDeletedException var14_14) {
                    if (this.mTransOrigData == null || var3_3 == 1 || var2_2 != 1) ** GOTO lbl66
                    var15_15 = this.getEntityDef();
                    var16_16 = new Object[var15_15.getPrimaryKeys().length];
                    var17_17 = 0;
                    var18_18 = 0;
                    ** while (var18_18 < var10_10)
                }
lbl-1000:
                // 1 sources

                {
                    if (var15_15.getAttributeDef(var18_18).isPrimaryKey() && this.mTransOrigData.isPopulated(var18_18)) {
                        var16_16[var17_17] = this.mTransOrigData.get(var18_18);
                        if (++var17_17 == var16_16.length) break;
                    }
                    ++var18_18;
                    continue;
                }
lbl58:
                // 2 sources

                if (var17_17 < var16_16.length) {
                    throw var14_14;
                }
                this.resetKey(new Key(var16_16));
                var12_12 = this.getPrimaryKey();
                if (var12_12 != null && !var12_12.isNull()) {
                    this.doSelect(false);
                } else {
                    throw var14_14;
lbl66:
                    // 1 sources

                    throw var14_14;
                }
            }
            this.restoreAttrValues(this.mOrigData);
            this.mOrigData = new SparseArray(var10_10);
            this.mTempOrigData = null;
            this.mChanged = new BitSet(var10_10);
            this.mChangedCount = 0;
            this.setState((byte)1);
            if (this.getTransactionListenersList().size() == 0) {
                this.removeFromValidationManager();
                if (var1_1 == 10 || this.mTransOrigData == null) {
                    this.removeFromTransactionManager();
                } else {
                    this.removeFromTransactionPostManager();
                }
            }
            if (var1_1 == 10 || this.mTransOrigData == null) {
                this.mEffectiveState = 1;
            }
            this.mContainer = null;
        }
    }

    public void lock() {
        Key key;
        byte by = this.getPostState();
        if (by == -1 || by == 0 || this.isLocked() || this.getDBTransaction().getLockingMode() == 0 || (key = this.getPrimaryKey()) == null || key.isNull()) {
            return;
        }
        if (by == 4) {
            throw new DeadEntityAccessException(this.getEntityDef().getName(), this.getPrimaryKey());
        }
        this.lockTopLevelEntity();
        this.doSelect(true);
    }

    protected void lockTopLevelEntity() {
        EntityImpl entityImpl = null;
        EntityImpl entityImpl2 = this;
        while (entityImpl2 != null) {
            entityImpl2 = entityImpl2.isContainerToBeLocked() ? (entityImpl = entityImpl2.getContainerEntity()) : entityImpl2.getContainerEntity();
        }
        if (entityImpl != null) {
            entityImpl.lock();
        }
    }

    private void doAddTransactionPostListener(TransactionPostListener transactionPostListener, boolean bl) {
        if (this.mTransactionListeners == null) {
            this.mTransactionListeners = new ArrayList();
        }
        if (!bl || !this.mTransactionListeners.contains((Object)transactionPostListener)) {
            this.mTransactionListeners.add((Object)transactionPostListener);
            transactionPostListener.setPostedToDB(false);
            if (transactionPostListener.isTransientTransactionPostListener()) {
                this.getDBTransactionImpl().setNextTransactionPostHandle(transactionPostListener);
            }
            if (transactionPostListener instanceof EntityImpl && !(this.getContainer() instanceof EntityImpl)) {
                this.addToTransactionManager();
            }
        }
    }

    protected void refreshFKInNewContainees() {
        ArrayList arrayList = this.getTransactionListenersList();
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        ArrayList arrayList2 = new ArrayList(2);
        AssociationDefImpl[] associationDefImplArray = this.getEntityDef().getAssociationDefImpls();
        if (associationDefImplArray != null) {
            int n = 0;
            while (n < associationDefImplArray.length) {
                AssociationEnd associationEnd = associationDefImplArray[n].getOtherAssociationEnd();
                if (associationEnd != null && associationEnd.hasContainer()) {
                    arrayList2.add((Object)associationDefImplArray[n]);
                }
                ++n;
            }
        }
        AssociationDefImpl associationDefImpl = null;
        ArrayList arrayList3 = new ArrayList(2);
        ArrayList arrayList4 = new ArrayList(2);
        int n = 0;
        while (n < arrayList2.size()) {
            associationDefImpl = (AssociationDefImpl)arrayList2.get(n);
            arrayList3.add((Object)associationDefImpl.getAssociationEnd().getAttributeDefImpls());
            arrayList4.add((Object)associationDefImpl.getOtherAssociationEnd().getAttributeDefImpls());
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Object object = arrayList.get(n2);
            if (object instanceof EntityImpl) {
                EntityDefImpl entityDefImpl = ((EntityImpl)object).mEbi;
                int n3 = 0;
                while (n3 < arrayList2.size()) {
                    associationDefImpl = (AssociationDefImpl)arrayList2.get(n3);
                    if (entityDefImpl == associationDefImpl.getOtherAssociationEnd().getOwner()) {
                        AttributeDefImpl[] attributeDefImplArray = (AttributeDefImpl[])arrayList3.get(n3);
                        AttributeDefImpl[] attributeDefImplArray2 = (AttributeDefImpl[])arrayList4.get(n3);
                        int n4 = 0;
                        while (n4 < attributeDefImplArray.length) {
                            ((EntityImpl)object).populateAttribute(attributeDefImplArray2[n4].mIndex, attributeDefImplArray2[n4].convertToJava(this.getAttributeInternal(attributeDefImplArray[n4].mIndex)), true, true, false);
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public void addTransactionPostListener(TransactionPostListener transactionPostListener) {
        this.doAddTransactionPostListener(transactionPostListener, true);
    }

    public void addTransactionPostListenerNoCheck(TransactionPostListener transactionPostListener) {
        this.doAddTransactionPostListener(transactionPostListener, false);
    }

    protected void addToTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.getContainer();
        if ((this.mInListenerList & 1) == 0) {
            transactionManager.addTransactionPostListenerNoCheck(this);
            this.mInListenerList = (byte)(this.mInListenerList | 1);
        }
        if ((this.mInListenerList & 2) == 0 && transactionManager instanceof DBTransaction) {
            ((DBTransaction)transactionManager).addTransactionListenerNoCheck(this);
            this.mInListenerList = (byte)(this.mInListenerList | 2);
        }
    }

    void adjustContainershipForActivate() {
        AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getForeignKeyAttrs();
        if (attributeDefImplArray != null) {
            int n = this.mEbi.mAttrAccessors.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.isAttributeChanged(n2)) {
                    AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mEbi.mAttrAccessors.get(n2);
                    int n3 = 0;
                    while (n3 < attributeDefImplArray.length) {
                        if (attributeDefImplArray[n3].equals(attributeDefImpl)) {
                            TransactionManager transactionManager = (TransactionManager)this.getContainer();
                            this.mContainer = null;
                            TransactionManager transactionManager2 = (TransactionManager)this.getContainer();
                            if (transactionManager2 instanceof EntityImpl) {
                                this.adjustContainership(transactionManager, transactionManager2, false);
                                break;
                            }
                            this.mContainer = transactionManager;
                            Class clazz = class$oracle$jbo$CSMessageBundle;
                            if (clazz == null) {
                                clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
                            }
                            throw new InvalidOwnerException(clazz, "25030", this.getEntityDef().getName(), this.getPrimaryKey());
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
    }

    void adjustContainership(TransactionManager transactionManager, TransactionManager transactionManager2, boolean bl) {
        if ((this.mValidated != 0 || bl) && transactionManager != transactionManager2) {
            this.mContainer = transactionManager;
            ArrayList arrayList = this.mTransactionListeners;
            this.removeFromTransactionManager();
            this.mTransactionListeners = arrayList;
            byte by = this.mValidated;
            this.mValidated = 0;
            this.removeFromValidationManager();
            this.mValidated = by;
        }
        this.mContainer = transactionManager2;
        this.lockTopLevelEntity();
        ((EntityImpl)this.mContainer).addToValidationListeners(this);
        if (transactionManager instanceof EntityImpl) {
            EntityImpl entityImpl = (EntityImpl)transactionManager;
            Object object = entityImpl.getContainer();
            while (object instanceof EntityImpl) {
                entityImpl = (EntityImpl)object;
                object = entityImpl.getContainer();
            }
            if (entityImpl != null) {
                if (!(object instanceof DBTransactionImpl)) {
                    Diagnostic.ASSERT(false, "Entity's root container " + object + " is not a DBTransactionImpl");
                }
                DBTransactionImpl dBTransactionImpl = (DBTransactionImpl)object;
                entityImpl.removeFromTransactionPostManager();
                entityImpl.addToTransactionManager();
            }
        }
    }

    public void removeTransactionPostListener(TransactionPostListener transactionPostListener) {
        int n = -1;
        if (this.mTransactionListeners != null) {
            n = this.mTransactionListeners.indexOf((Object)transactionPostListener);
        }
        if (n >= 0) {
            if (transactionPostListener.isTransientTransactionPostListener()) {
                this.getDBTransaction().removeTransactionPostListener(transactionPostListener);
            }
            this.mTransactionListeners.remove(n);
        } else if (Diagnostic.isOn()) {
            Diagnostic.println("***removeTransactionPostListener --- not found***");
        }
    }

    void removeFromTransactionPostManager() {
        if ((this.mInListenerList & 1) != 0) {
            ((TransactionManager)this.internalGetContainer()).removeTransactionPostListener(this);
            this.mInListenerList = (byte)(this.mInListenerList & 0xFFFFFFFE);
        }
    }

    void doRemoveFromTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.internalGetContainer();
        if ((this.mInListenerList & 1) != 0) {
            transactionManager.removeTransactionPostListener(this);
            this.mInListenerList = (byte)(this.mInListenerList & 0xFFFFFFFE);
        }
        if ((this.mInListenerList & 2) != 0 && transactionManager instanceof DBTransaction) {
            ((DBTransaction)transactionManager).removeTransactionListener(this);
            this.mInListenerList = (byte)(this.mInListenerList & 0xFFFFFFFD);
        }
    }

    void removeFromTransactionManager() {
        this.doRemoveFromTransactionManager();
        this.mTransactionListeners = null;
    }

    Object internalGetContainer() {
        return this.getPostState() != 1 ? this.getContainer() : (this.mContainer != null ? this.mContainer : this.getDBTransaction());
    }

    void removeFromValidationManager() {
        Object object = this.internalGetContainer();
        this.mValidated = 0;
        if (object instanceof EntityImpl) {
            ((EntityImpl)object).removeFromValidationListeners(this);
        } else if (object instanceof DBTransactionImpl) {
            ((DBTransactionImpl)object).removeFromValidationListeners(this);
        }
    }

    void beforePost(TransactionEvent transactionEvent) {
        byte by = this.getPostState();
        if (by != 0 && by != 1 && this.getDBTransaction().getLockingMode() == 2 && !this.isLocked()) {
            this.lock();
        }
    }

    void afterPost(TransactionEvent transactionEvent) {
        this.mErrState = this.getPostState();
        switch (this.mErrState) {
            case 3: {
                this.setState((byte)4);
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                this.setState((byte)1);
                break;
            }
            case 0: {
                this.setState((byte)1);
                break;
            }
            case -1: {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Internal error:" + this.getEntityDef().getName() + " of key:" + this.getKey());
                }
                throw new JboException("Internal error:Entity.afterPost.StatusInitialized");
            }
            default: {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Internal error:" + this.getEntityDef().getName() + " of key:" + this.getKey());
                }
                throw new JboException("Internal error:Entity.afterPost.default");
            }
        }
        this.mErrChanged = this.mChanged;
        this.mChanged = new BitSet(this.getAttributeCount());
        this.mChangedCount = 0;
        if (this.mTransOrigData == null) {
            this.mTransOrigData = this.mOrigData;
        }
        this.mTempOrigData = this.mOrigData;
        this.mOrigData = new SparseArray(this.getAttributeCount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postChanges(TransactionEvent transactionEvent) {
        boolean bl;
        boolean bl2 = transactionEvent == null || transactionEvent.getSource() == null;
        ArrayList arrayList = this.getTransactionListenersList();
        ArrayList arrayList2 = null;
        DBTransactionImpl dBTransactionImpl = this.getDBTransactionImpl();
        boolean bl3 = bl = dBTransactionImpl.getPostChangesFlag() != DBTransactionImpl.POST_ABORT_ON_FIRST_EXCEPTION;
        if (bl2) {
            if (transactionEvent == null) {
                transactionEvent = new TransactionEvent(this.getDBTransactionImpl(), this);
            } else {
                transactionEvent.mSource = this;
            }
            arrayList2 = this.prepareForBatch(new HashMap(10), arrayList, transactionEvent);
        }
        this.beforePost(transactionEvent);
        JboException jboException = null;
        int n = -1;
        byte by = this.getPostState();
        switch (by) {
            case 4: {
                if (!Diagnostic.isOn()) return;
                Diagnostic.println("***postChanges --- Ignoring Entity w/status = dead.***");
                return;
            }
            case 3: {
                if (!this.mEbi.mCascadeDelete && arrayList.size() > 0) {
                    dBTransactionImpl.doPostTransactionListeners(transactionEvent, arrayList, null, arrayList2, bl2, false);
                }
                if (!this.mEntityCache.mBatchMode) {
                    this.prepareForDML(3, transactionEvent);
                }
                this.doDML(3, transactionEvent);
                n = 3;
                break;
            }
            case 0: 
            case 2: {
                int n2 = n = by == 0 ? 1 : 2;
                if (this.mInitState != 3 || by != 2) {
                    if (!this.mEntityCache.mBatchMode) {
                        this.prepareForDML(n, transactionEvent);
                    }
                    if (bl) {
                        try {
                            this.doDML(n, transactionEvent);
                        }
                        catch (JboException jboException2) {
                            jboException = jboException2;
                        }
                        break;
                    }
                    this.doDML(n, transactionEvent);
                    break;
                }
                this.doDMLForCascadeUpdate(transactionEvent, arrayList, arrayList2, bl2);
                break;
            }
            case -1: {
                throw new JboException("Cannot post an entity with no attributes set");
            }
        }
        if (by != 3) {
            if (arrayList.size() == 0 && jboException != null) {
                throw jboException;
            }
            if (jboException == null && !this.mEntityCache.isBatchable(n)) {
                this.afterPost(transactionEvent);
            }
            if (bl && jboException != null) {
                try {
                    dBTransactionImpl.doPostTransactionListeners(transactionEvent, arrayList, null, arrayList2, bl2, false);
                }
                catch (JboException jboException3) {
                    ArrayList arrayList3 = new ArrayList(2);
                    arrayList3.add((Object)jboException);
                    arrayList3.add((Object)jboException3);
                    if (jboException3 instanceof DMLException) {
                        ((DMLException)jboException3).setEntityRowHandle(this.getTransPostHandle());
                        ((DMLException)jboException3).setEntityRow(this);
                    }
                    BatchDMLException batchDMLException = new BatchDMLException(arrayList3);
                    batchDMLException.setEntityRowHandle(this.getTransPostHandle());
                    batchDMLException.setEntityRow(this);
                    throw batchDMLException;
                }
                if (jboException == null) return;
                throw jboException;
            }
            try {
                dBTransactionImpl.doPostTransactionListeners(transactionEvent, arrayList, null, arrayList2, bl2, false);
                return;
            }
            catch (BatchDMLException batchDMLException) {
                batchDMLException.setEntityRowHandle(this.getTransPostHandle());
                batchDMLException.setEntityRow(this);
                throw batchDMLException;
            }
            catch (JboException jboException4) {
                if (jboException != null || this.mEntityCache.isBatchable(n)) throw jboException4;
                this.handlePostChangesError();
                throw jboException4;
            }
        }
        if (jboException != null || this.mEntityCache.isBatchable(n)) return;
        this.afterPost(transactionEvent);
    }

    protected void doDMLForCascadeUpdate(TransactionEvent transactionEvent, ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        if (!this.isLocked()) {
            Diagnostic.println("Locking to faultin this entity before cloning a new db row");
            this.lock();
        }
        Diagnostic.println("*** doDMLForCasacdeUpdate()");
        int n = this.getAttributeCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.mData.isPopulated(n2)) {
                this.populateAttributeAsChanged(n2, this.mData.get(n2));
            }
            ++n2;
        }
        if (!this.mEntityCache.mBatchMode) {
            this.prepareForDML(1, transactionEvent);
        }
        this.doDML(1, transactionEvent);
        this.getDBTransactionImpl().doPostTransactionListeners(transactionEvent, arrayList, null, arrayList2, bl, false);
        if (!this.mEntityCache.mBatchMode) {
            this.prepareForDML(3, transactionEvent);
        }
        this.doDML(3, transactionEvent);
    }

    final void populate() {
        this.doSelect(false);
    }

    protected void populateAttribute(int n, Object object) {
        int n2 = this.getEntityDef().getAttributeCount();
        if (n >= n2) {
            this.setDynamicAttributeValue(n - n2, object);
            return;
        }
        AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
        attributeDefImpl.setValueInSparseArray(object, this.mData, this, this.getDBTransaction());
        if (attributeDefImpl.isSessionScope()) {
            this.getEntityCache().pin(this);
        }
    }

    protected void populateAttribute(int n, Object object, boolean bl, boolean bl2) {
        this.populateAttribute(n, object, bl, bl2, false);
    }

    protected void populateAttribute(int n, Object object, boolean bl, boolean bl2, boolean bl3) {
        Object object2 = this.mData.get(n);
        try {
            if (bl3 && !this.mOrigData.isPopulated(n)) {
                if (this.mData.isPopulated(n)) {
                    this.mOrigData.set(n, object2);
                } else {
                    this.mOrigData.set(n, this.getAttributeInternal(n));
                }
            }
            if (bl2) {
                this.populateAttributeAsChanged(n, object);
            } else {
                this.populateAttribute(n, object);
            }
            if (bl) {
                this.notifyAttributesChanged(new int[]{n}, new Object[]{object2});
            }
        }
        catch (RuntimeException runtimeException) {
            this.populateAttribute(n, object2);
            AttributeDefImpl attributeDefImpl = this.getAttributeDefImpl(n);
            if (attributeDefImpl.isPrimaryKey() && this.getPrimaryKey() == null) {
                this.removeFromValidationManager();
            }
            throw runtimeException;
        }
    }

    protected void populateAttributeAsChanged(int n, Object object) {
        this.populateAttribute(n, object);
        this.setAttributeChanged(n, true);
        if (!((AttributeDefImpl)this.mEbi.mAttrAccessors.get(n)).isPersistent()) {
            this.addToTransactionManager();
        }
    }

    static boolean compareAttrVals(Object object, Object object2) {
        if (object2 != null) {
            return object != null && object2.equals(object);
        }
        return object == null;
    }

    protected boolean checkConsistency(SparseArray sparseArray, boolean bl) {
        return this.compare(sparseArray);
    }

    protected boolean compare(SparseArray sparseArray) {
        SparseArrayInterface sparseArrayInterface = this.mData;
        AttributeDefImpl attributeDefImpl = this.mEbi.getChangeIndicatorColumn();
        if (attributeDefImpl != null) {
            int n = attributeDefImpl.getIndex();
            Object object = this.mOrigData.isPopulated(n) ? this.mOrigData.get(n) : sparseArrayInterface.get(n);
            Object object2 = sparseArray.get(n);
            if (object != null && object2 != null) {
                return object.equals(object2);
            }
        }
        ArrayList arrayList = this.mEbi.mAttrAccessors;
        SQLBuilder sQLBuilder = this.getSQLBuilder();
        int n = 0;
        while (n < arrayList.size()) {
            Object object;
            Object object3;
            AttributeDefImpl attributeDefImpl2 = (AttributeDefImpl)arrayList.get(n);
            if (attributeDefImpl2.isPersistent() && sparseArrayInterface.isPopulated(n) && sparseArray.isPopulated(n) && !sQLBuilder.compareFetchedValue(this, attributeDefImpl2, object3 = this.mOrigData.isPopulated(n) ? this.mOrigData.get(n) : sparseArrayInterface.get(n), object = sparseArray.get(n))) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Entity compare failed for attribute " + attributeDefImpl2.getName());
                    if (!(object3 instanceof LobInterface) && !(object instanceof LobInterface)) {
                        Diagnostic.println("Original value :" + object3);
                        Diagnostic.println("Target value :" + object);
                    } else {
                        Diagnostic.println("Difference in lob values for attribute at index:" + n);
                    }
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    void merge(EntityImpl entityImpl) {
        if (!this.compare(entityImpl.mData.toSparseArray())) {
            this.populate();
            return;
        }
        int n = this.getAttributeCount();
        int n2 = 0;
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        int n3 = 0;
        while (n3 < n) {
            if (entityImpl.isAttributePopulated(n3)) {
                Object object = entityImpl.getAttributeInternal(n3);
                Object object2 = this.mData.get(n3);
                if (!this.isAttributeChanged(n3)) {
                    if (this.isAttributePopulated(n3) && !EntityImpl.compareAttrVals(object2, object)) {
                        nArray[n2] = n3;
                        objectArray[n2++] = object2;
                    }
                    this.populateAttribute(n3, object);
                } else {
                    this.mOrigData.set(n3, object);
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            if (n2 == n) {
                this.notifyAttributesChanged(nArray, objectArray);
            } else {
                int[] nArray2 = new int[n2];
                Object[] objectArray2 = new Object[n2];
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                this.notifyAttributesChanged(nArray2, objectArray2);
            }
        }
    }

    protected void notifyAttributesChanged(int[] nArray, Object[] objectArray) {
        this.notifyAttributesChanged(nArray, objectArray, true);
    }

    protected void notifyAttributesChanged(int[] nArray, Object[] objectArray, boolean bl) {
        Diagnostic.ASSERT(nArray.length == objectArray.length);
        this.getEntityCache().notifyColumnChange(this, nArray, objectArray, bl);
    }

    final void notifyBeforePKChange(int[] nArray, Object[] objectArray, int n, Key key) {
        if (n > 0) {
            if (n == nArray.length && n == objectArray.length) {
                this.getEntityCache().notifyBeforePKChange(this, nArray, objectArray, key);
            } else {
                int[] nArray2 = new int[n];
                Object[] objectArray2 = new Object[n];
                System.arraycopy(nArray, 0, nArray2, 0, n);
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
                this.getEntityCache().notifyBeforePKChange(this, nArray2, objectArray2, key);
            }
        }
    }

    public void afterCommit(TransactionEvent transactionEvent) {
        int n = this.getAttributeCount();
        this.mTransOrigData = null;
        this.mOrigData = new SparseArray(n);
        this.mTempOrigData = null;
        switch (this.getPostState()) {
            case 1: {
                this.mEffectiveState = 1;
                break;
            }
            case 3: {
                this.setState((byte)4);
            }
            case 4: {
                this.mEffectiveState = (byte)4;
                break;
            }
            case 2: {
                throw new JboException("Internal error:Entity.afterCommit.status_modified");
            }
            case 0: {
                throw new JboException("Internal error:Entity.afterCommit.status_new");
            }
            case -1: {
                throw new JboException("Internal error:Entity.afterCommit.status_initialized");
            }
            default: {
                throw new JboException("Internal error:Entity.afterCommit.status_default");
            }
        }
        if (this.mTransactionListeners != null) {
            int n2 = this.mTransactionListeners.size();
            int n3 = 0;
            while (n3 < n2) {
                EntityImpl entityImpl = (EntityImpl)this.mTransactionListeners.get(0);
                entityImpl.doRemoveFromTransactionManager();
                entityImpl.afterCommit(transactionEvent);
                entityImpl.afterRemove(transactionEvent);
                entityImpl.mTransactionListeners = null;
                ++n3;
            }
        }
        this.mContainer = null;
        this.mChanged = new BitSet(n);
        this.mChangedCount = 0;
        this.setLocked(false);
    }

    void resetKey(Key key) {
        if (key == null) {
            return;
        }
        AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getPrimaryKeys();
        Object[] objectArray = key.getKeyValues();
        int n = 0;
        while (n < objectArray.length) {
            this.populateAttribute(attributeDefImplArray[n].getIndex(), objectArray[n]);
            ++n;
        }
    }

    public void afterRollback(TransactionEvent transactionEvent) {
        int n = this.getAttributeCount();
        if (this.mEffectiveState == 0) {
            this.mEffectiveState = (byte)4;
        } else if (this.mEffectiveState == 2 || this.mEffectiveState == 3) {
            Key key = this.getOrigPrimaryKey();
            this.cleanStorage();
            this.resetKey(key);
            this.mEffectiveState = 1;
        } else {
            int n2 = 0;
            while (n2 < n) {
                if (this.mOrigData.isPopulated(n2)) {
                    this.populateAttribute(n2, this.mOrigData.get(n2));
                }
                ++n2;
            }
        }
        ArrayList arrayList = this.getTransactionListenersList();
        int n3 = 0;
        while (n3 < arrayList.size()) {
            TransactionListener transactionListener = (TransactionListener)arrayList.get(n3);
            transactionListener.afterRollback(transactionEvent);
            if (transactionListener instanceof EntityImpl) {
                ((EntityImpl)transactionListener).removeFromValidationManager();
                ((EntityImpl)transactionListener).removeFromTransactionManager();
            }
            ++n3;
        }
        if (this.mEffectiveState == 1 || this.mEffectiveState == 4) {
            this.removeFromValidationManager();
            this.removeFromTransactionManager();
        }
        this.setState(this.mEffectiveState);
        this.mValidationListeners = null;
        this.mTransOrigData = null;
        this.mOrigData = new SparseArray(n);
        this.mTempOrigData = null;
        this.mChanged = new BitSet(n);
        this.mChangedCount = 0;
        this.mContainer = null;
        this.setLocked(false);
    }

    public void afterRemove(TransactionEvent transactionEvent) {
        this.mInListenerList = (byte)(this.mInListenerList & 0xFFFFFFFD);
    }

    public boolean isTransientTransactionListener() {
        return true;
    }

    public void beforeCommit(TransactionEvent transactionEvent) {
        if (this.mTransactionListeners != null) {
            int n = 0;
            while (n < this.mTransactionListeners.size()) {
                ((TransactionListener)this.mTransactionListeners.get(n)).beforeCommit(transactionEvent);
                ++n;
            }
        }
    }

    public boolean isPostedToDB() {
        return this.mPostedToDB;
    }

    public void setPostedToDB(boolean bl) {
        this.mPostedToDB = bl;
    }

    public int getTransPostHandle() {
        return this.mTransPostHdl;
    }

    public void setTransPostHandle(int n) {
        this.mTransPostHdl = n;
    }

    public boolean isTransientTransactionPostListener() {
        return true;
    }

    public void beforeRollback(TransactionEvent transactionEvent) {
        if (this.mValidationListeners != null) {
            int n = 0;
            while (n < this.mValidationListeners.size()) {
                ((TransactionListener)this.mValidationListeners.get(n)).beforeRollback(transactionEvent);
                ++n;
            }
        }
        if (this.mTransactionListeners != null) {
            int n = 0;
            while (n < this.mTransactionListeners.size()) {
                ((TransactionListener)this.mTransactionListeners.get(n)).beforeRollback(transactionEvent);
                ++n;
            }
        }
    }

    protected void doSelect(boolean bl) {
        switch (this.getPostState()) {
            case -1: {
                break;
            }
            case 4: {
                if (!Diagnostic.isOn()) break;
                Diagnostic.println("Warning: Ignoring fault-in for STATUS_DEAD entity");
                break;
            }
            default: {
                this.getSQLBuilder().doEntitySelect(this, bl);
            }
        }
    }

    protected void prepareForDML(int n, TransactionEvent transactionEvent) {
        if (n == 1 || n == 2) {
            this.updateHistoryColumns();
        }
    }

    protected void prepareForBatchDML(int n, TransactionEvent transactionEvent) {
        EntityCache entityCache = this.mEntityCache;
        switch (n) {
            case 2: {
                this.prepareForDML(2, transactionEvent);
                entityCache.addToBatchList(2, this);
                ++entityCache.mUpdateCount;
                break;
            }
            case 1: {
                this.prepareForDML(1, transactionEvent);
                entityCache.addToBatchList(1, this);
                ++entityCache.mInsertCount;
                break;
            }
            case 3: {
                this.prepareForDML(3, transactionEvent);
                entityCache.addToBatchList(3, this);
                ++entityCache.mDeleteCount;
            }
        }
    }

    protected void doDML(int n, TransactionEvent transactionEvent) {
        if (!this.getEntityDef().hasLOBAttrs()) {
            this.getSQLBuilder().doEntityDML(this, n, transactionEvent);
        } else {
            this.doDMLWithLOBs(n, transactionEvent);
        }
    }

    protected void doDMLWithLOBs(int n, TransactionEvent transactionEvent) {
        if (n == 1 || n == 2) {
            int n2 = 0;
            ArrayList arrayList = this.getEntityDef().getLOBAttrs();
            int n3 = arrayList.size();
            int[] nArray = new int[n3];
            AttributeDefImpl[] attributeDefImplArray = (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[n3]);
            Object[] objectArray = new Object[n3];
            Connection connection = ((DBTransactionImpl)this.mDBTransaction).getJdbcConnection();
            boolean bl = false;
            n2 = 0;
            while (n2 < n3) {
                nArray[n2] = attributeDefImplArray[n2].getIndex();
                objectArray[n2] = this.mData.get(nArray[n2]);
                if (this.mChanged.get(nArray[n2]) && objectArray[n2] != null) {
                    bl = true;
                    ((BlobDomainInterface)objectArray[n2]).prepareForDML(connection);
                } else {
                    nArray[n2] = -1;
                }
                ++n2;
            }
            this.getSQLBuilder().doEntityDML(this, n, transactionEvent);
            if (bl) {
                n2 = 0;
                while (n2 < n3) {
                    if (nArray[n2] > -1) {
                        this.setAttributeChanged(nArray[n2], false);
                    }
                    ++n2;
                }
                SparseArray sparseArray = this.mOrigData;
                this.mOrigData = this.mData.toSparseArray();
                try {
                    this.doSelect(false);
                }
                catch (RowInconsistentException rowInconsistentException) {
                    // empty catch block
                }
                boolean bl2 = false;
                n2 = 0;
                while (n2 < n3) {
                    if (nArray[n2] > -1) {
                        Object object = this.mData.get(nArray[n2]);
                        try {
                            ((BlobDomainInterface)objectArray[n2]).saveToDatabase(this.getDBTransaction(), object);
                            if (attributeDefImplArray[n2].getSQLType() == 2002) {
                                bl2 = true;
                            }
                            if (!bl2) {
                                this.populateAttribute(nArray[n2], objectArray[n2]);
                            }
                        }
                        catch (Exception exception) {
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("EntityImpl.doDMLWithBlob failed...");
                                Diagnostic.printStackTrace(exception);
                            }
                            throw new DMLException(n, this, this.getTransPostHandle(), exception.getMessage(), exception);
                        }
                    }
                    if (bl2) {
                        this.doSelect(false);
                    }
                    ++n2;
                }
                this.mOrigData = sparseArray;
            }
        } else {
            this.getSQLBuilder().doEntityDML(this, n, transactionEvent);
        }
    }

    protected void vetoRemoveWithDetails(AttributeDef attributeDef) {
        AssociationDefImpl associationDefImpl = (AssociationDefImpl)attributeDef;
        AssociationEnd associationEnd = associationDefImpl.getAssociationEnd();
        Object object = associationDefImpl.get(this);
        if (object != null) {
            if (!this.mEbi.mCascadeDelete && associationEnd.isCascadeDelete()) {
                this.mEbi.mCascadeDelete = true;
            }
            if (this.mEbi.mCascadeDelete || associationEnd.isDeleteContainee()) {
                if (object instanceof RowIterator) {
                    RowIterator rowIterator = (RowIterator)object;
                    if (rowIterator.getFetchedRowCount() > 0 || associationEnd.isDeleteContainee()) {
                        while (rowIterator.hasNext()) {
                            rowIterator.next().remove();
                        }
                    } else if (rowIterator instanceof RowSet && ((RowSet)rowIterator).getEstimatedRowCount() > 0L) {
                        EntityImpl entityImpl = null;
                        rowIterator.reset();
                        while (rowIterator.hasNext()) {
                            entityImpl = (EntityImpl)rowIterator.next();
                            if (entityImpl.getPostState() >= 3) continue;
                            entityImpl.remove();
                            break;
                        }
                        if (entityImpl != null) {
                            EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
                            Class clazz = entityDefImpl.getRowClass();
                            if (entityDefImpl.isUseGlueCode()) {
                                clazz = clazz.getSuperclass();
                            }
                            if (JboNameUtil.findMethod(clazz, "remove", new Class[0], clazz.getSuperclass()) != null) {
                                while (rowIterator.hasNext()) {
                                    rowIterator.next().remove();
                                }
                                if (rowIterator.getRowCount() > 0) {
                                    throw new RemoveWithDetailsException();
                                }
                            }
                            if (entityImpl.getPostState() < 3) {
                                throw new RemoveWithDetailsException();
                            }
                        }
                    }
                } else if (object instanceof Row) {
                    ((Row)object).remove();
                }
            } else {
                int n = associationDefImpl.getOtherAssociationEnd().getCardinality();
                if (n != -1 || ((RowIterator)object).getRowCount() != 0 || n == 1 && object != null) {
                    throw new RemoveWithDetailsException();
                }
            }
        }
    }

    void removedByAnotherTrans() {
        this.setValidated(true);
        this.removeFromValidationManager();
        this.removeFromTransactionManager();
        this.setState((byte)4);
        this.mEffectiveState = (byte)4;
    }

    public void remove() {
        AssociationDefImpl[] associationDefImplArray = this.getEntityDef().getAssociationDefImpls();
        if (associationDefImplArray != null) {
            ArrayList arrayList;
            int n = 0;
            while (n < associationDefImplArray.length) {
                AssociationEnd associationEnd = associationDefImplArray[n].getOtherAssociationEnd();
                if (associationEnd != null && associationEnd.hasContainer()) {
                    this.vetoRemoveWithDetails(associationDefImplArray[n]);
                }
                ++n;
            }
            if (this.mEbi.mCascadeDelete && (arrayList = this.getTransactionListenersList()).size() > 0) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    EntityImpl entityImpl = (EntityImpl)arrayList.get(n2);
                    if (entityImpl.getPostState() < 3) {
                        entityImpl.remove();
                    }
                    ++n2;
                }
            }
        }
        byte by = this.getPostState();
        switch (by) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.getEntityCache().notifyBeforeRemove(this, this.mState);
                break;
            }
        }
        switch (by) {
            case 4: {
                throw new DeadEntityAccessException(this.getEntityDef().getName(), this.getPrimaryKey());
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                this.setState((byte)3);
                this.addToTransactionManager();
                this.removeFromValidationManager();
                this.mValidationListeners = null;
                Object object = this.getContainer();
                if (!(object instanceof EntityImpl)) break;
                ((EntityImpl)object).setInvalid();
                break;
            }
            case -1: 
            case 0: {
                this.setValidated(true);
                this.removeFromValidationManager();
                this.removeFromTransactionManager();
                this.setState((byte)4);
                break;
            }
            default: {
                throw new JboException("Internal error:Entity.remove.default");
            }
        }
    }

    public void removeFromCollection() {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25056", new Object[]{this.getEntityDef().getName()});
    }

    public void removeAndRetain() {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = EntityImpl.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25056", new Object[]{this.getEntityDef().getName()});
    }

    Object findAssociatedObjects(int n) {
        return this.getEntityDef().getAssociationDefImpl(n).get(this);
    }

    public Key getKey() {
        return this.getPrimaryKey();
    }

    public boolean isAttributeUpdateable(int n) {
        if (!this.hasUpdatePrivilege(n)) {
            return false;
        }
        switch (((AttributeDefImpl)this.mEbi.mAttrAccessors.get((int)n)).mUpdateable) {
            case 0: {
                return false;
            }
            case 1: {
                return this.mEffectiveState == 0;
            }
        }
        return true;
    }

    public boolean isDead() {
        return false;
    }

    final boolean isPrimaryKeyRetrievedOnInsert() {
        EntityDefImpl entityDefImpl = this.mEbi;
        if (entityDefImpl.isRowIDPrimaryKey()) {
            return true;
        }
        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.mPrimaryKeys;
        int n = 0;
        while (n < attributeDefImplArray.length) {
            if (attributeDefImplArray[n].mRetrievedOnInsert) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isPrimaryKeyRetrievedOnUpdate() {
        AttributeDefImpl[] attributeDefImplArray = this.mEbi.mPrimaryKeys;
        int n = 0;
        while (n < attributeDefImplArray.length) {
            if (attributeDefImplArray[n].mRetrievedOnUpdate) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final void initialRowID() {
        AttributeDefImpl[] attributeDefImplArray = this.getEntityDef().getPrimaryKeys();
        AttributeDefImpl attributeDefImpl = attributeDefImplArray[0];
        Key key = null;
        int n = 0;
        while (n < 100) {
            Object object = attributeDefImpl.convertToJava(this.getSQLBuilder().generateRowID(this));
            key = new Key(new Object[]{object});
            if (this.getEntityCache().get(key) == null) {
                this.populateAttribute(attributeDefImpl.getIndex(), object);
                return;
            }
            ++n;
        }
        throw new TooManyObjectsException(this.getEntityDef().getFullName(), key);
    }

    private final void initialRefAndOID() {
        AttributeDefImpl attributeDefImpl = this.getEntityDef().getPrimaryKeys()[0];
        AttributeDefImpl attributeDefImpl2 = this.getEntityDef().getOIDAttribute();
        Object[] objectArray = this.getSQLBuilder().generateRefAndOID(this);
        this.populateAttribute(attributeDefImpl.getIndex(), objectArray[0]);
        this.populateAttribute(attributeDefImpl2.getIndex(), objectArray[1]);
        this.setAttributeChanged(attributeDefImpl2.getIndex(), true);
    }

    void cleanStorage() {
        int n = this.getAttributeCount();
        this.mData = this.initData(n);
        this.mTransOrigData = null;
        this.mOrigData = new SparseArray(n);
        this.mTempOrigData = null;
        this.mChanged = new BitSet(n);
        this.mChangedCount = 0;
        this.mState = 1;
        this.mEffectiveState = 1;
    }

    boolean isNotCreated() {
        return this.mInitState == 0;
    }

    void dump(Writer writer, int n) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println(" State: " + EntityImpl.getStateAsString(this.getPostState()));
        printWriter.println("   Current Data: " + this.mData.toString(n));
        printWriter.println("  Original Data: " + this.mOrigData.toString(n));
    }

    void dump(Writer writer) {
        this.dump(writer, 0);
    }

    public String toString() {
        Key key = this.getPrimaryKey();
        return "Entity [" + (key == null ? "null" : key.toString()) + "]";
    }

    public void domainToBeModified(DomainInterface domainInterface) {
        this.lock();
    }

    AttributeDefImpl[] getAttributeDefImpls() {
        return this.mEbi.getAttributeDefImpls();
    }

    String getXMLElementTag() {
        String string = (String)this.mEbi.getProperty("XML_ROW_ELEMENT");
        return string != null ? string : this.mEbi.getName() + "Row";
    }

    protected void appendXMLElementNodes(Document document, Node node, int n, long l, AttributeDefImpl[] attributeDefImplArray) {
        this.appendXMLElementNodesForAttrs(document, node, l, attributeDefImplArray);
        ArrayList arrayList = this.getTransactionListenersList();
        Element element = null;
        if (arrayList.size() > 0) {
            element = document.createElement("CEO");
            node.appendChild(element);
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Object object = arrayList.get(n2);
            if (object instanceof EntityImpl) {
                try {
                    Serializer.passivateEntity((XMLDocument)document, (XMLElement)element, (EntityImpl)object, l);
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            ++n2;
        }
    }

    protected void appendXMLElementNodesForAttrs(Document document, Node node, long l, AttributeDefImpl[] attributeDefImplArray) {
        Element element = null;
        ((XMLElement)node).setAttribute(XML_POSTSTATE_TAG, new Byte(this.mEffectiveState).toString());
        if (this.mEffectiveState != 3) {
            boolean bl = this.mEffectiveState == 0 ? this.mEbi.isRowIDPrimaryKey() : false;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object = null;
            AttributeDefImpl attributeDefImpl = this.mEbi.getChangeIndicatorColumn();
            int n = 0;
            while (n < attributeDefImplArray.length) {
                element = null;
                AttributeDefImpl attributeDefImpl2 = attributeDefImplArray[n];
                int n2 = attributeDefImpl2.getIndex();
                switch (attributeDefImpl2.mKind) {
                    case 2: {
                        element = document.createElement(attributeDefImpl2.getName());
                    }
                    case 6: {
                        break;
                    }
                    default: {
                        object = null;
                        boolean bl4 = l == 0L;
                        boolean bl5 = false;
                        if ((l & 0x10000000L) != 0L) {
                            if (this.isAttributeChangedInTransaction(n2)) {
                                if (attributeDefImpl2.mPrimaryKey) {
                                    bl2 = true;
                                }
                                bl4 = true;
                                if (attributeDefImpl2 == attributeDefImpl) {
                                    bl3 = true;
                                }
                            } else if (this.hasAttributeException(attributeDefImpl2.mName)) {
                                bl5 = true;
                                bl4 = true;
                            } else {
                                boolean bl6 = bl4 = attributeDefImpl2 == attributeDefImpl || bl && attributeDefImpl2.mColumnName == ORACLE_ROWID_COLUMN;
                            }
                        }
                        if (bl4) {
                            object = !bl5 ? this.mData.get(n2) : ((AttrValException)this.mDeferredExceptions.get((Object)attributeDefImpl2.mName)).getAttrValue();
                            element = document.createElement(attributeDefImpl2.getName());
                            if (object != null) {
                                Node node2 = DomainAttributeDef.getXMLContentNode(document, object, attributeDefImpl2.getProperty("XML_CDATA") != null, true);
                                if (node2 != null) {
                                    Element element2 = document.createElement(XML_MDATA_TAG);
                                    element2.appendChild(node2);
                                    element.appendChild(element2);
                                }
                            } else {
                                Element element3 = document.createElement(XML_MDATA_TAG);
                                ((XMLElement)element3).setAttribute(AttributeDefImpl.XML_NULL_ATTR_TAG, "true");
                                element.appendChild(element3);
                            }
                            if (bl5 && element != null) {
                                ((XMLElement)element).setAttribute(XML_EXCEPTION_TAG, "1");
                            }
                            if (this.mEffectiveState != 0) {
                                if (attributeDefImpl != null && attributeDefImpl != attributeDefImpl2 || !this.mOrigData.isPopulated(n2)) break;
                                object = this.mOrigData.get(n2);
                                if (object != null) {
                                    Node node3 = DomainAttributeDef.getXMLContentNode(document, object, attributeDefImpl2.getProperty("XML_CDATA") != null, true);
                                    if (node3 != null) {
                                        Element element4 = document.createElement(XML_MORIGDATA_TAG);
                                        element4.appendChild(node3);
                                        element.appendChild(element4);
                                    }
                                } else {
                                    Element element5 = document.createElement(XML_MORIGDATA_TAG);
                                    ((XMLElement)element5).setAttribute(AttributeDefImpl.XML_NULL_ATTR_TAG, "true");
                                    element.appendChild(element5);
                                }
                            }
                        }
                        if (!bl5) break;
                    }
                }
                if (element != null) {
                    node.appendChild(element);
                    if (bl2) {
                        ((XMLElement)node).setAttribute(XML_PK_CHANGED, XML_PK_CHANGED_YES);
                    }
                    if (bl3) {
                        ((XMLElement)node).setAttribute(XML_CI_CHANGED, XML_PK_CHANGED_YES);
                    }
                }
                ++n;
            }
        }
    }

    void activateChildEOs(NodeList nodeList, boolean bl) {
        int n = 0;
        while (n < nodeList.getLength()) {
            try {
                Serializer.activateEntity((XMLElement)nodeList.item(n), this.getDBTransactionImpl(), this, bl);
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            ++n;
        }
    }

    protected void notifyEntityActivated(boolean bl) {
        if (bl) {
            this.postChanges(null);
        }
    }

    protected boolean handleActivatedRowNotFound() {
        return true;
    }

    EntityImpl activateMissingEntity(Key key) {
        this.resetKey(key);
        this.setState((byte)1);
        if (this.handleActivatedRowNotFound()) {
            return this.getEntityCache().add(this);
        }
        return this;
    }

    protected boolean readAttrsFromXML(Element element, AttributeDefImpl[] attributeDefImplArray, int n) {
        NodeList nodeList;
        String string = ((XMLElement)element).getAttribute(XML_CI_CHANGED);
        boolean bl = string == null || string.length() == 0;
        byte by = Byte.valueOf(element.getAttribute(XML_POSTSTATE_TAG));
        if (by == 3) {
            NodeList nodeList2 = ((XMLElement)element).getChildrenByTagName("CEO");
            if (nodeList2.getLength() == 1) {
                this.activateChildEOs(nodeList2.item(0).getChildNodes(), n > 0);
            }
            this.remove();
            return false;
        }
        AttributeDefImpl attributeDefImpl = this.mEbi.getChangeIndicatorColumn();
        boolean bl2 = this.mDBTransaction.isBundledExceptionMode() ^ true;
        boolean bl3 = by == 0 && this.mEbi.isRowIDPrimaryKey();
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            NodeList nodeList3;
            AttributeDefImpl attributeDefImpl2 = attributeDefImplArray[n2];
            if (attributeDefImpl2.mKind != 2 && attributeDefImpl2.mKind != 6 && (nodeList3 = ((XMLElement)element).getChildrenByTagName(attributeDefImpl2.getName())).getLength() > 0) {
                Object object;
                XMLElement xMLElement;
                XMLElement xMLElement2 = (XMLElement)nodeList3.item(0);
                NodeList nodeList4 = xMLElement2.getChildrenByTagName(XML_MDATA_TAG);
                if (nodeList4.getLength() > 0) {
                    if (n > 0) {
                        boolean bl4;
                        boolean bl5 = bl4 = bl3 && attributeDefImpl2.mColumnName == ORACLE_ROWID_COLUMN;
                        if (this.isAttributeUpdateable(n2) || bl4) {
                            xMLElement = (XMLElement)nodeList4.item(0);
                            object = attributeDefImpl2.getXMLContentValue((Element)xMLElement, true);
                            if (bl2 || xMLElement2.getAttributeNode(XML_EXCEPTION_TAG) == null) {
                                if (attributeDefImpl2 == attributeDefImpl && bl || bl4) {
                                    this.populateAttribute(n2, object);
                                } else {
                                    this.setAttributeValueInternal(n2, object);
                                }
                            } else if (attributeDefImpl2 == attributeDefImpl && bl || bl4) {
                                this.populateAttribute(n2, object);
                            } else {
                                try {
                                    this.setAttribute(n2, object);
                                }
                                catch (DataCreationException dataCreationException) {
                                    dataCreationException.setAttrInfo(121, this.getEntityDef().getFullName(), attributeDefImpl2.getName(), object);
                                    this.processAttributeException(attributeDefImpl2, object, dataCreationException);
                                }
                            }
                        }
                    } else {
                        this.populateAttribute(n2, attributeDefImpl2.getXMLContentValue((Element)nodeList4.item(0), true));
                    }
                }
                if ((nodeList4 = xMLElement2.getChildrenByTagName(XML_MORIGDATA_TAG)).getLength() > 0) {
                    xMLElement = (XMLElement)nodeList4.item(0);
                    object = attributeDefImpl2.getXMLContentValue((Element)xMLElement, true);
                    this.mOrigData.set(n2, object);
                }
            }
            ++n2;
        }
        if (bl3) {
            this.getEntityCache().add(this);
        }
        if ((nodeList = ((XMLElement)element).getChildrenByTagName("CEO")).getLength() == 1) {
            this.activateChildEOs(nodeList.item(0).getChildNodes(), n > 0);
        }
        return true;
    }

    public final void readXML(Element element, int n) {
        this.readAttrsFromXML(element, this.mEbi.getAttributeDefImpls(), n);
    }

    void doRefreshAfterBatch(TransactionEvent transactionEvent) {
        ArrayList arrayList;
        int n = 0;
        if (this.mEntityCache.mBatchMode) {
            boolean bl = false;
            AttributeDefImpl[] attributeDefImplArray = null;
            AttributeDefImpl[] attributeDefImplArray2 = null;
            switch (this.mState) {
                case 2: {
                    bl = this.mEbi.getRetrievedOnUpdatePrimaryKeys().length > 0 || this.mEbi.getRetrievedOnUpdateAttributes().length > 0;
                    n = 2;
                    attributeDefImplArray = this.mEbi.getRetrievedOnInsertAttributes();
                    attributeDefImplArray2 = this.mEbi.getRetrievedOnInsertPrimaryKeys();
                    break;
                }
                case 0: {
                    bl = this.mEbi.getRetrievedOnInsertAttributes().length > 0;
                    n = 1;
                    attributeDefImplArray = this.mEbi.getRetrievedOnUpdateAttributes();
                    attributeDefImplArray2 = this.mEbi.getRetrievedOnUpdatePrimaryKeys();
                }
            }
            if (bl) {
                this.internalRefreshSQL(n, this.getPrimaryKey(), attributeDefImplArray2, attributeDefImplArray);
            }
        }
        if ((arrayList = this.getTransactionListenersList()).size() > 0) {
            EntityImpl entityImpl = (EntityImpl)arrayList.get(0);
            if (!entityImpl.getEntityCache().mBatchMode) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    ((EntityImpl)arrayList.get(n2)).doRefreshAfterBatch(transactionEvent);
                    ++n2;
                }
            }
        }
        if (n != 0 && this.mEntityCache.isBatchable(n)) {
            this.afterPost(transactionEvent);
        }
    }

    ArrayList prepareForBatch(HashMap hashMap, ArrayList arrayList, TransactionEvent transactionEvent) {
        boolean bl = hashMap != null;
        ArrayList arrayList2 = new ArrayList(5);
        EntityCache entityCache = this.mEntityCache;
        if (entityCache.mBatchMode) {
            String string = this.mEbi.getName();
            if (bl && hashMap.get((Object)string) == null) {
                hashMap.put((Object)string, (Object)string);
                arrayList2.add((Object)entityCache);
            }
            int n = this.mEbi.mAttrAccessors.size();
            if (entityCache.mBatchUpdateBits == null) {
                entityCache.mBatchUpdateBits = new BitSet(n);
                entityCache.mBatchInsertBits = new BitSet(n);
            }
            int n2 = 3;
            BitSet bitSet = null;
            boolean bl2 = false;
            switch (this.mState) {
                case 2: {
                    bitSet = entityCache.mBatchUpdateBits;
                    n2 = 2;
                    bl2 = true;
                    break;
                }
                case 0: {
                    bitSet = entityCache.mBatchInsertBits;
                    n2 = 1;
                    bl2 = true;
                    break;
                }
                case 3: {
                    bl2 = true;
                }
            }
            if (bl2) {
                this.prepareForBatchDML(n2, transactionEvent);
            }
            if (bitSet != null) {
                int n3 = 0;
                while (n3 < n) {
                    if (this.isAttributeChanged(n3)) {
                        bitSet.set(n3);
                    }
                    ++n3;
                }
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            EntityImpl entityImpl = (EntityImpl)arrayList.get(n);
            ArrayList arrayList3 = entityImpl.prepareForBatch(hashMap, entityImpl.getTransactionListenersList(), transactionEvent);
            if (bl && arrayList3.size() > 0) {
                arrayList2.addAll((Collection)arrayList3);
            }
            ++n;
        }
        return bl ? arrayList2 : null;
    }

    void updateHistoryColumns() {
        AttributeDefImpl[] attributeDefImplArray = this.mEbi.getHistoryAttributeDefImpls();
        int n = 0;
        while (n < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n];
            if (!(attributeDefImpl.getUpdateableFlag() != 2 || attributeDefImpl.isRetrievedOnUpdate() || attributeDefImpl.getHistoryKind() != 4 && attributeDefImpl.getHistoryKind() != 2 && attributeDefImpl.getHistoryKind() != 5 || attributeDefImpl.getHistoryKind() == 5 && this.isAttributeChanged(attributeDefImpl.getIndex()))) {
                Object object = this.getHistoryContextForAttribute(attributeDefImpl);
                this.populateAttribute(attributeDefImpl.getIndex(), object, true, true, true);
            }
            ++n;
        }
    }

    void resurrect() {
        if (!this.isPostedToDB()) {
            int n;
            byte by = this.getPostState();
            if (by == 4) {
                n = 0;
            } else if (by == 3) {
                n = this.mOrigData.isEmpty() ? 1 : 2;
            } else {
                return;
            }
            this.setState((byte)n);
            this.getEntityCache().add(this);
        }
    }

    protected void doRefreshSQL(int n, ArrayList arrayList) {
        if (arrayList != null) {
            this.getSQLBuilder().doRefreshSQL(this, n, (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]), new AttributeDefImpl[0]);
        }
    }

    protected AttributeDefImpl[] getRefreshSQLKeyAttrs(int n) {
        AttributeDefImpl[] attributeDefImplArray = null;
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = this.mEbi.getRetrievedOnInsertPrimaryKeys().length == 0;
                break;
            }
            case 2: {
                boolean bl2 = bl = this.mEbi.getRetrievedOnUpdatePrimaryKeys().length == 0;
            }
        }
        if (bl) {
            attributeDefImplArray = this.mEbi.getPrimaryKeys();
        } else {
            attributeDefImplArray = this.mEbi.getUniqueKeys();
            if (attributeDefImplArray.length < 1) {
                Diagnostic.println("Warning: Attempting to use current primary key attributes for refresh SQL.");
                Diagnostic.println("*******  Found no UniqueKey attribute when a PK attribute is marked for refresh on Entity:" + this.mEbi.getName());
                attributeDefImplArray = this.mEbi.getPrimaryKeys();
            }
        }
        return attributeDefImplArray;
    }

    protected AttributeDefImpl[] buildRefreshSQL(StringBuffer stringBuffer, int n, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, boolean bl) {
        AttributeDefImpl[] attributeDefImplArray3 = this.getRefreshSQLKeyAttrs(n);
        AttributeDefImpl[] attributeDefImplArray4 = new AttributeDefImpl[attributeDefImplArray.length + attributeDefImplArray2.length];
        System.arraycopy(attributeDefImplArray2, 0, attributeDefImplArray4, 0, attributeDefImplArray2.length);
        System.arraycopy(attributeDefImplArray, 0, attributeDefImplArray4, attributeDefImplArray2.length, attributeDefImplArray.length);
        this.getSQLBuilder().buildSelectString(this.getDBTransactionImpl(), stringBuffer, this.mEbi.getSource(), "", attributeDefImplArray4, bl, this.getEntityDef().getBindingStyle());
        this.buildWhereClause(stringBuffer, attributeDefImplArray3, null);
        return attributeDefImplArray3;
    }

    void internalRefreshSQL(int n, Key key, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2) {
        int n2;
        int n3;
        ArrayList arrayList = new ArrayList();
        if (attributeDefImplArray != null) {
            key = this.getPrimaryKey();
            n3 = attributeDefImplArray.length;
            n2 = 0;
            while (n2 < n3) {
                arrayList.add((Object)attributeDefImplArray[n2]);
                ++n2;
            }
        }
        if (attributeDefImplArray2 != null) {
            n3 = attributeDefImplArray2.length;
            n2 = 0;
            while (n2 < n3) {
                arrayList.add((Object)attributeDefImplArray2[n2]);
                ++n2;
            }
        }
        n3 = arrayList.size();
        n2 = 0;
        while (n2 < n3) {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)arrayList.get(n2);
            int n4 = attributeDefImpl.getIndex();
            if (!(this.mOrigData.isPopulated(n4) || n == 1 && attributeDefImpl.isRetrievedOnInsert() || n == 2 && attributeDefImpl.isRetrievedOnUpdate())) {
                this.mOrigData.set(n4, this.mData.get(n4));
            }
            ++n2;
        }
        switch (n) {
            case 1: {
                Diagnostic.println("Fetch RefreshOnInsert attributes");
                break;
            }
            case 2: {
                Diagnostic.println("Fetch RefreshOnUpdate attributes");
                break;
            }
        }
        this.doRefreshSQL(n, arrayList);
        if (key == null || key != null && !key.equals(this.getPrimaryKey())) {
            this.getEntityCache().replace(this, key);
            if (n == 1) {
                this.refreshFKInNewContainees();
            }
        }
    }

    protected int bindDMLStatement(int n, PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, HashMap hashMap, boolean bl) throws SQLException {
        switch (n) {
            case 1: {
                return this.getSQLBuilder().bindInsertStatement(this, preparedStatement, attributeDefImplArray, attributeDefImplArray2, attributeDefImplArray3, hashMap, bl);
            }
            case 2: {
                return this.getSQLBuilder().bindUpdateStatement(this, preparedStatement, attributeDefImplArray, attributeDefImplArray2, attributeDefImplArray3, hashMap, bl);
            }
            case 3: {
                return this.getSQLBuilder().bindDeleteStatement(this, preparedStatement);
            }
        }
        return -1;
    }

    protected StringBuffer buildDMLStatement(int n, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, boolean bl) {
        switch (n) {
            case 1: {
                return this.getSQLBuilder().buildInsertStatement(this, attributeDefImplArray, attributeDefImplArray2, attributeDefImplArray3, bl);
            }
            case 2: {
                return this.getSQLBuilder().buildUpdateStatement(this, attributeDefImplArray, attributeDefImplArray2, attributeDefImplArray3, bl);
            }
            case 3: {
                return this.getSQLBuilder().buildDeleteStatement(this);
            }
        }
        throw new IllegalArgumentException("");
    }

    protected Object getHistoryContextForAttribute(AttributeDefImpl attributeDefImpl) {
        return attributeDefImpl.getHistoryContext(this, this.getDBTransaction());
    }

    public void setNewRowState(byte by) {
        block13: {
            block12: {
                byte by2 = this.getPostState();
                if (by2 != -1 && by2 != 0) break block12;
                switch (by) {
                    case -1: {
                        if (this.getPostState() == 0) {
                            if (this.isInCache()) {
                                AttributeDefImpl[] attributeDefImplArray = this.mEbi.getPrimaryKeys();
                                Object var4_4 = null;
                                int n = 0;
                                int n2 = 0;
                                while (n2 < attributeDefImplArray.length) {
                                    if (this.mChanged.get(attributeDefImplArray[n2].mIndex)) {
                                        ++n;
                                    } else if (this.mEbi.isRowIDPrimaryKey() && attributeDefImplArray[n2].mColumnName == ORACLE_ROWID_COLUMN) {
                                        ++n;
                                    } else if (this.mEbi.mOIDAttribute != null && attributeDefImplArray[n2] == this.mEbi.mOIDAttribute) {
                                        ++n;
                                    }
                                    ++n2;
                                }
                                this.getEntityCache().removeRow(this);
                            }
                            this.setState((byte)-1);
                            break;
                        }
                        break block13;
                    }
                    case 0: {
                        this.setState(by);
                        break;
                    }
                    default: {
                        Diagnostic.println("Warning:Ignoring setNewRowState to an illegal value:" + by);
                    }
                }
                break block13;
            }
            Diagnostic.println("Warning:Ignoring setNewRowState on an existing/old entity of state:" + by);
        }
    }

    Object getAttribute(int n, byte by) {
        if (by == 0) {
            return this.getAttribute(n);
        }
        return this.getPostedAttribute(n);
    }

    protected boolean hasUpdatePrivilege(int n) {
        ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.getDBTransactionImpl().getRootApplicationModule();
        if (!((SessionImpl)applicationModuleImpl.getSession()).isCheckPermission()) {
            return true;
        }
        EntityDefImpl entityDefImpl = this.getEntityDef();
        return this.hasUpdatePrivilege(applicationModuleImpl, entityDefImpl, entityDefImpl.getAttributeDefImpl(n));
    }

    boolean hasUpdatePrivilege(ApplicationModuleImpl applicationModuleImpl, EntityDefImpl entityDefImpl, AttributeDefImpl attributeDefImpl) {
        String string;
        AttributeDefImpl attributeDefImpl2;
        EntityDefImpl entityDefImpl2 = (EntityDefImpl)entityDefImpl.getBaseDefObject();
        if (entityDefImpl2 != null && (attributeDefImpl2 = (AttributeDefImpl)attributeDefImpl.getBaseDefObject()) == null) {
            return this.hasUpdatePrivilege(applicationModuleImpl, entityDefImpl2, attributeDefImpl);
        }
        String string2 = entityDefImpl.getFullName();
        byte by = applicationModuleImpl.getEntityAttributePermission(string2, string = attributeDefImpl.getName());
        return by == 2 || by == 1 && this.mEffectiveState == 0;
    }

    protected void buildWhereClause(StringBuffer stringBuffer, AttributeDefImpl[] attributeDefImplArray, Object object) {
        this.getSQLBuilder().buildWhereClause(this, stringBuffer, attributeDefImplArray, object);
    }

    protected int bindWhereClause(PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray, Object object, int n) throws SQLException {
        return this.getSQLBuilder().bindWhereClause(this, preparedStatement, attributeDefImplArray, object, n);
    }

    void validateHistoryColumns() {
        AssociationDefImpl[] associationDefImplArray;
        byte by = this.getPostState();
        if (by == 1 && (associationDefImplArray = this.getEntityDef().getAssociationDefImpls()) != null) {
            int n = 0;
            while (n < associationDefImplArray.length) {
                AssociationEnd associationEnd = associationDefImplArray[n].getOtherAssociationEnd();
                if (associationEnd != null && associationEnd.isUpdateHistoryColumn()) {
                    Diagnostic.println("# eoname: " + this.mEbi.getName());
                    this.setState((byte)2);
                    this.addToTransactionManager();
                }
                ++n;
            }
        }
    }

    protected ViewObjectImpl findAssociationAccessorVO(AssociationDefImpl associationDefImpl, String string, EntityAssociation entityAssociation) {
        ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.getDBTransactionImpl().getRootApplicationModule();
        return (ViewObjectImpl)applicationModuleImpl.findViewObject(string);
    }

    protected ViewObjectImpl createAssociationAccessorVO(AssociationDefImpl associationDefImpl, String string, EntityAssociation entityAssociation) {
        AssociationEnd associationEnd = associationDefImpl.getOtherAssociationEnd();
        EntityDefImpl entityDefImpl = (EntityDefImpl)associationEnd.getOwner();
        ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.getDBTransactionImpl().getRootApplicationModule();
        return (ViewObjectImpl)applicationModuleImpl.doCreateViewObjectFromQueryClauses(string, entityDefImpl.getFullName(), entityDefImpl.getAliasName(), associationEnd.getAssociationSelect(), associationEnd.getAssociationFrom(), null, null);
    }

    protected EntityRowSetImpl createAssociationAccessorRS(AssociationDefImpl associationDefImpl, ViewObjectImpl viewObjectImpl, Row row, Object[] objectArray) {
        return new EntityRowSetImpl(viewObjectImpl, associationDefImpl, associationDefImpl.getParamValues(this.getEntityDef(), this.getEntityDef().getBindingStyle(), row, objectArray));
    }

    protected ViewObjectImpl findEntityViewLinkAccessorVO(AssociationDefImpl associationDefImpl, String string, ViewDefImpl viewDefImpl, ViewLinkDefImpl viewLinkDefImpl) {
        ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.getDBTransactionImpl().getRootApplicationModule();
        return (ViewObjectImpl)applicationModuleImpl.findViewObject(string);
    }

    protected ViewObjectImpl createEntityViewLinkAccessorVO(AssociationDefImpl associationDefImpl, String string, ViewDefImpl viewDefImpl, ViewLinkDefImpl viewLinkDefImpl) {
        ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.getDBTransactionImpl().getRootApplicationModule();
        return (ViewObjectImpl)applicationModuleImpl.createViewObject(string, viewDefImpl);
    }

    protected ViewRowSetImpl createEntityViewLinkAccessorRS(AssociationDefImpl associationDefImpl, ViewObjectImpl viewObjectImpl, Row row, Object[] objectArray) {
        return ViewObjectImpl.doCreateViewLinkAccessorRS(associationDefImpl, viewObjectImpl, row, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

