/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pcoll;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jbo.PCollException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.pcoll.PCollListener;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.pcoll.PCollNode;
import oracle.jbo.pcoll.PCollPersistable;
import oracle.jbo.pcoll.PersistManager;
import oracle.jbo.pcoll.PersistentMarker;

public class PCollection
implements PCollListener {
    public static final int PRINT_NODE_INFO = 1;
    public static final int PRINT_NODE_PERS_INFO = 2;
    public static final int PRINT_NODE_POS_INFO = 4;
    public static final int PRINT_NODE_CHECK_LOCK_COUNT = 8;
    public static final boolean mDebugOn = true;
    public static boolean mEventTrace = false;
    private static final int DEFAULT_NODE_CAPACITY = 100;
    private static final int MINIMUM_NODE_CAPACITY = 4;
    private static final int DEFAULT_MAX_ELEMS_ACTIVE = 1000;
    private static final int ACTIVE_OBJ_TAB_CAPACITY = 10;
    private WeakReference mListener;
    private Hashtable mActiveObjsTab;
    private PCollManager mManager;
    private PCollNode mRoot;
    private PCollNode mLRUNode;
    private PCollNode mMRUNode;
    private String mName;
    private int mNodeCapacity;
    private int mMaxActiveLeafNodes;
    private int mNumActiveLeafNodes;
    private boolean mPassivationEnabled;
    private boolean mIsCollectionOfOne;
    private int mCollId;
    private long mNodeId;
    int count_persMgrCalls;
    int count_passivateElemCalls;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mListener = null;
        this.mActiveObjsTab = null;
        this.mLRUNode = null;
        this.mMRUNode = null;
        this.mNumActiveLeafNodes = 0;
        this.mPassivationEnabled = true;
        this.mIsCollectionOfOne = false;
        this.mCollId = -1;
        this.mNodeId = -1;
        this.count_persMgrCalls = 0;
        this.count_passivateElemCalls = 0;
    }

    public PCollection(PCollManager pCollManager, String string, int n) {
        this(pCollManager, string, n, -1, -1);
    }

    public PCollection(PCollManager pCollManager, String string, int n, int n2) {
        this(pCollManager, string, n, n2, -1);
    }

    public PCollection(PCollManager pCollManager, String string, int n, int n2, int n3) {
        this.$init$();
        this.mManager = pCollManager;
        this.mName = string;
        if (!this.getManager().hasPersistMgr()) {
            n2 = -1;
        }
        this.setMaxActiveLeafNodes(n2);
        this.mNodeCapacity = n < 0 ? 100 : (n < 4 ? 4 : n);
        this.mCollId = this.mManager.register(this, n3);
        this.mRoot = new PCollNode(this, null, true);
    }

    public synchronized void close() {
        this.mManager.unregister(this);
    }

    PCollListener getListener() {
        PCollection pCollection;
        PCollListener pCollListener = pCollection = this.mListener == null ? this : (PCollListener)this.mListener.get();
        if (pCollection == null) {
            pCollection = this;
        }
        return pCollection;
    }

    public void setListener(PCollListener pCollListener) {
        this.mListener = pCollListener == null ? null : new WeakReference<PCollListener>(pCollListener);
    }

    public final int getId() {
        return this.mCollId;
    }

    public String getName() {
        return this.mName;
    }

    public synchronized void enableIdAccess() {
        this.mActiveObjsTab = new Hashtable(10);
        this.getRoot().addToActiveTabRecurse();
    }

    void addToActiveTab(PCollPersistable pCollPersistable) {
        if (this.mActiveObjsTab != null) {
            long l = pCollPersistable.getPersistentId();
            if (l == 0L) {
                l = this.getListener().getNextObjId();
                pCollPersistable.setPersistentId(l);
            }
            this.mActiveObjsTab.put(new Long(l), pCollPersistable);
        }
    }

    void removeFromActiveTab(long l) {
        if (this.mActiveObjsTab != null) {
            this.mActiveObjsTab.remove(new Long(l));
        }
    }

    PCollPersistable activeObjWithId(long l) {
        if (this.mActiveObjsTab != null) {
            return (PCollPersistable)this.mActiveObjsTab.get(new Long(l));
        }
        return null;
    }

    public Hashtable activeObjsTab() {
        return this.mActiveObjsTab;
    }

    void dropFromRUChain(PCollNode pCollNode) {
        if (!pCollNode.mIsLeaf) {
            return;
        }
        if (pCollNode == this.mLRUNode) {
            this.mLRUNode = pCollNode.mNextRUNode;
        }
        if (pCollNode == this.mMRUNode) {
            this.mMRUNode = pCollNode.mPrevRUNode;
        }
        if (pCollNode.mPrevRUNode != null) {
            pCollNode.mPrevRUNode.mNextRUNode = pCollNode.mNextRUNode;
        }
        if (pCollNode.mNextRUNode != null) {
            pCollNode.mNextRUNode.mPrevRUNode = pCollNode.mPrevRUNode;
        }
    }

    boolean checkForDupInRUChain(PCollNode pCollNode) {
        PCollNode pCollNode2 = this.mLRUNode;
        while (pCollNode2 != null) {
            if (pCollNode2.getPersistentId() == pCollNode.getPersistentId()) {
                return false;
            }
            pCollNode2 = pCollNode2.mNextRUNode;
        }
        return true;
    }

    boolean markAsRecentlyUsed(PCollNode pCollNode) {
        if (!pCollNode.mIsLeaf || pCollNode == this.mMRUNode) {
            return false;
        }
        this.dropFromRUChain(pCollNode);
        if (this.mLRUNode == pCollNode) {
            this.mLRUNode = pCollNode.mNextRUNode;
        }
        if (this.mLRUNode == null) {
            this.mLRUNode = pCollNode;
        }
        if (this.mMRUNode == null) {
            this.mMRUNode = pCollNode;
        } else {
            this.mMRUNode.mNextRUNode = pCollNode;
            pCollNode.mPrevRUNode = this.mMRUNode;
            pCollNode.mNextRUNode = null;
            this.mMRUNode = pCollNode;
        }
        return true;
    }

    void nodeRecentlyUsed(PCollNode pCollNode) {
        if (this.markAsRecentlyUsed(pCollNode)) {
            try {
                ++pCollNode.mLockCount;
                this.checkActiveLeafLimit();
                Object var3_2 = null;
                --pCollNode.mLockCount;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                --pCollNode.mLockCount;
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    PCollNode findLRULeafNode() {
        var1_1 = this.mLRUNode;
        if (var1_1 != this.mRoot) ** GOTO lbl6
        return null;
        while (var1_1.mLockCount > 0) {
            var1_1 = var1_1.mNextRUNode;
lbl6:
            // 2 sources

            if (var1_1 != null) continue;
        }
        return var1_1;
    }

    void incrNumActiveLeafNodes() {
        ++this.mNumActiveLeafNodes;
    }

    void decrNumActiveLeafNodes() {
        --this.mNumActiveLeafNodes;
    }

    boolean passivateLRULeafNode() {
        PCollNode pCollNode;
        PCollNode pCollNode2 = null;
        while ((pCollNode = this.findLRULeafNode()) != null) {
            if (pCollNode2 == null) {
                pCollNode2 = pCollNode;
            } else if (pCollNode2 == pCollNode) {
                this.notifyPCollEvent(4, pCollNode, "passivateLRULeafNode/loopComp");
                return false;
            }
            if (!pCollNode.passivate()) {
                this.markAsRecentlyUsed(pCollNode);
                continue;
            }
            pCollNode = pCollNode.mParent;
            while (pCollNode != this.mRoot && pCollNode.mNumPassivatedElems == pCollNode.mElems.size()) {
                pCollNode.passivate();
                pCollNode = pCollNode.mParent;
            }
            return true;
        }
        this.notifyPCollEvent(4, pCollNode, "passivateLRULeafNode/noNode");
        return false;
    }

    public synchronized long getNextObjId() {
        return this.getManager().getNextObjId(this.getId());
    }

    public void beforePassivateElement(PCollection pCollection, PCollPersistable pCollPersistable) {
    }

    public void afterActivateElement(PCollection pCollection, PCollPersistable pCollPersistable) {
    }

    long getNextNodeId() {
        long l;
        if (this.getManager().isPersistent()) {
            l = this.getManager().getPersistentNextNodeId(this.getId());
        } else {
            long l2 = this.mNodeId;
            l = l2;
            this.mNodeId = l2 - 1L;
        }
        return l;
    }

    void checkActiveLeafLimit() {
        if (this.isPassivationEnabled() && this.getManager().hasPersistMgr()) {
            while (this.mMaxActiveLeafNodes >= 0 && this.mNumActiveLeafNodes > this.mMaxActiveLeafNodes) {
                if (this.passivateLRULeafNode()) continue;
                Diagnostic.println("passivateLRULeafNode ret false, #activeLeaves: " + this.mNumActiveLeafNodes + ", #maxActiveLeaves: " + this.mMaxActiveLeafNodes);
                break;
            }
        }
    }

    public boolean isPassivationEnabled() {
        return this.mPassivationEnabled;
    }

    public void setPassivationEnabled(boolean bl) {
        this.mPassivationEnabled = bl;
    }

    public synchronized long passivate() {
        if (this.getRoot().passivateBranch()) {
            return this.mRoot.mNodeId;
        }
        return 0L;
    }

    public synchronized void activate(long l) {
        PCollNode pCollNode = null;
        if (this.mIsCollectionOfOne) {
            pCollNode = this.getRoot();
            pCollNode.addPersistentMarker(1L, -1);
        } else {
            pCollNode = (PCollNode)PCollNode.activateElemWithId(this, l);
        }
        if (pCollNode == null || pCollNode.getLeftSib(true) != null || pCollNode.getRightSib(true) != null || pCollNode.getPCollParentId() != 0L) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = PCollection.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28039", new Object[]{this.getName(), new Integer(this.getId()), new Long(l)}, null);
        }
        this.mLRUNode = null;
        this.mMRUNode = null;
        this.mNumActiveLeafNodes = 0;
        if (this.mActiveObjsTab != null) {
            this.enableIdAccess();
        }
        pCollNode.mColl = this;
        this.notifyPCollEvent(4, pCollNode, "nodeRecentlyUsed/activateNode");
        this.nodeRecentlyUsed(pCollNode);
        if (pCollNode.mIsLeaf) {
            this.incrNumActiveLeafNodes();
        }
        this.addToActiveTab(pCollNode);
        this.mRoot = pCollNode;
    }

    public void setCommitThreshhold(int n) {
        PersistManager persistManager = this.getPersistManager();
        if (persistManager != null) {
            persistManager.setCommitThreshhold(n);
        }
    }

    public synchronized int getNumActiveLeafNodes() {
        return this.mNumActiveLeafNodes;
    }

    public synchronized int getMaxActiveLeafNodes() {
        return this.mMaxActiveLeafNodes;
    }

    public synchronized void setMaxActiveLeafNodes(int n) {
        if (this.getManager().hasPersistMgr()) {
            if (n == 0 && (n = 1000 / this.mNodeCapacity) <= 0) {
                n = 1;
            }
            this.mMaxActiveLeafNodes = n;
        }
    }

    public PCollManager getManager() {
        return this.mManager;
    }

    PersistManager getPersistManager() {
        if (this.mMaxActiveLeafNodes < 0) {
            return null;
        }
        return this.getManager().getPersistManager();
    }

    public Connection getConnection() {
        return this.mManager.getConnection();
    }

    public int getNodeCapacity() {
        return this.mNodeCapacity;
    }

    PCollNode getRoot() {
        return this.mRoot;
    }

    void setRoot(PCollNode pCollNode) {
        this.notifyPCollEvent(4, pCollNode, "nodeRecentlyUsed/setRoot");
        this.nodeRecentlyUsed(pCollNode);
        this.mRoot = pCollNode;
        this.mRoot.mParent = null;
    }

    boolean checkTrimFromTop() {
        if (!this.mRoot.mIsLeaf && this.mRoot.mElems.size() == 1) {
            Diagnostic.print("$$removed root$$ id=" + this.mRoot.mNodeId);
            this.removeFromActiveTab(this.mRoot.mNodeId);
            this.setRoot((PCollNode)this.mRoot.mElems.elementAt(0));
            Diagnostic.println(", new root=" + this.mRoot.mNodeId);
            return true;
        }
        return false;
    }

    long countActiveLeafNodes(PCollNode pCollNode) {
        long l = 0L;
        if (pCollNode.mIsLeaf) {
            return 1L;
        }
        int n = 0;
        while (n < pCollNode.mElems.size()) {
            Object e = pCollNode.mElems.elementAt(n);
            if (!(e instanceof PersistentMarker) && e instanceof PCollNode) {
                l += this.countActiveLeafNodes((PCollNode)e);
            }
            ++n;
        }
        return l;
    }

    void checkActiveObjsTab(PrintWriter printWriter) {
        if (this.mActiveObjsTab != null) {
            Enumeration enumeration = this.mActiveObjsTab.keys();
            while (enumeration.hasMoreElements()) {
                Long l = (Long)enumeration.nextElement();
                PCollPersistable pCollPersistable = (PCollPersistable)this.mActiveObjsTab.get(l);
                Diagnostic.ASSERT(l.longValue() == pCollPersistable.getPersistentId(), "Key in active tab (" + l + ") does not match object id (" + pCollPersistable.getPersistentId() + ")");
                Diagnostic.ASSERT(this.mRoot.isInTree(pCollPersistable), "Object " + pCollPersistable + " of id (" + pCollPersistable.getPersistentId() + ") not found in tree");
            }
        }
    }

    void checkRUChain(PrintWriter printWriter) {
        PCollNode pCollNode = this.mLRUNode;
        PCollNode pCollNode2 = null;
        long l = this.countActiveLeafNodes(this.mRoot);
        long l2 = 0L;
        Diagnostic.ASSERT(pCollNode != null, "LRU node is null");
        while (pCollNode != null) {
            Diagnostic.ASSERT(pCollNode.mPrevRUNode == pCollNode2, "mPrevRUNode problem");
            if (pCollNode.mNextRUNode != null) {
                Diagnostic.ASSERT(pCollNode.mNextRUNode.mPrevRUNode == pCollNode, "mNextRUNode problem");
            }
            String string = pCollNode.getNodeInfo();
            if (printWriter != null) {
                printWriter.println("Node id=" + pCollNode.mNodeId + ", indx=" + l2 + ": " + string);
            }
            Diagnostic.ASSERT(pCollNode.mIsLeaf, "Non leaf found on RU chain");
            pCollNode2 = pCollNode;
            pCollNode = pCollNode.mNextRUNode;
            ++l2;
        }
        Diagnostic.ASSERT(l == l2, "Count from countActiveLeafNodes (" + l + ") different from count through RU chain (" + l2 + ")");
        Diagnostic.ASSERT(l2 == (long)this.mNumActiveLeafNodes, "Count of active leaf nodes (" + this.mNumActiveLeafNodes + ") different from count through RU chain (" + l2 + ")");
    }

    public synchronized void printActiveObjsTab(PrintWriter printWriter) {
        try {
            this.checkActiveObjsTab(printWriter);
            Object var3_2 = null;
            if (printWriter != null) {
                printWriter.flush();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (printWriter != null) {
                printWriter.flush();
            }
            throw throwable;
        }
    }

    public synchronized void printRUChain(PrintWriter printWriter) {
        try {
            this.checkRUChain(printWriter);
            Object var3_2 = null;
            if (printWriter != null) {
                printWriter.flush();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (printWriter != null) {
                printWriter.flush();
            }
            throw throwable;
        }
    }

    public synchronized void printColl(PrintWriter printWriter) {
        this.printColl(printWriter, 0);
    }

    public synchronized void printColl(PrintWriter printWriter, int n) {
        try {
            this.mRoot.printNode(printWriter, n);
            Object var4_3 = null;
            if (printWriter != null) {
                printWriter.flush();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (printWriter != null) {
                printWriter.flush();
            }
            throw throwable;
        }
        this.checkRUChain(null);
        this.checkActiveObjsTab(null);
    }

    public synchronized void addElement(PCollPersistable pCollPersistable) {
        this.mRoot.addObject(pCollPersistable);
    }

    public Object[] toArray(Object[] objectArray) {
        int n = (int)this.size();
        if (objectArray == null) {
            objectArray = new Object[n];
        }
        if (objectArray.length < n) {
            n = objectArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.elementAt(n2);
            ++n2;
        }
        return objectArray;
    }

    public synchronized PCollPersistable elementAt(long l) {
        return this.mRoot.objectAt(l);
    }

    public synchronized long idAt(long l) {
        return this.mRoot.idAt(l);
    }

    public synchronized long[] idsWithKey(int n, Object object) {
        PersistManager persistManager = this.getPersistManager();
        return persistManager != null ? persistManager.retrieveIdsWithKey(n, object, this.getId()) : new long[]{};
    }

    public synchronized PCollPersistable elementWithId(long l) {
        PCollPersistable pCollPersistable;
        if (this.mActiveObjsTab == null) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = PCollection.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28034", new Object[]{this.getName(), new Integer(this.getId())}, null);
        }
        if (l <= 0L) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = PCollection.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28035", new Object[]{this.getName(), new Integer(this.getId()), new Long(l)}, null);
        }
        if ((pCollPersistable = this.activeObjWithId(l)) == null) {
            pCollPersistable = PCollNode.activateObjWithId(this, l);
        }
        return pCollPersistable;
    }

    public synchronized void insertElementAt(PCollPersistable pCollPersistable, long l) {
        this.mRoot.insertObjectAt(pCollPersistable, l);
    }

    public synchronized void setElementAt(PCollPersistable pCollPersistable, long l) {
        this.mRoot.setObjectAt(pCollPersistable, l);
    }

    public synchronized void removeAllElements() {
        PersistManager persistManager;
        this.mLRUNode = null;
        this.mMRUNode = null;
        this.mNumActiveLeafNodes = 0;
        if (this.mActiveObjsTab != null) {
            this.mActiveObjsTab = new Hashtable(10);
        }
        this.mRoot = new PCollNode(this, null, true);
        if (this.mActiveObjsTab != null) {
            this.enableIdAccess();
        }
        if ((persistManager = this.getPersistManager()) != null) {
            if (this.count_persMgrCalls > 0) {
                Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.deleteAll");
            }
            ++this.count_persMgrCalls;
            persistManager.deleteAll(this.getId());
            --this.count_persMgrCalls;
        }
    }

    public synchronized void removeElementAt(long l) {
        this.mRoot.removeObjectAt(l);
        while (this.checkTrimFromTop()) {
        }
    }

    public synchronized long indexOf(PCollPersistable pCollPersistable) {
        long l;
        PCollNode pCollNode;
        if (this.mActiveObjsTab == null) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = PCollection.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28034", new Object[]{this.getName(), new Integer(this.getId())}, null);
        }
        if ((pCollNode = (PCollNode)this.activeObjWithId(l = pCollPersistable.getPCollParentId())) == null) {
            pCollNode = (PCollNode)PCollNode.activateObjWithId(this, l);
        }
        if (pCollNode != null) {
            return pCollNode.indexOf(pCollPersistable);
        }
        return -1;
    }

    public synchronized long size() {
        return this.mRoot.mNumOfObjs;
    }

    public static String pcollEventString(int n, Object object, Object object2) {
        String string = null;
        String string2 = null;
        string2 = object instanceof PCollNode ? "[PCollNode " + new Long(((PCollNode)object).getPersistentId()).toString() + "]" : (object instanceof PCollPersistable ? "[" + object.getClass().getName() + " " + new Long(((PCollPersistable)object).getPersistentId()).toString() + "]" : (object == null ? "null" : object.toString()));
        string = "**PCollEvent: " + n + ", obj=" + string2 + ", otherInfo=" + object2;
        return string;
    }

    public static void printPCollEvent(int n, Object object, Object object2) {
        if (Diagnostic.isOn()) {
            String string = PCollection.pcollEventString(n, object, object2);
            Diagnostic.println(string);
        }
    }

    public void notifyPCollEvent(int n, Object object, Object object2) {
        PersistManager persistManager = this.getPersistManager();
        if (persistManager != null) {
            persistManager.notifyPCollEvent(n, object, object2);
        }
    }

    public void setCollectionOfOne(boolean bl) {
        this.mIsCollectionOfOne = bl;
    }

    public boolean isCollectionOfOne() {
        return this.mIsCollectionOfOne;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

