/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.jbo.common.IDiagnostic;
import oracle.jbo.common.IDiagnostic2;

public class FileDiagnosticImpl
implements IDiagnostic2,
IDiagnostic {
    public static final String LOGFILE_PREFIX = "bc4j";
    public static final String LOGFILE_SUFFIX = ".log";
    private File m_LogFile;
    private PrintWriter m_LogStream;
    private boolean m_HaveWarned;

    public FileDiagnosticImpl() {
        this.$init$();
        try {
            this.m_LogFile = File.createTempFile(LOGFILE_PREFIX, LOGFILE_SUFFIX);
            this.m_LogStream = new PrintWriter((Writer)new FileWriter(this.m_LogFile), true);
        }
        catch (IOException iOException) {
            System.out.println("WARNING: could not create logfile: " + iOException.getMessage());
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public void print(String string) {
        try {
            this.m_LogStream.print(string);
        }
        catch (Exception exception) {
            System.out.print(string);
        }
    }

    private /* synthetic */ void $init$() {
        this.m_HaveWarned = false;
    }

    public void println(String string) {
        try {
            this.m_LogStream.println(string);
        }
        catch (Exception exception) {
            if (!this.m_HaveWarned) {
                System.out.println("WARNING: failed to write to m_LogFile.toString() - routing to console");
                System.out.println("FAILEDLOG: " + exception.getMessage());
                this.m_HaveWarned = true;
            }
            System.out.println(string);
        }
    }

    public void initialized(String string) {
        System.out.println("Diagnostics: (" + string + ") " + this.toString());
    }

    public String toString() {
        return "Routing diagnostics to File: " + this.m_LogFile.toString();
    }
}

