/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ws;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import oracle.adf.share.ADFContext;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ApplicationPoolSvcMsgContext;
import oracle.jbo.AttributeDef;
import oracle.jbo.ComponentObject;
import oracle.jbo.Exportable;
import oracle.jbo.JboException;
import oracle.jbo.JboExceptionHandler;
import oracle.jbo.JboWarning;
import oracle.jbo.LocaleContext;
import oracle.jbo.NoObjException;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.Session;
import oracle.jbo.SessionData;
import oracle.jbo.SortCriteria;
import oracle.jbo.Transaction;
import oracle.jbo.VariableManager;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.client.remote.ViewUsageImpl;
import oracle.jbo.common.ClientDocument;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.JboServiceMessage;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.RowSetHelper;
import oracle.jbo.common.SvcMsgRequestParams;
import oracle.jbo.common.SvcMsgResponseException;
import oracle.jbo.common.ampool.RemotePoolCookie;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.common.ampool.SessionCookieImpl;
import oracle.jbo.common.ws.WSApplicationModuleMarshaller;
import oracle.jbo.common.ws.WSAttributeDefImpl;
import oracle.jbo.common.ws.WSComponentObjectImpl;
import oracle.jbo.common.ws.WSObject;
import oracle.jbo.common.ws.WSProxy;
import oracle.jbo.common.ws.WSRowSetIteratorImpl;
import oracle.jbo.common.ws.WSViewLinkImpl;
import oracle.jbo.common.ws.WSViewObjectImpl;
import oracle.svcmsg.Request;
import oracle.svcmsg.ServiceMessage;

public class WSApplicationModuleImpl
extends WSObject
implements Exportable,
Serializable,
Session,
ApplicationModule {
    public static final int BATCH_ALLOW_XTN = 1;
    public static final int BATCH_ALLOW_RANGE_SET = 2;
    public static final int BATCH_ALLOW_INFO = 4;
    public static final int BATCH_ALLOW_CACHE = 8;
    public static final int BATCH_ALLOW_PASSIVATION = 16;
    public static final int BATCH_ALLOW_XML = 32;
    public static final int BATCH_ALLOW_MASTER_DETL = 64;
    public static final int BATCH_ALLOW_STRUCT = 128;
    public static final int BATCH_ALLOW_RANGE = 256;
    public static final int BATCH_DEFAULT = 511;
    private String mName;
    private String mDefFullName;
    private ArrayList mApplicationModules;
    private ArrayList mViewObjects;
    private ArrayList mViewLinks;
    private ArrayList mComponentObjects;
    private int mSyncMode;
    private String mAMFullName;
    private boolean mIsSyncIteratorState;
    private HashMap mFetchAttrsMap;
    private Locale mFetchAttrLocale;
    private HashMap mSortCriteriaMap;
    private Locale mLocale;
    private int mIsClient;
    private boolean mResetStateInProg;
    private transient HashMap mObjects;
    private transient HashMap mImplToWSObject;
    private transient ArrayList mObjsFromActivation;
    private transient WSApplicationModuleImpl mParent;
    private transient ApplicationModule mAM;
    private transient SessionCookie mSessionCookie;
    private transient boolean mWorkerAMInitialized;
    private transient boolean mReset;
    private transient boolean mSyncMarshaller;
    private transient boolean mIsSyncNeeded;
    private transient boolean mDeferredBeginRequest;
    private transient int mBatchCommMode;
    public static final String END_REQUEST_RELEASE_LEVEL = "__jbo.endrequest_release_level__";
    private transient HashMap mProxyVOMap;
    private static /* synthetic */ Class class$oracle$jbo$ApplicationModule;

    private /* synthetic */ void $init$() {
        this.mApplicationModules = new ArrayList(4);
        this.mViewObjects = new ArrayList(4);
        this.mViewLinks = new ArrayList(4);
        this.mComponentObjects = new ArrayList(4);
        this.mSyncMode = 0;
        this.mFetchAttrsMap = null;
        this.mSortCriteriaMap = null;
        this.mIsClient = -1;
        this.mResetStateInProg = false;
        this.mObjects = null;
        this.mImplToWSObject = null;
        this.mObjsFromActivation = null;
        this.mParent = null;
        this.mAM = null;
        this.mSessionCookie = null;
        this.mWorkerAMInitialized = false;
        this.mReset = false;
        this.mSyncMarshaller = false;
        this.mIsSyncNeeded = false;
        this.mDeferredBeginRequest = false;
        this.mBatchCommMode = 511;
        this.mProxyVOMap = new HashMap();
    }

    public WSApplicationModuleImpl(ApplicationModule applicationModule) {
        this.$init$();
        this.mAM = applicationModule;
        this.mObjStat = 1;
        this.mId = this.registerObject(this);
        applicationModule.setSyncMode(2);
        this.setSyncMode(2);
        ((WSApplicationModuleMarshaller)((Object)this.mAM)).setBoundToWorkingSet(true);
        ((WSApplicationModuleMarshaller)((Object)this.mAM)).bindToWorkingSet(this);
        this.afterCreate();
    }

    public WSApplicationModuleImpl(SessionCookie sessionCookie) {
        this.$init$();
        this.mSessionCookie = sessionCookie;
        this.mSessionCookie.setIgnorePiggyback(true);
        this.mSessionCookie.setReferenceCounting(true);
        this.mSessionCookie.setEnvironment("__jbo_bound_to_working_set__", "true");
        this.mObjStat = 1;
        this.mId = this.registerObject(this);
        this.afterCreate();
    }

    protected WSApplicationModuleImpl(String string, WSApplicationModuleImpl wSApplicationModuleImpl) {
        this.$init$();
        this.mName = string;
        this.mParent = wSApplicationModuleImpl;
        this.mObjStat = 1;
        this.mId = this.registerObject(this);
        this.afterCreate();
    }

    protected WSApplicationModuleImpl(String string, String string2, WSApplicationModuleImpl wSApplicationModuleImpl) {
        this.$init$();
        this.mName = string;
        this.mDefFullName = string2;
        this.mParent = wSApplicationModuleImpl;
        this.mObjStat = 0;
        this.mId = this.registerObject(this);
        this.afterCreate();
    }

    void afterCreate() {
        if (!this.isClient()) {
            this.doInit();
        }
    }

    public SessionCookie getSessionCookie() {
        return this.mSessionCookie;
    }

    public boolean isOnLine() {
        return this.mParent == null ? this.mSessionCookie == null : this.mParent.isOnLine();
    }

    public String getResponseName() {
        if (this.mAM != null) {
            return ((WSApplicationModuleMarshaller)((Object)this.mAM)).getResponseName();
        }
        return null;
    }

    public int getRemoteObjectId(Object object) {
        if (this.mAM != null) {
            return ((WSApplicationModuleMarshaller)((Object)this.mAM)).getRemoteObjectId(object);
        }
        return -1;
    }

    public Object marshal(Object object) {
        if (this.mAM != null) {
            return ((WSApplicationModuleMarshaller)((Object)this.mAM)).marshal(object);
        }
        return null;
    }

    public void setDataModelRefresh(boolean bl) {
        if (this.mAM != null) {
            ((WSApplicationModuleMarshaller)((Object)this.mAM)).setDataModelRefresh(bl);
        }
    }

    public void addResponse(Serializable serializable) {
        if (this.mAM != null) {
            ((WSApplicationModuleMarshaller)((Object)this.mAM)).addResponse(serializable);
        }
    }

    void processWSException(Exception exception, WSObject wSObject) {
        if (Diagnostic.isOn()) {
            Diagnostic.printStackTrace(exception);
        }
        boolean bl = wSObject.getImplObject() != null;
        wSObject.markForError(exception, bl);
        SvcMsgResponseException svcMsgResponseException = new SvcMsgResponseException("WorkingSetException", exception, wSObject.getId(), true, bl);
        this.addResponse(svcMsgResponseException);
    }

    public ObjectMarshaller getObjectMarshaller() {
        if (this.mAM == null) {
            throw new IllegalStateException();
        }
        return ((WSApplicationModuleMarshaller)((Object)this.mAM)).getObjectMarshaller();
    }

    public WSObject getParent() {
        return this.mParent;
    }

    public HashMap getObjects() {
        return this.mObjects;
    }

    public HashMap getActiveObjects() {
        if (this.mResetStateInProg) {
            return null;
        }
        return this.mObjects;
    }

    public boolean isSyncIteratorState() {
        return this.mIsSyncIteratorState;
    }

    public void setSyncIteratorState(boolean bl) {
        this.mIsSyncIteratorState = bl;
    }

    public ApplicationModule getApplicationModuleImpl() {
        return this.mAM;
    }

    void setApplicationModuleImpl(ApplicationModule applicationModule) {
        this.mAM = applicationModule;
        this.registerImplToWSObject(this.mAM, this);
    }

    public Object getImplObject() {
        return this.getApplicationModuleImpl();
    }

    public void setImplObject(Object object) {
        this.setApplicationModuleImpl((ApplicationModule)object);
    }

    public void markForError(Exception exception, boolean bl) {
        if (!bl) {
            this.mObjStat = -1;
            if (this.mParent != null) {
                this.mParent.removeChild(this);
            }
            this.mParent = null;
        }
    }

    public void detach() {
        if (this.mAM == null) {
            return;
        }
        ((WSApplicationModuleMarshaller)((Object)this.mAM)).detach();
    }

    public String getAMFullName() {
        return this.mAMFullName;
    }

    void registerImplToWSObject(Object object, WSObject wSObject) {
        if (this.mParent == null) {
            if (this.mImplToWSObject == null) {
                this.mImplToWSObject = new HashMap(4);
            }
            if (this.mImplToWSObject.get(object) == null) {
                this.mImplToWSObject.put(object, wSObject);
            }
            this.registerWSObject(wSObject);
        } else {
            this.mParent.registerImplToWSObject(object, wSObject);
        }
    }

    void registerWSObject(WSObject wSObject) {
        if (wSObject == null || wSObject.getId() <= 0) {
            return;
        }
        if (this.mParent == null) {
            if (this.mObjects == null) {
                this.mObjects = new HashMap(4);
            }
            this.mObjects.put(new Integer(wSObject.getId()), wSObject);
        } else {
            this.mParent.registerWSObject(wSObject);
        }
    }

    WSObject getWSObjectFromImpl(Object object) {
        if (this.mParent == null) {
            return this.mImplToWSObject != null ? (WSObject)this.mImplToWSObject.get(object) : null;
        }
        return this.mParent.getWSObjectFromImpl(object);
    }

    int registerObject(Object object) {
        if (this.mParent == null) {
            int n = WSObject.mIdCtr++;
            if (this.mObjects == null) {
                this.mObjects = new HashMap(4);
            }
            this.mObjects.put(new Integer(n), object);
            this.setIsSyncNeeded(true);
            return n;
        }
        return this.mParent.registerObject(object);
    }

    public void registerObjFromActivation(Object object) {
        if (this.mParent == null) {
            if (this.mObjsFromActivation == null) {
                this.mObjsFromActivation = new ArrayList(4);
            }
            this.mObjsFromActivation.add(object);
        } else {
            this.mParent.registerObjFromActivation(object);
        }
    }

    void removeChild(Object object) {
        if (object instanceof WSObject) {
            WSObject wSObject = (WSObject)object;
            if (this.mObjects != null) {
                this.mObjects.remove(new Integer(wSObject.getId()));
            }
            if (wSObject.getImplObject() != null) {
                this.mImplToWSObject.remove(wSObject.getImplObject());
            }
        }
        if (object instanceof WSApplicationModuleImpl) {
            this.mApplicationModules.remove(object);
        } else if (object instanceof WSViewObjectImpl) {
            this.mViewObjects.remove(object);
        } else if (object instanceof WSViewLinkImpl) {
            this.mViewLinks.remove(object);
        } else if (object instanceof WSComponentObjectImpl) {
            this.mComponentObjects.remove(object);
        }
    }

    public void addChildAM(WSApplicationModuleImpl wSApplicationModuleImpl) {
        Object v = this.mObjects.remove(new Integer(this.mId));
        if (this.mObjects != null && !this.mObjects.isEmpty()) {
            throw new JboException("Internal error: addChildAM called on a WSAM whose mObjects is not empty");
        }
        this.mObjects = wSApplicationModuleImpl.mObjects;
        if (v != null) {
            this.mObjects.put(new Integer(this.mId), v);
        }
        if (this.mImplToWSObject != null && !this.mImplToWSObject.isEmpty()) {
            throw new JboException("Internal error: addChildAM called on a WSAM whose mImplToWSObject is not empty");
        }
        this.mImplToWSObject = wSApplicationModuleImpl.mImplToWSObject;
        if (this.mObjsFromActivation != null && !this.mObjsFromActivation.isEmpty()) {
            throw new JboException("Internal error: addChildAM called on a WSAM whose mObjsFromActivation is not empty");
        }
        this.mObjsFromActivation = wSApplicationModuleImpl.mObjsFromActivation;
        wSApplicationModuleImpl.mObjects = null;
        wSApplicationModuleImpl.mImplToWSObject = null;
        wSApplicationModuleImpl.mObjsFromActivation = null;
        wSApplicationModuleImpl.mParent = this;
        this.addChild(wSApplicationModuleImpl);
    }

    protected void addChild(Object object) {
        if (object instanceof WSApplicationModuleImpl) {
            this.mApplicationModules.add(object);
        } else if (object instanceof WSViewObjectImpl) {
            this.mViewObjects.add(object);
        } else if (object instanceof WSViewLinkImpl) {
            this.mViewLinks.add(object);
        } else if (object instanceof WSComponentObjectImpl) {
            this.mComponentObjects.add(object);
        }
    }

    public void prepareResetState() {
        this.mResetStateInProg = true;
    }

    void beforeSend(List list) {
        if (this.mAM != null) {
            if (this.mName == null) {
                this.mName = this.mAM.getName();
            }
            this.mAMFullName = this.mAM.getFullName();
        }
        if (this.mResetStateInProg) {
            return;
        }
        int n = 0;
        while (n < this.mViewObjects.size()) {
            WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
            wSViewObjectImpl.beforeSend(list);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mViewLinks.size()) {
            WSViewLinkImpl wSViewLinkImpl = (WSViewLinkImpl)this.mViewLinks.get(n2);
            wSViewLinkImpl.beforeSend(list);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.mComponentObjects.size()) {
            WSComponentObjectImpl wSComponentObjectImpl = (WSComponentObjectImpl)this.mComponentObjects.get(n3);
            wSComponentObjectImpl.beforeSend(list);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.mApplicationModules.size()) {
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.mApplicationModules.get(n4);
            wSApplicationModuleImpl.beforeSend(list);
            ++n4;
        }
    }

    void afterSend() {
        if (this.mObjStat == 100) {
            if (this.mParent != null) {
                this.mParent.removeChild(this);
            }
            return;
        }
        this.mIsSyncIteratorState = false;
        this.mSyncMarshaller = false;
        this.setIsSyncNeeded(false);
        if (this.mResetStateInProg) {
            this.mResetStateInProg = false;
            return;
        }
        int n = 0;
        while (n < this.mViewObjects.size()) {
            WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
            wSViewObjectImpl.afterSend();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mViewLinks.size()) {
            WSViewLinkImpl wSViewLinkImpl = (WSViewLinkImpl)this.mViewLinks.get(n2);
            wSViewLinkImpl.afterSend();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.mComponentObjects.size()) {
            WSComponentObjectImpl wSComponentObjectImpl = (WSComponentObjectImpl)this.mComponentObjects.get(n3);
            wSComponentObjectImpl.afterSend();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.mApplicationModules.size()) {
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.mApplicationModules.get(n4);
            wSApplicationModuleImpl.afterSend();
            ++n4;
        }
    }

    public void doInit() {
        if (this.mObjStat == -1) {
            return;
        }
        try {
            if (this.mParent != null) {
                ApplicationModule applicationModule;
                ApplicationModule applicationModule2 = this.mParent.getApplicationModuleImpl();
                if (this.mObjStat == 0) {
                    applicationModule = applicationModule2.createApplicationModule(this.mName, this.mDefFullName);
                } else {
                    applicationModule = applicationModule2.findApplicationModule(this.mName);
                    if (applicationModule == null) {
                        throw new NoObjException(111, this.mName);
                    }
                    if (this.mObjStat == 100) {
                        applicationModule.remove();
                        return;
                    }
                }
                this.setApplicationModuleImpl(applicationModule);
            }
            this.setSyncMode(this.mSyncMode);
            int n = 0;
            while (n < this.mViewObjects.size()) {
                WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
                wSViewObjectImpl.doInit();
                ++n;
            }
            int n2 = 0;
            while (n2 < this.mViewLinks.size()) {
                WSViewLinkImpl wSViewLinkImpl = (WSViewLinkImpl)this.mViewLinks.get(n2);
                wSViewLinkImpl.doInit();
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.mComponentObjects.size()) {
                WSComponentObjectImpl wSComponentObjectImpl = (WSComponentObjectImpl)this.mComponentObjects.get(n3);
                wSComponentObjectImpl.doInit();
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.mApplicationModules.size()) {
                WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.mApplicationModules.get(n4);
                wSApplicationModuleImpl.doInit();
                ++n4;
            }
            int n5 = 0;
            while (n5 < this.mViewObjects.size()) {
                WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n5);
                wSViewObjectImpl.doInit2();
                ++n5;
            }
        }
        catch (Exception exception) {
            this.processWSException(exception, this);
        }
    }

    public void doWork() {
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        try {
            int n = 0;
            while (n < this.mViewObjects.size()) {
                WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
                wSViewObjectImpl.doWork();
                ++n;
            }
            int n2 = 0;
            while (n2 < this.mViewObjects.size()) {
                WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n2);
                wSViewObjectImpl.doWorkPart2();
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.mApplicationModules.size()) {
                WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.mApplicationModules.get(n3);
                wSApplicationModuleImpl.doWork();
                ++n3;
            }
        }
        catch (Exception exception) {
            this.processWSException(exception, this);
        }
    }

    public void doFinish(boolean bl) {
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        try {
            int n = 0;
            while (n < this.mViewObjects.size()) {
                WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
                wSViewObjectImpl.doFinish(bl);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.mApplicationModules.size()) {
                WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.mApplicationModules.get(n2);
                wSApplicationModuleImpl.doFinish(bl);
                ++n2;
            }
        }
        catch (Exception exception) {
            this.processWSException(exception, this);
        }
    }

    public ArrayList getAllRowSetIterators() {
        if (this.mResetStateInProg) {
            return new ArrayList(0);
        }
        return this.collectRowSetIterators(new ArrayList(4));
    }

    ArrayList collectRowSetIterators(ArrayList arrayList) {
        int n = 0;
        while (n < this.mViewObjects.size()) {
            WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
            wSViewObjectImpl.collectRowSetIterators(arrayList);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mApplicationModules.size()) {
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.mApplicationModules.get(n2);
            wSApplicationModuleImpl.collectRowSetIterators(arrayList);
            ++n2;
        }
        return arrayList;
    }

    public ApplicationModule createApplicationModule(String string, String string2) {
        WSApplicationModuleImpl wSApplicationModuleImpl = new WSApplicationModuleImpl(string, string2, this);
        this.addChild(wSApplicationModuleImpl);
        return wSApplicationModuleImpl;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public ApplicationModule findApplicationModule(String string) {
        return this.findApplicationModuleWSInternal(string, true);
    }

    ApplicationModule findApplicationModuleWSInternal(String string, boolean bl) {
        if (WSApplicationModuleImpl.isEmpty(string)) {
            WSApplicationModuleImpl wSApplicationModuleImpl = this;
            while (wSApplicationModuleImpl.getParent() != null) {
                wSApplicationModuleImpl = (WSApplicationModuleImpl)wSApplicationModuleImpl.getParent();
            }
            return wSApplicationModuleImpl;
        }
        String string2 = JboNameUtil.getFirstPartOfName(string);
        String string3 = JboNameUtil.getRemainingPartOfName(string);
        WSApplicationModuleImpl wSApplicationModuleImpl = this.findWSApplicationModule(string2);
        if (wSApplicationModuleImpl == null) {
            ApplicationModule applicationModule;
            if (bl && (applicationModule = this.getApplicationModuleImpl()) != null && applicationModule.isRoot() && (string2.equals(applicationModule.getName()) || string2.equals("Root"))) {
                return this.findApplicationModuleWSInternal(string3, false);
            }
            wSApplicationModuleImpl = new WSApplicationModuleImpl(string2, this);
            this.addChild(wSApplicationModuleImpl);
        }
        if (string3 == null) {
            return wSApplicationModuleImpl;
        }
        return wSApplicationModuleImpl.findApplicationModuleWSInternal(string3, false);
    }

    public WSApplicationModuleImpl findWSApplicationModule(String string) {
        int n = 0;
        while (n < this.mApplicationModules.size()) {
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.mApplicationModules.get(n);
            String string2 = wSApplicationModuleImpl.getName();
            if (string != null && string.equals(string2)) {
                return wSApplicationModuleImpl;
            }
            ++n;
        }
        return null;
    }

    public String[] getApplicationModuleNames() {
        return this.getApplicationModuleNames(true, false);
    }

    public String[] getApplicationModuleNames(boolean bl, boolean bl2) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getApplicationModuleNames(bl, bl2);
        }
        this.invalidOperation("getApplicationModuleNames");
        return null;
    }

    public String[] getWSApplicationModuleNames() {
        String[] stringArray = new String[this.mApplicationModules.size()];
        int n = 0;
        while (n < this.mApplicationModules.size()) {
            stringArray[n] = ((ApplicationModule)this.mApplicationModules.get(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public Request createRequest() {
        return new SvcMsgRequestParams(143, Integer.MAX_VALUE, "WorkingSetRequest").setObjectParam(this);
    }

    public ServiceMessage createSyncMessage() {
        JboServiceMessage jboServiceMessage = new JboServiceMessage("WorkingSetSync", 2);
        jboServiceMessage.addRequest(this.createRequest());
        return jboServiceMessage;
    }

    public void setIsSyncNeeded(boolean bl) {
        if (this.mParent == null) {
            this.mIsSyncNeeded = bl;
        } else {
            this.mParent.setIsSyncNeeded(bl);
        }
    }

    public boolean isSyncNeeded() {
        if (this.mParent == null) {
            if (this.mIsSyncNeeded) {
                return true;
            }
            return this.mAM != null && ((WSApplicationModuleMarshaller)((Object)this.mAM)).hasPendingDataPosts();
        }
        return this.mParent.isSyncNeeded();
    }

    public void syncIfNeeded() {
        if (this.isSyncNeeded()) {
            this.sync();
        }
    }

    public void sync() {
        if (this.mParent == null) {
            if (this.mAM != null && !this.isClient()) {
                return;
            }
            this.sendRequests("syncWorkingSet", this.createSyncMessage());
        } else {
            this.mParent.sync();
        }
    }

    public ServiceMessage sendRequests(String string, ServiceMessage serviceMessage) {
        List list = serviceMessage.getRequests();
        ServiceMessage serviceMessage2 = null;
        if (this.mParent == null) {
            this.doBeginRequest();
            try {
                this.isClient();
                this.createWorkerApplicationModule();
                SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(146, Integer.MAX_VALUE, null);
                svcMsgRequestParams.setObjectParam(this.mLocale);
                list.add(0, svcMsgRequestParams);
                this.beforeSend(list);
                if (this.mFetchAttrsMap != null) {
                    svcMsgRequestParams = new SvcMsgRequestParams(159, Integer.MAX_VALUE, null);
                    svcMsgRequestParams.setObjectParams(new Object[]{this.mFetchAttrsMap, this.mFetchAttrLocale});
                    list.add(0, svcMsgRequestParams);
                    this.mFetchAttrsMap = null;
                    this.mFetchAttrLocale = null;
                }
                if (this.mSortCriteriaMap != null) {
                    svcMsgRequestParams = new SvcMsgRequestParams(217, Integer.MAX_VALUE, null);
                    svcMsgRequestParams.setObjectParams(new Object[]{this.mSortCriteriaMap});
                    list.add(0, svcMsgRequestParams);
                    this.mSortCriteriaMap = null;
                }
                ArrayList arrayList = this.getAllRowSetIterators();
                int n = 0;
                while (n < arrayList.size()) {
                    WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)arrayList.get(n);
                    if (wSRowSetIteratorImpl.needsRefresh()) {
                        String string2 = wSRowSetIteratorImpl.getFullName();
                        svcMsgRequestParams = new SvcMsgRequestParams(20, string2, "refresh_" + string2);
                        svcMsgRequestParams.setIntParams(new int[]{-1});
                        svcMsgRequestParams.setBooleanParams(new boolean[]{true});
                        list.add(svcMsgRequestParams);
                    }
                    ++n;
                }
                if (this.mObjsFromActivation != null) {
                    this.mObjsFromActivation.clear();
                }
                if (this.mSyncMarshaller) {
                    ((WSApplicationModuleMarshaller)((Object)this.mAM)).syncMarshaller(serviceMessage);
                }
                serviceMessage2 = ((WSApplicationModuleMarshaller)((Object)this.mAM)).sendWorkingSetRequests(string, this, serviceMessage);
                Object var11_10 = null;
                if (!this.isOnLine()) {
                    this.detach();
                }
                this.afterSend();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (!this.isOnLine()) {
                    this.detach();
                }
                this.afterSend();
                throw throwable;
            }
        } else {
            this.mParent.sendRequests(string, serviceMessage);
        }
        return serviceMessage2;
    }

    public void setBatchCommMode(int n) {
        if (this.isRoot()) {
            this.mBatchCommMode = n;
        } else {
            this.getRootWSApplicationModule().setBatchCommMode(n);
        }
    }

    public int getBatchCommMode() {
        if (this.isRoot()) {
            return this.mBatchCommMode;
        }
        return this.getRootWSApplicationModule().getBatchCommMode();
    }

    public void setSyncMode(int n) {
        if (this.isRoot()) {
            this.mSyncMode = n;
        } else {
            this.getRootWSApplicationModule().setSyncMode(n);
        }
    }

    public int getSyncMode() {
        if (this.isRoot()) {
            return this.mSyncMode;
        }
        return this.getRootWSApplicationModule().getSyncMode();
    }

    public ViewObject createViewObject(String string, String string2) {
        WSViewObjectImpl wSViewObjectImpl = new WSViewObjectImpl(string, string2, true, this);
        this.addChild(wSViewObjectImpl);
        return wSViewObjectImpl;
    }

    public ViewObject createViewObjectFromQueryClauses(String string, String string2, String string3, String string4, String string5, String string6) {
        WSViewObjectImpl wSViewObjectImpl = new WSViewObjectImpl(string, string2, string3, string4, string5, string6, this);
        this.addChild(wSViewObjectImpl);
        return wSViewObjectImpl;
    }

    public ViewObject createViewObjectOnEntity(String string, String string2) {
        return null;
    }

    public ViewObject createViewObjectOnRowSet(String string, RowSet rowSet) {
        return null;
    }

    public ViewObject createViewObjectFromQueryStmt(String string, String string2) {
        WSViewObjectImpl wSViewObjectImpl = new WSViewObjectImpl(string, string2, false, this);
        this.addChild(wSViewObjectImpl);
        return wSViewObjectImpl;
    }

    public ViewObject findViewObject(String string) {
        String string2 = JboNameUtil.getContainerPartOfName(string);
        string = JboNameUtil.getLastPartOfName(string);
        if (string2 != null) {
            ApplicationModule applicationModule = this.findApplicationModule(string2);
            ViewObject viewObject = applicationModule.findViewObject(string);
            if (viewObject instanceof WSViewObjectImpl) {
                ViewObject viewObject2 = this.findproxyForVO((WSViewObjectImpl)viewObject);
                if (viewObject2 == null) {
                    return viewObject;
                }
                return viewObject2;
            }
            return viewObject;
        }
        WSViewObjectImpl wSViewObjectImpl = this.findWSViewObject(string);
        if (wSViewObjectImpl == null) {
            wSViewObjectImpl = new WSViewObjectImpl(string, this);
            this.addChild(wSViewObjectImpl);
            ViewObject viewObject = this.findproxyForVO(wSViewObjectImpl);
            if (viewObject != null) {
                return viewObject;
            }
        } else {
            ViewObject viewObject = this.findproxyForVO(wSViewObjectImpl);
            if (viewObject != null) {
                return viewObject;
            }
        }
        return wSViewObjectImpl;
    }

    private ViewObject findproxyForVO(WSViewObjectImpl wSViewObjectImpl) {
        ViewObject viewObject = (ViewObject)this.mProxyVOMap.get(wSViewObjectImpl);
        if (viewObject != null) {
            return viewObject;
        }
        ViewObject viewObject2 = wSViewObjectImpl.getViewObjectImpl();
        if (viewObject2 != null && viewObject2 instanceof ViewUsageImpl) {
            ViewUsageImpl viewUsageImpl = (ViewUsageImpl)viewObject2;
            String string = viewUsageImpl.getInterfaceName();
            ViewObject viewObject3 = WSProxy.createCustomVoProxy(wSViewObjectImpl, string);
            this.mProxyVOMap.put(wSViewObjectImpl, viewObject3);
            return viewObject3;
        }
        return null;
    }

    public WSViewObjectImpl findWSViewObject(String string) {
        int n = 0;
        while (n < this.mViewObjects.size()) {
            WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
            String string2 = wSViewObjectImpl.getName();
            if (string != null && string.equals(string2)) {
                return wSViewObjectImpl;
            }
            ++n;
        }
        return null;
    }

    public String[] getViewObjectNames() {
        return this.getViewObjectNames(true, false);
    }

    public String[] getViewObjectNames(boolean bl, boolean bl2) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getViewObjectNames(bl, bl2);
        }
        this.invalidOperation("getViewObjectNames");
        return null;
    }

    public String[] getWSViewObjectNames() {
        String[] stringArray = new String[this.mViewObjects.size()];
        int n = 0;
        while (n < this.mViewObjects.size()) {
            stringArray[n] = ((ViewObject)this.mViewObjects.get(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public ViewLink createViewLink(String string, String string2, ViewObject viewObject, ViewObject viewObject2) {
        WSViewLinkImpl wSViewLinkImpl = new WSViewLinkImpl(string, string2, true, (WSViewObjectImpl)viewObject, (WSViewObjectImpl)viewObject2, this);
        this.addChild(wSViewLinkImpl);
        return wSViewLinkImpl;
    }

    public ViewLink createViewLinkFromEntityAssocName(String string, String string2, ViewObject viewObject, ViewObject viewObject2) {
        WSViewLinkImpl wSViewLinkImpl = new WSViewLinkImpl(string, string2, false, (WSViewObjectImpl)viewObject, (WSViewObjectImpl)viewObject2, this);
        this.addChild(wSViewLinkImpl);
        return wSViewLinkImpl;
    }

    public ViewLink createViewLinkBetweenViewObjects(String string, String string2, ViewObject viewObject, AttributeDef[] attributeDefArray, ViewObject viewObject2, AttributeDef[] attributeDefArray2, String string3) {
        WSViewLinkImpl wSViewLinkImpl = new WSViewLinkImpl(string, string2, (WSViewObjectImpl)viewObject, (WSAttributeDefImpl[])attributeDefArray, (WSViewObjectImpl)viewObject2, (WSAttributeDefImpl[])attributeDefArray2, string3, this);
        this.addChild(wSViewLinkImpl);
        return wSViewLinkImpl;
    }

    public ViewLink findViewLink(String string) {
        WSViewLinkImpl wSViewLinkImpl = this.findWSViewLink(string);
        if (wSViewLinkImpl == null) {
            wSViewLinkImpl = new WSViewLinkImpl(string, this);
            this.addChild(wSViewLinkImpl);
        }
        return wSViewLinkImpl;
    }

    public WSViewLinkImpl findWSViewLink(String string) {
        int n = 0;
        while (n < this.mViewLinks.size()) {
            WSViewLinkImpl wSViewLinkImpl = (WSViewLinkImpl)this.mViewLinks.get(n);
            String string2 = wSViewLinkImpl.getName();
            if (string != null && string.equals(string2)) {
                return wSViewLinkImpl;
            }
            ++n;
        }
        return null;
    }

    public String[] getViewLinkNames() {
        return this.getViewLinkNames(true, false);
    }

    public String[] getViewLinkNames(boolean bl, boolean bl2) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getViewLinkNames(bl, bl2);
        }
        this.invalidOperation("getViewLinkNames");
        return null;
    }

    public String[] getWSViewLinkNames() {
        String[] stringArray = new String[this.mViewLinks.size()];
        int n = 0;
        while (n < this.mViewLinks.size()) {
            stringArray[n] = ((ViewLink)this.mViewLinks.get(n)).getName();
            ++n;
        }
        return stringArray;
    }

    public ComponentObject createComponentObject(String string, String string2) {
        WSComponentObjectImpl wSComponentObjectImpl = new WSComponentObjectImpl(string, string2, this);
        this.addChild(wSComponentObjectImpl);
        return wSComponentObjectImpl;
    }

    public ComponentObject findComponentObject(String string) {
        WSComponentObjectImpl wSComponentObjectImpl = this.findWSComponentObject(string);
        if (wSComponentObjectImpl == null) {
            wSComponentObjectImpl = new WSComponentObjectImpl(string, this);
            this.addChild(wSComponentObjectImpl);
        }
        return wSComponentObjectImpl;
    }

    public WSComponentObjectImpl findWSComponentObject(String string) {
        int n = 0;
        while (n < this.mComponentObjects.size()) {
            WSComponentObjectImpl wSComponentObjectImpl = (WSComponentObjectImpl)this.mComponentObjects.get(n);
            String string2 = wSComponentObjectImpl.getName();
            if (string != null && string.equals(string2)) {
                return wSComponentObjectImpl;
            }
            ++n;
        }
        return null;
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public WSApplicationModuleImpl getRootWSApplicationModule() {
        WSApplicationModuleImpl wSApplicationModuleImpl = this;
        WSApplicationModuleImpl wSApplicationModuleImpl2 = this.mParent;
        while (wSApplicationModuleImpl2 != null) {
            wSApplicationModuleImpl = wSApplicationModuleImpl2;
            wSApplicationModuleImpl2 = (WSApplicationModuleImpl)wSApplicationModuleImpl.getParent();
        }
        return wSApplicationModuleImpl;
    }

    public Transaction getTransaction() {
        if (this.mAM == null) {
            this.sync();
        }
        return this.mAM != null ? this.mAM.getTransaction() : this.mParent.getTransaction();
    }

    public Session getSession() {
        return this;
    }

    public Object getSyncLock() {
        if (this.mAM == null) {
            this.sync();
        }
        return this.mAM != null ? this.mAM.getSyncLock() : this.mParent.getSyncLock();
    }

    public void clearVOCaches(String string, boolean bl) {
        if (this.mAM != null && (this.getBatchCommMode() & 8) != 0) {
            this.mAM.clearVOCaches(string, bl);
        } else {
            this.invalidOperation("clearVOCaches");
        }
    }

    public RowSetIterator findRSIForEntity(RowSetIterator[] rowSetIteratorArray, int n) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.findRSIForEntity(rowSetIteratorArray, n);
        }
        this.invalidOperation("findRSIForEntity");
        return null;
    }

    public ViewObject findViewObjectWithParameters(String string, VariableManager variableManager, boolean bl) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            WSViewObjectImpl wSViewObjectImpl = this.findWSViewObject(string);
            if (wSViewObjectImpl == null) {
                ViewObject viewObject = this.mAM.findViewObjectWithParameters(string, variableManager, bl);
                wSViewObjectImpl = new WSViewObjectImpl(string, this);
                this.addChild(wSViewObjectImpl);
                return wSViewObjectImpl;
            }
            RowSetHelper.updateNamedWhereParamValues(wSViewObjectImpl.getDefaultRowSet(), (VariableValueManager)variableManager, bl);
            ViewObject viewObject = this.findproxyForVO(wSViewObjectImpl);
            if (viewObject != null) {
                return viewObject;
            }
            return wSViewObjectImpl;
        }
        this.invalidOperation("findViewObjectWithParameters");
        return null;
    }

    public ViewObject findViewObjectUsingEntity(ViewObject[] viewObjectArray, String string, String[] stringArray) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            ViewObject viewObject;
            ViewObject viewObject2 = this.mAM.findViewObjectUsingEntity(viewObjectArray, string, stringArray);
            if (viewObject2 instanceof WSViewObjectImpl && (viewObject = this.findproxyForVO((WSViewObjectImpl)viewObject2)) != null) {
                return viewObject;
            }
            return viewObject2;
        }
        this.invalidOperation("findViewObjectUsingEntity");
        return null;
    }

    public Object[] transformExceptionParams(ViewObject[] viewObjectArray, String string, String string2, Object[] objectArray) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.transformExceptionParams(viewObjectArray, string, string2, objectArray);
        }
        this.invalidOperation("transformExceptionParams");
        return null;
    }

    public JboExceptionHandler getExceptionHandler() {
        if (this.mAM != null) {
            return this.mAM.getExceptionHandler();
        }
        this.invalidOperation("getExceptionHandler");
        return null;
    }

    public void setExceptionHandler(JboExceptionHandler jboExceptionHandler) {
        if (this.mAM != null) {
            this.mAM.setExceptionHandler(jboExceptionHandler);
        } else {
            this.invalidOperation("setExceptionHandler");
        }
    }

    public void addWarning(JboWarning jboWarning) {
        if (this.mAM != null) {
            this.mAM.addWarning(jboWarning);
        } else {
            this.invalidOperation("addWarning");
        }
    }

    public ClientDocument getStyles(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getStyles(string);
        }
        this.invalidOperation("getStyles");
        return null;
    }

    public void setStyles(String string, ClientDocument clientDocument) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            this.mAM.setStyles(string, clientDocument);
        } else {
            this.invalidOperation("setStyles");
        }
    }

    public int reserveSnapshotId(int n) {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.reserveSnapshotId(n);
        }
        this.invalidOperation("reserveSnapshotId");
        return -1;
    }

    public int getMostRecentStackId() {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.getMostRecentStackId();
        }
        this.invalidOperation("getMostRecentStackId");
        return -1;
    }

    public int reservePassivationId() {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.reservePassivationId();
        }
        this.invalidOperation("reservePassivationId");
        return -1;
    }

    public int passivateState(int n, byte[] byArray) {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.passivateState(n, byArray);
        }
        this.invalidOperation("passivateState");
        return -1;
    }

    public int passivateState(byte[] byArray) {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.passivateState(byArray);
        }
        this.invalidOperation("passivateState");
        return -1;
    }

    public int passivateState(int n, byte[] byArray, int n2) {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.passivateState(n, byArray, n2);
        }
        this.invalidOperation("passivateState");
        return -1;
    }

    public int passivateState(byte[] byArray, int n) {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.passivateState(byArray, n);
        }
        this.invalidOperation("passivateState");
        return -1;
    }

    public String passivateStateForUndo(String string, byte[] byArray, int n) {
        if (this.mAM == null) {
            this.sync();
        }
        return this.mAM.passivateStateForUndo(string, byArray, n);
    }

    public byte[] activateState(int n, boolean bl, SessionData sessionData) {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            return this.mAM.activateState(n, bl, sessionData);
        }
        this.invalidOperation("activateState");
        return null;
    }

    public byte[] activateState(int n, boolean bl) {
        this.invalidOperation("activateState");
        return null;
    }

    public byte[] activateState(int n, SessionData sessionData, int n2) {
        this.invalidOperation("activateState");
        return null;
    }

    public byte[] activateStateForUndo(String string, int n) {
        if (this.mAM == null) {
            this.sync();
        }
        byte[] byArray = this.mAM.activateStateForUndo(string, n);
        this.sync();
        return byArray;
    }

    public boolean isValidIdForUndo(String string) {
        if (this.mAM == null) {
            this.sync();
        }
        return this.mAM.isValidIdForUndo(string);
    }

    public ApplicationPoolSvcMsgContext doPoolMessage(ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        this.invalidOperation("doPoolMessage");
        return null;
    }

    public void prepareSession(SessionData sessionData) {
        this.invalidOperation("prepareSession");
    }

    public void resetState(boolean bl) {
        this.invalidOperation("resetState");
    }

    public void resetState(int n) {
        if (this.mAM != null) {
            this.mAM.resetState(8);
        }
        this.mReset = true;
    }

    public void removeState(int n) {
        this.invalidOperation("removeState");
    }

    public void setStoreForPassiveState(byte by) {
        if (this.mAM != null && (this.getBatchCommMode() & 0x10) != 0) {
            this.mAM.setStoreForPassiveState(by);
        } else {
            this.invalidOperation("setStoreForPassiveState");
        }
    }

    public void fetchAttributeProperties(String[] stringArray, String[][] stringArray2, LocaleContext localeContext) {
        if (this.mFetchAttrsMap == null) {
            this.mFetchAttrsMap = new HashMap(8);
        }
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String[] stringArray3 = stringArray2 != null ? stringArray2[n] : null;
            ArrayList<String> arrayList = (ArrayList<String>)this.mFetchAttrsMap.get(stringArray[n]);
            if (arrayList == null) {
                if (stringArray3 != null) {
                    arrayList = new ArrayList<String>(stringArray3.length);
                    n2 = 0;
                    while (n2 < stringArray3.length) {
                        arrayList.add(stringArray3[n2]);
                        ++n2;
                    }
                }
                this.mFetchAttrsMap.put(stringArray[n], arrayList);
            } else if (stringArray3 != null) {
                n2 = 0;
                while (n2 < stringArray3.length) {
                    if (!arrayList.contains(stringArray3[n2])) {
                        arrayList.add(stringArray3[n2]);
                    }
                    ++n2;
                }
            } else {
                this.mFetchAttrsMap.put(stringArray[n], null);
            }
            ++n;
        }
        this.mFetchAttrLocale = localeContext != null ? localeContext.getLocale() : null;
        this.setIsSyncNeeded(true);
    }

    public void applyVOSortCriteria(ViewObject viewObject, SortCriteria[] sortCriteriaArray) {
        if (this.mSortCriteriaMap == null) {
            this.mSortCriteriaMap = new HashMap(10);
        }
        this.mSortCriteriaMap.put(viewObject.getFullName(), sortCriteriaArray);
        this.setIsSyncNeeded(true);
    }

    public String getDefName() {
        if (this.mAM != null) {
            return this.mAM.getDefName();
        }
        if (this.mDefFullName == null) {
            return null;
        }
        return JboNameUtil.getLastPartOfName(this.mDefFullName);
    }

    public String getDefFullName() {
        return this.mAM != null ? this.mAM.getDefFullName() : this.mDefFullName;
    }

    public String getName() {
        return this.mAM != null ? this.mAM.getName() : this.mName;
    }

    public String getFullName() {
        return this.mAM != null ? this.mAM.getFullName() : this.mParent.getFullName() + "." + this.mName;
    }

    public void remove() {
        if (this.mObjStat == 0 && this.mParent != null) {
            this.mParent.removeChild(this);
        }
        this.mObjStat = 100;
    }

    public void closeWSApplicationModule() {
        if (this.mSessionCookie != null) {
            ((SessionCookieImpl)this.mSessionCookie).timeout();
            this.mSessionCookie = null;
        }
    }

    public Object getProperty(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getProperty(string);
        }
        this.invalidOperation("getProperty");
        return null;
    }

    public Object refreshProperty(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.refreshProperty(string);
        }
        this.invalidOperation("refreshProperty");
        return null;
    }

    public Hashtable getProperties() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getProperties();
        }
        this.invalidOperation("getProperties");
        return null;
    }

    public void resolve(ApplicationModule applicationModule) {
        this.setApplicationModuleImpl(applicationModule);
        this.resolveAfterLoad(null);
    }

    void resolveAfterLoad(WSApplicationModuleImpl wSApplicationModuleImpl) {
        this.mParent = wSApplicationModuleImpl;
        int n = 0;
        while (n < this.mViewObjects.size()) {
            WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)this.mViewObjects.get(n);
            wSViewObjectImpl.resolveAfterLoad(this);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mViewLinks.size()) {
            WSViewLinkImpl wSViewLinkImpl = (WSViewLinkImpl)this.mViewLinks.get(n2);
            wSViewLinkImpl.resolveAfterLoad(this);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.mComponentObjects.size()) {
            WSComponentObjectImpl wSComponentObjectImpl = (WSComponentObjectImpl)this.mComponentObjects.get(n3);
            wSComponentObjectImpl.resolveAfterLoad(this);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.mApplicationModules.size()) {
            WSApplicationModuleImpl wSApplicationModuleImpl2 = (WSApplicationModuleImpl)this.mApplicationModules.get(n4);
            wSApplicationModuleImpl2.resolveAfterLoad(this);
            ++n4;
        }
    }

    public WSApplicationModuleMarshaller getWSApplicationModuleMarshaller() {
        return null;
    }

    public Object get(Object object) {
        if (object instanceof String) {
            String string = JboNameUtil.toUpperCaseFirstChar((String)object);
            ComponentObject componentObject = this.getApplicationModuleImpl().findViewObject(string);
            if (componentObject != null) {
                return componentObject;
            }
            componentObject = this.getApplicationModuleImpl().findViewLink(string);
            if (componentObject != null) {
                return componentObject;
            }
        }
        return super.get(object);
    }

    public String getVersion() {
        if (this.mAM != null) {
            return this.mAM.getSession().getVersion();
        }
        this.invalidOperation("getVersion");
        return null;
    }

    public Locale getLocale() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getLocale();
        }
        this.invalidOperation("getLocale");
        return null;
    }

    public void setLocale(Locale locale) {
        if (!(locale == null || this.mLocale != null && this.mLocale.equals(locale))) {
            this.mLocale = locale;
            if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
                this.mAM.getSession().setLocale(locale);
            } else {
                this.invalidOperation("setLocale");
            }
        }
    }

    public String[] getPackageNames() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getPackageNames();
        }
        this.invalidOperation("getPackageNames");
        return null;
    }

    public String[] getApplicationModuleDefNames(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getApplicationModuleDefNames(string);
        }
        this.invalidOperation("getApplicationModuleDefNames");
        return null;
    }

    public String[] getAllApplicationModuleDefNames() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getAllApplicationModuleDefNames();
        }
        this.invalidOperation("getAllApplicationModuleDefNames");
        return null;
    }

    public String[] getViewDefNames(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getViewDefNames(string);
        }
        this.invalidOperation("getViewDefNames");
        return null;
    }

    public String[] getAllViewDefNames() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getAllViewDefNames();
        }
        this.invalidOperation("getAllViewDefNames");
        return null;
    }

    public String[] getEntityDefNames(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getEntityDefNames(string);
        }
        this.invalidOperation("getEntityDefNames");
        return null;
    }

    public String[] getAllEntityDefNames() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getAllEntityDefNames();
        }
        this.invalidOperation("getAllEntityDefNames");
        return null;
    }

    public String[] getEntityAssociationDefNames(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getEntityAssociationDefNames(string);
        }
        this.invalidOperation("getEntityAssociationDefNames");
        return null;
    }

    public String[] getAllEntityAssociationDefNames() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getAllEntityAssociationDefNames();
        }
        this.invalidOperation("getAllEntityAssociationDefNames");
        return null;
    }

    public String[] getViewLinkDefNames(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getViewLinkDefNames(string);
        }
        this.invalidOperation("getViewLinkDefNames");
        return null;
    }

    public String[] getAllViewLinkDefNames() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getAllViewLinkDefNames();
        }
        this.invalidOperation("getAllViewLinkDefNames");
        return null;
    }

    public void loadPackage(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            this.mAM.getSession().loadPackage(string);
        } else {
            this.invalidOperation("loadPackage");
        }
    }

    public Hashtable getEnvironment() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getEnvironment();
        }
        this.invalidOperation("getEnvironment");
        return null;
    }

    public LocaleContext getLocaleContext() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getLocaleContext();
        }
        this.invalidOperation("getLocaleContext");
        return null;
    }

    public Hashtable getUserData() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getUserData();
        }
        this.invalidOperation("getUserData");
        return null;
    }

    public String[] getUserRoles() {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().getUserRoles();
        }
        this.invalidOperation("getUserRoles");
        return null;
    }

    public boolean isUserInRole(String string) {
        if (this.mAM != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mAM.getSession().isUserInRole(string);
        }
        this.invalidOperation("isUserInRole");
        return false;
    }

    public boolean isClient() {
        if (this.mIsClient == -1) {
            this.mIsClient = this.mAM == null ? 1 : (this.mAM.getSession().isClient() ? 1 : 0);
        }
        return this.mIsClient != 0;
    }

    public ApplicationModule getCustomApplicationModule() {
        String string;
        if (this.mAM == null) {
            this.createWorkerApplicationModule();
        }
        if (this.mAM != null && (string = ((WSApplicationModuleMarshaller)((Object)this.mAM)).getClientProxyInterfaceName()) != null) {
            Class clazz = class$oracle$jbo$ApplicationModule;
            if (clazz == null) {
                clazz = class$oracle$jbo$ApplicationModule = WSApplicationModuleImpl.class$("oracle.jbo.ApplicationModule");
            }
            if (!string.equals(clazz.getName())) {
                return WSProxy.createCustomAMProxy(this, string);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void createWorkerApplicationModule() {
        ApplicationModule applicationModule = null;
        int n = -1;
        Object object = null;
        boolean bl = false;
        try {
            if (this.mSessionCookie != null && !this.mWorkerAMInitialized) {
                if (this.mSessionCookie instanceof RemotePoolCookie) {
                    this.mAM = ((RemotePoolCookie)((Object)this.mSessionCookie)).createWorkerApplicationModule();
                } else {
                    object = this.mSessionCookie.getEnvironment(PropertyMetadata.ENV_DO_FAILOVER.pName);
                    this.mSessionCookie.setEnvironment(PropertyMetadata.ENV_DO_FAILOVER.pName, "false");
                    bl = true;
                    n = this.mSessionCookie.getPassivationId();
                    this.mSessionCookie.setPassivationId(-1);
                    applicationModule = this.mSessionCookie.useApplicationModule(true);
                    this.mAM = ((WSApplicationModuleMarshaller)((Object)applicationModule)).createWorkerApplicationModule(this.mSessionCookie);
                }
                this.mAM.setSyncMode(2);
                ((WSApplicationModuleMarshaller)((Object)this.mAM)).setBoundToWorkingSet(true);
                ((WSApplicationModuleMarshaller)((Object)this.mAM)).bindToWorkingSet(this);
                this.mWorkerAMInitialized = true;
            }
            Object var7_5 = null;
            if (applicationModule == null) return;
            this.mSessionCookie.releaseApplicationModule(3);
            if (n != -1) {
                try {
                    this.mSessionCookie.setPassivationId(n);
                    this.mSessionCookie.setActivationRequired(true);
                    this.mSessionCookie.setIgnorePiggyback(false);
                    this.sync();
                    ApplicationModule applicationModule2 = this.getApplicationModuleImpl();
                    if (applicationModule2 != null && applicationModule2 instanceof WSApplicationModuleMarshaller) {
                        ((WSApplicationModuleMarshaller)((Object)applicationModule2)).afterActivation(1);
                    }
                    Object var9_9 = null;
                    this.mSessionCookie.setIgnorePiggyback(true);
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.mSessionCookie.setIgnorePiggyback(true);
                    throw throwable;
                }
            }
            if (!bl) return;
            this.mSessionCookie.setEnvironment(PropertyMetadata.ENV_DO_FAILOVER.pName, object);
            return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (applicationModule == null) throw throwable;
            this.mSessionCookie.releaseApplicationModule(3);
            if (n != -1) {
                try {}
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    this.mSessionCookie.setIgnorePiggyback(true);
                    throw throwable2;
                }
                this.mSessionCookie.setPassivationId(n);
                this.mSessionCookie.setActivationRequired(true);
                this.mSessionCookie.setIgnorePiggyback(false);
                this.sync();
                ApplicationModule applicationModule3 = this.getApplicationModuleImpl();
                if (applicationModule3 != null && applicationModule3 instanceof WSApplicationModuleMarshaller) {
                    ((WSApplicationModuleMarshaller)((Object)applicationModule3)).afterActivation(1);
                }
                Object var9_11 = null;
                this.mSessionCookie.setIgnorePiggyback(true);
            }
            if (!bl) throw throwable;
            this.mSessionCookie.setEnvironment(PropertyMetadata.ENV_DO_FAILOVER.pName, object);
            throw throwable;
        }
    }

    public Object invokeExportedMethod(String string, String[] stringArray, Object[] objectArray) {
        return this.getRootWSApplicationModule().doInvokeExportedMethod(this, string, stringArray, objectArray);
    }

    Object doInvokeExportedMethod(Object object, String string, String[] stringArray, Object[] objectArray) {
        if (this.mAM == null) {
            this.createWorkerApplicationModule();
        }
        return ((WSApplicationModuleMarshaller)((Object)this.mAM)).invokeMethod(object, string, stringArray, objectArray);
    }

    public ViewObject findCustomViewObject(String string, String string2) {
        ViewObject viewObject = this.findViewObject(string);
        if (viewObject instanceof WSViewObjectImpl) {
            return this.findCustomViewObject((WSViewObjectImpl)this.findViewObject(string), string2);
        }
        if (viewObject instanceof Proxy) {
            WSProxy wSProxy = (WSProxy)Proxy.getInvocationHandler(viewObject);
            return wSProxy.getWSViewObject();
        }
        return null;
    }

    public ViewObject findCustomViewObject(WSViewObjectImpl wSViewObjectImpl, String string) {
        ViewObject viewObject = this.findproxyForVO(wSViewObjectImpl);
        if (viewObject != null) {
            return viewObject;
        }
        ViewObject viewObject2 = WSProxy.createCustomVoProxy(wSViewObjectImpl, string);
        this.mProxyVOMap.put(wSViewObjectImpl, viewObject2);
        return viewObject2;
    }

    public int getReleaseLevel() {
        if (this.mAM != null) {
            return this.mAM.getReleaseLevel();
        }
        return -1;
    }

    public void setReleaseLevel(int n) {
        if (this.mAM != null) {
            this.mAM.setReleaseLevel(n);
        }
    }

    public void beginRequest(HashMap hashMap) {
        this.mDeferredBeginRequest = true;
        if (this.mSessionCookie.isFailoverEnabled() || this.mSessionCookie.isApplicationModuleReserved()) {
            this.doBeginRequest();
        }
    }

    private void doBeginRequest() {
        if (this.mDeferredBeginRequest) {
            ADFContext aDFContext;
            this.mDeferredBeginRequest = false;
            this.mSessionCookie.useApplicationModule();
            if (this.mSessionCookie.wasActivated()) {
                this.mSyncMarshaller = true;
            }
            if ((aDFContext = ADFContext.getCurrent()).hasEnvironment()) {
                this.mSessionCookie.writeValue(aDFContext.getEnvironment().getRequest());
            }
        }
    }

    public void endRequest(HashMap hashMap) {
        boolean bl = this.mReset;
        this.mReset = false;
        this.mDeferredBeginRequest = false;
        if (this.mSessionCookie.getThreadRefCount() > 0) {
            if (!bl) {
                int n;
                if (this.mSessionCookie.isFailoverEnabled()) {
                    this.setSyncIteratorState(true);
                    this.sync();
                }
                int n2 = n = hashMap != null ? (Integer)hashMap.get(END_REQUEST_RELEASE_LEVEL) : 0;
                if ((n & 2) > 0) {
                    this.mSessionCookie.releaseApplicationModule(0);
                } else {
                    this.mSessionCookie.releaseApplicationModule(3);
                }
            } else {
                this.mSessionCookie.releaseApplicationModule(1);
            }
        }
    }

    public Class getMessageBundleClass() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

