/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.java2;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import oracle.jbo.common.JBOClassLoader;

public class JDK2ClassLoader
implements JBOClassLoader {
    public void init() {
    }

    public Class loadClassForName(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = this.getCurrentClassLoader();
            Class<?> clazz = Class.forName(string, true, classLoader);
            return clazz;
        }
        catch (SecurityException securityException) {
            throw new ClassNotFoundException(string, securityException);
        }
    }

    public InputStream loadResourceAsStream(String string) {
        InputStream inputStream = null;
        ClassLoader classLoader = this.getCurrentClassLoader();
        inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null && string.startsWith("/")) {
            inputStream = classLoader.getResourceAsStream(string.substring(1));
        }
        return inputStream;
    }

    public ClassLoader getCurrentClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    private static void printClassLoader(ClassLoader classLoader) {
        JDK2ClassLoader.printClassLoaderTree(classLoader, 0);
    }

    private static void printClassLoaderTree(ClassLoader classLoader, int n) {
        if (classLoader != null) {
            JDK2ClassLoader.indent(n);
            if (classLoader instanceof URLClassLoader) {
                StringBuffer stringBuffer = new StringBuffer("URLS=");
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    stringBuffer = stringBuffer.append(" " + uRLArray[n2].toExternalForm());
                    ++n2;
                }
                JDK2ClassLoader.indent(n);
            }
            JDK2ClassLoader.printClassLoaderTree(classLoader.getParent(), ++n);
        }
    }

    private static void indent(int n) {
        int n2 = 0;
        while (n2 < n) {
            ++n2;
        }
    }
}

