/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ampool;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jbo.JboException;
import oracle.jbo.client.Configuration;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.ApplicationPoolException;
import oracle.jbo.common.ampool.ContextPoolManager;
import oracle.jbo.pool.ResourcePoolManager;

public class PoolMgr
extends ResourcePoolManager {
    private static final PoolMgr mInstance = JboEnvUtil.inOC4J() ? new ContextPoolManager() : new PoolMgr();
    private Hashtable mEnvironment;
    private static /* synthetic */ Class class$oracle$jbo$common$ampool$AMPoolMessageBundle;

    public static PoolMgr getInstance() {
        return mInstance;
    }

    public boolean isPoolCreated(String string) {
        return this.getResourcePool(string) != null;
    }

    public ApplicationPool getPool(String string) {
        return (ApplicationPool)this.getResourcePool(string);
    }

    public void addPool(ApplicationPool applicationPool) {
        this.addResourcePool(applicationPool.getName(), applicationPool);
    }

    public void removePool(String string) {
        this.removeResourcePool(string);
    }

    public Enumeration getPools() {
        return this.getResourcePools();
    }

    public Enumeration getPoolNames() {
        return this.getResourcePoolKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPool createPool(String string, String string2, String string3, String string4, Hashtable hashtable) throws Exception {
        Integer n = this.mLock;
        synchronized (n) {
            if (this.isPoolCreated(string)) {
                Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = PoolMgr.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                }
                throw new ApplicationPoolException(clazz, "30000", new Object[]{string});
            }
            Class clazz = JBOClass.forName(string2);
            ApplicationPool applicationPool = (ApplicationPool)clazz.newInstance();
            applicationPool.initialize(string, string3, string4, hashtable);
            if (this.mEnvironment == null) {
                this.mEnvironment = (Hashtable)hashtable.clone();
            }
            this.addPool(applicationPool);
            ApplicationPool applicationPool2 = applicationPool;
            return applicationPool2;
        }
    }

    public ApplicationPool createPool(String string, String string2, String string3, Hashtable hashtable) throws Exception {
        return this.createPool(string, "oracle.jbo.common.ampool.ApplicationPoolImpl", string2, string3, hashtable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationPool createPool(String string, Configuration configuration, String string2) {
        Integer n = this.mLock;
        synchronized (n) {
            Hashtable hashtable = configuration.getConfiguration(string2);
            String string3 = (String)hashtable.get("ApplicationName");
            String string4 = (String)hashtable.get("DBconnection");
            if (string3 == null) {
                throw new RuntimeException("Configuration does not define one or more properties ");
            }
            String string5 = (String)hashtable.get("PoolClassName");
            ApplicationPool applicationPool = null;
            try {
                applicationPool = string5 != null ? this.createPool(string, string5, string3, string4, hashtable) : this.createPool(string, string3, string4, hashtable);
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            applicationPool.setUserData(hashtable);
            ApplicationPool applicationPool2 = applicationPool;
            return applicationPool2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPool createPool(String string, String string2, String string3, Properties properties) throws Exception {
        Integer n = this.mLock;
        synchronized (n) {
            String string4;
            Configuration configuration = new Configuration();
            configuration.loadFromClassPath(Configuration.buildConfigurationFileNameFromClassPath(string2));
            Hashtable hashtable = configuration.getConfiguration(string3);
            String string5 = null;
            string5 = (String)hashtable.get("ApplicationName");
            String string6 = (String)hashtable.get("DBconnection");
            if (string5 == null) {
                throw new Exception("Configuration does not define one or more properties ");
            }
            if (properties != null) {
                Enumeration<Object> enumeration = properties.keys();
                Object object = null;
                String string7 = null;
                boolean bl = true;
                while (enumeration.hasMoreElements()) {
                    bl = true;
                    object = enumeration.nextElement();
                    if (object instanceof String) {
                        string7 = (String)object;
                        if (string7.equals("IsStateLessRuntime") && hashtable.containsKey("RELEASE_MODE")) {
                            bl = false;
                        }
                        if (string7.equals("jbo.ejb.useampool")) {
                            String string8;
                            if (hashtable.containsKey("jbo.ejb.useampool")) {
                                bl = false;
                            }
                            if (!("EjbIas".equals(string8 = (String)hashtable.get("DeployPlatform")) || "EjbWls".equals(string8) || "Ejb".equals(string8))) {
                                bl = false;
                            }
                            if (Diagnostic.isOn()) {
                                String string9 = (String)hashtable.get("jbo.ejb.useampool");
                                if (bl) {
                                    Diagnostic.println("* jbo.ejb.useampool auto-enabled for jclient in *Batch* mode");
                                } else {
                                    Diagnostic.println("* jbo.ejb.useampool='" + (string9 == null ? "null" : string9) + "' from config");
                                }
                            }
                        }
                    }
                    if (!bl) continue;
                    hashtable.put(object, properties.get(object));
                }
            }
            if ("true".equals(string4 = (String)hashtable.get("jbo.ejb.useampool"))) {
                hashtable.put(PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.getName(), "oracle.jbo.common.ampool.RemoteCookieFactory");
                if (Diagnostic.isOn()) {
                    Diagnostic.println("* jbo.ejb.useampool='true'");
                    Diagnostic.println("* " + PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.getName() + "='" + "oracle.jbo.common.ampool.RemoteCookieFactory" + "'");
                }
            } else {
                hashtable.put("jbo.ejb.useampool", "false");
                Diagnostic.println("* jbo.ejb.useampool='false'");
            }
            String string10 = (String)hashtable.get("PoolClassName");
            ApplicationPool applicationPool = null;
            applicationPool = string10 != null ? this.createPool(string, string10, string5, string6, hashtable) : this.createPool(string, string5, string6, hashtable);
            applicationPool.setUserData(hashtable);
            ApplicationPool applicationPool2 = applicationPool;
            return applicationPool2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPool findPool(String string, String string2, String string3, String string4, Hashtable hashtable) {
        Integer n = this.mLock;
        synchronized (n) {
            ApplicationPool applicationPool = this.getPool(string);
            if (applicationPool == null) {
                try {
                    applicationPool = this.createPool(string, string2, string3, string4, hashtable);
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            ApplicationPool applicationPool2 = applicationPool;
            return applicationPool2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPool findPool(String string, String string2, String string3, Hashtable hashtable) {
        Integer n = this.mLock;
        synchronized (n) {
            ApplicationPool applicationPool = this.getPool(string);
            if (applicationPool == null) {
                try {
                    applicationPool = this.createPool(string, "oracle.jbo.common.ampool.ApplicationPoolImpl", string2, string3, hashtable);
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            ApplicationPool applicationPool2 = applicationPool;
            return applicationPool2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPool findPool(String string, Configuration configuration, String string2) {
        Integer n = this.mLock;
        synchronized (n) {
            ApplicationPool applicationPool = this.getPool(string);
            if (applicationPool == null) {
                applicationPool = this.createPool(string, configuration, string2);
            }
            ApplicationPool applicationPool2 = applicationPool;
            return applicationPool2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPool findPool(String string, String string2, String string3, Properties properties) {
        Integer n = this.mLock;
        synchronized (n) {
            ApplicationPool applicationPool = this.getPool(string);
            if (applicationPool == null) {
                try {
                    applicationPool = this.createPool(string, string2, string3, properties);
                    if (properties != null) {
                        String string4;
                        String string5 = (String)properties.get("Password");
                        if (string5 != null && string5.length() > 0) {
                            applicationPool.setPassword(string5);
                        }
                        if ((string4 = (String)properties.get("UserName")) != null && string4.length() > 0) {
                            applicationPool.setUserName(string4);
                        }
                    }
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
            }
            ApplicationPool applicationPool2 = applicationPool;
            return applicationPool2;
        }
    }

    protected int getMonitorSleepInterval() {
        return PoolMgr.getProperty(PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.pName, this.mEnvironment, Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.pDefault));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

