/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.jbo.common.IDiagnostic;
import oracle.jbo.common.IDiagnostic2;

public class SharedFileDiagnosticImpl
implements IDiagnostic2,
IDiagnostic {
    public static final String LOGFILE_PREFIX = "bc4j";
    public static final String LOGFILE_SUFFIX = ".log";
    private static File m_LogFile = null;
    private static Object m_Lock = new String();
    private static PrintWriter m_LogStream;
    private static boolean m_Initialized;
    private boolean m_HaveWarned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedFileDiagnosticImpl(String string) {
        this.$init$();
        Object object = m_Lock;
        synchronized (object) {
            if (m_LogFile == null) {
                try {
                    m_LogFile = string == null ? File.createTempFile(LOGFILE_PREFIX, LOGFILE_SUFFIX) : new File(string);
                    m_LogStream = new PrintWriter((Writer)new FileWriter(m_LogFile), true);
                }
                catch (IOException iOException) {
                    System.out.println("WARNING: could not create logfile: " + iOException.getMessage());
                    throw new RuntimeException(iOException.getMessage());
                }
            }
        }
    }

    public SharedFileDiagnosticImpl() {
        this(null);
    }

    public void print(String string) {
        try {
            m_LogStream.print(string);
        }
        catch (Exception exception) {
            System.out.print(string);
        }
    }

    private /* synthetic */ void $init$() {
        this.m_HaveWarned = false;
    }

    public void println(String string) {
        try {
            m_LogStream.println(string);
        }
        catch (Exception exception) {
            if (!this.m_HaveWarned) {
                System.out.println("WARNING: failed to write to m_LogFile.toString() - routing to console");
                System.out.println("FAILEDLOG: " + exception.getMessage());
                this.m_HaveWarned = true;
            }
            System.out.println(string);
        }
    }

    public void initialized(String string) {
        if (!m_Initialized) {
            m_Initialized = true;
            System.out.println("Diagnostics: (" + string + ") " + this.toString());
        }
    }

    public String toString() {
        return "Routing diagnostics to File: " + m_LogFile.toString();
    }

    static {
        m_Initialized = false;
    }
}

