/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

class PropertiesStates
implements GroupRefresh {
    private static Noun s_noun = null;
    private static PropertiesStates s_states = null;
    private static HashMap s_pstates = new HashMap();
    private static boolean s_lock = false;

    private PropertiesStates() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertiesStates(Noun noun) {
        s_noun = Noun.create(noun, "Properties", "");
        PropertiesStates propertiesStates = this;
        synchronized (propertiesStates) {
            s_lock = true;
        }
        this.create_states(this.getSystemProperties());
        propertiesStates = this;
        synchronized (propertiesStates) {
            s_lock = false;
        }
    }

    static PropertiesStates create(Noun noun) {
        if (s_states != null) {
            return s_states;
        }
        s_states = new PropertiesStates(noun);
        return s_states;
    }

    void create_states(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        try {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null || string.length() == 0) continue;
                String string2 = string.replaceAll("\\.", "_");
                String string3 = properties.getProperty(string);
                State state = State.create(s_noun, string2, (byte)5, "", "");
                state.setRefresh(this);
                state.update(string3);
                s_pstates.put(string, state);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (s_lock) {
                return;
            }
            s_lock = true;
        }
        object2 = this.getSystemProperties();
        Set set = s_pstates.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)object2);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = ((Properties)object2).getProperty(string);
            if (string2 != null) {
                object = (State)s_pstates.get(string);
                ((State)object).update(string2);
                properties.remove(string);
                continue;
            }
            arrayList.add(string);
        }
        int n = arrayList.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                object = (String)arrayList.get(i);
                State state = (State)s_pstates.remove(object);
                state.destroy();
            }
        }
        if (properties.size() > 0) {
            this.create_states(properties);
        }
        PropertiesStates propertiesStates = this;
        synchronized (propertiesStates) {
            s_lock = false;
        }
    }

    private Properties getSystemProperties() {
        Properties properties = null;
        properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        return properties;
    }

    static synchronized void exit() {
        s_noun = null;
        s_states = null;
        s_pstates.clear();
        s_lock = false;
    }
}

