/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.Transaction;
import oracle.jbo.TransactionStateListener;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.domain.BlobDomain;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.SQLBuilderFactory;
import oracle.ord.im.NotOrdDomainException;
import oracle.ord.im.OrdContentSource;
import oracle.ord.im.OrdDomainIOInterface;
import oracle.ord.im.OrdDomainState;
import oracle.ord.im.OrdDomainSupportInterface;
import oracle.ord.im.OrdFileSource;
import oracle.ord.im.OrdHttpUploadFile;
import oracle.ord.im.OrdImageDomain;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OrdDomainUtil {
    static final String CLIENT_APPMODULE_CLASS = "oracle.jbo.client.remote.ApplicationModuleImpl";
    static final String CLIENT_ORD_UTIL_CLASS = "oracle.jbo.client.remote.OrdClientUtil";
    static final String ORD_IMAGE = "oracle.ord.im.OrdImage";
    static final String ORD_AUDIO = "oracle.ord.im.OrdAudio";
    static final String ORD_VIDEO = "oracle.ord.im.OrdVideo";
    static final String ORD_DOC = "oracle.ord.im.OrdDoc";
    static final String ORD_IMAGE_SIGNATURE = "oracle.ord.im.OrdImageSignature";
    static final String IMAGE_DOMAIN = "OrdImageDomain";
    static final String AUDIO_DOMAIN = "OrdAudioDomain";
    static final String VIDEO_DOMAIN = "OrdVideoDomain";
    static final String DOC_DOMAIN = "OrdDocDomain";
    static final String IMAGE_SIGNATURE_DOMAIN = "OrdImageSignatureDomain";
    static final int TIER_CT = 1;
    static final int TIER_MT = 2;
    static final int TIER_UNKNOWN = 0;
    static int BUFFER_LENGTH = 4096;
    private static Method invocator = null;
    private static Method addCPListener = null;
    private static Method removeCPListener = null;
    private static Method getOrdCPListener = null;
    static final String _XML_MIME_TYPE = "mimeType";
    static final String _XML_TIMESTAMP = "timeStamp";
    static final String _XML_CONTENT_HANDLE = "contentHandle";
    static final String _TEMP_FILE_PREFIX = "ord";
    static final String _TEMP_FILE_SUFFIX = "pas";
    static final String _TEMP_ORD_SUB_DIR = "ordpas";
    static final String _XML_TIER_MIDDLE = "mt";
    static final String _XML_TIER_CLIENT = "ct";
    private static /* synthetic */ Class class$oracle$jbo$Transaction;
    private static /* synthetic */ Class class$oracle$ord$im$OrdDomainIOInterface;
    private static /* synthetic */ Class class$java$lang$Object;
    private static /* synthetic */ Class class$oracle$jbo$Row;
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class array$Ljava$lang$String;
    private static /* synthetic */ Class array$Ljava$lang$Object;

    private OrdDomainUtil() {
    }

    static Method getInvokeDomainMethod() {
        try {
            if (invocator == null) {
                Class clazz;
                Class clazz2;
                Class clazz3;
                Class<?> clazz4 = Class.forName(CLIENT_APPMODULE_CLASS);
                Class[] classArray = new Class[6];
                Class clazz5 = class$oracle$jbo$Row;
                if (clazz5 == null) {
                    clazz5 = classArray[0] = (class$oracle$jbo$Row = OrdDomainUtil.class$("oracle.jbo.Row"));
                }
                if ((clazz3 = class$java$lang$String) == null) {
                    clazz3 = class$java$lang$String = OrdDomainUtil.class$("java.lang.String");
                }
                classArray[1] = clazz3;
                classArray[2] = Boolean.TYPE;
                Class clazz6 = class$java$lang$String;
                if (clazz6 == null) {
                    clazz6 = classArray[3] = (class$java$lang$String = OrdDomainUtil.class$("java.lang.String"));
                }
                if ((clazz2 = array$Ljava$lang$String) == null) {
                    clazz2 = classArray[4] = (array$Ljava$lang$String = OrdDomainUtil.class$("[Ljava.lang.String;"));
                }
                if ((clazz = array$Ljava$lang$Object) == null) {
                    clazz = array$Ljava$lang$Object = OrdDomainUtil.class$("[Ljava.lang.Object;");
                }
                classArray[5] = clazz;
                invocator = clazz4.getMethod("invokeDomainMethod", classArray);
            }
            Method method = invocator;
            return method;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    static Method getAddCPListenerMethod() {
        try {
            if (addCPListener == null) {
                Class clazz;
                Class<?> clazz2 = Class.forName(CLIENT_ORD_UTIL_CLASS);
                Class[] classArray = new Class[2];
                Class clazz3 = class$oracle$jbo$Transaction;
                if (clazz3 == null) {
                    clazz3 = classArray[0] = (class$oracle$jbo$Transaction = OrdDomainUtil.class$("oracle.jbo.Transaction"));
                }
                if ((clazz = class$java$lang$Object) == null) {
                    clazz = class$java$lang$Object = OrdDomainUtil.class$("java.lang.Object");
                }
                classArray[1] = clazz;
                addCPListener = clazz2.getMethod("addClientPostListener", classArray);
            }
            Method method = addCPListener;
            return method;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    static Method getRemoveCPListenerMethod() {
        try {
            if (removeCPListener == null) {
                Class clazz;
                Class<?> clazz2 = Class.forName(CLIENT_ORD_UTIL_CLASS);
                Class[] classArray = new Class[2];
                Class clazz3 = class$oracle$jbo$Transaction;
                if (clazz3 == null) {
                    clazz3 = classArray[0] = (class$oracle$jbo$Transaction = OrdDomainUtil.class$("oracle.jbo.Transaction"));
                }
                if ((clazz = class$java$lang$Object) == null) {
                    clazz = class$java$lang$Object = OrdDomainUtil.class$("java.lang.Object");
                }
                classArray[1] = clazz;
                removeCPListener = clazz2.getMethod("removeClientPostListener", classArray);
            }
            Method method = removeCPListener;
            return method;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    static Method getGetOrdCPListenerMethod() {
        try {
            if (getOrdCPListener == null) {
                Class clazz;
                Class<?> clazz2 = Class.forName(CLIENT_ORD_UTIL_CLASS);
                Class[] classArray = new Class[2];
                Class clazz3 = class$oracle$jbo$Transaction;
                if (clazz3 == null) {
                    clazz3 = classArray[0] = (class$oracle$jbo$Transaction = OrdDomainUtil.class$("oracle.jbo.Transaction"));
                }
                if ((clazz = class$oracle$ord$im$OrdDomainIOInterface) == null) {
                    clazz = class$oracle$ord$im$OrdDomainIOInterface = OrdDomainUtil.class$("oracle.ord.im.OrdDomainIOInterface");
                }
                classArray[1] = clazz;
                getOrdCPListener = clazz2.getMethod("getOrdCPListener", classArray);
            }
            Method method = getOrdCPListener;
            return method;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    static Object getOrdPostListener(Transaction transaction, OrdDomainIOInterface ordDomainIOInterface) {
        Object object = null;
        try {
            Method method = OrdDomainUtil.getGetOrdCPListenerMethod();
            object = method.invoke(null, transaction, ordDomainIOInterface);
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
        return object;
    }

    static void removeOrdPostListener(Transaction transaction, Object object) {
        try {
            Method method = OrdDomainUtil.getRemoveCPListenerMethod();
            method.invoke(null, transaction, object);
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    static void addOrdPostListener(Transaction transaction, Object object) {
        try {
            Method method = OrdDomainUtil.getAddCPListenerMethod();
            method.invoke(null, transaction, object);
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    static DomainOwnerInterface getOwnerRow(LobInterface lobInterface) {
        DomainOwnerInterface domainOwnerInterface = lobInterface.getOwner();
        while (domainOwnerInterface instanceof LobInterface) {
            domainOwnerInterface = ((LobInterface)domainOwnerInterface).getOwner();
        }
        return domainOwnerInterface;
    }

    static String getRemoteIdString(LobInterface lobInterface) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(lobInterface.getOwnerAttributeIndex());
        DomainOwnerInterface domainOwnerInterface = lobInterface.getOwner();
        while (domainOwnerInterface instanceof LobInterface) {
            stringBuffer = stringBuffer.insert(0, '.');
            stringBuffer = stringBuffer.insert(0, ((LobInterface)domainOwnerInterface).getOwnerAttributeIndex());
            domainOwnerInterface = ((LobInterface)domainOwnerInterface).getOwner();
        }
        Diagnostic.println((String)("domain's m_indexString is " + stringBuffer));
        return stringBuffer.toString();
    }

    static SQLException unwrapSQLException(InvocationTargetException invocationTargetException) throws Exception {
        JboException jboException = (JboException)invocationTargetException.getTargetException();
        Object[] objectArray = jboException.getDetails();
        InvocationTargetException invocationTargetException2 = (InvocationTargetException)objectArray[0];
        SQLException sQLException = (SQLException)invocationTargetException2.getTargetException();
        return sQLException;
    }

    static void fromInputToOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[BUFFER_LENGTH];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        inputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean getDataInFile(String string, BlobDomain blobDomain) throws IOException {
        InputStream inputStream;
        block6: {
            FileOutputStream fileOutputStream = null;
            inputStream = null;
            try {
                File file = new File(string);
                fileOutputStream = new FileOutputStream(file);
                inputStream = blobDomain.getInputStream();
                OrdDomainUtil.fromInputToOutput(inputStream, fileOutputStream);
                Object var7_5 = null;
                if (fileOutputStream == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            fileOutputStream.close();
        }
        if (inputStream == null) return true;
        inputStream.close();
        return true;
    }

    static void updateRow(Object object) {
        SQLBuilderFactory.create().doEntityDML((EntityImpl)object, 2, null);
    }

    static Object createDomainFromXMLElement(Element element, Object object) {
        if (object instanceof OrdDomainIOInterface) {
            String string = null;
            String string2 = null;
            XMLElement xMLElement = (XMLElement)element.getFirstChild();
            NodeList nodeList = xMLElement.getChildrenByTagName(_XML_MIME_TYPE);
            if (nodeList.getLength() == 1) {
                Element element2 = (Element)nodeList.item(0);
                XMLText xMLText = (XMLText)element2.getFirstChild();
                string = xMLText.getNodeValue();
            }
            nodeList = xMLElement.getChildrenByTagName(_XML_TIMESTAMP);
            Timestamp timestamp = null;
            if (nodeList.getLength() == 1) {
                Element element3 = (Element)nodeList.item(0);
                XMLText xMLText = (XMLText)element3.getFirstChild();
                String string3 = xMLText.getNodeValue();
                Long l = new Long(string3);
                timestamp = new Timestamp(l);
            }
            nodeList = xMLElement.getChildrenByTagName(_XML_CONTENT_HANDLE);
            String string4 = null;
            if (nodeList.getLength() == 1) {
                Element element4 = (Element)nodeList.item(0);
                Element element5 = (Element)element4.getFirstChild();
                string4 = element5.getTagName();
                XMLText xMLText = (XMLText)element5.getFirstChild();
                string2 = xMLText.getNodeValue();
            }
            OrdDomainIOInterface ordDomainIOInterface = (OrdDomainIOInterface)object;
            try {
                if (string2 != null) {
                    if (string4.equals(_XML_TIER_MIDDLE)) {
                        OrdFileSource ordFileSource = new OrdFileSource(string2);
                        if (string != null && !string.equals("")) {
                            ordFileSource.setMimeType(string);
                        }
                        ordFileSource.deleteFileInRelease();
                        ordDomainIOInterface.setContentSource(ordFileSource);
                        if (timestamp != null) {
                            try {
                                ordDomainIOInterface.setUpdateTime(timestamp);
                            }
                            catch (Exception exception) {}
                        }
                    } else if (string4.equals(_XML_TIER_CLIENT)) {
                        ((OrdDomainSupportInterface)((Object)ordDomainIOInterface)).setCTPassivationHandle(string2);
                        if (string != null && !string.equals("")) {
                            ordDomainIOInterface.setMimeType(string);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
        return object;
    }

    static XMLDomainFactory getXMLDomainFactory(Class clazz) {
        return new 1facClass(clazz);
    }

    private static boolean blobContainContent(OrdDomainIOInterface ordDomainIOInterface) {
        boolean bl = false;
        try {
            bl = ordDomainIOInterface.getContentAsBlobDomain().isCacheDataModified();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl;
    }

    static Node getXMLContentNode(Document document, OrdDomainIOInterface ordDomainIOInterface, String string) {
        String string2 = null;
        String string3 = null;
        OrdFileSource ordFileSource = null;
        Element element = null;
        OrdDomainSupportInterface ordDomainSupportInterface = (OrdDomainSupportInterface)((Object)ordDomainIOInterface);
        string3 = (String)ordDomainSupportInterface.getCTPassivationHandle();
        if (string3 != null) {
            element = document.createElement(string);
            try {
                string2 = ordDomainIOInterface.getMimeType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 != null && !string2.equals("")) {
                Element element2 = document.createElement(_XML_MIME_TYPE);
                Text text = document.createTextNode(string2);
                element2.appendChild(text);
                element.appendChild(element2);
            }
            Timestamp timestamp = null;
            try {
                timestamp = ordDomainIOInterface.getUpdateTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (timestamp != null) {
                Element element3 = document.createElement(_XML_TIMESTAMP);
                Text text = document.createTextNode(Long.toString(timestamp.getTime()));
                element3.appendChild(text);
                element.appendChild(element3);
            }
            if (string3 != null) {
                Element element4 = document.createElement(_XML_CONTENT_HANDLE);
                Element element5 = document.createElement(_XML_TIER_CLIENT);
                Text text = document.createTextNode(string3);
                element4.appendChild(element5);
                element5.appendChild(text);
                element.appendChild(element4);
            }
        } else {
            ordFileSource = OrdDomainUtil.prepareTempFile(ordDomainIOInterface);
            if (ordFileSource != null) {
                string3 = ordFileSource.getFileName();
                string2 = ordFileSource.getMimeType();
            }
            element = document.createElement(string);
            if (string2 != null && !string2.equals("")) {
                Element element6 = document.createElement(_XML_MIME_TYPE);
                Text text = document.createTextNode(string2);
                element6.appendChild(text);
                element.appendChild(element6);
            }
            Timestamp timestamp = null;
            try {
                timestamp = ordDomainIOInterface.getUpdateTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (timestamp != null) {
                Element element7 = document.createElement(_XML_TIMESTAMP);
                Text text = document.createTextNode(Long.toString(timestamp.getTime()));
                element7.appendChild(text);
                element.appendChild(element7);
            }
            if (string3 != null) {
                Element element8 = document.createElement(_XML_CONTENT_HANDLE);
                Text text = document.createTextNode(string3);
                Element element9 = document.createElement(_XML_TIER_MIDDLE);
                element8.appendChild(element9);
                element9.appendChild(text);
                element.appendChild(element8);
            }
        }
        return element;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setPropertiesAfterLoading(OrdDomainIOInterface ordDomainIOInterface) throws SQLException, IOException {
        OrdContentSource ordContentSource;
        block9: {
            String string;
            ordContentSource = ordDomainIOInterface.getContentSource();
            boolean bl = true;
            try {
                try {
                    LobInterface lobInterface = (LobInterface)ordDomainIOInterface;
                    String string2 = (String)((Row)OrdDomainUtil.getOwnerRow(lobInterface)).getStructureDef().getAttributeDef(lobInterface.getOwnerAttributeIndex()).getProperty("ORD_SET_PROPERTIES");
                    if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                        bl = Boolean.valueOf(string2);
                    }
                    if (!bl) throw new SQLException();
                    ordDomainIOInterface.setProperties();
                    Object var9_5 = null;
                    string = ordContentSource.getMimeType();
                    if (string == null || string.equals("")) break block9;
                }
                catch (SQLException sQLException) {
                    ordDomainIOInterface.setUpdateTime(null);
                    int n = ordContentSource.getContentLength();
                    if (n != -1) {
                        ordDomainIOInterface.setContentLength(n);
                    }
                    Object var9_6 = null;
                    String string2 = ordContentSource.getMimeType();
                    if (string2 != null && !string2.equals("")) {
                        ordDomainIOInterface.setMimeType(string2);
                    }
                    ordContentSource.release();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                String string3 = ordContentSource.getMimeType();
                if (string3 != null && !string3.equals("")) {
                    ordDomainIOInterface.setMimeType(string3);
                }
                ordContentSource.release();
                throw throwable;
            }
            ordDomainIOInterface.setMimeType(string);
        }
        ordContentSource.release();
    }

    public static void loadAndSetProperties(OrdDomainIOInterface ordDomainIOInterface) throws SQLException, IOException {
        OrdContentSource ordContentSource = ordDomainIOInterface.getContentSource();
        BlobDomain blobDomain = ordDomainIOInterface.getContentAsBlobDomain();
        OutputStream outputStream = blobDomain.getOutputStream();
        OrdDomainUtil.fromInputToOutput(ordContentSource.getInputStream(), outputStream);
        OrdDomainUtil.setPropertiesAfterLoading(ordDomainIOInterface);
        OrdDomainUtil.releaseContentSourceResource(ordDomainIOInterface);
    }

    public static String printXMLDefinition(Hashtable hashtable, PrintWriter printWriter, boolean bl, String string) {
        String string2 = null;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(charArrayWriter);
            bufferedWriter.newLine();
            bufferedWriter.close();
            string2 = charArrayWriter.toString();
        }
        catch (IOException iOException) {
            throw new JboException((Throwable)iOException);
        }
        if (hashtable.get(string) == null) {
            stringBuffer = new StringBuffer("<!ELEMENT ").append(string).append(" (").append(_XML_MIME_TYPE).append("?, ").append(_XML_CONTENT_HANDLE).append("?)>");
            hashtable.put(string, string);
            printWriter.println(stringBuffer.toString());
            if (hashtable.get(_XML_MIME_TYPE) == null) {
                hashtable.put(_XML_MIME_TYPE, _XML_MIME_TYPE);
                stringBuffer2 = new StringBuffer("<!ELEMENT ").append(_XML_MIME_TYPE).append(" (#PCDATA)>").append(string2).append("<!ELEMENT ").append(_XML_CONTENT_HANDLE).append(" (#PCDATA)>");
                printWriter.println(stringBuffer2.toString());
            }
        }
        if (bl) {
            return stringBuffer.append(string2).append(stringBuffer2).toString();
        }
        return stringBuffer.toString();
    }

    public static boolean isOrdDomainType(AttributeDef attributeDef) {
        Class clazz = attributeDef.getJavaType();
        String string = clazz.getName();
        return string.equals("oracle.ord.im.OrdImageDomain") || string.equals("oracle.ord.im.OrdAudioDomain") || string.equals("oracle.ord.im.OrdVideoDomain") || string.equals("oracle.ord.im.OrdDocDomain") || string.equals("oracle.ord.im.OrdImageSignatureDomain");
    }

    public static boolean isOrdImageType(AttributeDef attributeDef) {
        Class clazz = attributeDef.getJavaType();
        String string = clazz.getName();
        return string.equals("oracle.ord.im.OrdImageDomain");
    }

    public static boolean isOrdDomainType(String string) {
        String string2 = string;
        return string2.equals("oracle.ord.im.OrdImageDomain") || string2.equals("oracle.ord.im.OrdAudioDomain") || string2.equals("oracle.ord.im.OrdVideoDomain") || string2.equals("oracle.ord.im.OrdDocDomain") || string2.equals("oracle.ord.im.OrdImageSignatureDomain") || string2.equals(IMAGE_DOMAIN) || string2.equals(AUDIO_DOMAIN) || string2.equals(VIDEO_DOMAIN) || string2.equals(DOC_DOMAIN) || string2.equals(IMAGE_SIGNATURE_DOMAIN);
    }

    public static Object newInstance(AttributeDef attributeDef) throws IllegalAccessException, InstantiationException {
        if (OrdDomainUtil.isOrdDomainType(attributeDef)) {
            Class clazz = attributeDef.getJavaType();
            Object t = clazz.newInstance();
            return t;
        }
        throw new NotOrdDomainException(attributeDef.getJavaType().getName());
    }

    static void releaseContentSourceResource(OrdDomainIOInterface ordDomainIOInterface) {
        OrdContentSource ordContentSource;
        if (ordDomainIOInterface != null && (ordContentSource = ordDomainIOInterface.getContentSource()) != null) {
            ordContentSource.release();
            ((OrdDomainSupportInterface)((Object)ordDomainIOInterface)).setCTPassivationHandle(null);
            ordDomainIOInterface.clearContentSource();
        }
    }

    static void bindToTransaction(OrdDomainIOInterface ordDomainIOInterface, Transaction transaction) {
        OrdContentSource ordContentSource = ordDomainIOInterface.getContentSource();
        if (ordContentSource != null && transaction != null) {
            if (!((OrdDomainState)((Object)ordDomainIOInterface)).isAddedToTransaction()) {
                transaction.addTransactionStateListener((TransactionStateListener)ordDomainIOInterface);
                ((OrdDomainState)((Object)ordDomainIOInterface)).setAddToTransactionState(true);
            }
            Diagnostic.println((String)"domain was bound to transaction.");
        }
    }

    public static OrdFileSource createTempFile(InputStream inputStream, String string, String string2) throws Exception {
        String string3 = string2 + File.separatorChar + _TEMP_ORD_SUB_DIR + File.separatorChar;
        Diagnostic.println((String)("ORD temp file dir is : " + string3));
        File file = new File(string3);
        file.mkdir();
        File file2 = File.createTempFile(_TEMP_FILE_PREFIX, _TEMP_FILE_SUFFIX, file);
        Diagnostic.println((String)("ORD temp file is : " + file2.getCanonicalPath()));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        OrdDomainUtil.fromInputToOutput(inputStream, fileOutputStream);
        OrdFileSource ordFileSource = new OrdFileSource(file2.getCanonicalPath());
        if (string != null) {
            ordFileSource.setMimeType(string);
        }
        ordFileSource.deleteFileInRelease();
        return ordFileSource;
    }

    public static OrdHttpUploadFile getOrdHttpUploadFile(String string, String string2, InputStream inputStream, int n, int n2, String string3) throws IOException {
        OrdHttpUploadFile ordHttpUploadFile = new OrdHttpUploadFile(string, string2, inputStream);
        ordHttpUploadFile.readFromPostData(n, n2, string3);
        return ordHttpUploadFile;
    }

    static OrdFileSource prepareTempFile(OrdDomainIOInterface ordDomainIOInterface) {
        OrdContentSource ordContentSource = ordDomainIOInterface.getContentSource();
        OrdFileSource ordFileSource = null;
        byte[] byArray = null;
        String string = null;
        String string2 = JboEnvUtil.getBC4JTempDir(null);
        Diagnostic.println((String)("domain passivation temp file dir: " + string2));
        if (ordContentSource != null) {
            if (ordContentSource instanceof OrdFileSource) {
                OrdFileSource ordFileSource2 = (OrdFileSource)ordContentSource;
                if (ordFileSource2.isDeleteFileInRelease()) {
                    ordFileSource = ordFileSource2;
                } else {
                    try {
                        ordFileSource = OrdDomainUtil.createTempFile(ordFileSource2.getInputStream(), ordFileSource2.getMimeType(), string2);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Temp file can not be created by interMedia domain passivation. ");
                    }
                }
                Diagnostic.println((String)("domain passivation original file source: " + ordFileSource.getFileName()));
            } else {
                try {
                    ordFileSource = OrdDomainUtil.createTempFile(ordContentSource.getInputStream(), null, string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = ordContentSource.getMimeType();
                if (ordFileSource != null) {
                    ordFileSource.setMimeType(string);
                }
                ordDomainIOInterface.setContentSource(ordFileSource);
                Diagnostic.println((String)("domain passivation from other source, temp file source: " + ordFileSource.getFileName()));
            }
        } else if (OrdDomainUtil.blobContainContent(ordDomainIOInterface)) {
            try {
                string = ordDomainIOInterface.getMimeType();
            }
            catch (SQLException sQLException) {
                string = null;
            }
            try {
                byArray = ordDomainIOInterface.getContentAsBlobDomain().getStorageByteArray();
            }
            catch (SQLException sQLException) {
                byArray = null;
            }
            if (byArray != null) {
                try {
                    ordFileSource = OrdDomainUtil.createTempFile(new ByteArrayInputStream(byArray), null, string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ordFileSource != null) {
                    ordFileSource.setMimeType(string);
                }
                ordDomainIOInterface.setContentSource(ordFileSource);
                Diagnostic.println((String)("domain passivation from BLOB, temp file source: " + ordFileSource.getFileName()));
            }
        } else {
            try {
                string = ordDomainIOInterface.getMimeType();
            }
            catch (SQLException sQLException) {
                string = null;
            }
            try {
                ordFileSource = OrdDomainUtil.createTempFile(ordDomainIOInterface.getDataInStream(), null, string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ordFileSource != null) {
                ordFileSource.setMimeType(string);
                Diagnostic.println((String)("domain from db, passivation file source: " + ordFileSource.getFileName()));
            }
        }
        return ordFileSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OrdDomainIOInterface getOrdObject(AttributeDef attributeDef, OrdFileSource ordFileSource, Row row, ApplicationModule applicationModule, String string) throws InstantiationException, IllegalAccessException {
        OrdDomainIOInterface ordDomainIOInterface = null;
        if (ordFileSource == null) return ordDomainIOInterface;
        Object object = row.getAttribute(attributeDef.getIndex());
        boolean bl = applicationModule.getSession().isClient();
        if (bl) {
            ordDomainIOInterface = object == null ? (OrdDomainIOInterface)OrdDomainUtil.newInstance(attributeDef) : (OrdDomainIOInterface)object;
            try {
                ordDomainIOInterface.setContentSource(ordFileSource);
                if (ordDomainIOInterface instanceof OrdImageDomain) {
                    ((OrdImageDomain)ordDomainIOInterface).setWidth(0);
                    ((OrdImageDomain)ordDomainIOInterface).setHeight(0);
                }
                ordDomainIOInterface.setMimeType(string);
                if (!((OrdDomainState)((Object)ordDomainIOInterface)).isConnected()) return ordDomainIOInterface;
                ordDomainIOInterface.setUpdateTime(null);
                return ordDomainIOInterface;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        } else {
            ordDomainIOInterface = (OrdDomainIOInterface)OrdDomainUtil.newInstance(attributeDef);
            ordDomainIOInterface.setContentSource(ordFileSource);
        }
        return ordDomainIOInterface;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class 1facClass
    implements XMLDomainFactory {
        Class mAttrClass;

        1facClass(Class clazz) {
            this.mAttrClass = clazz;
        }

        public DomainInterface createDomainFromXMLElement(Element element) {
            Object var2_2 = null;
            try {
                var2_2 = this.mAttrClass.newInstance();
            }
            catch (Exception exception) {
                var2_2 = null;
            }
            DomainInterface domainInterface = (DomainInterface)OrdDomainUtil.createDomainFromXMLElement(element, var2_2);
            return domainInterface;
        }
    }
}

