/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import oracle.ord.im.OrdHttpUploadException;
import oracle.ord.im.OrdMultipartBodyInputStream;
import oracle.ord.im.OrdMultipartHeader;
import oracle.ord.im.OrdMultipartInputStream;
import oracle.ord.im.OrdMultipartUtil;

class OrdMultipartReader {
    private OrdMultipartInputStream mpIn;
    private OrdMultipartBodyInputStream mpBodyIn;
    private byte[] dataBuf;
    private int dataLen;
    private static final int INITIAL_DATA_BUF_LEN = 128;
    private static final int CR = 13;
    private static final int LF = 10;

    OrdMultipartReader(OrdMultipartInputStream ordMultipartInputStream, OrdMultipartBodyInputStream ordMultipartBodyInputStream) {
        this.mpIn = ordMultipartInputStream;
        this.mpBodyIn = ordMultipartBodyInputStream;
        this.dataBuf = new byte[128];
        this.dataLen = 0;
    }

    private void growDataBuf() {
        byte[] byArray = new byte[this.dataBuf.length * 2];
        System.arraycopy(this.dataBuf, 0, byArray, 0, this.dataLen);
        this.dataBuf = byArray;
    }

    String readBody(String string) throws IOException {
        this.dataLen = 0;
        while (true) {
            int n;
            if (this.dataLen >= this.dataBuf.length) {
                this.growDataBuf();
            }
            if ((n = this.mpBodyIn.read(this.dataBuf, this.dataLen, this.dataBuf.length - this.dataLen)) <= 0) break;
            this.dataLen += n;
        }
        if (string == null) {
            return OrdMultipartUtil.byteArrayToString(this.dataBuf, 0, this.dataLen);
        }
        return new String(this.dataBuf, 0, this.dataLen, string);
    }

    boolean readCheckDelimiter() throws IOException {
        this.readLine();
        return this.mpBodyIn.checkDelimiter(this.dataBuf, this.dataLen);
    }

    OrdMultipartHeader readHeader(boolean bl) throws IOException {
        this.readLine();
        if (this.dataLen == 0) {
            return null;
        }
        if (this.mpBodyIn.checkDelimiter(this.dataBuf, this.dataLen)) {
            throw new OrdHttpUploadException(107);
        }
        return new OrdMultipartHeader(this.dataBuf, this.dataLen, bl);
    }

    private void readLine() throws IOException {
        int n;
        this.dataLen = 0;
        while ((n = this.mpIn.read()) != 13) {
            if (this.dataLen >= this.dataBuf.length) {
                this.growDataBuf();
            }
            this.dataBuf[this.dataLen++] = (byte)n;
        }
        if (this.mpIn.read() != 10) {
            throw new OrdHttpUploadException(109);
        }
    }
}

