/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetCache;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.T4CTTIoac;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.driver.VarnumAccessor;

public abstract class OracleStatement
implements oracle.jdbc.internal.OracleStatement,
ScrollRsetStatement {
    static final int PLAIN_STMT = 0;
    static final int PREP_STMT = 1;
    static final int CALL_STMT = 2;
    static final byte IS_UNINITIALIZED = -1;
    static final byte IS_SELECT = 0;
    static final byte IS_PLSQL_BLOCK = 1;
    static final byte IS_DML = 2;
    static final byte IS_OTHER = 3;
    static final byte IS_CALL_BLOCK = 4;
    int cursorId;
    int number_of_define_positions;
    int defines_batch_size;
    Accessor[] accessors;
    int defineByteSubRange;
    int defineCharSubRange;
    int defineIndicatorSubRange;
    int defineLengthSubRange;
    byte[] defineBytes;
    char[] defineChars;
    short[] defineIndicators;
    boolean described = false;
    boolean describedWithNames = false;
    int rows_processed;
    int cachedDefineByteSize = 0;
    int cachedDefineCharSize = 0;
    int cachedDefineIndicatorSize = 0;
    OracleStatement children;
    OracleStatement nextChild;
    OracleStatement next;
    OracleStatement prev;
    long c_state;
    int number_of_bind_positions;
    byte[] bindBytes;
    char[] bindChars;
    short[] bindIndicators;
    int bindByteOffset;
    int bindCharOffset;
    int bindIndicatorOffset;
    int bindByteSubRange;
    int bindCharSubRange;
    int bindIndicatorSubRange;
    Accessor[] outBindAccessors;
    InputStream[][] parameterStream;
    boolean hasIbtBind = false;
    byte[] ibtBindBytes;
    char[] ibtBindChars;
    short[] ibtBindIndicators;
    int ibtBindByteOffset;
    int ibtBindCharOffset;
    int ibtBindIndicatorOffset;
    int ibtBindIndicatorSize;
    int first_row_in_batch;
    byte[] tmpByteArray;
    int sizeTmpByteArray = 0;
    byte[] tmpBindsByteArray;
    boolean needToSendOalToFetch = false;
    int[] definedColumnType = null;
    int[] definedColumnSize = null;
    T4CTTIoac[] oacdefSent = null;
    int[] nbPostPonedColumns = null;
    int[][] indexOfPostPonedColumn = null;
    char[][] charOutput = new char[1][];
    byte[][] byteOutput = new byte[1][];
    short[][] shortOutput = new short[1][];
    int accessorByteOffset = 0;
    int accessorCharOffset = 0;
    int accessorShortOffset = 0;
    static final int VALID_ROWS_UNINIT = -999;
    PhysicalConnection connection;
    OracleInputStream streamList;
    OracleInputStream nextStream;
    OracleResultSetImpl current_result_set;
    boolean process_escapes;
    int m_queryTimeout;
    int batch;
    int m_currentRank;
    int current_row;
    int valid_rows;
    int max_field_size;
    int max_rows;
    int total_rows_visited;
    int row_prefetch;
    int rowPrefetchAtExecute = -1;
    int default_row_prefetch;
    boolean row_prefetch_changed;
    boolean got_last_batch;
    boolean clear_params;
    boolean closed;
    boolean sql_string_changed;
    OracleSql m_sql;
    boolean need_to_parse;
    boolean need_to_prepare_define_buffer;
    boolean columns_defined_by_user;
    byte sql_kind;
    int auto_rollback;
    int default_fetch_direction;
    boolean m_autoRefetch;
    boolean serverCursor;
    boolean fixedString = false;
    boolean noMoreUpdateCounts = false;
    boolean m_isExecuting = false;
    static final byte EXECUTE_NONE = -1;
    static final byte EXECUTE_QUERY = 1;
    static final byte EXECUTE_UPDATE = 2;
    static final byte EXECUTE_NORMAL = 3;
    byte executionType = (byte)-1;
    OracleResultSet m_scrollRset;
    oracle.jdbc.OracleResultSetCache m_cache;
    int m_userRsetType;
    int m_realRsetType;
    boolean m_needToAddIdentifier;
    SQLWarning m_warning;
    int cacheState = 1;
    int m_creationState = 0;
    boolean m_isOpen = false;
    int statementType = 0;
    boolean columnSetNull = false;
    TimeZone defaultTZ = null;
    static final String dms_parent_name = "STATEMENT_";
    static final String dms_parent_type = "JDBC_Statement";
    static final String dms_sqlText_name = "SQLText";
    static final String dms_sqlText_description = "current SQL text";
    static final String dms_sqlText_units = "";
    static final String dms_execute_name = "Execute";
    static final String dms_execute_description = "the time required for all executions of this statement";
    static final String dms_fetch_name = "Fetch";
    static final String dms_fetch_description = "the time required for all fetches by this statement";
    static int dmsStatementCount = 0;
    NounIntf dmsParent = null;
    StateIntf dmsSqlText = null;
    PhaseEventIntf dmsExecute = null;
    PhaseEventIntf dmsFetch = null;
    int last_index;
    Vector m_batchItems = new Vector();
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    abstract void do_describe(boolean var1) throws SQLException;

    abstract void execute_for_describe() throws SQLException;

    abstract void execute_for_rows(boolean var1) throws SQLException;

    abstract void fetch() throws SQLException;

    void continueReadRow(int n) throws SQLException {
        throw new SQLException("continueReadRow is only implemented by the T4C statements.");
    }

    abstract void do_close() throws SQLException;

    abstract void closeQuery() throws SQLException;

    void createDMSSensors() throws SQLException {
        if (this.connection.dmsGenerateStatementCachingMetrics && this.connection.getImplicitCachingEnabled() || this.connection.m_dmsGenerateStatementMetrics) {
            try {
                ++dmsStatementCount;
            }
            catch (ArithmeticException arithmeticException) {
                dmsStatementCount = 0;
            }
            this.dmsParent = DMSFactory.createNoun(this.connection.m_dmsParent, dms_parent_name + dmsStatementCount, dms_parent_type);
            this.dmsSqlText = DMSFactory.createState(this.dmsParent, dms_sqlText_name, dms_sqlText_units, dms_sqlText_description, this.m_sql.toString());
            this.dmsExecute = DMSFactory.createPhaseEvent(this.dmsParent, dms_execute_name, dms_execute_description);
            this.dmsExecute.deriveMetric(511);
            this.dmsFetch = DMSFactory.createPhaseEvent(this.dmsParent, dms_fetch_name, dms_fetch_description);
            this.dmsFetch.deriveMetric(511);
        }
    }

    OracleStatement(PhysicalConnection physicalConnection, int n, int n2) throws SQLException {
        this(physicalConnection, n, n2, -1, -1);
    }

    OracleStatement(PhysicalConnection physicalConnection, int n, int n2, int n3, int n4) throws SQLException {
        this.connection = physicalConnection;
        this.connection.needLine();
        this.connection.add_statement(this);
        this.m_sql = new OracleSql(this.connection.conversion);
        this.m_sql.isV8Compatible = this.connection.m_v8Compatible;
        this.process_escapes = this.connection.m_process_escapes;
        this.auto_rollback = 2;
        this.got_last_batch = false;
        this.closed = false;
        this.clear_params = true;
        this.serverCursor = false;
        this.m_needToAddIdentifier = false;
        this.default_fetch_direction = 1000;
        this.fixedString = this.connection.getDefaultFixedString();
        this.row_prefetch_changed = false;
        this.row_prefetch = n2;
        this.default_row_prefetch = n2;
        this.batch = n;
        this.m_autoRefetch = this.connection.getDefaultAutoRefetch();
        this.sql_string_changed = true;
        this.need_to_parse = true;
        this.need_to_prepare_define_buffer = true;
        this.columns_defined_by_user = false;
        if (n3 != -1 || n4 != -1) {
            this.m_realRsetType = 0;
            this.m_userRsetType = ResultSetUtil.getRsetTypeCode(n3, n4);
            this.m_needToAddIdentifier = ResultSetUtil.needIdentifier(this.m_userRsetType);
        } else {
            this.m_userRsetType = 1;
            this.m_realRsetType = 1;
        }
        this.createDMSSensors();
    }

    void initializeDefineSubRanges() {
        this.defineByteSubRange = 0;
        this.defineCharSubRange = 0;
        this.defineIndicatorSubRange = 0;
    }

    void prepareDefinePreambles() {
    }

    void prepareAccessors() throws SQLException {
        Accessor accessor;
        int n;
        byte[] byArray = null;
        char[] cArray = null;
        short[] sArray = null;
        boolean bl = false;
        if (this.accessors == null) {
            DatabaseError.throwSqlException(21);
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.number_of_define_positions; ++n) {
            accessor = this.accessors[n];
            if (accessor == null) {
                DatabaseError.throwSqlException(21);
            }
            n2 += accessor.byteLength;
            n3 += accessor.charLength;
        }
        if (this.streamList != null && !this.connection.useFetchSizeWithLongColumn) {
            this.row_prefetch = 1;
        }
        this.defines_batch_size = n = this.row_prefetch;
        this.initializeDefineSubRanges();
        int n4 = this.defineByteSubRange + n2 * n;
        if (this.defineBytes == null || this.defineBytes.length < n4) {
            if (this.defineBytes != null) {
                byArray = this.defineBytes;
            }
            this.defineBytes = new byte[n4];
        }
        this.defineByteSubRange += this.accessorByteOffset;
        int n5 = this.defineCharSubRange + n3 * n;
        if ((this.defineChars == null || this.defineChars.length < n5) && n5 > 0) {
            if (this.defineChars != null) {
                cArray = this.defineChars;
            }
            this.defineChars = new char[n5];
        }
        this.defineCharSubRange += this.accessorCharOffset;
        int n6 = this.number_of_define_positions * n;
        int n7 = this.defineIndicatorSubRange + n6 + n6;
        if (this.defineIndicators == null || this.defineIndicators.length < n7) {
            if (this.defineIndicators != null) {
                sArray = this.defineIndicators;
            }
            this.defineIndicators = new short[n7];
        } else if (this.defineIndicators.length > n7) {
            bl = true;
            sArray = this.defineIndicators;
        }
        this.defineIndicatorSubRange += this.accessorShortOffset;
        int n8 = this.defineIndicatorSubRange + n6;
        for (int i = 0; i < this.number_of_define_positions; ++i) {
            accessor = this.accessors[i];
            accessor.lengthIndexLastRow = accessor.lengthIndex;
            accessor.indicatorIndexLastRow = accessor.indicatorIndex;
            accessor.columnIndexLastRow = accessor.columnIndex;
            accessor.setOffsets(n);
            accessor.lengthIndex = n8;
            accessor.indicatorIndex = this.defineIndicatorSubRange;
            accessor.rowSpaceByte = this.defineBytes;
            accessor.rowSpaceChar = this.defineChars;
            accessor.rowSpaceIndicator = this.defineIndicators;
            this.defineIndicatorSubRange += n;
            n8 += n;
        }
        this.prepareDefinePreambles();
        if (cArray != null || byArray != null) {
            this.saveDefineBuffersIfRequired(cArray, byArray, sArray != null ? sArray : this.defineIndicators, bl);
        } else if (bl && this.rowPrefetchAtExecute != -1 && this.row_prefetch != this.rowPrefetchAtExecute) {
            this.saveDefineBuffersIfRequired(this.defineChars, this.defineBytes, this.defineIndicators, bl);
        }
        this.rowPrefetchAtExecute = this.row_prefetch;
    }

    boolean checkAccessorsUsable() throws SQLException {
        int n = this.accessors.length;
        if (n < this.number_of_define_positions) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < this.number_of_define_positions; ++i) {
            Accessor accessor = this.accessors[i];
            if (accessor == null || accessor.external_type == 0) {
                bl = false;
                continue;
            }
            bl2 = true;
        }
        if (bl) {
            bl3 = true;
        } else if (bl2) {
            DatabaseError.throwSqlException(21);
        } else {
            this.columns_defined_by_user = false;
        }
        return bl3;
    }

    void execute_maybe_describe() throws SQLException {
        if (this.row_prefetch_changed) {
            if (this.streamList == null && this.row_prefetch != this.defines_batch_size) {
                this.need_to_prepare_define_buffer = true;
            }
            this.row_prefetch_changed = false;
        }
        if (!this.need_to_prepare_define_buffer) {
            if (this.accessors == null) {
                this.need_to_prepare_define_buffer = true;
            } else if (this.columns_defined_by_user) {
                this.need_to_prepare_define_buffer = !this.checkAccessorsUsable();
            }
        }
        boolean bl = false;
        try {
            this.m_isExecuting = true;
            if (this.need_to_prepare_define_buffer) {
                if (!this.columns_defined_by_user) {
                    this.execute_for_describe();
                    bl = true;
                }
                this.prepareAccessors();
            }
            int n = this.accessors.length;
            for (int i = this.number_of_define_positions; i < n; ++i) {
                Accessor accessor = this.accessors[i];
                if (accessor == null) continue;
                accessor.rowSpaceIndicator = null;
            }
            this.execute_for_rows(bl);
        }
        catch (SQLException sQLException) {
            this.need_to_parse = true;
            throw sQLException;
        }
        finally {
            this.m_isExecuting = false;
        }
    }

    void adjustGotLastBatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doExecuteWithTimeout() throws SQLException {
        long l = 0L;
        if (this.dmsExecute != null) {
            l = this.dmsExecute.start();
        }
        try {
            this.connection.updateEndToEndMetrics();
            this.rows_processed = 0;
            if (this.sql_kind == 0) {
                if (this.connection.m_j2ee13Compliant && this.executionType == 2) {
                    DatabaseError.throwSqlException(129);
                }
                this.connection.needLine();
                if (!this.m_isOpen) {
                    this.connection.open(this);
                    this.m_isOpen = true;
                }
                this.connection.registerHeartbeat();
                if (this.m_queryTimeout != 0) {
                    try {
                        this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                        this.execute_maybe_describe();
                    }
                    finally {
                        this.connection.getTimeout().cancelTimeout();
                    }
                } else {
                    this.execute_maybe_describe();
                }
                this.checkValidRowsStatus();
                if (this.serverCursor) {
                    this.adjustGotLastBatch();
                }
            } else {
                if (this.connection.m_j2ee13Compliant && this.sql_kind != 1 && this.sql_kind != 4 && this.executionType == 1) {
                    DatabaseError.throwSqlException(128);
                }
                ++this.m_currentRank;
                if (this.m_currentRank >= this.batch) {
                    block23: {
                        try {
                            try {
                                this.connection.needLine();
                                if (!this.m_isOpen) {
                                    this.connection.open(this);
                                    this.m_isOpen = true;
                                }
                                if (this.m_queryTimeout != 0) {
                                    this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                                }
                                this.m_isExecuting = true;
                                this.execute_for_rows(false);
                            }
                            catch (SQLException sQLException) {
                                this.need_to_parse = true;
                                throw sQLException;
                            }
                            Object var5_4 = null;
                            if (this.m_queryTimeout == 0) break block23;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            if (this.m_queryTimeout != 0) {
                                this.connection.getTimeout().cancelTimeout();
                            }
                            this.m_currentRank = 0;
                            this.m_isExecuting = false;
                            this.checkValidRowsStatus();
                            throw throwable;
                        }
                        this.connection.getTimeout().cancelTimeout();
                    }
                    this.m_currentRank = 0;
                    this.m_isExecuting = false;
                    this.checkValidRowsStatus();
                }
            }
            if (this.connection.useDMSForEndToEnd) {
                ExecutionContext.get().setECIDSequenceNumber((int)this.connection.endToEndECIDSequenceNumber);
            }
            Object var7_7 = null;
            if (this.dmsExecute == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (this.dmsExecute == null) throw throwable;
            this.dmsExecute.stop(l);
            throw throwable;
        }
        this.dmsExecute.stop(l);
    }

    void open() throws SQLException {
        if (!this.m_isOpen) {
            this.connection.needLine();
            this.connection.open(this);
            this.m_isOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String string) throws SQLException {
        OracleResultSet oracleResultSet = null;
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                try {
                    this.executionType = 1;
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfJdbcBatchExists();
                    this.sendBatch();
                    this.m_sql.initialize(string);
                    this.sql_kind = this.m_sql.getSqlKind();
                    this.need_to_parse = true;
                    if (this.dmsSqlText != null) {
                        this.dmsSqlText.update((Object)this.m_sql.toString());
                    }
                    this.prepare_for_new_result(true, true);
                    if (this.m_userRsetType == 1) {
                        this.doExecuteWithTimeout();
                        this.current_result_set = new OracleResultSetImpl(this.connection, this);
                        oracleResultSet = this.current_result_set;
                    } else {
                        oracleResultSet = this.doScrollStmtExecuteQuery();
                        if (oracleResultSet == null) {
                            this.current_result_set = new OracleResultSetImpl(this.connection, this);
                            oracleResultSet = this.current_result_set;
                        }
                    }
                }
                finally {
                    this.executionType = (byte)-1;
                }
            }
        }
        return oracleResultSet;
    }

    public void closeWithKey(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.closeOrCache(null);
            }
        }
    }

    protected void closeOrCache(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.statementType != 0 && this.cacheState != 0 && this.cacheState != 3 && this.connection.isStatementCacheInitialized()) {
            if (string == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement((OraclePreparedStatement)this, this.m_sql.getOriginalSql(), this.statementType, this.m_userRsetType);
                } else {
                    this.cacheState = 0;
                    this.hardClose();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement((OraclePreparedStatement)this, string);
            } else {
                this.cacheState = 0;
                this.hardClose();
            }
        } else {
            this.hardClose();
        }
    }

    protected void hardClose() throws SQLException {
        this.hardClose(true);
    }

    private void hardClose(boolean bl) throws SQLException {
        this.alwaysOnClose();
        this.describedWithNames = false;
        this.described = false;
        this.connection.remove_statement(this);
        if (this.dmsParent != null) {
            this.dmsParent.destroy();
        }
        this.cleanupDefines();
        if (this.m_isOpen && bl && (this.connection.lifecycle == 1 || this.connection.lifecycle == 2)) {
            this.do_close();
            this.m_isOpen = false;
        }
        this.m_sql = null;
    }

    protected void alwaysOnClose() throws SQLException {
        OracleStatement oracleStatement = this.children;
        while (oracleStatement != null) {
            OracleStatement oracleStatement2 = oracleStatement.nextChild;
            oracleStatement.close();
            oracleStatement = oracleStatement2;
        }
        this.closed = true;
        if (!this.connection.isClosed()) {
            this.connection.needLine();
            if (this.current_result_set != null) {
                this.current_result_set.internal_close(false);
                this.current_result_set = null;
            }
            if (this.m_scrollRset != null) {
                this.m_scrollRset.close();
                this.m_scrollRset = null;
            }
        }
        this.clearWarnings();
        this.m_batchItems = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeLeaveCursorOpen() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (this.closed) {
                    return;
                }
                this.hardClose(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int n;
                try {
                    if (this.executionType == -1) {
                        this.executionType = (byte)2;
                    }
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfJdbcBatchExists();
                    this.sendBatch();
                    this.m_sql.initialize(string);
                    this.sql_kind = this.m_sql.getSqlKind();
                    this.need_to_parse = true;
                    if (this.dmsSqlText != null) {
                        this.dmsSqlText.update((Object)this.m_sql.toString());
                    }
                    this.prepare_for_new_result(true, true);
                    if (this.m_userRsetType == 1) {
                        this.doExecuteWithTimeout();
                    } else {
                        this.doScrollStmtExecuteQuery();
                    }
                    n = this.valid_rows;
                }
                catch (Throwable throwable) {
                    this.executionType = (byte)-1;
                    throw throwable;
                }
                this.executionType = (byte)-1;
                return n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                boolean bl;
                try {
                    this.executionType = (byte)3;
                    this.noMoreUpdateCounts = false;
                    this.ensureOpen();
                    this.checkIfJdbcBatchExists();
                    this.sendBatch();
                    this.m_sql.initialize(string);
                    this.sql_kind = this.m_sql.getSqlKind();
                    this.need_to_parse = true;
                    if (this.dmsSqlText != null) {
                        this.dmsSqlText.update((Object)this.m_sql.toString());
                    }
                    this.prepare_for_new_result(true, true);
                    if (this.m_userRsetType == 1) {
                        this.doExecuteWithTimeout();
                    } else {
                        this.doScrollStmtExecuteQuery();
                    }
                    bl = this.sql_kind == 0;
                }
                catch (Throwable throwable) {
                    this.executionType = (byte)-1;
                    throw throwable;
                }
                this.executionType = (byte)-1;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfColumns() throws SQLException {
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(false);
                    this.described = true;
                }
            }
        }
        return this.number_of_define_positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescription() throws SQLException {
        if (!this.described) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(false);
                    this.described = true;
                }
            }
        }
        return this.accessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Accessor[] getDescriptionWithNames() throws SQLException {
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
        }
        return this.accessors;
    }

    byte getSqlKind() {
        return this.sql_kind;
    }

    public synchronized void clearDefines() throws SQLException {
        this.freeLine();
        this.streamList = null;
        this.columns_defined_by_user = false;
        this.need_to_prepare_define_buffer = true;
        this.number_of_define_positions = 0;
        this.defines_batch_size = 0;
        this.described = false;
        this.describedWithNames = false;
        this.cleanupDefines();
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
    }

    void defineColumnTypeInternal(int n, int n2, int n3, boolean bl, String string) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, (short)1, bl, string);
    }

    void defineColumnTypeInternal(int n, int n2, int n3, short s, boolean bl, String string) throws SQLException {
        int n4;
        if (this.connection.disableDefineColumnType) {
            return;
        }
        if (n < 1) {
            DatabaseError.throwSqlException(3);
        }
        if (n2 == 0) {
            DatabaseError.throwSqlException(4);
        }
        int n5 = n - 1;
        int n6 = this.max_field_size;
        if (bl) {
            if (n2 == 1 || n2 == 12) {
                this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 108);
            }
        } else {
            if (n3 < 0) {
                DatabaseError.throwSqlException(53);
            }
            if (n6 == 0 || n3 < n6) {
                n6 = n3;
            }
        }
        if (this.current_result_set != null && !this.current_result_set.closed) {
            DatabaseError.throwSqlException(28);
        }
        if (!this.columns_defined_by_user) {
            this.clearDefines();
            this.columns_defined_by_user = true;
        }
        if (this.number_of_define_positions < n) {
            if (this.accessors == null || this.accessors.length < n) {
                Accessor[] accessorArray = new Accessor[n << 1];
                if (this.accessors != null) {
                    System.arraycopy(this.accessors, 0, accessorArray, 0, this.number_of_define_positions);
                }
                this.accessors = accessorArray;
            }
            this.number_of_define_positions = n;
        }
        if (!((n4 = this.get_internal_type(n2)) != 109 && n4 != 111 || string != null && !string.equals(dms_sqlText_units))) {
            DatabaseError.check_error(60, "Invalid arguments");
        }
        Accessor accessor = this.accessors[n5];
        boolean bl2 = true;
        if (accessor != null) {
            int n7 = accessor.useForDataAccessIfPossible(n4, n2, n6, string);
            if (n7 == 0) {
                s = accessor.formOfUse;
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n7 == 1) {
                accessor = null;
                this.reparseOnRedefineIfNeeded();
            } else if (n7 == 2) {
                bl2 = false;
            }
        }
        if (bl2) {
            this.need_to_prepare_define_buffer = true;
        }
        if (accessor == null) {
            this.accessors[n5] = this.allocateAccessor(n4, n2, n, n6, s, string, false);
            this.described = false;
            this.describedWithNames = false;
        }
    }

    Accessor allocateAccessor(int n, int n2, int n3, int n4, short s, String string, boolean bl) throws SQLException {
        switch (n) {
            case 96: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new CharAccessor(this, n4, s, n2, bl);
            }
            case 8: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (!bl) {
                    return new LongAccessor(this, n3, n4, s, n2);
                }
            }
            case 1: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new VarcharAccessor(this, n4, s, n2, bl);
            }
            case 2: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new NumberAccessor(this, n4, s, n2, bl);
            }
            case 6: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new VarnumAccessor(this, n4, s, n2, bl);
            }
            case 24: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (!bl) {
                    return new LongRawAccessor(this, n3, n4, s, n2);
                }
            }
            case 23: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (bl) {
                    return new OutRawAccessor(this, n4, s, n2);
                }
                return new RawAccessor(this, n4, s, n2, false);
            }
            case 100: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BinaryFloatAccessor(this, n4, s, n2, bl);
            }
            case 101: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BinaryDoubleAccessor(this, n4, s, n2, bl);
            }
            case 104: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new RowidAccessor(this, n4, s, n2, bl);
            }
            case 102: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new ResultSetAccessor(this, n4, s, n2, bl);
            }
            case 12: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new DateAccessor(this, n4, s, n2, bl);
            }
            case 113: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BlobAccessor(this, n4, s, n2, bl);
            }
            case 112: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new ClobAccessor(this, n4, s, n2, bl);
            }
            case 114: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new BfileAccessor(this, n4, s, n2, bl);
            }
            case 109: {
                if (string == null) {
                    if (bl) {
                        DatabaseError.throwSqlException(12, "sqlType=" + n2);
                    } else {
                        DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                    }
                }
                NamedTypeAccessor namedTypeAccessor = new NamedTypeAccessor(this, string, s, n2, bl);
                ((Accessor)namedTypeAccessor).initMetadata();
                return namedTypeAccessor;
            }
            case 111: {
                if (string == null) {
                    if (bl) {
                        DatabaseError.throwSqlException(12, "sqlType=" + n2);
                    } else {
                        DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                    }
                }
                RefTypeAccessor refTypeAccessor = new RefTypeAccessor(this, string, s, n2, bl);
                ((Accessor)refTypeAccessor).initMetadata();
                return refTypeAccessor;
            }
            case 180: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (this.connection.m_v8Compatible) {
                    return new DateAccessor(this, n4, s, n2, bl);
                }
                return new TimestampAccessor(this, n4, s, n2, bl);
            }
            case 181: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new TimestamptzAccessor(this, n4, s, n2, bl);
            }
            case 231: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new TimestampltzAccessor(this, n4, s, n2, bl);
            }
            case 182: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new IntervalymAccessor(this, n4, s, n2, bl);
            }
            case 183: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                return new IntervaldsAccessor(this, n4, s, n2, bl);
            }
            case 995: {
                DatabaseError.throwSqlException(89);
            }
        }
        DatabaseError.throwSqlException(4);
        return null;
    }

    public synchronized void defineColumnType(int n, int n2) throws SQLException {
        this.defineColumnTypeInternal(n, n2, 0, true, null);
    }

    public void defineColumnType(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    public void defineColumnType(int n, int n2, int n3, short s) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, s, false, null);
    }

    public synchronized void defineColumnTypeBytes(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    public void defineColumnTypeChars(int n, int n2, int n3) throws SQLException {
        this.defineColumnTypeInternal(n, n2, n3, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineColumnType(int n, int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                this.defineColumnTypeInternal(n, n2, 0, true, string);
            }
        }
    }

    void setCursorId(int n) throws SQLException {
        this.cursorId = n;
    }

    void setPrefetchInternal(int n, boolean bl, boolean bl2) throws SQLException {
        if (bl) {
            if (n <= 0) {
                DatabaseError.throwSqlException(20);
            }
        } else if (n < 0) {
            DatabaseError.throwSqlException(68, "setFetchSize");
        } else if (n == 0) {
            n = this.connection.getDefaultRowPrefetch();
        }
        if (bl2) {
            if (n != this.default_row_prefetch) {
                this.default_row_prefetch = n;
                if (this.current_result_set == null || this.current_result_set.closed) {
                    this.row_prefetch_changed = true;
                }
            }
        } else if (n != this.row_prefetch && this.streamList == null) {
            this.row_prefetch = n;
            this.row_prefetch_changed = true;
        }
    }

    public synchronized void setRowPrefetch(int n) throws SQLException {
        this.setPrefetchInternal(n, true, true);
    }

    int getPrefetchInternal(boolean bl) {
        int n = bl ? this.default_row_prefetch : this.row_prefetch;
        return n;
    }

    public synchronized int getRowPrefetch() {
        return this.getPrefetchInternal(true);
    }

    public void setFixedString(boolean bl) {
        this.fixedString = bl;
    }

    public boolean getFixedString() {
        return this.fixedString;
    }

    void check_row_prefetch_changed() throws SQLException {
        if (this.row_prefetch_changed) {
            if (this.streamList == null) {
                this.prepareAccessors();
                this.need_to_prepare_define_buffer = true;
            }
            this.row_prefetch_changed = false;
        }
    }

    void setDefinesInitialized(boolean bl) {
    }

    void printState(String string) throws SQLException {
    }

    void checkValidRowsStatus() throws SQLException {
        if (this.valid_rows == -2) {
            this.valid_rows = 1;
            this.connection.holdLine(this);
            OracleInputStream oracleInputStream = this.streamList;
            while (oracleInputStream != null) {
                if (oracleInputStream.hasBeenOpen) {
                    oracleInputStream = oracleInputStream.accessor.initForNewRow();
                }
                oracleInputStream.closed = false;
                oracleInputStream.hasBeenOpen = true;
                oracleInputStream = oracleInputStream.nextStream;
            }
            this.nextStream = this.streamList;
        } else if (this.sql_kind == 0) {
            if (this.valid_rows < this.row_prefetch) {
                this.got_last_batch = true;
            }
        } else if (this.sql_kind != 1 && this.sql_kind != 4) {
            this.rows_processed = this.valid_rows;
        }
    }

    void cleanupDefines() {
        if (this.accessors != null) {
            for (int i = 0; i < this.accessors.length; ++i) {
                this.accessors[i] = null;
            }
        }
        this.accessors = null;
        if (this.defineBytes != null) {
            this.defineBytes = null;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
        }
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.max_field_size;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        return this.max_rows;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.max_rows = n;
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.connection.trace("Statement.setEscapeProcessing");
        this.process_escapes = bl;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            DatabaseError.throwSqlException(68);
        }
        this.m_queryTimeout = n;
    }

    public void cancel() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.connection.statement_holding_line != null) {
            this.freeLine();
        } else if (this.m_isExecuting) {
            this.connection.do_cancel();
        }
        this.connection.releaseLineForCancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    void foundPlsqlCompilerWarning() throws SQLException {
        SQLWarning sQLWarning = DatabaseError.newSqlWarning("Found Plsql compiler warnings.", "99999", 24439);
        if (this.m_warning != null) {
            this.m_warning.setNextWarning(sQLWarning);
        } else {
            this.m_warning = sQLWarning;
        }
    }

    public void setCursorName(String string) throws SQLException {
        this.connection.trace("Statement.setCursorName");
        DatabaseError.throwSqlException(23);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.connection.trace("Statement.getResultSet");
        if (this.m_userRsetType == 1) {
            if (this.sql_kind == 0) {
                if (this.current_result_set == null) {
                    this.current_result_set = new OracleResultSetImpl(this.connection, this);
                }
                return this.current_result_set;
            }
        } else {
            return this.m_scrollRset;
        }
        return null;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.connection.trace("Statement.getUpdateCount");
        int n = -1;
        switch (this.sql_kind) {
            case -1: 
            case 0: {
                break;
            }
            case 3: {
                if (!this.noMoreUpdateCounts) {
                    n = this.rows_processed;
                }
                this.noMoreUpdateCounts = true;
                break;
            }
            case 1: {
                this.noMoreUpdateCounts = true;
                break;
            }
            case 2: {
                if (!this.noMoreUpdateCounts) {
                    n = this.rows_processed;
                }
                this.noMoreUpdateCounts = true;
            }
        }
        return n;
    }

    public boolean getMoreResults() throws SQLException {
        this.connection.trace("Statement.getMoreResults");
        return false;
    }

    public int sendBatch() throws SQLException {
        return 0;
    }

    void prepare_for_new_result(boolean bl, boolean bl2) throws SQLException {
        this.clearWarnings();
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (bl2) {
                OracleInputStream oracleInputStream = this.streamList;
                OracleInputStream oracleInputStream2 = null;
                this.streamList = null;
                while (oracleInputStream != null) {
                    if (!oracleInputStream.hasBeenOpen) {
                        if (oracleInputStream2 == null) {
                            this.streamList = oracleInputStream;
                        } else {
                            oracleInputStream2.nextStream = oracleInputStream;
                        }
                        oracleInputStream2 = oracleInputStream;
                    }
                    oracleInputStream = oracleInputStream.nextStream;
                }
            }
        }
        if (this.current_result_set != null) {
            this.current_result_set.internal_close(true);
            this.current_result_set = null;
        }
        this.current_row = -1;
        this.valid_rows = 0;
        this.total_rows_visited = 0;
        this.got_last_batch = false;
        if (this.need_to_parse && !this.columns_defined_by_user) {
            if (bl2 && this.number_of_define_positions != 0) {
                this.number_of_define_positions = 0;
            }
            this.need_to_prepare_define_buffer = true;
        }
        if (bl && this.row_prefetch != this.default_row_prefetch && this.streamList == null) {
            this.row_prefetch = this.default_row_prefetch;
            this.row_prefetch_changed = true;
        }
    }

    void reopenStreams() throws SQLException {
        OracleInputStream oracleInputStream = this.streamList;
        while (oracleInputStream != null) {
            if (oracleInputStream.hasBeenOpen) {
                oracleInputStream = oracleInputStream.accessor.initForNewRow();
            }
            oracleInputStream.closed = false;
            oracleInputStream.hasBeenOpen = true;
            oracleInputStream = oracleInputStream.nextStream;
        }
        this.nextStream = this.streamList;
    }

    void end_of_result_set(boolean bl) throws SQLException {
        if (!bl) {
            this.prepare_for_new_result(false, false);
        }
        this.clearDefines();
    }

    boolean wasNullValue() throws SQLException {
        if (this.last_index == 0) {
            DatabaseError.throwSqlException(24);
        }
        if (this.sql_kind == 0) {
            return this.accessors[this.last_index - 1].isNull(this.current_row);
        }
        return this.outBindAccessors[this.last_index - 1].isNull(this.m_currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int get_column_index(String string) throws SQLException {
        if (!this.describedWithNames) {
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                OracleStatement oracleStatement = this;
                synchronized (oracleStatement) {
                    this.connection.needLine();
                    this.do_describe(true);
                    this.described = true;
                    this.describedWithNames = true;
                }
            }
        }
        for (int i = 0; i < this.number_of_define_positions; ++i) {
            if (!this.accessors[i].columnName.equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        DatabaseError.throwSqlException(6);
        return 0;
    }

    int get_internal_type(int n) throws SQLException {
        int n2 = 0;
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 6;
                break;
            }
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                n2 = 101;
                break;
            }
            case 999: {
                n2 = 999;
                break;
            }
            case 1: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 8;
                break;
            }
            case 91: 
            case 92: {
                n2 = 12;
                break;
            }
            case -100: 
            case 93: {
                n2 = 180;
                break;
            }
            case -101: {
                n2 = 181;
                break;
            }
            case -102: {
                n2 = 231;
                break;
            }
            case -103: {
                n2 = 182;
                break;
            }
            case -104: {
                n2 = 183;
                break;
            }
            case -3: 
            case -2: {
                n2 = 23;
                break;
            }
            case -4: {
                n2 = 24;
                break;
            }
            case -8: {
                n2 = 104;
                break;
            }
            case 2004: {
                n2 = 113;
                break;
            }
            case 2005: {
                n2 = 112;
                break;
            }
            case -13: {
                n2 = 114;
                break;
            }
            case -10: {
                n2 = 102;
                break;
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                n2 = 109;
                break;
            }
            case 2006: {
                n2 = 111;
                break;
            }
            case -14: {
                n2 = 998;
                break;
            }
            case 70: {
                n2 = 1;
                break;
            }
            case 0: {
                n2 = 995;
                break;
            }
            default: {
                DatabaseError.throwSqlException(4);
                n2 = 0;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describe() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                if (!this.described) {
                    this.connection.needLine();
                    this.do_describe(false);
                }
            }
        }
    }

    void freeLine() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    void closeUsedStreams(int n) throws SQLException {
        while (this.nextStream != null && this.nextStream.columnIndex < n) {
            try {
                this.nextStream.close();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
            this.nextStream = this.nextStream.nextStream;
        }
    }

    final void ensureOpen() throws SQLException {
        if (this.connection.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
    }

    void allocateTmpByteArray() {
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n == 1000) {
            this.default_fetch_direction = n;
        } else if (n == 1001 || n == 1002) {
            this.default_fetch_direction = 1000;
            this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 87);
        } else {
            DatabaseError.throwSqlException(68, "setFetchDirection");
        }
    }

    public int getFetchDirection() throws SQLException {
        return this.default_fetch_direction;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.setPrefetchInternal(n, false, true);
    }

    public int getFetchSize() throws SQLException {
        return this.getPrefetchInternal(true);
    }

    public int getResultSetConcurrency() throws SQLException {
        return ResultSetUtil.getUpdateConcurrency(this.m_userRsetType);
    }

    public int getResultSetType() throws SQLException {
        return ResultSetUtil.getScrollType(this.m_userRsetType);
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public synchronized void setResultSetCache(oracle.jdbc.OracleResultSetCache oracleResultSetCache) throws SQLException {
        try {
            if (oracleResultSetCache == null) {
                DatabaseError.throwSqlException(68);
            }
            if (this.m_cache != null) {
                this.m_cache.close();
            }
            this.m_cache = oracleResultSetCache;
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
    }

    public synchronized void setResultSetCache(OracleResultSetCache oracleResultSetCache) throws SQLException {
        this.setResultSetCache((oracle.jdbc.OracleResultSetCache)oracleResultSetCache);
    }

    public synchronized OracleResultSetCache getResultSetCache() throws SQLException {
        return (OracleResultSetCache)this.m_cache;
    }

    void initBatch() {
    }

    int getBatchSize() {
        return this.m_batchItems.size();
    }

    void addBatchItem(String string) {
        this.m_batchItems.addElement(string);
    }

    String getBatchItem(int n) {
        return (String)this.m_batchItems.elementAt(n);
    }

    void clearBatchItems() {
        this.m_batchItems.removeAllElements();
    }

    void checkIfJdbcBatchExists() throws SQLException {
        if (this.getBatchSize() > 0) {
            DatabaseError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    public synchronized void addBatch(String string) throws SQLException {
        this.addBatchItem(string);
    }

    public synchronized void clearBatch() throws SQLException {
        this.clearBatchItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            OracleStatement oracleStatement = this;
            synchronized (oracleStatement) {
                int[] nArray;
                block26: {
                    block24: {
                        int n = 0;
                        int n2 = this.getBatchSize();
                        if (n2 <= 0) {
                            return new int[0];
                        }
                        nArray = new int[n2];
                        this.ensureOpen();
                        this.prepare_for_new_result(true, true);
                        int n3 = this.number_of_define_positions;
                        String string = this.m_sql.getOriginalSql();
                        byte by = this.sql_kind;
                        this.noMoreUpdateCounts = false;
                        int n4 = 0;
                        try {
                            try {
                                this.connection.needLine();
                                for (n = 0; n < n2; ++n) {
                                    int n5;
                                    block23: {
                                        Object var13_12;
                                        this.m_sql.initialize(this.getBatchItem(n));
                                        this.sql_kind = this.m_sql.getSqlKind();
                                        this.need_to_parse = true;
                                        this.number_of_define_positions = 0;
                                        this.rows_processed = 0;
                                        this.m_currentRank = 1;
                                        if (this.sql_kind == 0) {
                                            DatabaseError.throwBatchUpdateException(80, "invalid SELECT batch command " + n, n, nArray);
                                        }
                                        if (!this.m_isOpen) {
                                            this.connection.open(this);
                                            this.m_isOpen = true;
                                        }
                                        n5 = -1;
                                        try {
                                            try {
                                                if (this.m_queryTimeout != 0) {
                                                    this.connection.getTimeout().setTimeout(this.m_queryTimeout * 1000, this);
                                                }
                                                this.m_isExecuting = true;
                                                this.execute_for_rows(false);
                                                if (this.valid_rows > 0) {
                                                    n4 += this.valid_rows;
                                                }
                                                n5 = this.valid_rows;
                                            }
                                            catch (SQLException sQLException) {
                                                this.need_to_parse = true;
                                                throw sQLException;
                                            }
                                            var13_12 = null;
                                            if (this.m_queryTimeout == 0) break block23;
                                        }
                                        catch (Throwable throwable) {
                                            var13_12 = null;
                                            if (this.m_queryTimeout != 0) {
                                                this.connection.getTimeout().cancelTimeout();
                                            }
                                            this.valid_rows = n4;
                                            this.checkValidRowsStatus();
                                            this.m_isExecuting = false;
                                            throw throwable;
                                        }
                                        this.connection.getTimeout().cancelTimeout();
                                    }
                                    this.valid_rows = n4;
                                    this.checkValidRowsStatus();
                                    this.m_isExecuting = false;
                                    nArray[n] = n5;
                                    if (nArray[n] >= 0) continue;
                                    DatabaseError.throwBatchUpdateException(81, "command return value " + nArray[n], n, nArray);
                                }
                                Object var15_15 = null;
                                this.clearBatchItems();
                                this.number_of_define_positions = n3;
                                if (string == null) break block24;
                            }
                            catch (SQLException sQLException) {
                                if (sQLException instanceof BatchUpdateException) {
                                    throw sQLException;
                                }
                                DatabaseError.throwBatchUpdateException(81, sQLException.getMessage(), n, nArray);
                                Object var15_16 = null;
                                this.clearBatchItems();
                                this.number_of_define_positions = n3;
                                if (string != null) {
                                    this.m_sql.initialize(string);
                                    this.sql_kind = by;
                                }
                                this.m_currentRank = 0;
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var15_17 = null;
                            this.clearBatchItems();
                            this.number_of_define_positions = n3;
                            if (string != null) {
                                this.m_sql.initialize(string);
                                this.sql_kind = by;
                            }
                            this.m_currentRank = 0;
                            throw throwable;
                        }
                        this.m_sql.initialize(string);
                        this.sql_kind = by;
                    }
                    this.m_currentRank = 0;
                }
                return nArray;
            }
        }
    }

    public int copyBinds(Statement statement, int n) throws SQLException {
        return 0;
    }

    public void notify_close_rset() throws SQLException {
        this.m_scrollRset = null;
        this.end_of_result_set(false);
    }

    public String getRevisedSql() throws SQLException {
        return this.m_sql.getRevisedSql();
    }

    public String getOriginalSql() throws SQLException {
        return this.m_sql.getOriginalSql();
    }

    void doScrollExecuteCommon() throws SQLException {
        if (this.m_scrollRset != null) {
            this.m_scrollRset.close();
            this.m_scrollRset = null;
        }
        if (this.sql_kind != 0) {
            this.doExecuteWithTimeout();
            return;
        }
        if (!this.m_needToAddIdentifier) {
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_sql.setIncludeRowid(true);
                this.need_to_parse = true;
                if (this.dmsSqlText != null) {
                    this.dmsSqlText.update((Object)this.m_sql.toString());
                }
                this.prepare_for_new_result(true, false);
                if (this.columns_defined_by_user) {
                    Accessor[] accessorArray = this.accessors;
                    if (this.accessors == null || this.accessors.length <= this.number_of_define_positions) {
                        this.accessors = new Accessor[this.number_of_define_positions + 1];
                    }
                    if (accessorArray != null) {
                        for (int i = this.number_of_define_positions; i > 0; --i) {
                            Accessor accessor;
                            this.accessors[i] = accessor = accessorArray[i - 1];
                            if (!accessor.isColumnNumberAware) continue;
                            accessor.updateColumnNumber(i);
                        }
                    }
                    this.allocateRowidAccessor();
                    ++this.number_of_define_positions;
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                this.m_realRsetType = this.m_userRsetType;
            }
            catch (SQLException sQLException) {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                this.m_sql.setIncludeRowid(false);
                this.need_to_parse = true;
                if (this.dmsSqlText != null) {
                    this.dmsSqlText.update((Object)this.m_sql.toString());
                }
                this.prepare_for_new_result(true, false);
                if (this.columns_defined_by_user) {
                    this.need_to_prepare_define_buffer = true;
                    --this.number_of_define_positions;
                    System.arraycopy(this.accessors, 1, this.accessors, 0, this.number_of_define_positions);
                    this.accessors[this.number_of_define_positions] = null;
                    for (int i = 0; i < this.number_of_define_positions; ++i) {
                        Accessor accessor = this.accessors[i];
                        if (!accessor.isColumnNumberAware) continue;
                        accessor.updateColumnNumber(i);
                    }
                }
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                this.m_warning = DatabaseError.addSqlWarning(this.m_warning, 91, sQLException.getMessage());
            }
        }
        this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new RowidAccessor(this, 128, 1, -8, false);
    }

    OracleResultSet doScrollStmtExecuteQuery() throws SQLException {
        this.doScrollExecuteCommon();
        return this.m_scrollRset;
    }

    public void setAutoRefetch(boolean bl) throws SQLException {
        this.m_autoRefetch = bl;
    }

    public boolean getAutoRefetch() throws SQLException {
        return this.m_autoRefetch;
    }

    public synchronized int creationState() {
        return this.m_creationState;
    }

    public boolean isColumnSetNull(int n) {
        return this.columnSetNull;
    }

    public boolean isNCHAR(int n) throws SQLException {
        if (!this.described) {
            this.describe();
        }
        if (n < 0 || n >= this.number_of_define_positions) {
            DatabaseError.throwSqlException(3);
        }
        boolean bl = this.accessors[n].formOfUse == 2;
        return bl;
    }

    void addChild(OracleStatement oracleStatement) {
        oracleStatement.nextChild = this.children;
        this.children = oracleStatement;
    }

    public boolean getMoreResults(int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public boolean execute(String string, int n) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getcacheState() {
        return this.cacheState;
    }

    public int getstatementType() {
        return this.statementType;
    }

    public boolean getserverCursor() {
        return this.serverCursor;
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
    }

    TimeZone getDefaultTimeZone() {
        if (this.defaultTZ == null) {
            this.defaultTZ = TimeZone.getDefault();
        }
        return this.defaultTZ;
    }
}

