/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ws.responsaveis.client;

import br.gov.rs.tce.ssl.util.SSLFactoryUtils;
import br.gov.rs.tce.ws.responsaveis.webservice.impl.Wsresponsaveis;
import https.wsresponsaveis_tce_rs_gov.EntidadeWSPojo;
import https.wsresponsaveis_tce_rs_gov.ResponsaveisWSPojo;
import https.wsresponsaveis_tce_rs_gov_br.ResponsaveisWebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

public class ResponsaveisWSClient {
    private static ResponsaveisWebService responsaveisWS;
    private static final String ARQUIVO_PROPERTIES = "conf/mci.properties";

    public static void initalize() throws WebServiceException {
        try {
            try {
                SSLFactoryUtils.initNaiveSSLSocketFactory();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            System.out.println("MCI-Modelo URL: " + ResponsaveisWSClient.carregaConfigUrl());
            responsaveisWS = new Wsresponsaveis(new URL(ResponsaveisWSClient.carregaConfigUrl())).getResponsaveisWebServiceImplPort();
            Map requestContext = ((BindingProvider)responsaveisWS).getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", ResponsaveisWSClient.carregaConfigUrl());
            requestContext.put("com.sun.xml.internal.ws.connect.timeout", 1000);
            requestContext.put("com.sun.xml.internal.ws.request.timeout", 5000);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static EntidadeWSPojo buscarDadosEntidade(Long codigoOrgao) throws Exception {
        return responsaveisWS.buscarDadosEntidade(codigoOrgao);
    }

    public static ResponsaveisWSPojo buscarResponsaveis(Long codigoOrgao, String periodoInicio, String periodoFim) throws Exception {
        return responsaveisWS.buscarResponsaveis(codigoOrgao, periodoInicio, periodoFim);
    }

    public static ResponsaveisWSPojo buscarResponsaveisCI(Long codigoOrgao, String periodoInicio, String periodoFim) throws Exception {
        return responsaveisWS.buscarResponsaveisCI(codigoOrgao, periodoInicio, periodoFim);
    }

    public static ResponsaveisWSPojo buscarResponsaveisComplementares(Long codigoOrgao, String periodoInicio, String periodoFim) throws Exception {
        return responsaveisWS.buscarResponsaveisComplementares(codigoOrgao, periodoInicio, periodoFim);
    }

    private static String carregaConfigUrl() {
        String url = null;
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = new FileInputStream(file);
            Properties props = new Properties();
            props.load(is);
            url = props.getProperty("wsresponsaveis.url");
            ((InputStream)is).close();
            props.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }
}

