/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ws.recepcao.client;

import br.gov.rs.tce.pcdi.ws.soap.webservice.RecepcaoWS;
import br.gov.rs.tce.pcdi.ws.soap.webservice.Response;
import br.gov.rs.tce.pcdi.ws.soap.webservice.impl.Recepcao;
import br.gov.rs.tce.ssl.util.SSLFactoryUtils;
import br.gov.rs.tce.util.ProxyBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

public class RecepcaoWSClient {
    private static RecepcaoWS recepcaoWS;
    private static final String ARQUIVO_PROPERTIES = "conf/mci.properties";
    private static final String ARQUIVO_PROXY_PROPERTIES = "remessa/proxy.properties";

    public static void initalize() throws WebServiceException {
        try {
            try {
                SSLFactoryUtils.initNaiveSSLSocketFactory();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            ProxyBean proxyBean = new ProxyBean(ARQUIVO_PROXY_PROPERTIES);
            proxyBean.carregaDadosAutenticacao();
            ProxyBean.debug();
            System.out.println("PAD-Modelo URL: " + RecepcaoWSClient.carregaConfigUrl());
            recepcaoWS = new Recepcao(new URL(RecepcaoWSClient.carregaConfigUrl())).getRecepcaoWSImplPort();
            Map requestContext = ((BindingProvider)recepcaoWS).getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", RecepcaoWSClient.carregaConfigUrl());
            requestContext.put("com.sun.xml.internal.ws.connect.timeout", 1000000);
            requestContext.put("com.sun.xml.internal.ws.request.timeout", 5000000);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private static String carregaConfigUrl() {
        String url = null;
        try {
            File file = new File(ARQUIVO_PROPERTIES);
            FileInputStream is = new FileInputStream(file);
            Properties props = new Properties();
            props.load(is);
            url = props.getProperty("wsrecepcao.url");
            ((InputStream)is).close();
            props.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    public static Response receberComplementar(DataHandler arquivo, String remessaInfo, Long tamanhoArquivo) throws Exception {
        return recepcaoWS.receberComplementar(arquivo, remessaInfo, tamanhoArquivo);
    }

    public static Response receberNormal(DataHandler arquivo, String remessaInfo, Long tamanhoArquivo) throws Exception {
        return recepcaoWS.receberNormal(arquivo, remessaInfo, tamanhoArquivo);
    }
}

