/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyBean {
    private static Log log = LogFactory.getLog(ProxyBean.class);
    static final String[] PROXY_SYSPROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort", "socksProxyHost", "socksProxyPort", "socksProxyVersion", "java.net.useSystemProxies"};
    final String arquivoProperties;
    String usuario;
    String senha;
    String servidor;
    String porta;
    boolean isProxy;

    public ProxyBean(String arquivoProperties) {
        this.arquivoProperties = arquivoProperties;
    }

    public void carregaDadosAutenticacao() {
        try {
            File file = new File(this.arquivoProperties);
            FileInputStream is = null;
            Properties props = null;
            if (file.exists()) {
                is = new FileInputStream(file);
                props = new Properties();
                props.load(is);
                this.servidor = props.getProperty("proxy.servidor");
                this.porta = props.getProperty("proxy.porta");
                this.usuario = props.getProperty("proxy.usuario");
                this.senha = props.getProperty("proxy.senha");
                if (this.servidor != null && !this.servidor.equals("")) {
                    System.setProperty("proxySet", "true");
                } else {
                    System.setProperty("proxySet", "false");
                }
                System.setProperty("http.proxyHost", this.servidor);
                System.setProperty("http.proxyPort", this.porta);
                System.setProperty("https.proxyHost", this.servidor);
                System.setProperty("https.proxyPort", this.porta);
                log.info((Object)("carregaDadosAutenticacao: isProxy=" + this.isProxy + " ; proxy=" + this.servidor + ":" + this.porta));
                System.out.println("carregaDadosAutenticacao: isProxy=" + this.isProxy + " ; proxy=" + this.servidor + ":" + this.porta);
                ((InputStream)is).close();
            } else {
                log.info((Object)("carregaDadosAutenticacao: arquivo " + this.arquivoProperties + " n\u00e3o existente"));
                System.out.println("carregaDadosAutenticacao: arquivo " + this.arquivoProperties + " n\u00e3o existente");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean getIsProxy() {
        try {
            File file = new File(this.arquivoProperties);
            FileInputStream is = null;
            Properties props = null;
            if (file.exists()) {
                is = new FileInputStream(file);
                props = new Properties();
                props.load(is);
                this.servidor = props.getProperty("proxy.servidor");
                if (this.servidor != null && !"".equals(this.servidor)) {
                    this.setIsProxy(true);
                }
                ((InputStream)is).close();
            }
            log.info((Object)("getIsProxy: proxy = " + this.servidor + ":" + this.porta + " [isProxy=" + this.isProxy + "]"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.isProxy;
    }

    void setIsProxy(boolean proxy) {
        this.isProxy = proxy;
    }

    public Proxy getProxy() {
        if (this.isProxy) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.servidor, (int)Integer.valueOf(this.porta)));
        }
        return Proxy.NO_PROXY;
    }

    public static void debug() {
        for (String s : PROXY_SYSPROPS) {
            log.debug((Object)("sysprop: " + s + "=" + System.getProperty(s)));
        }
    }

    public Authenticator newProxyAuthenticator() {
        ProxyAuthenticator auth = new ProxyAuthenticator();
        log.info((Object)("newProxyAuthenticator: proxy = " + this.servidor + ":" + this.porta + " [" + this.isProxy + "]"));
        return auth;
    }

    public class ProxyAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String username = ProxyBean.this.usuario;
            String password = ProxyBean.this.senha;
            return new PasswordAuthentication(username, password.toCharArray());
        }
    }
}

