/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.swing;

import br.gov.rs.tce.mci.visao.swing.MciAbstractNumberField;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class MciDecimalField
extends MciAbstractNumberField {
    private static final long serialVersionUID = 1L;
    private double value;

    public MciDecimalField() {
        this(Locale.getDefault());
    }

    protected MciDecimalField(Locale locale) {
        this(NumberFormat.getInstance(locale));
    }

    public MciDecimalField(String format) {
        this(new DecimalFormat(format));
        this.setInputVerifier(new MciAbstractNumberField.MciNumberInputVerifier());
    }

    protected MciDecimalField(NumberFormat value) {
        super(value);
    }

    @Override
    public boolean processFormat() {
        boolean valorOk = true;
        try {
            Number number = ((DecimalFormat)this.getFormat()).parse(this.getText());
            Double d = new Double(this.value);
        }
        catch (ParseException pe) {
            valorOk = false;
        }
        return valorOk;
    }

    public Object getFieldValue() {
        try {
            Number number = ((DecimalFormat)this.getFormat()).parse(this.getText());
            this.value = number.doubleValue();
            return new Double(this.value);
        }
        catch (ParseException pe) {
            return new Double(0.0);
        }
    }

    public void setFieldValue(Object value) {
        this.setValue(value);
    }

    @Override
    public String getTextSemMascara() {
        return this.getText();
    }
}

