/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.swing;

import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.swing.MciAbstractField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.MaskFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MciDateField
extends MciAbstractField {
    private static final long serialVersionUID = 1L;
    private String _maskFormat = null;
    private String _errorMessage = null;
    private SimpleDateFormat _dateformat;
    private char[] _simbols = new char[]{'G', 'y', 'M', 'w', 'W', 'D', 'd', 'F', 'E', 'a', 'H', 'k', 'K', 'h', 'm', 's', 'S', 'z', 'Z'};
    public static SimpleDateFormat defaultDateFormat = new SimpleDateFormat("dd/MM/yyyy");
    public static SimpleDateFormat persistDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static Log log = LogFactory.getLog(MciDateField.class);

    public static String defaultFormat(Date d) {
        return defaultDateFormat.format(d);
    }

    public MciDateField(String mask) {
        this(mask, null);
    }

    public MciDateField(String mask, String errorMessage) {
        super(new MaskFormatter());
        this.addFocusListener(new DateFocusListener());
        this.addKeyListener(new DateKeyListener());
        this._errorMessage = errorMessage;
        this.setInputVerifier(new MciDateInputVerifier());
        this.setMaskEdit((MaskFormatter)this.getFormatter());
        this.setDateFormat(new SimpleDateFormat(mask));
        this.getDateFormat().setLenient(false);
        this.getMaskEdit().setPlaceholderCharacter('_');
        StringBuffer newMask = new StringBuffer();
        char[] temp = mask.toCharArray();
        for (int i = 0; i < temp.length; ++i) {
            int p = Arrays.binarySearch(this._simbols, temp[i]);
            if (p == -1) {
                newMask.append(temp[i]);
                continue;
            }
            newMask.append('#');
        }
        try {
            this.getMaskEdit().setMask(newMask.toString());
            this._maskFormat = newMask.toString();
        }
        catch (ParseException e) {
            log.error((Object)e.toString());
        }
    }

    public Object getFieldValue() {
        String text = null;
        String textSemMascara = null;
        Date date = null;
        textSemMascara = this.getTextSemMascara();
        text = this.getText();
        if (textSemMascara != null && !textSemMascara.equals("")) {
            try {
                date = this._dateformat.parse(text);
            }
            catch (ParseException e) {
                date = new Date();
            }
        }
        return date;
    }

    @Override
    public Object getValue() {
        Object value = null;
        if (this.getText() != null) {
            String text = this.getText();
            String textSemMascara = this.getTextSemMascara();
            if (!text.equals("") && !text.equals(this._maskFormat)) {
                value = textSemMascara.equals("") ? "" : super.getValue();
            }
        }
        return value;
    }

    public void setPlaceholderCharacter(char chr) {
        this.getMaskEdit().setPlaceholderCharacter(chr);
    }

    public SimpleDateFormat getDateFormat() {
        return this._dateformat;
    }

    public void setDateFormat(SimpleDateFormat dateformat) {
        this._dateformat = dateformat;
    }

    private void mostraAviso() {
        int option = 1;
        Object[] options = new Object[]{"    Ok    "};
        option = JOptionPane.showOptionDialog(MciWizardHelper.getInstance().getForm(), this._errorMessage, "Aviso de Verifica\u00e7\u00e3o", 0, 2, null, options, options[0]);
    }

    @Override
    public void setText(String t) {
        if (t != null && !t.equals("")) {
            this.getMaskEdit().setAllowsInvalid(true);
            super.setText(t);
            this.setCaretPosition(0);
            this.getMaskEdit().setAllowsInvalid(false);
        } else {
            super.setText(t);
        }
    }

    @Override
    public void setEditable(boolean enabled) {
        if (!enabled) {
            this.setText("");
            try {
                ((MaskFormatter)this.getFormatter()).setMask("");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (this.getMaskEdit() != null && (this.getMaskEdit().getMask() == null || this.getMaskEdit().getMask().equals(""))) {
            try {
                ((MaskFormatter)this.getFormatter()).setMask(this._maskFormat);
                ((MaskFormatter)this.getFormatter()).install(this);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        super.setEditable(enabled);
    }

    @Override
    public String getTextSemMascara() {
        StringBuffer newText = null;
        String text = this.getText();
        if (text != null) {
            newText = new StringBuffer();
            for (int index = 0; index < text.length(); ++index) {
                char placeHolder = this.getMaskEdit().getPlaceholderCharacter();
                char chr = text.charAt(index);
                if (chr == placeHolder || this.containsSeparateSimbol(chr)) continue;
                newText.append(chr);
            }
        }
        return newText.toString();
    }

    class DateFocusListener
    implements FocusListener {
        DateFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object obj = e.getSource();
            if (MciDateField.this.getTextSemMascara() == null || MciDateField.this.getTextSemMascara().equals("")) {
                if (obj instanceof MciDateField) {
                    ((MaskFormatter)((MciDateField)obj).getFormatter()).install((MciDateField)obj);
                }
            } else {
                MciDateField text = (MciDateField)obj;
                text.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class DateKeyListener
    extends KeyAdapter {
        DateKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            if (c == '\u007f') {
                Object obj = e.getSource();
                if ((MciDateField.this.getTextSemMascara() == null || MciDateField.this.getTextSemMascara().equals("")) && obj instanceof MciDateField) {
                    ((MaskFormatter)((MciDateField)obj).getFormatter()).install((MciDateField)obj);
                }
            }
            if (!Character.isDigit(c) && c != '\b' && c != '\u007f' || c == ' ') {
                MciDateField.this.getToolkit().beep();
                e.consume();
            }
        }
    }

    class MciDateInputVerifier
    extends InputVerifier {
        @Override
        public boolean verify(JComponent input) {
            Date date = null;
            boolean ok = true;
            MciDateField field = (MciDateField)input;
            MaskFormatter formatter = field.getMaskEdit();
            String text = field.getText();
            String textSemMascara = field.getTextSemMascara();
            if (textSemMascara != null) {
                if (!textSemMascara.equals("")) {
                    if (formatter != null) {
                        try {
                            date = MciDateField.this._dateformat.parse(text);
                            ok = true;
                        }
                        catch (ParseException pe) {
                            ok = false;
                        }
                    }
                } else {
                    ok = true;
                }
            }
            return ok;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            boolean teste = this.verify(input);
            if (!teste) {
                input.setInputVerifier(null);
                MciDateField.this.mostraAviso();
                input.setInputVerifier(this);
            }
            return teste;
        }
    }
}

